/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.jdesktop.swingx.plaf.ErrorPaneAddon;
import org.jdesktop.swingx.plaf.ErrorPaneUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.basic.BasicErrorPaneUI;

public class JXErrorPane
extends JComponent {
    public static final String REPORT_ACTION_KEY = "report-action";
    public static final String FATAL_ACTION_KEY = "fatal-action";
    public static final String uiClassID = "ErrorPaneUI";
    private ErrorInfo errorInfo = new ErrorInfo("Error", "Normally this place contains problem description.\n You see this text because one of the following reasons:\n * Either it is a test\n * Developer have not provided error details\n * This error message was invoked unexpectedly and there are no more details available", null, null, null, null, null);
    private Icon icon;
    private ErrorReporter reporter;

    public JXErrorPane() {
        this.updateUI();
    }

    public Dimension getPreferredSize() {
        if (super.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return ((BasicErrorPaneUI)this.getUI()).calculatePreferredSize();
    }

    public ErrorPaneUI getUI() {
        return (ErrorPaneUI)this.ui;
    }

    public void setUI(ErrorPaneUI ui) {
        super.setUI(ui);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((ErrorPaneUI)LookAndFeelAddons.getUI(this, ErrorPaneUI.class));
    }

    public void setErrorInfo(ErrorInfo info) {
        if (info == null) {
            throw new NullPointerException("ErrorInfo can't be null. Provide valid ErrorInfo object.");
        }
        ErrorInfo old = this.errorInfo;
        this.errorInfo = info;
        this.firePropertyChange("errorInfo", old, this.errorInfo);
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChange("icon", old, this.icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setErrorReporter(ErrorReporter reporter) {
        ErrorReporter old = this.getErrorReporter();
        this.reporter = reporter;
        this.firePropertyChange("errorReporter", old, this.getErrorReporter());
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public static void showDialog(Throwable e) {
        ErrorInfo ii = new ErrorInfo(null, null, null, null, e, null, null);
        JXErrorPane.showDialog(null, ii);
    }

    public static void showDialog(Component owner, ErrorInfo info) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(info);
        JXErrorPane.showDialog(owner, pane);
    }

    public static void showDialog(final Component owner, final JXErrorPane pane) {
        Runnable r = new Runnable(){

            public void run() {
                JDialog dlg = JXErrorPane.createDialog(owner, pane);
                dlg.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public static JDialog createDialog(Component owner, JXErrorPane pane) {
        JDialog window = pane.getUI().getErrorDialog(owner);
        if (owner != null) {
            pane.applyComponentOrientation(owner.getComponentOrientation());
        } else {
            pane.applyComponentOrientation(window.getComponentOrientation());
        }
        window.setDefaultCloseOperation(2);
        window.pack();
        window.setLocationRelativeTo(owner);
        return window;
    }

    public static void showFrame(Throwable e) {
        ErrorInfo ii = new ErrorInfo(null, null, null, null, e, null, null);
        JXErrorPane.showFrame(null, ii);
    }

    public static void showFrame(Component owner, ErrorInfo info) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(info);
        JXErrorPane.showFrame(owner, pane);
    }

    public static void showFrame(final Component owner, final JXErrorPane pane) {
        Runnable r = new Runnable(){

            public void run() {
                JFrame window = JXErrorPane.createFrame(owner, pane);
                window.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public static JFrame createFrame(Component owner, JXErrorPane pane) {
        JFrame window = pane.getUI().getErrorFrame(owner);
        if (owner != null) {
            pane.applyComponentOrientation(owner.getComponentOrientation());
        } else {
            pane.applyComponentOrientation(window.getComponentOrientation());
        }
        window.setDefaultCloseOperation(2);
        window.pack();
        return window;
    }

    public static void showInternalFrame(Throwable e) {
        ErrorInfo ii = new ErrorInfo(null, null, null, null, e, null, null);
        JXErrorPane.showInternalFrame(null, ii);
    }

    public static void showInternalFrame(Component owner, ErrorInfo info) {
        JXErrorPane pane = new JXErrorPane();
        pane.setErrorInfo(info);
        JXErrorPane.showInternalFrame(owner, pane);
    }

    public static void showInternalFrame(final Component owner, final JXErrorPane pane) {
        Runnable r = new Runnable(){

            public void run() {
                JInternalFrame window = JXErrorPane.createInternalFrame(owner, pane);
                window.setVisible(true);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public static JInternalFrame createInternalFrame(Component owner, JXErrorPane pane) {
        JInternalFrame window = pane.getUI().getErrorInternalFrame(owner);
        if (owner != null) {
            pane.applyComponentOrientation(owner.getComponentOrientation());
        } else {
            pane.applyComponentOrientation(window.getComponentOrientation());
        }
        window.setDefaultCloseOperation(2);
        window.pack();
        return window;
    }

    static {
        LookAndFeelAddons.contribute(new ErrorPaneAddon());
    }
}

