/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

import ij.plugin.MacroInstaller;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String c2hex(Color c) {
        int i = c.getRGB();
        char[] buf7 = new char[7];
        buf7[0] = 35;
        for (int pos = 6; pos >= 1; --pos) {
            buf7[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf7);
    }

    public static String f2hex(float f) {
        int i = Float.floatToIntBits(f);
        char[] buf9 = new char[9];
        buf9[0] = 35;
        for (int pos = 8; pos >= 1; --pos) {
            buf9[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf9);
    }

    public static String int2hex(int i, int digits) {
        char[] buf = new char[digits];
        for (int pos = buf.length - 1; pos >= 0; --pos) {
            buf[pos] = hexDigits[i & 0xF];
            i >>>= 4;
        }
        return new String(buf);
    }

    public static double[] getMinMax(double[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] getMinMax(float[] a) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < a.length; ++i) {
            double value = a[i];
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double[] minAndMax = new double[]{min, max};
        return minAndMax;
    }

    public static double[] toDouble(float[] a) {
        int len = a.length;
        double[] d = new double[len];
        for (int i = 0; i < len; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static float[] toFloat(double[] a) {
        if (a == null) {
            return null;
        }
        int len = a.length;
        float[] f = new float[len];
        for (int i = 0; i < len; ++i) {
            f[i] = (float)a[i];
        }
        return f;
    }

    public static String fixNewLines(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r') continue;
            chars[i] = 10;
        }
        return new String(chars);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            defaultValue = Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static double parseDouble(String s) {
        return Tools.parseDouble(s, Double.NaN);
    }

    public static int getDecimalPlaces(double n) {
        if ((double)((int)n) == n || Double.isNaN(n)) {
            return 0;
        }
        String s = "" + n;
        if (s.contains("E")) {
            return -2;
        }
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        int index = s.indexOf(".");
        if (index == -1) {
            return 0;
        }
        int digits = s.length() - index - 1;
        if (digits > 4) {
            digits = 4;
        }
        return digits;
    }

    public static int getDecimalPlaces(double n1, double n2) {
        if ((double)((int)n1) == n1 && (double)((int)n2) == n2) {
            return 0;
        }
        int digits = Tools.getDecimalPlaces(n1);
        int digits2 = Tools.getDecimalPlaces(n2);
        if (digits == 0) {
            return digits2;
        }
        if (digits2 == 0) {
            return digits;
        }
        if (digits < 0 || digits2 < 0) {
            return digits;
        }
        if (digits2 > digits) {
            digits = digits2;
        }
        return digits;
    }

    public static String[] split(String str) {
        return Tools.split(str, " \t\n\r");
    }

    public static String[] split(String str, String delim) {
        String[] strings;
        if (delim.equals("\n")) {
            return Tools.splitLines(str);
        }
        StringTokenizer t = new StringTokenizer(str, delim);
        int tokens = t.countTokens();
        if (tokens > 0) {
            strings = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                strings[i] = t.nextToken();
            }
        } else {
            strings = new String[]{};
        }
        return strings;
    }

    static String[] splitLines(String str) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(str));
            while ((line = br.readLine()) != null) {
                v.addElement(line);
            }
            br.close();
        }
        catch (Exception br) {
            // empty catch block
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        return lines;
    }

    public static int[] rank(double[] values) {
        int n = values.length;
        Integer[] indexes = new Integer[n];
        final Double[] data = new Double[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = new Integer(i);
            data[i] = new Double(values[i]);
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareTo(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static int[] rank(final String[] data) {
        int n = data.length;
        Integer[] indexes = new Integer[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = new Integer(i);
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return data[o1].compareToIgnoreCase(data[o2]);
            }
        });
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    public static String openFromIJJarAsString(String path) {
        return new MacroInstaller().openFromIJJar(path);
    }
}

