/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicator
implements PlugIn,
TextListener,
ItemListener {
    private static boolean staticDuplicateStack;
    private boolean duplicateStack;
    private int first;
    private int last;
    private Checkbox checkbox;
    private TextField titleField;
    private TextField rangeField;
    private TextField[] rangeFields;
    private int firstC;
    private int lastC;
    private int firstZ;
    private int lastZ;
    private int firstT;
    private int lastT;
    private String defaultTitle;
    private String sliceLabel;
    private ImagePlus imp;
    private boolean legacyMacro;
    private boolean titleChanged;
    private GenericDialog gd;

    public void run(String arg) {
        String newTitle;
        this.imp = IJ.getImage();
        int stackSize = this.imp.getStackSize();
        String title = this.imp.getTitle();
        this.defaultTitle = newTitle = WindowManager.getUniqueName(title);
        boolean bl = this.duplicateStack = staticDuplicateStack && !IJ.isMacro();
        if (!IJ.altKeyDown() || stackSize > 1) {
            if (this.imp.isHyperStack() || this.imp.isComposite()) {
                this.duplicateHyperstack(this.imp, newTitle);
                return;
            }
            newTitle = this.showDialog(this.imp, "Duplicate...", "Title: ");
        }
        if (newTitle == null) {
            return;
        }
        Roi roi = this.imp.getRoi();
        ImagePlus imp2 = this.duplicateStack && (this.first > 1 || this.last < stackSize) ? this.run(this.imp, this.first, this.last) : (this.duplicateStack || this.imp.getStackSize() == 1 ? this.run(this.imp) : this.crop(this.imp));
        Calibration cal = imp2.getCalibration();
        if (roi != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0)) {
            cal.xOrigin -= (double)roi.getBounds().x;
            cal.yOrigin -= (double)roi.getBounds().y;
        }
        imp2.setTitle(newTitle);
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            Roi roi2 = (Roi)this.cropRoi(this.imp, roi).clone();
            roi2.setLocation(0, 0);
            imp2.setRoi(roi2);
        }
        imp2.show();
        if (stackSize > 1 && imp2.getStackSize() == stackSize) {
            imp2.setSlice(this.imp.getCurrentSlice());
        }
    }

    public ImagePlus run(ImagePlus imp) {
        Overlay overlay;
        if (imp.getStackSize() == 1) {
            return this.crop(imp);
        }
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        Roi roi2 = this.cropRoi(imp, roi);
        if (roi2 != null && roi2.isArea()) {
            rect = roi2.getBounds();
        }
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        int n = stack.getSize();
        for (int i = 1; i <= n; ++i) {
            if (stack.isVirtual()) {
                IJ.showStatus("Duplicating: " + i + "/" + n);
            }
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight(), imp.getProcessor().getColorModel());
            }
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, 0);
            ((CompositeImage)imp2).copyLuts(imp);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            imp2.setOverlay(overlay.crop(rect));
        }
        if (Recorder.record) {
            Recorder.recordCall("imp2 = imp.duplicate();");
        }
        return imp2;
    }

    public ImagePlus crop(ImagePlus imp) {
        Overlay overlay;
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor ip2 = ip.crop();
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setProcessor("DUP_" + imp.getTitle(), ip2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            String label = stack.getSliceLabel(imp.getCurrentSlice());
            if (label != null && label.indexOf(10) > 0) {
                imp2.setProperty("Info", label);
            }
            if (imp.isComposite()) {
                LUT lut = ((CompositeImage)imp).getChannelLut();
                imp2.getProcessor().setColorModel(lut);
            }
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(ip.getRoi());
            if (imp.getStackSize() > 1) {
                overlay2.crop(imp.getCurrentSlice(), imp.getCurrentSlice());
            }
            imp2.setOverlay(overlay2);
        }
        if (Recorder.record) {
            if (imp.getStackSize() == 1) {
                Recorder.recordCall("imp2 = imp.duplicate();");
            } else {
                Recorder.recordCall("imp2 = imp.crop();");
            }
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstSlice, int lastSlice) {
        boolean tseries;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        for (int i = firstSlice; i <= lastSlice; ++i) {
            if (stack.isVirtual()) {
                IJ.showStatus("Duplicating: " + i + "/" + lastSlice);
            }
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            if (stack2 == null) {
                stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight(), imp.getProcessor().getColorModel());
            }
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        int size = stack2.getSize();
        boolean bl = tseries = imp.getNFrames() == imp.getStackSize();
        if (tseries) {
            imp2.setDimensions(1, 1, size);
        } else {
            imp2.setDimensions(1, size, 1);
        }
        Overlay overlay = imp.getOverlay();
        if (overlay != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(rect);
            overlay2.crop(firstSlice, lastSlice);
            imp2.setOverlay(overlay2);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp2 = new Duplicator().run(imp, " + firstSlice + ", " + lastSlice + ");");
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstC, int lastC, int firstZ, int lastZ, int firstT, int lastT) {
        Overlay overlay;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        Roi roi2 = this.cropRoi(imp, roi);
        if (roi2 != null && roi2.isArea()) {
            rect = roi2.getBounds();
        }
        ImageStack stack = imp.getStack();
        ImageStack stack2 = null;
        for (int t = firstT; t <= lastT; ++t) {
            for (int z = firstZ; z <= lastZ; ++z) {
                for (int c = firstC; c <= lastC; ++c) {
                    int n1 = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = stack.getProcessor(n1);
                    String label = stack.getSliceLabel(n1);
                    ip.setRoi(rect);
                    ip = ip.crop();
                    if (stack2 == null) {
                        stack2 = new ImageStack(ip.getWidth(), ip.getHeight(), null);
                    }
                    stack2.addSlice(label, ip);
                }
            }
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        imp2.setDimensions(lastC - firstC + 1, lastZ - firstZ + 1, lastT - firstT + 1);
        if (imp.isComposite()) {
            int mode = ((CompositeImage)imp).getMode();
            if (lastC > firstC) {
                imp2 = new CompositeImage(imp2, mode);
                int i2 = 1;
                for (int i = firstC; i <= lastC; ++i) {
                    LUT lut = ((CompositeImage)imp).getChannelLut(i);
                    ((CompositeImage)imp2).setChannelLut(lut, i2++);
                }
            } else if (firstC == lastC) {
                LUT lut = ((CompositeImage)imp).getChannelLut(firstC);
                imp2.getProcessor().setColorModel(lut);
                imp2.setDisplayRange(lut.min, lut.max);
            }
        }
        imp2.setOpenAsHyperStack(true);
        Calibration cal = imp2.getCalibration();
        if (roi != null && (cal.xOrigin != 0.0 || cal.yOrigin != 0.0)) {
            cal.xOrigin -= (double)roi.getBounds().x;
            cal.yOrigin -= (double)roi.getBounds().y;
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            Overlay overlay2 = overlay.crop(roi2 != null ? roi2.getBounds() : null);
            overlay2.crop(firstC, lastC, firstZ, lastZ, firstT, lastT);
            imp2.setOverlay(overlay2);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp2 = new Duplicator().run(imp, " + firstC + ", " + lastC + ", " + firstZ + ", " + lastZ + ", " + firstT + ", " + lastT + ");");
        }
        return imp2;
    }

    String showDialog(ImagePlus imp, String dialogTitle, String prompt) {
        GenericDialog gd;
        int stackSize = imp.getStackSize();
        String options = Macro.getOptions();
        boolean isMacro = options != null;
        this.duplicateStack = stackSize > 1 && this.duplicateStack && !isMacro;
        this.legacyMacro = options != null && (options.contains("duplicate") || !options.contains("use"));
        String title = this.getNewTitle();
        if (title == null) {
            title = this.defaultTitle;
        }
        this.gd = gd = new GenericDialog(dialogTitle);
        gd.addStringField(prompt, title, 15);
        if (stackSize > 1) {
            gd.addCheckbox("Duplicate stack", this.duplicateStack);
            gd.setInsets(2, 30, 3);
            gd.addStringField("Range:", "1-" + stackSize);
            if (!isMacro) {
                this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
                this.checkbox.addItemListener(this);
                Vector v = gd.getStringFields();
                this.titleField = (TextField)v.elementAt(0);
                this.rangeField = (TextField)v.elementAt(1);
                this.titleField.addTextListener(this);
                this.rangeField.addTextListener(this);
            }
        }
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        title = gd.getNextString();
        if (stackSize > 1) {
            this.duplicateStack = gd.getNextBoolean();
            if (this.duplicateStack) {
                String[] range = Tools.split(gd.getNextString(), " -");
                double d1 = gd.parseDouble(range[0]);
                double d2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
                this.first = Double.isNaN(d1) ? 1 : (int)d1;
                int n = this.last = Double.isNaN(d2) ? stackSize : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > stackSize) {
                    this.last = stackSize;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = stackSize;
                }
            } else {
                this.first = 1;
                this.last = stackSize;
            }
        }
        if (!isMacro) {
            staticDuplicateStack = this.duplicateStack;
        }
        if (Recorder.record && this.titleField != null && this.titleField.getText().equals(this.sliceLabel)) {
            Recorder.recordOption("use");
        }
        return title;
    }

    private String getNewTitle() {
        if (this.titleChanged) {
            return null;
        }
        String title = this.defaultTitle;
        if (!(this.imp.getStackSize() <= 1 || this.duplicateStack || this.legacyMacro || this.checkbox != null && this.checkbox.getState())) {
            ImageStack stack = this.imp.getStack();
            String label = stack.getShortSliceLabel(this.imp.getCurrentSlice());
            if (label != null && label.length() == 0) {
                label = null;
            }
            if (label != null) {
                title = label;
                this.sliceLabel = label;
            }
        }
        return title;
    }

    void duplicateHyperstack(ImagePlus imp, String newTitle) {
        if ((newTitle = this.showHSDialog(imp, newTitle)) == null) {
            return;
        }
        ImagePlus imp2 = null;
        Roi roi = imp.getRoi();
        if (!this.duplicateStack) {
            boolean singleComposite;
            int nChannels = imp.getNChannels();
            boolean bl = singleComposite = imp.isComposite() && nChannels == imp.getStackSize();
            if (!singleComposite && nChannels > 1 && imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
                this.firstC = 1;
                this.lastC = nChannels;
            } else {
                this.firstC = this.lastC = imp.getChannel();
            }
            this.firstZ = this.lastZ = imp.getSlice();
            this.firstT = this.lastT = imp.getFrame();
        }
        if ((imp2 = this.run(imp, this.firstC, this.lastC, this.firstZ, this.lastZ, this.firstT, this.lastT)) == null) {
            return;
        }
        imp2.setTitle(newTitle);
        if (imp2.getWidth() == 0 || imp2.getHeight() == 0) {
            IJ.error("Duplicator", "Selection is outside the image");
            return;
        }
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            Roi roi2 = (Roi)this.cropRoi(imp, roi).clone();
            roi2.setLocation(0, 0);
            imp2.setRoi(roi2);
        }
        imp2.show();
        imp2.setPosition(imp.getC(), imp.getZ(), imp.getT());
        if (IJ.isMacro() && imp2.getWindow() != null) {
            IJ.wait(50);
        }
    }

    String showHSDialog(ImagePlus imp, String newTitle) {
        String[] range;
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        boolean composite = imp.isComposite() && nChannels == imp.getStackSize();
        String options = Macro.getOptions();
        boolean isMacro = options != null;
        GenericDialog gd = new GenericDialog("Duplicate");
        gd.addStringField("Title:", newTitle, 15);
        gd.setInsets(12, 20, 8);
        gd.addCheckbox("Duplicate hyperstack", this.duplicateStack && !isMacro || composite);
        int nRangeFields = 0;
        if (nChannels > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Channels (c):", "1-" + nChannels);
            ++nRangeFields;
        }
        if (nSlices > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Slices (z):", "1-" + nSlices);
            ++nRangeFields;
        }
        if (nFrames > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Frames (t):", "1-" + nFrames);
            ++nRangeFields;
        }
        if (!isMacro) {
            this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
            this.checkbox.addItemListener(this);
            Vector v = gd.getStringFields();
            this.rangeFields = new TextField[3];
            for (int i = 0; i < nRangeFields; ++i) {
                this.rangeFields[i] = (TextField)v.elementAt(i + 1);
                this.rangeFields[i].addTextListener(this);
            }
        }
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        newTitle = gd.getNextString();
        this.duplicateStack = gd.getNextBoolean();
        if (nChannels > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double c1 = gd.parseDouble(range[0]);
            double c2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstC = Double.isNaN(c1) ? 1 : (int)c1;
            int n = this.lastC = Double.isNaN(c2) ? this.firstC : (int)c2;
            if (this.firstC < 1) {
                this.firstC = 1;
            }
            if (this.lastC > nChannels) {
                this.lastC = nChannels;
            }
            if (this.firstC > this.lastC) {
                this.firstC = 1;
                this.lastC = nChannels;
            }
        } else {
            this.lastC = 1;
            this.firstC = 1;
        }
        if (nSlices > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double z1 = gd.parseDouble(range[0]);
            double z2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstZ = Double.isNaN(z1) ? 1 : (int)z1;
            int n = this.lastZ = Double.isNaN(z2) ? this.firstZ : (int)z2;
            if (this.firstZ < 1) {
                this.firstZ = 1;
            }
            if (this.lastZ > nSlices) {
                this.lastZ = nSlices;
            }
            if (this.firstZ > this.lastZ) {
                this.firstZ = 1;
                this.lastZ = nSlices;
            }
        } else {
            this.lastZ = 1;
            this.firstZ = 1;
        }
        if (nFrames > 1) {
            range = Tools.split(gd.getNextString(), " -");
            double t1 = gd.parseDouble(range[0]);
            double t2 = range.length == 2 ? gd.parseDouble(range[1]) : Double.NaN;
            this.firstT = Double.isNaN(t1) ? 1 : (int)t1;
            int n = this.lastT = Double.isNaN(t2) ? this.firstT : (int)t2;
            if (this.firstT < 1) {
                this.firstT = 1;
            }
            if (this.lastT > nFrames) {
                this.lastT = nFrames;
            }
            if (this.firstT > this.lastT) {
                this.firstT = 1;
                this.lastT = nFrames;
            }
        } else {
            this.lastT = 1;
            this.firstT = 1;
        }
        if (!isMacro) {
            staticDuplicateStack = this.duplicateStack;
        }
        return newTitle;
    }

    Roi cropRoi(ImagePlus imp, Roi roi) {
        if (roi == null) {
            return null;
        }
        if (imp == null) {
            return roi;
        }
        Rectangle b = roi.getBounds();
        int w = imp.getWidth();
        int h = imp.getHeight();
        if (b.x < 0 || b.y < 0 || b.x + b.width > w || b.y + b.height > h) {
            ShapeRoi shape1 = new ShapeRoi(roi);
            ShapeRoi shape2 = new ShapeRoi(new Roi(0, 0, w, h));
            roi = shape2.and(shape1);
        }
        if (roi.getBounds().width == 0 || roi.getBounds().height == 0) {
            throw new IllegalArgumentException("Selection is outside the image");
        }
        return roi;
    }

    public static Overlay cropOverlay(Overlay overlay, Rectangle bounds) {
        return overlay.crop(bounds);
    }

    public void textValueChanged(TextEvent e) {
        if (IJ.debugMode) {
            IJ.log("Duplicator.textValueChanged: " + e);
        }
        if (e.getSource() == this.titleField) {
            if (!this.titleField.getText().equals(this.getNewTitle())) {
                this.titleChanged = true;
            }
        } else {
            this.checkbox.setState(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String title;
        this.duplicateStack = this.checkbox.getState();
        if (this.titleField != null && (title = this.getNewTitle()) != null && !title.equals(this.titleField.getText())) {
            this.titleField.setText(title);
            if (this.gd != null) {
                this.gd.setDefaultString(0, title);
            }
        }
    }
}

