/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import java.awt.Color;
import java.awt.Font;

class PlotObject
implements Cloneable {
    public static final int XY_DATA = 0;
    public static final int ARROWS = 1;
    public static final int LINE = 2;
    public static final int NORMALIZED_LINE = 3;
    public static final int DOTTED_LINE = 4;
    public static final int LABEL = 5;
    public static final int NORMALIZED_LABEL = 6;
    public static final int LEGEND = 7;
    public static final int CONSTRUCTOR_DATA = 1;
    public int type = 0;
    public int flags;
    public float[] xValues;
    public float[] yValues;
    public float[] xEValues;
    public float[] yEValues;
    public int shape;
    public float lineWidth;
    public Color color;
    public Color color2;
    public double x;
    public double y;
    public double xEnd;
    public double yEnd;
    public int step;
    public String label;
    public int justification;
    public Font font;

    PlotObject(float[] xValues, float[] yValues, float[] yErrorBars, int shape, float lineWidth, Color color, Color color2, String yLabel) {
        this.type = 0;
        this.xValues = xValues;
        this.yValues = yValues;
        this.yEValues = yErrorBars;
        this.shape = shape;
        this.lineWidth = lineWidth;
        this.color = color;
        this.color2 = color2;
        this.label = yLabel;
    }

    PlotObject(float[] x1, float[] y1, float[] x2, float[] y2, float lineWidth, Color color) {
        this.type = 1;
        this.xValues = x1;
        this.yValues = y1;
        this.xEValues = x2;
        this.yEValues = y2;
        this.lineWidth = lineWidth;
        this.color = color;
    }

    PlotObject(double x, double y, double xEnd, double yEnd, float lineWidth, int step, Color color, int type) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.xEnd = xEnd;
        this.yEnd = yEnd;
        this.lineWidth = lineWidth;
        this.step = step;
        this.color = color;
    }

    PlotObject(String label, double x, double y, int justification, Font font, Color color, int type) {
        this.type = type;
        this.label = label;
        this.x = x;
        this.y = y;
        this.justification = justification;
        this.font = font;
        this.color = color;
    }

    PlotObject(String labels, float lineWidth, Font font, Color color, int flags) {
        this.type = 7;
        this.label = labels;
        this.lineWidth = lineWidth;
        this.font = font;
        this.color = color;
        this.flags = flags;
    }

    boolean hasFlag(int what) {
        return (this.flags & what) != 0;
    }

    boolean hasCurve() {
        return this.type == 0 && (this.shape == 2 || this.shape == 7);
    }

    boolean hasMarker() {
        return this.type == 0 && (this.shape == 0 || this.shape == 1 || this.shape == 3 || this.shape == 4 || this.shape == 5 || this.shape == 6 || this.shape == 7);
    }

    boolean hasFilledMarker() {
        return this.type == 0 && this.color2 != null && (this.shape == 0 || this.shape == 3 || this.shape == 4);
    }

    int getMarkerSize() {
        return this.lineWidth <= 1.0f ? 5 : 7;
    }

    public PlotObject clone() {
        try {
            return (PlotObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

