/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jps;

import java.net.URISyntaxException;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jps.Arguments;

public class Jps {
    private static Arguments arguments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            arguments = new Arguments(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            Arguments.printUsage(System.err);
            System.exit(1);
        }
        if (arguments.isHelp()) {
            Arguments.printUsage(System.err);
            System.exit(0);
        }
        try {
            HostIdentifier hostIdentifier = arguments.hostId();
            MonitoredHost monitoredHost = MonitoredHost.getMonitoredHost(hostIdentifier);
            Set<Integer> set = monitoredHost.activeVms();
            for (Integer n : set) {
                StringBuilder stringBuilder = new StringBuilder();
                Exception exception = null;
                int n2 = n;
                stringBuilder.append(String.valueOf(n2));
                if (arguments.isQuiet()) {
                    System.out.println(stringBuilder);
                    continue;
                }
                MonitoredVm monitoredVm = null;
                String string = "//" + n2 + "?mode=r";
                String string2 = null;
                try {
                    String string3;
                    string2 = " -- process information unavailable";
                    VmIdentifier vmIdentifier = new VmIdentifier(string);
                    monitoredVm = monitoredHost.getMonitoredVm(vmIdentifier, 0);
                    string2 = " -- main class information unavailable";
                    stringBuilder.append(" " + MonitoredVmUtil.mainClass(monitoredVm, arguments.showLongPaths()));
                    if (arguments.showMainArgs()) {
                        string2 = " -- main args information unavailable";
                        string3 = MonitoredVmUtil.mainArgs(monitoredVm);
                        if (string3 != null && string3.length() > 0) {
                            stringBuilder.append(" " + string3);
                        }
                    }
                    if (arguments.showVmArgs()) {
                        string2 = " -- jvm args information unavailable";
                        string3 = MonitoredVmUtil.jvmArgs(monitoredVm);
                        if (string3 != null && string3.length() > 0) {
                            stringBuilder.append(" " + string3);
                        }
                    }
                    if (arguments.showVmFlags()) {
                        string2 = " -- jvm flags information unavailable";
                        string3 = MonitoredVmUtil.jvmFlags(monitoredVm);
                        if (string3 != null && string3.length() > 0) {
                            stringBuilder.append(" " + string3);
                        }
                    }
                    string2 = " -- detach failed";
                    monitoredHost.detach(monitoredVm);
                    System.out.println(stringBuilder);
                    string2 = null;
                }
                catch (URISyntaxException uRISyntaxException) {
                    exception = uRISyntaxException;
                    assert (false);
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                finally {
                    if (string2 == null) continue;
                    stringBuilder.append(string2);
                    if (arguments.isDebug() && exception != null && exception.getMessage() != null) {
                        stringBuilder.append("\n\t");
                        stringBuilder.append(exception.getMessage());
                    }
                    System.out.println(stringBuilder);
                    if (!arguments.printStackTrace()) continue;
                    exception.printStackTrace();
                }
            }
        }
        catch (MonitorException monitorException) {
            if (monitorException.getMessage() != null) {
                System.err.println(monitorException.getMessage());
            } else {
                Throwable throwable = monitorException.getCause();
                if (throwable != null && throwable.getMessage() != null) {
                    System.err.println(throwable.getMessage());
                } else {
                    monitorException.printStackTrace();
                }
            }
            System.exit(1);
        }
    }
}

