/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;

public final class BinaryConstantPool
implements Constants {
    private byte[] types;
    private Object[] cpool;
    Hashtable indexHashObject;
    Hashtable indexHashAscii;
    Vector MoreStuff;

    BinaryConstantPool(DataInputStream dataInputStream) throws IOException {
        this.types = new byte[dataInputStream.readUnsignedShort()];
        this.cpool = new Object[this.types.length];
        block12: for (int i = 1; i < this.cpool.length; ++i) {
            int n = i;
            this.types[i] = dataInputStream.readByte();
            switch (this.types[i]) {
                case 1: {
                    this.cpool[i] = dataInputStream.readUTF();
                    continue block12;
                }
                case 3: {
                    this.cpool[i] = new Integer(dataInputStream.readInt());
                    continue block12;
                }
                case 4: {
                    this.cpool[i] = new Float(dataInputStream.readFloat());
                    continue block12;
                }
                case 5: {
                    this.cpool[i++] = new Long(dataInputStream.readLong());
                    continue block12;
                }
                case 6: {
                    this.cpool[i++] = new Double(dataInputStream.readDouble());
                    continue block12;
                }
                case 7: 
                case 8: {
                    this.cpool[i] = new Integer(dataInputStream.readUnsignedShort());
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[i] = new Integer(dataInputStream.readUnsignedShort() << 16 | dataInputStream.readUnsignedShort());
                    continue block12;
                }
                case 15: {
                    this.cpool[i] = this.readBytes(dataInputStream, 3);
                    continue block12;
                }
                case 16: {
                    this.cpool[i] = this.readBytes(dataInputStream, 2);
                    continue block12;
                }
                case 18: {
                    this.cpool[i] = this.readBytes(dataInputStream, 4);
                    continue block12;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[i]);
                }
            }
        }
    }

    private byte[] readBytes(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public int getInteger(int n) {
        return n == 0 ? 0 : ((Number)this.cpool[n]).intValue();
    }

    public Object getValue(int n) {
        return n == 0 ? null : this.cpool[n];
    }

    public String getString(int n) {
        return n == 0 ? null : (String)this.cpool[n];
    }

    public Identifier getIdentifier(int n) {
        return n == 0 ? null : Identifier.lookup(this.getString(n));
    }

    public ClassDeclaration getDeclarationFromName(Environment environment, int n) {
        return n == 0 ? null : environment.getClassDeclaration(Identifier.lookup(this.getString(n).replace('/', '.')));
    }

    public ClassDeclaration getDeclaration(Environment environment, int n) {
        return n == 0 ? null : this.getDeclarationFromName(environment, this.getInteger(n));
    }

    public Type getType(int n) {
        return Type.tType(this.getString(n));
    }

    public int getConstantType(int n) {
        return this.types[n];
    }

    public Object getConstant(int n, Environment environment) {
        int n2 = this.getConstantType(n);
        switch (n2) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 18: {
                return this.getValue(n);
            }
            case 7: {
                return this.getDeclaration(environment, n);
            }
            case 8: {
                return this.getString(this.getInteger(n));
            }
            case 9: 
            case 10: 
            case 11: {
                try {
                    int n3 = this.getInteger(n);
                    ClassDefinition classDefinition = this.getDeclaration(environment, n3 >> 16).getClassDefinition(environment);
                    int n4 = this.getInteger(n3 & 0xFFFF);
                    Identifier identifier = this.getIdentifier(n4 >> 16);
                    Type type = this.getType(n4 & 0xFFFF);
                    for (MemberDefinition memberDefinition = classDefinition.getFirstMatch(identifier); memberDefinition != null; memberDefinition = memberDefinition.getNextMatch()) {
                        Type type2 = memberDefinition.getType();
                        if (!(n2 == 9 ? type2 == type : type2.equalArguments(type))) continue;
                        return memberDefinition;
                    }
                }
                catch (ClassNotFound classNotFound) {
                    // empty catch block
                }
                return null;
            }
        }
        throw new ClassFormatError("invalid constant type: " + n2);
    }

    public Vector getDependencies(Environment environment) {
        Vector<ClassDeclaration> vector = new Vector<ClassDeclaration>();
        for (int i = 1; i < this.cpool.length; ++i) {
            switch (this.types[i]) {
                case 7: {
                    vector.addElement(this.getDeclarationFromName(environment, this.getInteger(i)));
                }
            }
        }
        return vector;
    }

    public int indexObject(Object object, Environment environment) {
        Integer n;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n = (Integer)this.indexHashObject.get(object)) == null) {
            throw new IndexOutOfBoundsException("Cannot find object " + object + " of type " + object.getClass() + " in constant pool");
        }
        return n;
    }

    public int indexString(String string, Environment environment) {
        Integer n;
        if (this.indexHashObject == null) {
            this.createIndexHash(environment);
        }
        if ((n = (Integer)this.indexHashAscii.get(string)) == null) {
            if (this.MoreStuff == null) {
                this.MoreStuff = new Vector();
            }
            n = new Integer(this.cpool.length + this.MoreStuff.size());
            this.MoreStuff.addElement(string);
            this.indexHashAscii.put(string, n);
        }
        return n;
    }

    public void createIndexHash(Environment environment) {
        this.indexHashObject = new Hashtable();
        this.indexHashAscii = new Hashtable();
        for (int i = 1; i < this.cpool.length; ++i) {
            if (this.types[i] == 1) {
                this.indexHashAscii.put(this.cpool[i], new Integer(i));
                continue;
            }
            try {
                this.indexHashObject.put(this.getConstant(i, environment), new Integer(i));
                continue;
            }
            catch (ClassFormatError classFormatError) {
                // empty catch block
            }
        }
    }

    public void write(DataOutputStream dataOutputStream, Environment environment) throws IOException {
        int n;
        int n2 = this.cpool.length;
        if (this.MoreStuff != null) {
            n2 += this.MoreStuff.size();
        }
        dataOutputStream.writeShort(n2);
        block10: for (n = 1; n < this.cpool.length; ++n) {
            byte by = this.types[n];
            Object object = this.cpool[n];
            dataOutputStream.writeByte(by);
            switch (by) {
                case 1: {
                    dataOutputStream.writeUTF((String)object);
                    continue block10;
                }
                case 3: {
                    dataOutputStream.writeInt(((Number)object).intValue());
                    continue block10;
                }
                case 4: {
                    dataOutputStream.writeFloat(((Number)object).floatValue());
                    continue block10;
                }
                case 5: {
                    dataOutputStream.writeLong(((Number)object).longValue());
                    ++n;
                    continue block10;
                }
                case 6: {
                    dataOutputStream.writeDouble(((Number)object).doubleValue());
                    ++n;
                    continue block10;
                }
                case 7: 
                case 8: {
                    dataOutputStream.writeShort(((Number)object).intValue());
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int n3 = ((Number)object).intValue();
                    dataOutputStream.writeShort(n3 >> 16);
                    dataOutputStream.writeShort(n3 & 0xFFFF);
                    continue block10;
                }
                case 15: 
                case 16: 
                case 18: {
                    dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.types[n]);
                }
            }
        }
        for (n = this.cpool.length; n < n2; ++n) {
            String string = (String)this.MoreStuff.elementAt(n - this.cpool.length);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }
}

