/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.expr;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import com.sun.tools.example.debug.expr.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

abstract class LValue {
    protected Value jdiValue;
    static final int STATIC = 0;
    static final int INSTANCE = 1;
    static List<String> primitiveTypeNames = new ArrayList<String>();
    static final int SAME = 0;
    static final int ASSIGNABLE = 1;
    static final int DIFFERENT = 2;

    LValue() {
    }

    abstract Value getValue() throws InvocationException, IncompatibleThreadStateException, InvalidTypeException, ClassNotLoadedException, ParseException;

    abstract void setValue0(Value var1) throws ParseException, InvalidTypeException, ClassNotLoadedException;

    abstract void invokeWith(List<Value> var1) throws ParseException;

    void setValue(Value value) throws ParseException {
        try {
            this.setValue0(value);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new ParseException("Attempt to set value of incorrect type" + invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new ParseException("Attempt to set value before " + classNotLoadedException.className() + " was loaded" + classNotLoadedException);
        }
    }

    void setValue(LValue lValue) throws ParseException {
        this.setValue(lValue.interiorGetValue());
    }

    LValue memberLValue(ExpressionParser.GetFrame getFrame, String string) throws ParseException {
        try {
            return this.memberLValue(string, getFrame.get().thread());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
    }

    LValue memberLValue(String string, ThreadReference threadReference) throws ParseException {
        Value value = this.interiorGetValue();
        if (value instanceof ArrayReference && "length".equals(string)) {
            return new LValueArrayLength((ArrayReference)value);
        }
        return new LValueInstanceMember(value, string, threadReference);
    }

    Value getMassagedValue(ExpressionParser.GetFrame getFrame) throws ParseException {
        Value value = this.interiorGetValue();
        if (value instanceof ObjectReference && !(value instanceof StringReference) && !(value instanceof ArrayReference)) {
            StackFrame stackFrame;
            try {
                stackFrame = getFrame.get();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw new ParseException("Thread not suspended");
            }
            ThreadReference threadReference = stackFrame.thread();
            LValue lValue = this.memberLValue("toString", threadReference);
            lValue.invokeWith(new ArrayList<Value>());
            return lValue.interiorGetValue();
        }
        return value;
    }

    Value interiorGetValue() throws ParseException {
        Value value;
        try {
            value = this.getValue();
        }
        catch (InvocationException invocationException) {
            throw new ParseException("Unable to complete expression. Exception " + invocationException.exception() + " thrown");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Unable to complete expression. Thread not suspended for method invoke");
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new ParseException("Unable to complete expression. Method argument type mismatch");
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new ParseException("Unable to complete expression. Method argument type " + classNotLoadedException.className() + " not yet loaded");
        }
        return value;
    }

    LValue arrayElementLValue(LValue lValue) throws ParseException {
        Value value = lValue.interiorGetValue();
        if (!(value instanceof IntegerValue || value instanceof ShortValue || value instanceof ByteValue || value instanceof CharValue)) {
            throw new ParseException("Array index must be a integer type");
        }
        int n = ((PrimitiveValue)value).intValue();
        return new LValueArrayElement(this.interiorGetValue(), n);
    }

    public String toString() {
        try {
            return this.interiorGetValue().toString();
        }
        catch (ParseException parseException) {
            return "<Parse Exception>";
        }
    }

    static Field fieldByName(ReferenceType referenceType, String string, int n) {
        Field field = referenceType.fieldByName(string);
        if (field != null) {
            boolean bl = field.isStatic();
            if (n == 0 && !bl || n == 1 && bl) {
                field = null;
            }
        }
        return field;
    }

    static List<Method> methodsByName(ReferenceType referenceType, String string, int n) {
        List<Method> list = referenceType.methodsByName(string);
        Iterator<Method> iterator = list.iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            boolean bl = method.isStatic();
            if ((n != 0 || bl) && (n != 1 || !bl)) continue;
            iterator.remove();
        }
        return list;
    }

    static int argumentsMatch(List<Type> list, List<Value> list2) {
        if (list.size() != list2.size()) {
            return 2;
        }
        Iterator<Type> iterator = list.iterator();
        Iterator<Value> iterator2 = list2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Type type = iterator.next();
            Value value = iterator2.next();
            if (value == null && primitiveTypeNames.contains(type.name())) {
                return 2;
            }
            if (value.type().equals(type)) continue;
            if (LValue.isAssignableTo(value.type(), type)) {
                n = 1;
                continue;
            }
            return 2;
        }
        return n;
    }

    static boolean isComponentAssignable(Type type, Type type2) {
        if (type instanceof PrimitiveType) {
            return type.equals(type2);
        }
        if (type2 instanceof PrimitiveType) {
            return false;
        }
        return LValue.isAssignableTo(type, type2);
    }

    static boolean isArrayAssignableTo(ArrayType arrayType, Type type) {
        if (type instanceof ArrayType) {
            try {
                Type type2 = ((ArrayType)type).componentType();
                return LValue.isComponentAssignable(arrayType.componentType(), type2);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
        }
        if (type instanceof InterfaceType) {
            return type.name().equals("java.lang.Cloneable");
        }
        return type.name().equals("java.lang.Object");
    }

    static boolean isAssignableTo(Type type, Type type2) {
        List<InterfaceType> list;
        if (type.equals(type2)) {
            return true;
        }
        if (type instanceof BooleanType) {
            return type2 instanceof BooleanType;
        }
        if (type2 instanceof BooleanType) {
            return false;
        }
        if (type instanceof PrimitiveType) {
            return type2 instanceof PrimitiveType;
        }
        if (type2 instanceof PrimitiveType) {
            return false;
        }
        if (type instanceof ArrayType) {
            return LValue.isArrayAssignableTo((ArrayType)type, type2);
        }
        if (type instanceof ClassType) {
            ClassType classType = ((ClassType)type).superclass();
            if (classType != null && LValue.isAssignableTo(classType, type2)) {
                return true;
            }
            list = ((ClassType)type).interfaces();
        } else {
            list = ((InterfaceType)type).superinterfaces();
        }
        for (InterfaceType interfaceType : list) {
            if (!LValue.isAssignableTo(interfaceType, type2)) continue;
            return true;
        }
        return false;
    }

    static Method resolveOverload(List<Method> list, List<Value> list2) throws ParseException {
        if (list.size() == 1) {
            return list.get(0);
        }
        Method method = null;
        int n = 0;
        for (Method method2 : list) {
            List<Type> list3;
            try {
                list3 = method2.argumentTypes();
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                continue;
            }
            int n2 = LValue.argumentsMatch(list3, list2);
            if (n2 == 0) {
                return method2;
            }
            if (n2 == 2) continue;
            method = method2;
            ++n;
        }
        if (method != null) {
            if (n == 1) {
                return method;
            }
            throw new ParseException("Arguments match multiple methods");
        }
        throw new ParseException("Arguments match no method");
    }

    static LValue make(VirtualMachine virtualMachine, boolean bl) {
        return new LValueConstant(virtualMachine.mirrorOf(bl));
    }

    static LValue make(VirtualMachine virtualMachine, byte by) {
        return new LValueConstant(virtualMachine.mirrorOf(by));
    }

    static LValue make(VirtualMachine virtualMachine, char c) {
        return new LValueConstant(virtualMachine.mirrorOf(c));
    }

    static LValue make(VirtualMachine virtualMachine, short s) {
        return new LValueConstant(virtualMachine.mirrorOf(s));
    }

    static LValue make(VirtualMachine virtualMachine, int n) {
        return new LValueConstant(virtualMachine.mirrorOf(n));
    }

    static LValue make(VirtualMachine virtualMachine, long l) {
        return new LValueConstant(virtualMachine.mirrorOf(l));
    }

    static LValue make(VirtualMachine virtualMachine, float f) {
        return new LValueConstant(virtualMachine.mirrorOf(f));
    }

    static LValue make(VirtualMachine virtualMachine, double d) {
        return new LValueConstant(virtualMachine.mirrorOf(d));
    }

    static LValue make(VirtualMachine virtualMachine, String string) throws ParseException {
        return new LValueConstant(virtualMachine.mirrorOf(string));
    }

    static LValue makeBoolean(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, token.image.charAt(0) == 't');
    }

    static LValue makeCharacter(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, token.image.charAt(1));
    }

    static LValue makeFloat(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Float.valueOf(token.image).floatValue());
    }

    static LValue makeDouble(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Double.valueOf(token.image));
    }

    static LValue makeInteger(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Integer.parseInt(token.image));
    }

    static LValue makeShort(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Short.parseShort(token.image));
    }

    static LValue makeLong(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Long.parseLong(token.image));
    }

    static LValue makeByte(VirtualMachine virtualMachine, Token token) {
        return LValue.make(virtualMachine, Byte.parseByte(token.image));
    }

    static LValue makeString(VirtualMachine virtualMachine, Token token) throws ParseException {
        int n = token.image.length();
        return LValue.make(virtualMachine, token.image.substring(1, n - 1));
    }

    static LValue makeNull(VirtualMachine virtualMachine, Token token) throws ParseException {
        return new LValueConstant(null);
    }

    static LValue makeThisObject(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, Token token) throws ParseException {
        if (getFrame == null) {
            throw new ParseException("No current thread");
        }
        try {
            StackFrame stackFrame = getFrame.get();
            ObjectReference objectReference = stackFrame.thisObject();
            if (objectReference == null) {
                throw new ParseException("No 'this'.  In native or static method");
            }
            return new LValueConstant(objectReference);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
    }

    static LValue makeNewObject(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, String string, List<Value> list) throws ParseException {
        ObjectReference objectReference;
        Method method;
        List<ReferenceType> list2 = virtualMachine.classesByName(string);
        if (list2.size() == 0) {
            throw new ParseException("No class named: " + string);
        }
        if (list2.size() > 1) {
            throw new ParseException("More than one class named: " + string);
        }
        ReferenceType referenceType = list2.get(0);
        if (!(referenceType instanceof ClassType)) {
            throw new ParseException("Cannot create instance of interface " + string);
        }
        ClassType classType = (ClassType)referenceType;
        ArrayList<Method> arrayList = new ArrayList<Method>(classType.methods());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (method.isConstructor()) continue;
            iterator.remove();
        }
        method = LValue.resolveOverload(arrayList, list);
        try {
            ThreadReference threadReference = getFrame.get().thread();
            objectReference = classType.newInstance(threadReference, method, list, 0);
        }
        catch (InvocationException invocationException) {
            throw new ParseException("Exception in " + string + " constructor: " + invocationException.exception().referenceType().name());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw new ParseException("Thread not suspended");
        }
        catch (Exception exception) {
            throw new ParseException("Unable to create " + string + " instance");
        }
        return new LValueConstant(objectReference);
    }

    private static LValue nFields(LValue lValue, StringTokenizer stringTokenizer, ThreadReference threadReference) throws ParseException {
        if (!stringTokenizer.hasMoreTokens()) {
            return lValue;
        }
        return LValue.nFields(lValue.memberLValue(stringTokenizer.nextToken(), threadReference), stringTokenizer, threadReference);
    }

    static LValue makeName(VirtualMachine virtualMachine, ExpressionParser.GetFrame getFrame, String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        if (getFrame != null) {
            try {
                LValue lValue;
                Object object;
                LocalVariable localVariable;
                StackFrame stackFrame = getFrame.get();
                ThreadReference threadReference = stackFrame.thread();
                try {
                    localVariable = stackFrame.visibleVariableByName(string2);
                }
                catch (AbsentInformationException absentInformationException) {
                    localVariable = null;
                }
                if (localVariable != null) {
                    return LValue.nFields(new LValueLocal(stackFrame, localVariable), stringTokenizer, threadReference);
                }
                List<ReferenceType> list = stackFrame.thisObject();
                if (list != null) {
                    object = new LValueConstant((Value)((Object)list));
                    try {
                        lValue = ((LValue)object).memberLValue(string2, threadReference);
                    }
                    catch (ParseException parseException) {
                        lValue = null;
                    }
                    if (lValue != null) {
                        return LValue.nFields(lValue, stringTokenizer, threadReference);
                    }
                }
                while (stringTokenizer.hasMoreTokens()) {
                    list = virtualMachine.classesByName(string2);
                    if (list.size() > 0) {
                        if (list.size() > 1) {
                            throw new ParseException("More than one class named: " + string2);
                        }
                        object = (ReferenceType)list.get(0);
                        lValue = new LValueStaticMember((ReferenceType)object, stringTokenizer.nextToken(), threadReference);
                        return LValue.nFields(lValue, stringTokenizer, threadReference);
                    }
                    string2 = string2 + '.' + stringTokenizer.nextToken();
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw new ParseException("Thread not suspended");
            }
        }
        throw new ParseException("Name unknown: " + string);
    }

    static String stringValue(LValue lValue, ExpressionParser.GetFrame getFrame) throws ParseException {
        Value value = lValue.getMassagedValue(getFrame);
        if (value == null) {
            return "null";
        }
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        return value.toString();
    }

    static LValue booleanOperation(VirtualMachine virtualMachine, Token token, LValue lValue, LValue lValue2) throws ParseException {
        boolean bl;
        String string = token.image;
        Value value = lValue.interiorGetValue();
        Value value2 = lValue2.interiorGetValue();
        if (!(value instanceof PrimitiveValue) || !(value2 instanceof PrimitiveValue)) {
            if (string.equals("==")) {
                return LValue.make(virtualMachine, value.equals(value2));
            }
            if (string.equals("!=")) {
                return LValue.make(virtualMachine, !value.equals(value2));
            }
            throw new ParseException("Operands or '" + string + "' must be primitive");
        }
        double d = ((PrimitiveValue)value).doubleValue();
        double d2 = ((PrimitiveValue)value2).doubleValue();
        if (string.equals("<")) {
            bl = d < d2;
        } else if (string.equals(">")) {
            bl = d > d2;
        } else if (string.equals("<=")) {
            bl = d <= d2;
        } else if (string.equals(">=")) {
            bl = d >= d2;
        } else if (string.equals("==")) {
            bl = d == d2;
        } else if (string.equals("!=")) {
            bl = d != d2;
        } else {
            throw new ParseException("Unknown operation: " + string);
        }
        return LValue.make(virtualMachine, bl);
    }

    static LValue operation(VirtualMachine virtualMachine, Token token, LValue lValue, LValue lValue2, ExpressionParser.GetFrame getFrame) throws ParseException {
        int n;
        String string = token.image;
        Value value = lValue.interiorGetValue();
        Value value2 = lValue2.interiorGetValue();
        if ((value instanceof StringReference || value2 instanceof StringReference) && string.equals("+")) {
            return LValue.make(virtualMachine, LValue.stringValue(lValue, getFrame) + LValue.stringValue(lValue2, getFrame));
        }
        if (value instanceof ObjectReference || value2 instanceof ObjectReference) {
            if (string.equals("==")) {
                return LValue.make(virtualMachine, value.equals(value2));
            }
            if (string.equals("!=")) {
                return LValue.make(virtualMachine, !value.equals(value2));
            }
            throw new ParseException("Invalid operation '" + string + "' on an Object");
        }
        if (value instanceof BooleanValue || value2 instanceof BooleanValue) {
            throw new ParseException("Invalid operation '" + string + "' on a Boolean");
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)value;
        PrimitiveValue primitiveValue2 = (PrimitiveValue)value2;
        if (primitiveValue instanceof DoubleValue || primitiveValue2 instanceof DoubleValue) {
            double d;
            double d2 = primitiveValue.doubleValue();
            double d3 = primitiveValue2.doubleValue();
            if (string.equals("+")) {
                d = d2 + d3;
            } else if (string.equals("-")) {
                d = d2 - d3;
            } else if (string.equals("*")) {
                d = d2 * d3;
            } else if (string.equals("/")) {
                d = d2 / d3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, d);
        }
        if (primitiveValue instanceof FloatValue || primitiveValue2 instanceof FloatValue) {
            float f;
            float f2 = primitiveValue.floatValue();
            float f3 = primitiveValue2.floatValue();
            if (string.equals("+")) {
                f = f2 + f3;
            } else if (string.equals("-")) {
                f = f2 - f3;
            } else if (string.equals("*")) {
                f = f2 * f3;
            } else if (string.equals("/")) {
                f = f2 / f3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, f);
        }
        if (primitiveValue instanceof LongValue || primitiveValue2 instanceof LongValue) {
            long l;
            long l2 = primitiveValue.longValue();
            long l3 = primitiveValue2.longValue();
            if (string.equals("+")) {
                l = l2 + l3;
            } else if (string.equals("-")) {
                l = l2 - l3;
            } else if (string.equals("*")) {
                l = l2 * l3;
            } else if (string.equals("/")) {
                l = l2 / l3;
            } else {
                throw new ParseException("Unknown operation: " + string);
            }
            return LValue.make(virtualMachine, l);
        }
        int n2 = primitiveValue.intValue();
        int n3 = primitiveValue2.intValue();
        if (string.equals("+")) {
            n = n2 + n3;
        } else if (string.equals("-")) {
            n = n2 - n3;
        } else if (string.equals("*")) {
            n = n2 * n3;
        } else if (string.equals("/")) {
            n = n2 / n3;
        } else {
            throw new ParseException("Unknown operation: " + string);
        }
        return LValue.make(virtualMachine, n);
    }

    static {
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
    }

    private static class LValueConstant
    extends LValue {
        final Value value;

        LValueConstant(Value value) {
            this.value = value;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.value;
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws ParseException {
            throw new ParseException("Cannot set constant: " + this.value);
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            throw new ParseException("Constant is not a method");
        }
    }

    private static class LValueArrayElement
    extends LValue {
        final ArrayReference array;
        final int index;

        LValueArrayElement(Value value, int n) throws ParseException {
            if (!(value instanceof ArrayReference)) {
                throw new ParseException("Must be array type: " + value);
            }
            this.array = (ArrayReference)value;
            this.index = n;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.array.getValue(this.index);
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws InvalidTypeException, ClassNotLoadedException {
            this.array.setValue(this.index, value);
            this.jdiValue = value;
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueArrayLength
    extends LValue {
        final ArrayReference arrayRef;

        LValueArrayLength(ArrayReference arrayReference) {
            this.arrayRef = arrayReference;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.arrayRef.virtualMachine().mirrorOf(this.arrayRef.length());
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws ParseException {
            throw new ParseException("Cannot set constant: " + value);
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            throw new ParseException("Array element is not a method");
        }
    }

    private static class LValueStaticMember
    extends LValue {
        final ReferenceType refType;
        final ThreadReference thread;
        final Field matchingField;
        final List<Method> overloads;
        Method matchingMethod = null;
        List<Value> methodArguments = null;

        LValueStaticMember(ReferenceType referenceType, String string, ThreadReference threadReference) throws ParseException {
            this.refType = referenceType;
            this.thread = threadReference;
            this.matchingField = LValue.fieldByName(referenceType, string, 0);
            this.overloads = LValue.methodsByName(referenceType, string, 0);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No static field or method with the name " + string + " in " + referenceType.name());
            }
        }

        @Override
        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                this.jdiValue = this.refType.getValue(this.matchingField);
                return this.jdiValue;
            }
            if (this.refType instanceof ClassType) {
                ClassType classType = (ClassType)this.refType;
                this.jdiValue = classType.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
                return this.jdiValue;
            }
            if (this.refType instanceof InterfaceType) {
                InterfaceType interfaceType = (InterfaceType)this.refType;
                this.jdiValue = interfaceType.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
                return this.jdiValue;
            }
            throw new InvalidTypeException("Cannot invoke static method on " + this.refType.name());
        }

        @Override
        void setValue0(Value value) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            if (!(this.refType instanceof ClassType)) {
                throw new ParseException("Cannot set interface field: " + this.refType);
            }
            ((ClassType)this.refType).setValue(this.matchingField, value);
            this.jdiValue = value;
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = list;
            this.matchingMethod = LValue.resolveOverload(this.overloads, list);
        }
    }

    private static class LValueInstanceMember
    extends LValue {
        final ObjectReference obj;
        final ThreadReference thread;
        final Field matchingField;
        final List<Method> overloads;
        Method matchingMethod = null;
        List<Value> methodArguments = null;

        LValueInstanceMember(Value value, String string, ThreadReference threadReference) throws ParseException {
            if (!(value instanceof ObjectReference)) {
                throw new ParseException("Cannot access field of primitive type: " + value);
            }
            this.obj = (ObjectReference)value;
            this.thread = threadReference;
            ReferenceType referenceType = this.obj.referenceType();
            this.matchingField = LValue.fieldByName(referenceType, string, 1);
            this.overloads = LValue.methodsByName(referenceType, string, 1);
            if (this.matchingField == null && this.overloads.size() == 0) {
                throw new ParseException("No instance field or method with the name " + string + " in " + referenceType.name());
            }
        }

        @Override
        Value getValue() throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, ParseException {
            if (this.jdiValue != null) {
                return this.jdiValue;
            }
            if (this.matchingMethod == null) {
                if (this.matchingField == null) {
                    throw new ParseException("No such field in " + this.obj.referenceType().name());
                }
                this.jdiValue = this.obj.getValue(this.matchingField);
                return this.jdiValue;
            }
            this.jdiValue = this.obj.invokeMethod(this.thread, this.matchingMethod, this.methodArguments, 0);
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws ParseException, InvalidTypeException, ClassNotLoadedException {
            if (this.matchingMethod != null) {
                throw new ParseException("Cannot assign to a method invocation");
            }
            this.obj.setValue(this.matchingField, value);
            this.jdiValue = value;
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            if (this.matchingMethod != null) {
                throw new ParseException("Invalid consecutive invocations");
            }
            this.methodArguments = list;
            this.matchingMethod = LValue.resolveOverload(this.overloads, list);
        }
    }

    private static class LValueLocal
    extends LValue {
        final StackFrame frame;
        final LocalVariable var;

        LValueLocal(StackFrame stackFrame, LocalVariable localVariable) {
            this.frame = stackFrame;
            this.var = localVariable;
        }

        @Override
        Value getValue() {
            if (this.jdiValue == null) {
                this.jdiValue = this.frame.getValue(this.var);
            }
            return this.jdiValue;
        }

        @Override
        void setValue0(Value value) throws InvalidTypeException, ClassNotLoadedException {
            this.frame.setValue(this.var, value);
            this.jdiValue = value;
        }

        @Override
        void invokeWith(List<Value> list) throws ParseException {
            throw new ParseException(this.var.name() + " is not a method");
        }
    }
}

