/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.tools.StandardLocation;

public class Util {
    public static ProgramElementDoc[] excludeDeprecatedMembers(ProgramElementDoc[] programElementDocArray) {
        return Util.toProgramElementDocArray(Util.excludeDeprecatedMembersAsList(programElementDocArray));
    }

    public static List<ProgramElementDoc> excludeDeprecatedMembersAsList(ProgramElementDoc[] programElementDocArray) {
        ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].tags("deprecated").length != 0) continue;
            arrayList.add(programElementDocArray[i]);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static ProgramElementDoc[] toProgramElementDocArray(List<ProgramElementDoc> list) {
        ProgramElementDoc[] programElementDocArray = new ProgramElementDoc[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            programElementDocArray[i] = list.get(i);
        }
        return programElementDocArray;
    }

    public static boolean nonPublicMemberFound(ProgramElementDoc[] programElementDocArray) {
        for (int i = 0; i < programElementDocArray.length; ++i) {
            if (programElementDocArray[i].isPublic()) continue;
            return true;
        }
        return false;
    }

    public static MethodDoc findMethod(ClassDoc classDoc, MethodDoc methodDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            if (!Util.executableMembersEqual((ExecutableMemberDoc)methodDoc, (ExecutableMemberDoc)methodDocArray[i])) continue;
            return methodDocArray[i];
        }
        return null;
    }

    public static boolean executableMembersEqual(ExecutableMemberDoc executableMemberDoc, ExecutableMemberDoc executableMemberDoc2) {
        if (!(executableMemberDoc instanceof MethodDoc) || !(executableMemberDoc2 instanceof MethodDoc)) {
            return false;
        }
        MethodDoc methodDoc = (MethodDoc)executableMemberDoc;
        MethodDoc methodDoc2 = (MethodDoc)executableMemberDoc2;
        if (methodDoc.isStatic() && methodDoc2.isStatic()) {
            Parameter[] parameterArray;
            Parameter[] parameterArray2 = methodDoc.parameters();
            if (methodDoc.name().equals(methodDoc2.name()) && (parameterArray = methodDoc2.parameters()).length == parameterArray2.length) {
                int n;
                for (n = 0; n < parameterArray2.length && (parameterArray2[n].typeName().equals(parameterArray[n].typeName()) || parameterArray[n].type() instanceof TypeVariable || parameterArray2[n].type() instanceof TypeVariable); ++n) {
                }
                if (n == parameterArray2.length) {
                    return true;
                }
            }
            return false;
        }
        return methodDoc.overrides(methodDoc2) || methodDoc2.overrides(methodDoc) || executableMemberDoc == executableMemberDoc2;
    }

    public static boolean isCoreClass(ClassDoc classDoc) {
        return classDoc.containingClass() == null || classDoc.isStatic();
    }

    public static boolean matches(ProgramElementDoc programElementDoc, ProgramElementDoc programElementDoc2) {
        if (programElementDoc instanceof ExecutableMemberDoc && programElementDoc2 instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)programElementDoc;
            ExecutableMemberDoc executableMemberDoc2 = (ExecutableMemberDoc)programElementDoc2;
            return Util.executableMembersEqual(executableMemberDoc, executableMemberDoc2);
        }
        return programElementDoc.name().equals(programElementDoc2.name());
    }

    public static void copyDocFiles(Configuration configuration, PackageDoc packageDoc) {
        Util.copyDocFiles(configuration, DocPath.forPackage(packageDoc).resolve(DocPaths.DOC_FILES));
    }

    public static void copyDocFiles(Configuration configuration, DocPath docPath) {
        try {
            boolean bl = true;
            for (DocFile docFile : DocFile.list(configuration, StandardLocation.SOURCE_PATH, docPath)) {
                DocFile docFile2;
                DocFile docFile3;
                if (!docFile.isDirectory() || (docFile3 = docFile).isSameFile(docFile2 = DocFile.createFileForOutput(configuration, docPath))) continue;
                for (DocFile docFile4 : docFile3.list()) {
                    DocFile docFile5 = docFile2.resolve(docFile4.getName());
                    if (docFile4.isFile()) {
                        if (docFile5.exists() && !bl) {
                            configuration.message.warning((SourcePosition)null, "doclet.Copy_Overwrite_warning", docFile4.getPath(), docFile2.getPath());
                            continue;
                        }
                        configuration.message.notice("doclet.Copying_File_0_To_Dir_1", docFile4.getPath(), docFile2.getPath());
                        docFile5.copyFile(docFile4);
                        continue;
                    }
                    if (!docFile4.isDirectory() || !configuration.copydocfilesubdirs || configuration.shouldExcludeDocFileDir(docFile4.getName())) continue;
                    Util.copyDocFiles(configuration, docPath.resolve(docFile4.getName()));
                }
                bl = false;
            }
        }
        catch (SecurityException securityException) {
            throw new DocletAbortException(securityException);
        }
        catch (IOException iOException) {
            throw new DocletAbortException(iOException);
        }
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration, boolean bl) {
        AbstractMap abstractMap = bl ? new TreeMap() : new LinkedHashMap();
        Type[] typeArray = null;
        Type type2 = null;
        if (type instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)type).interfaceTypes();
            type2 = ((ParameterizedType)type).superclassType();
        } else if (type instanceof ClassDoc) {
            typeArray = ((ClassDoc)type).interfaceTypes();
            type2 = ((ClassDoc)type).superclassType();
        } else {
            typeArray = type.asClassDoc().interfaceTypes();
            type2 = type.asClassDoc().superclassType();
        }
        for (int i = 0; i < typeArray.length; ++i) {
            Type type3 = typeArray[i];
            ClassDoc classDoc = type3.asClassDoc();
            if (!classDoc.isPublic() && configuration != null && !Util.isLinkable(classDoc, configuration)) continue;
            abstractMap.put(classDoc, type3);
            List<Type> list = Util.getAllInterfaces(type3, configuration, bl);
            for (Type type4 : list) {
                abstractMap.put(type4.asClassDoc(), type4);
            }
        }
        if (type2 == null) {
            return new ArrayList<Type>(abstractMap.values());
        }
        Util.addAllInterfaceTypes(abstractMap, type2, Util.interfaceTypesOf(type2), false, configuration);
        ArrayList<Type> arrayList = new ArrayList<Type>(abstractMap.values());
        if (bl) {
            Collections.sort(arrayList, new TypeComparator());
        }
        return arrayList;
    }

    private static Type[] interfaceTypesOf(Type type) {
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        return type instanceof ClassDoc ? ((ClassDoc)type).interfaceTypes() : ((ParameterizedType)type).interfaceTypes();
    }

    public static List<Type> getAllInterfaces(Type type, Configuration configuration) {
        return Util.getAllInterfaces(type, configuration, true);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> map, ClassDoc classDoc, boolean bl, Configuration configuration) {
        Type type = classDoc.superclassType();
        if (type == null) {
            return;
        }
        Util.addAllInterfaceTypes(map, type, Util.interfaceTypesOf(type), bl, configuration);
    }

    private static void findAllInterfaceTypes(Map<ClassDoc, Type> map, ParameterizedType parameterizedType, Configuration configuration) {
        Type type = parameterizedType.superclassType();
        if (type == null) {
            return;
        }
        Util.addAllInterfaceTypes(map, type, Util.interfaceTypesOf(type), false, configuration);
    }

    private static void addAllInterfaceTypes(Map<ClassDoc, Type> map, Type type, Type[] typeArray, boolean bl, Configuration configuration) {
        for (int i = 0; i < typeArray.length; ++i) {
            Type type2 = typeArray[i];
            ClassDoc classDoc = type2.asClassDoc();
            if (!classDoc.isPublic() && (configuration == null || !Util.isLinkable(classDoc, configuration))) continue;
            if (bl) {
                type2 = type2.asClassDoc();
            }
            map.put(classDoc, type2);
            List<Type> list = Util.getAllInterfaces(type2, configuration);
            for (Type type3 : list) {
                map.put(type3.asClassDoc(), type3);
            }
        }
        if (type instanceof AnnotatedType) {
            type = ((AnnotatedType)type).underlyingType();
        }
        if (type instanceof ParameterizedType) {
            Util.findAllInterfaceTypes(map, (ParameterizedType)type, configuration);
        } else if (((ClassDoc)type).typeParameters().length == 0) {
            Util.findAllInterfaceTypes(map, (ClassDoc)type, bl, configuration);
        } else {
            Util.findAllInterfaceTypes(map, (ClassDoc)type, true, configuration);
        }
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    public static String getPackageName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "<Unnamed>" : packageDoc.name();
    }

    public static String getPackageFileHeadName(PackageDoc packageDoc) {
        return packageDoc == null || packageDoc.name().length() == 0 ? "default" : packageDoc.name();
    }

    public static String replaceText(String string, String string2, String string3) {
        if (string2 == null || string3 == null || string2.equals(string3)) {
            return string;
        }
        return string.replace(string2, string3);
    }

    public static boolean isDocumentedAnnotation(AnnotationTypeDoc annotationTypeDoc) {
        AnnotationDesc[] annotationDescArray = annotationTypeDoc.annotations();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            if (!annotationDescArray[i].annotationType().qualifiedName().equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isDeclarationTarget(AnnotationDesc annotationDesc) {
        AnnotationDesc.ElementValuePair[] elementValuePairArray = annotationDesc.elementValues();
        if (elementValuePairArray == null || elementValuePairArray.length != 1 || !"value".equals(elementValuePairArray[0].element().name()) || !(elementValuePairArray[0].value().value() instanceof AnnotationValue[])) {
            return true;
        }
        AnnotationValue[] annotationValueArray = (AnnotationValue[])elementValuePairArray[0].value().value();
        for (int i = 0; i < annotationValueArray.length; ++i) {
            Object object = annotationValueArray[i].value();
            if (!(object instanceof FieldDoc)) {
                return true;
            }
            FieldDoc fieldDoc = (FieldDoc)object;
            if (!Util.isJava5DeclarationElementType(fieldDoc)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeclarationAnnotation(AnnotationTypeDoc annotationTypeDoc, boolean bl) {
        if (!bl) {
            return false;
        }
        AnnotationDesc[] annotationDescArray = annotationTypeDoc.annotations();
        if (annotationDescArray.length == 0) {
            return true;
        }
        for (int i = 0; i < annotationDescArray.length; ++i) {
            if (!annotationDescArray[i].annotationType().qualifiedName().equals(Target.class.getName()) || !Util.isDeclarationTarget(annotationDescArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isLinkable(ClassDoc classDoc, Configuration configuration) {
        return classDoc.isIncluded() && configuration.isGeneratedDoc(classDoc) || configuration.extern.isExternal((ProgramElementDoc)classDoc) && (classDoc.isPublic() || classDoc.isProtected());
    }

    public static Type getFirstVisibleSuperClass(ClassDoc classDoc, Configuration configuration) {
        if (classDoc == null) {
            return null;
        }
        Type type = classDoc.superclassType();
        ClassDoc classDoc2 = classDoc.superclass();
        while (!(type == null || classDoc2.isPublic() || Util.isLinkable(classDoc2, configuration) || classDoc2.superclass().qualifiedName().equals(classDoc2.qualifiedName()))) {
            type = classDoc2.superclassType();
            classDoc2 = classDoc2.superclass();
        }
        if (classDoc.equals(classDoc2)) {
            return null;
        }
        return type;
    }

    public static ClassDoc getFirstVisibleSuperClassCD(ClassDoc classDoc, Configuration configuration) {
        ClassDoc classDoc2;
        if (classDoc == null) {
            return null;
        }
        for (classDoc2 = classDoc.superclass(); classDoc2 != null && !classDoc2.isPublic() && !Util.isLinkable(classDoc2, configuration); classDoc2 = classDoc2.superclass()) {
        }
        if (classDoc.equals(classDoc2)) {
            return null;
        }
        return classDoc2;
    }

    public static String getTypeName(Configuration configuration, ClassDoc classDoc, boolean bl) {
        String string = "";
        if (classDoc.isOrdinaryClass()) {
            string = "doclet.Class";
        } else if (classDoc.isInterface()) {
            string = "doclet.Interface";
        } else if (classDoc.isException()) {
            string = "doclet.Exception";
        } else if (classDoc.isError()) {
            string = "doclet.Error";
        } else if (classDoc.isAnnotationType()) {
            string = "doclet.AnnotationType";
        } else if (classDoc.isEnum()) {
            string = "doclet.Enum";
        }
        return configuration.getText(bl ? StringUtils.toLowerCase(string) : string);
    }

    public static String replaceTabs(Configuration configuration, String string) {
        if (string.indexOf("\t") == -1) {
            return string;
        }
        int n = configuration.sourcetab;
        String string2 = configuration.tabSpaces;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = 0;
        int n4 = 0;
        block4: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    n4 = 0;
                    continue block4;
                }
                case '\t': {
                    stringBuilder.append(string, n3, i);
                    int n5 = n - n4 % n;
                    stringBuilder.append(string2, 0, n5);
                    n4 += n5;
                    n3 = i + 1;
                    continue block4;
                }
                default: {
                    ++n4;
                }
            }
        }
        stringBuilder.append(string, n3, n2);
        return stringBuilder.toString();
    }

    public static String normalizeNewlines(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        String string2 = DocletConstants.NL;
        int n2 = 0;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append(string, n2, i);
                    stringBuilder.append(string2);
                    n2 = i + 1;
                    continue block4;
                }
                case '\r': {
                    stringBuilder.append(string, n2, i);
                    stringBuilder.append(string2);
                    if (i + 1 < n && string.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    n2 = i + 1;
                }
            }
        }
        stringBuilder.append(string, n2, n);
        return stringBuilder.toString();
    }

    public static void setEnumDocumentation(Configuration configuration, ClassDoc classDoc) {
        MethodDoc[] methodDocArray = classDoc.methods();
        for (int i = 0; i < methodDocArray.length; ++i) {
            StringBuilder stringBuilder;
            MethodDoc methodDoc = methodDocArray[i];
            if (methodDoc.name().equals("values") && methodDoc.parameters().length == 0) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(configuration.getText("doclet.enum_values_doc.main", classDoc.name()));
                stringBuilder.append("\n@return ");
                stringBuilder.append(configuration.getText("doclet.enum_values_doc.return"));
                methodDoc.setRawCommentText(stringBuilder.toString());
                continue;
            }
            if (!methodDoc.name().equals("valueOf") || methodDoc.parameters().length != 1 || (stringBuilder = methodDoc.parameters()[0].type()) == null || !stringBuilder.qualifiedTypeName().equals(String.class.getName())) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(configuration.getText("doclet.enum_valueof_doc.main", classDoc.name()));
            stringBuilder2.append("\n@param name ");
            stringBuilder2.append(configuration.getText("doclet.enum_valueof_doc.param_name"));
            stringBuilder2.append("\n@return ");
            stringBuilder2.append(configuration.getText("doclet.enum_valueof_doc.return"));
            stringBuilder2.append("\n@throws IllegalArgumentException ");
            stringBuilder2.append(configuration.getText("doclet.enum_valueof_doc.throws_ila"));
            stringBuilder2.append("\n@throws NullPointerException ");
            stringBuilder2.append(configuration.getText("doclet.enum_valueof_doc.throws_npe"));
            methodDoc.setRawCommentText(stringBuilder2.toString());
        }
    }

    public static boolean isDeprecated(Doc doc) {
        if (doc.tags("deprecated").length > 0) {
            return true;
        }
        AnnotationDesc[] annotationDescArray = doc instanceof PackageDoc ? ((PackageDoc)doc).annotations() : ((ProgramElementDoc)doc).annotations();
        for (int i = 0; i < annotationDescArray.length; ++i) {
            if (!annotationDescArray[i].annotationType().qualifiedName().equals(Deprecated.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static String propertyNameFromMethodName(Configuration configuration, String string) {
        String string2 = null;
        if (string.startsWith("get") || string.startsWith("set")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is")) {
            string2 = string.substring(2);
        }
        if (string2 == null || string2.isEmpty()) {
            return "";
        }
        return string2.substring(0, 1).toLowerCase(configuration.getLocale()) + string2.substring(1);
    }

    public static ClassDoc[] filterOutPrivateClasses(ClassDoc[] classDocArray, boolean bl) {
        if (!bl) {
            return classDocArray;
        }
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>(classDocArray.length);
        for (ClassDoc classDoc : classDocArray) {
            Tag[] tagArray;
            if (classDoc.isPrivate() || classDoc.isPackagePrivate() || (tagArray = classDoc.tags("treatAsPrivate")) != null && tagArray.length > 0) continue;
            arrayList.add(classDoc);
        }
        return arrayList.toArray(new ClassDoc[0]);
    }

    public static boolean isJava5DeclarationElementType(FieldDoc fieldDoc) {
        return fieldDoc.name().contentEquals(ElementType.ANNOTATION_TYPE.name()) || fieldDoc.name().contentEquals(ElementType.CONSTRUCTOR.name()) || fieldDoc.name().contentEquals(ElementType.FIELD.name()) || fieldDoc.name().contentEquals(ElementType.LOCAL_VARIABLE.name()) || fieldDoc.name().contentEquals(ElementType.METHOD.name()) || fieldDoc.name().contentEquals(ElementType.PACKAGE.name()) || fieldDoc.name().contentEquals(ElementType.PARAMETER.name()) || fieldDoc.name().contentEquals(ElementType.TYPE.name());
    }

    private static class TypeComparator
    implements Comparator<Type> {
        private TypeComparator() {
        }

        @Override
        public int compare(Type type, Type type2) {
            return type.qualifiedTypeName().compareToIgnoreCase(type2.qualifiedTypeName());
        }
    }
}

