/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocFileFactory;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.javac.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.tools.DocumentationTool;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

class StandardDocFileFactory
extends DocFileFactory {
    private final StandardJavaFileManager fileManager;
    private File destDir;

    public StandardDocFileFactory(Configuration configuration) {
        super(configuration);
        this.fileManager = (StandardJavaFileManager)configuration.getFileManager();
    }

    private File getDestDir() {
        if (this.destDir == null) {
            if (!this.configuration.destDirName.isEmpty() || !this.fileManager.hasLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT)) {
                try {
                    String string = this.configuration.destDirName.isEmpty() ? "." : this.configuration.destDirName;
                    File file = new File(string);
                    this.fileManager.setLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT, Arrays.asList(file));
                }
                catch (IOException iOException) {
                    throw new DocletAbortException(iOException);
                }
            }
            this.destDir = this.fileManager.getLocation(DocumentationTool.Location.DOCUMENTATION_OUTPUT).iterator().next();
        }
        return this.destDir;
    }

    @Override
    public DocFile createFileForDirectory(String string) {
        return new StandardDocFile(new File(string));
    }

    @Override
    public DocFile createFileForInput(String string) {
        return new StandardDocFile(new File(string));
    }

    @Override
    public DocFile createFileForOutput(DocPath docPath) {
        return new StandardDocFile(DocumentationTool.Location.DOCUMENTATION_OUTPUT, docPath);
    }

    @Override
    Iterable<DocFile> list(JavaFileManager.Location location, DocPath docPath) {
        if (location != StandardLocation.SOURCE_PATH) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DocFile> linkedHashSet = new LinkedHashSet<DocFile>();
        StandardLocation standardLocation = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        for (File file : this.fileManager.getLocation(standardLocation)) {
            File file2;
            if (!file.isDirectory() || !(file2 = new File(file, docPath.getPath())).exists()) continue;
            linkedHashSet.add(new StandardDocFile(file2));
        }
        return linkedHashSet;
    }

    private static File newFile(File file, String string) {
        return file == null ? new File(string) : new File(file, string);
    }

    class StandardDocFile
    extends DocFile {
        private File file;

        private StandardDocFile(File file) {
            super(StandardDocFileFactory.this.configuration);
            this.file = file;
        }

        private StandardDocFile(JavaFileManager.Location location, DocPath docPath) {
            super(StandardDocFileFactory.this.configuration, location, docPath);
            Assert.check(location == DocumentationTool.Location.DOCUMENTATION_OUTPUT);
            this.file = StandardDocFileFactory.newFile(StandardDocFileFactory.this.getDestDir(), docPath.getPath());
        }

        @Override
        public InputStream openInputStream() throws IOException {
            JavaFileObject javaFileObject = this.getJavaFileObjectForInput(this.file);
            return new BufferedInputStream(javaFileObject.openInputStream());
        }

        @Override
        public OutputStream openOutputStream() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream outputStream = this.getFileObjectForOutput(this.path).openOutputStream();
            return new BufferedOutputStream(outputStream);
        }

        @Override
        public Writer openWriter() throws IOException, UnsupportedEncodingException {
            if (this.location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalStateException();
            }
            OutputStream outputStream = this.getFileObjectForOutput(this.path).openOutputStream();
            if (StandardDocFileFactory.this.configuration.docencoding == null) {
                return new BufferedWriter(new OutputStreamWriter(outputStream));
            }
            return new BufferedWriter(new OutputStreamWriter(outputStream, StandardDocFileFactory.this.configuration.docencoding));
        }

        @Override
        public boolean canRead() {
            return this.file.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.file.canWrite();
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        @Override
        public boolean isAbsolute() {
            return this.file.isAbsolute();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public boolean isSameFile(DocFile docFile) {
            if (!(docFile instanceof StandardDocFile)) {
                return false;
            }
            try {
                return this.file.exists() && this.file.getCanonicalFile().equals(((StandardDocFile)docFile).file.getCanonicalFile());
            }
            catch (IOException iOException) {
                return false;
            }
        }

        @Override
        public Iterable<DocFile> list() {
            ArrayList<DocFile> arrayList = new ArrayList<DocFile>();
            for (File file : this.file.listFiles()) {
                arrayList.add(new StandardDocFile(file));
            }
            return arrayList;
        }

        @Override
        public boolean mkdirs() {
            return this.file.mkdirs();
        }

        @Override
        public DocFile resolve(DocPath docPath) {
            return this.resolve(docPath.getPath());
        }

        @Override
        public DocFile resolve(String string) {
            if (this.location == null && this.path == null) {
                return new StandardDocFile(new File(this.file, string));
            }
            return new StandardDocFile(this.location, this.path.resolve(string));
        }

        @Override
        public DocFile resolveAgainst(JavaFileManager.Location location) {
            if (location != DocumentationTool.Location.DOCUMENTATION_OUTPUT) {
                throw new IllegalArgumentException();
            }
            return new StandardDocFile(StandardDocFileFactory.newFile(StandardDocFileFactory.this.getDestDir(), this.file.getPath()));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("StandardDocFile[");
            if (this.location != null) {
                stringBuilder.append("locn:").append(this.location).append(",");
            }
            if (this.path != null) {
                stringBuilder.append("path:").append(this.path.getPath()).append(",");
            }
            stringBuilder.append("file:").append(this.file);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        private JavaFileObject getJavaFileObjectForInput(File file) {
            return StandardDocFileFactory.this.fileManager.getJavaFileObjects(file).iterator().next();
        }

        private FileObject getFileObjectForOutput(DocPath docPath) throws IOException {
            String string = docPath.getPath();
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    n = i;
                    continue;
                }
                if (i == n + 1 && !Character.isJavaIdentifierStart(c) || !Character.isJavaIdentifierPart(c)) break;
            }
            String string2 = n == -1 ? "" : string.substring(0, n);
            String string3 = string.substring(n + 1);
            return StandardDocFileFactory.this.fileManager.getFileForOutput(this.location, string2, string3, null);
        }
    }
}

