/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;

public class DocPath {
    private final String path;
    public static final DocPath empty = new DocPath("");
    public static final DocPath parent = new DocPath("..");

    public static DocPath create(String string) {
        return string == null || string.isEmpty() ? empty : new DocPath(string);
    }

    public static DocPath forClass(ClassDoc classDoc) {
        return classDoc == null ? empty : DocPath.forPackage(classDoc.containingPackage()).resolve(DocPath.forName(classDoc));
    }

    public static DocPath forName(ClassDoc classDoc) {
        return classDoc == null ? empty : new DocPath(classDoc.name() + ".html");
    }

    public static DocPath forPackage(ClassDoc classDoc) {
        return classDoc == null ? empty : DocPath.forPackage(classDoc.containingPackage());
    }

    public static DocPath forPackage(PackageDoc packageDoc) {
        return packageDoc == null ? empty : DocPath.create(packageDoc.name().replace('.', '/'));
    }

    public static DocPath forRoot(PackageDoc packageDoc) {
        String string;
        String string2 = string = packageDoc == null ? "" : packageDoc.name();
        if (string.isEmpty()) {
            return empty;
        }
        return new DocPath(string.replace('.', '/').replaceAll("[^/]+", ".."));
    }

    public static DocPath relativePath(PackageDoc packageDoc, PackageDoc packageDoc2) {
        return DocPath.forRoot(packageDoc).resolve(DocPath.forPackage(packageDoc2));
    }

    protected DocPath(String string) {
        this.path = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
    }

    public boolean equals(Object object) {
        return object instanceof DocPath && this.path.equals(((DocPath)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public DocPath basename() {
        int n = this.path.lastIndexOf("/");
        return n == -1 ? this : new DocPath(this.path.substring(n + 1));
    }

    public DocPath parent() {
        int n = this.path.lastIndexOf("/");
        return n == -1 ? empty : new DocPath(this.path.substring(0, n));
    }

    public DocPath resolve(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return new DocPath(string);
        }
        return new DocPath(this.path + "/" + string);
    }

    public DocPath resolve(DocPath docPath) {
        if (docPath == null || docPath.isEmpty()) {
            return this;
        }
        if (this.path.isEmpty()) {
            return docPath;
        }
        return new DocPath(this.path + "/" + docPath.getPath());
    }

    public DocPath invert() {
        return new DocPath(this.path.replaceAll("[^/]+", ".."));
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public DocLink fragment(String string) {
        return new DocLink(this.path, null, string);
    }

    public DocLink query(String string) {
        return new DocLink(this.path, string, null);
    }

    public String getPath() {
        return this.path;
    }
}

