/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.PathDocFileFactory;
import com.sun.tools.doclets.internal.toolkit.util.StandardDocFileFactory;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;

abstract class DocFileFactory {
    private static final Map<Configuration, DocFileFactory> factories = new WeakHashMap<Configuration, DocFileFactory>();
    protected Configuration configuration;

    static synchronized DocFileFactory getFactory(Configuration configuration) {
        DocFileFactory docFileFactory = factories.get(configuration);
        if (docFileFactory == null) {
            JavaFileManager javaFileManager = configuration.getFileManager();
            if (javaFileManager instanceof StandardJavaFileManager) {
                docFileFactory = new StandardDocFileFactory(configuration);
            } else {
                try {
                    Class<?> clazz = Class.forName("com.sun.tools.javac.nio.PathFileManager");
                    if (clazz.isAssignableFrom(javaFileManager.getClass())) {
                        docFileFactory = new PathDocFileFactory(configuration);
                    }
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException(throwable);
                }
            }
            factories.put(configuration, docFileFactory);
        }
        return docFileFactory;
    }

    protected DocFileFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    abstract DocFile createFileForDirectory(String var1);

    abstract DocFile createFileForInput(String var1);

    abstract DocFile createFileForOutput(DocPath var1);

    abstract Iterable<DocFile> list(JavaFileManager.Location var1, DocPath var2);
}

