/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.internal.toolkit.ClassWriter;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;

public class ClassBuilder
extends AbstractBuilder {
    public static final String ROOT = "ClassDoc";
    private final ClassDoc classDoc;
    private final ClassWriter writer;
    private final boolean isInterface;
    private final boolean isEnum;
    private Content contentTree;

    private ClassBuilder(AbstractBuilder.Context context, ClassDoc classDoc, ClassWriter classWriter) {
        super(context);
        this.classDoc = classDoc;
        this.writer = classWriter;
        if (classDoc.isInterface()) {
            this.isInterface = true;
            this.isEnum = false;
        } else if (classDoc.isEnum()) {
            this.isInterface = false;
            this.isEnum = true;
            Util.setEnumDocumentation(this.configuration, classDoc);
        } else {
            this.isInterface = false;
            this.isEnum = false;
        }
    }

    public static ClassBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, ClassWriter classWriter) {
        return new ClassBuilder(context, classDoc, classWriter);
    }

    @Override
    public void build() throws IOException {
        this.build(this.layoutParser.parseXML(ROOT), this.contentTree);
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildClassDoc(XMLNode xMLNode, Content content) throws Exception {
        String string = this.isInterface ? "doclet.Interface" : (this.isEnum ? "doclet.Enum" : "doclet.Class");
        content = this.writer.getHeader(this.configuration.getText(string) + " " + this.classDoc.name());
        Content content2 = this.writer.getClassContentHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(content2);
        this.writer.addFooter(content);
        this.writer.printDocument(content);
        this.writer.close();
        this.copyDocFiles();
    }

    public void buildClassTree(XMLNode xMLNode, Content content) {
        this.writer.addClassTree(content);
    }

    public void buildClassInfo(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getClassInfoTreeHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(this.writer.getClassInfo(content2));
    }

    public void buildTypeParamInfo(XMLNode xMLNode, Content content) {
        this.writer.addTypeParamInfo(content);
    }

    public void buildSuperInterfacesInfo(XMLNode xMLNode, Content content) {
        this.writer.addSuperInterfacesInfo(content);
    }

    public void buildImplementedInterfacesInfo(XMLNode xMLNode, Content content) {
        this.writer.addImplementedInterfacesInfo(content);
    }

    public void buildSubClassInfo(XMLNode xMLNode, Content content) {
        this.writer.addSubClassInfo(content);
    }

    public void buildSubInterfacesInfo(XMLNode xMLNode, Content content) {
        this.writer.addSubInterfacesInfo(content);
    }

    public void buildInterfaceUsageInfo(XMLNode xMLNode, Content content) {
        this.writer.addInterfaceUsageInfo(content);
    }

    public void buildFunctionalInterfaceInfo(XMLNode xMLNode, Content content) {
        this.writer.addFunctionalInterfaceInfo(content);
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addClassDeprecationInfo(content);
    }

    public void buildNestedClassInfo(XMLNode xMLNode, Content content) {
        this.writer.addNestedClassInfo(content);
    }

    private void copyDocFiles() {
        PackageDoc packageDoc = this.classDoc.containingPackage();
        if (!(this.configuration.packages != null && Arrays.binarySearch(this.configuration.packages, packageDoc) >= 0 || this.containingPackagesSeen.contains(packageDoc.name()))) {
            Util.copyDocFiles(this.configuration, packageDoc);
            this.containingPackagesSeen.add(packageDoc.name());
        }
    }

    public void buildClassSignature(XMLNode xMLNode, Content content) {
        StringBuilder stringBuilder;
        stringBuilder.append((stringBuilder = new StringBuilder(this.classDoc.modifiers())).length() == 0 ? "" : " ");
        if (this.isEnum) {
            stringBuilder.append("enum ");
            int n = stringBuilder.indexOf("abstract");
            if (n >= 0) {
                stringBuilder.delete(n, n + "abstract".length());
                stringBuilder = new StringBuilder(Util.replaceText(stringBuilder.toString(), "  ", " "));
            }
            if ((n = stringBuilder.indexOf("final")) >= 0) {
                stringBuilder.delete(n, n + "final".length());
                stringBuilder = new StringBuilder(Util.replaceText(stringBuilder.toString(), "  ", " "));
            }
        } else if (!this.isInterface) {
            stringBuilder.append("class ");
        }
        this.writer.addClassSignature(stringBuilder.toString(), content);
    }

    public void buildClassDescription(XMLNode xMLNode, Content content) {
        this.writer.addClassDescription(content);
    }

    public void buildClassTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addClassTagInfo(content);
    }

    public void buildMemberSummary(XMLNode xMLNode, Content content) throws Exception {
        Content content2 = this.writer.getMemberTreeHeader();
        this.configuration.getBuilderFactory().getMemberSummaryBuilder(this.writer).buildChildren(xMLNode, content2);
        content.addContent(this.writer.getMemberSummaryTree(content2));
    }

    public void buildMemberDetails(XMLNode xMLNode, Content content) {
        Content content2 = this.writer.getMemberTreeHeader();
        this.buildChildren(xMLNode, content2);
        content.addContent(this.writer.getMemberDetailsTree(content2));
    }

    public void buildEnumConstantsDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getEnumConstantsBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildFieldDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getFieldBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildPropertyDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getPropertyBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildConstructorDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getConstructorBuilder(this.writer).buildChildren(xMLNode, content);
    }

    public void buildMethodDetails(XMLNode xMLNode, Content content) throws Exception {
        this.configuration.getBuilderFactory().getMethodBuilder(this.writer).buildChildren(xMLNode, content);
    }
}

