/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.LayoutParser;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public abstract class AbstractBuilder {
    protected final Configuration configuration;
    protected final Set<String> containingPackagesSeen;
    protected final LayoutParser layoutParser;
    protected static final boolean DEBUG = false;

    public AbstractBuilder(Context context) {
        this.configuration = context.configuration;
        this.containingPackagesSeen = context.containingPackagesSeen;
        this.layoutParser = context.layoutParser;
    }

    public abstract String getName();

    public abstract void build() throws IOException;

    protected void build(XMLNode xMLNode, Content content) {
        String string = xMLNode.name;
        try {
            this.invokeMethod("build" + string, new Class[]{XMLNode.class, Content.class}, new Object[]{xMLNode, content});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            this.configuration.root.printError("Unknown element: " + string);
            throw new DocletAbortException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DocletAbortException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.configuration.root.printError("Exception " + exception.getClass().getName() + " thrown while processing element: " + string);
            throw new DocletAbortException(exception);
        }
    }

    protected void buildChildren(XMLNode xMLNode, Content content) {
        for (XMLNode xMLNode2 : xMLNode.children) {
            this.build(xMLNode2, content);
        }
    }

    protected void invokeMethod(String string, Class<?>[] classArray, Object[] objectArray) throws Exception {
        Method method = this.getClass().getMethod(string, classArray);
        method.invoke((Object)this, objectArray);
    }

    public static class Context {
        final Configuration configuration;
        final Set<String> containingPackagesSeen;
        final LayoutParser layoutParser;

        Context(Configuration configuration, Set<String> set, LayoutParser layoutParser) {
            this.configuration = configuration;
            this.containingPackagesSeen = set;
            this.layoutParser = layoutParser;
        }
    }
}

