/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html.markup;

import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentBuilder
extends Content {
    protected List<Content> contents = Collections.emptyList();

    @Override
    public void addContent(Content content) {
        ContentBuilder.nullCheck(content);
        this.ensureMutableContents();
        if (content instanceof ContentBuilder) {
            this.contents.addAll(((ContentBuilder)content).contents);
        } else {
            this.contents.add(content);
        }
    }

    @Override
    public void addContent(String string) {
        StringContent stringContent;
        Content content;
        if (string.isEmpty()) {
            return;
        }
        this.ensureMutableContents();
        Content content2 = content = this.contents.isEmpty() ? null : this.contents.get(this.contents.size() - 1);
        if (content != null && content instanceof StringContent) {
            stringContent = (StringContent)content;
        } else {
            stringContent = new StringContent();
            this.contents.add(stringContent);
        }
        stringContent.addContent(string);
    }

    @Override
    public boolean write(Writer writer, boolean bl) throws IOException {
        for (Content content : this.contents) {
            bl = content.write(writer, bl);
        }
        return bl;
    }

    @Override
    public boolean isEmpty() {
        for (Content content : this.contents) {
            if (content.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int charCount() {
        int n = 0;
        for (Content content : this.contents) {
            n += content.charCount();
        }
        return n;
    }

    private void ensureMutableContents() {
        if (this.contents.isEmpty()) {
            this.contents = new ArrayList<Content>();
        }
    }
}

