/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set<ClassDoc> documentedClasses;

    public PackageFrameWriter(ConfigurationImpl configurationImpl, PackageDoc packageDoc) throws IOException {
        super(configurationImpl, DocPath.forPackage(packageDoc).resolve(DocPaths.PACKAGE_FRAME));
        this.packageDoc = packageDoc;
        if (configurationImpl.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configurationImpl.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packageFrameWriter = new PackageFrameWriter(configurationImpl, packageDoc);
            String string = Util.getPackageName(packageDoc);
            HtmlTree htmlTree = packageFrameWriter.getBody(false, packageFrameWriter.getWindowTitle(string));
            StringContent stringContent = new StringContent(string);
            HtmlTree htmlTree2 = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, packageFrameWriter.getTargetPackageLink(packageDoc, "classFrame", stringContent));
            ((Content)htmlTree).addContent(htmlTree2);
            HtmlTree htmlTree3 = new HtmlTree(HtmlTag.DIV);
            htmlTree3.addStyle(HtmlStyle.indexContainer);
            packageFrameWriter.addClassListing(htmlTree3);
            ((Content)htmlTree).addContent(htmlTree3);
            packageFrameWriter.printHtmlDocument(configurationImpl.metakeywords.getMetaKeywords(packageDoc), false, htmlTree);
            packageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), DocPaths.PACKAGE_FRAME.getPath());
            throw new DocletAbortException(iOException);
        }
    }

    protected void addClassListing(Content content) {
        ConfigurationImpl configurationImpl = this.configuration;
        if (this.packageDoc.isIncluded()) {
            this.addClassKindListing(this.packageDoc.interfaces(), this.getResource("doclet.Interfaces"), content);
            this.addClassKindListing(this.packageDoc.ordinaryClasses(), this.getResource("doclet.Classes"), content);
            this.addClassKindListing(this.packageDoc.enums(), this.getResource("doclet.Enums"), content);
            this.addClassKindListing(this.packageDoc.exceptions(), this.getResource("doclet.Exceptions"), content);
            this.addClassKindListing(this.packageDoc.errors(), this.getResource("doclet.Errors"), content);
            this.addClassKindListing((ClassDoc[])this.packageDoc.annotationTypes(), this.getResource("doclet.AnnotationTypes"), content);
        } else {
            String string = Util.getPackageName(this.packageDoc);
            this.addClassKindListing(configurationImpl.classDocCatalog.interfaces(string), this.getResource("doclet.Interfaces"), content);
            this.addClassKindListing(configurationImpl.classDocCatalog.ordinaryClasses(string), this.getResource("doclet.Classes"), content);
            this.addClassKindListing(configurationImpl.classDocCatalog.enums(string), this.getResource("doclet.Enums"), content);
            this.addClassKindListing(configurationImpl.classDocCatalog.exceptions(string), this.getResource("doclet.Exceptions"), content);
            this.addClassKindListing(configurationImpl.classDocCatalog.errors(string), this.getResource("doclet.Errors"), content);
            this.addClassKindListing(configurationImpl.classDocCatalog.annotationTypes(string), this.getResource("doclet.AnnotationTypes"), content);
        }
    }

    protected void addClassKindListing(ClassDoc[] classDocArray, Content content, Content content2) {
        if ((classDocArray = Util.filterOutPrivateClasses(classDocArray, this.configuration.javafx)).length > 0) {
            Arrays.sort(classDocArray);
            boolean bl = false;
            HtmlTree htmlTree = new HtmlTree(HtmlTag.UL);
            htmlTree.setTitle(content);
            for (int i = 0; i < classDocArray.length; ++i) {
                Content content3;
                if (this.documentedClasses != null && !this.documentedClasses.contains(classDocArray[i]) || !Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                if (!bl) {
                    content3 = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, true, content);
                    content2.addContent(content3);
                    bl = true;
                }
                content3 = new StringContent(classDocArray[i].name());
                if (classDocArray[i].isInterface()) {
                    content3 = HtmlTree.SPAN(HtmlStyle.interfaceName, content3);
                }
                Content content4 = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.PACKAGE_FRAME, classDocArray[i]).label(content3).target("classFrame"));
                HtmlTree htmlTree2 = HtmlTree.LI(content4);
                htmlTree.addContent(htmlTree2);
            }
            content2.addContent(htmlTree);
        }
    }
}

