/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.AnnotatedType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.markup.ContentBuilder;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkFactory;
import com.sun.tools.doclets.internal.toolkit.util.links.LinkInfo;
import java.util.List;

public class LinkFactoryImpl
extends LinkFactory {
    private HtmlDocletWriter m_writer;

    public LinkFactoryImpl(HtmlDocletWriter htmlDocletWriter) {
        this.m_writer = htmlDocletWriter;
    }

    @Override
    protected Content newContent() {
        return new ContentBuilder();
    }

    @Override
    protected Content getClassLink(LinkInfo linkInfo) {
        LinkInfoImpl linkInfoImpl = (LinkInfoImpl)linkInfo;
        boolean bl = linkInfo.label == null || linkInfo.label.isEmpty();
        ClassDoc classDoc = linkInfoImpl.classDoc;
        String string = linkInfoImpl.where == null || linkInfoImpl.where.length() == 0 ? this.getClassToolTip(classDoc, linkInfoImpl.type != null && !classDoc.qualifiedTypeName().equals(linkInfoImpl.type.qualifiedTypeName())) : "";
        Content content = linkInfoImpl.getClassLinkLabel(this.m_writer.configuration);
        ConfigurationImpl configurationImpl = this.m_writer.configuration;
        ContentBuilder contentBuilder = new ContentBuilder();
        if (classDoc.isIncluded()) {
            if (configurationImpl.isGeneratedDoc(classDoc)) {
                DocPath docPath = this.getPath(linkInfoImpl);
                if (linkInfo.linkToSelf || !DocPath.forName(classDoc).equals(this.m_writer.filename)) {
                    ((Content)contentBuilder).addContent(this.m_writer.getHyperLink(docPath.fragment(linkInfoImpl.where), content, linkInfoImpl.isStrong, linkInfoImpl.styleName, string, linkInfoImpl.target));
                    if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
                        ((Content)contentBuilder).addContent(this.getTypeParameterLinks(linkInfo));
                    }
                    return contentBuilder;
                }
            }
        } else {
            Content content2 = this.m_writer.getCrossClassLink(classDoc.qualifiedName(), linkInfoImpl.where, content, linkInfoImpl.isStrong, linkInfoImpl.styleName, true);
            if (content2 != null) {
                ((Content)contentBuilder).addContent(content2);
                if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
                    ((Content)contentBuilder).addContent(this.getTypeParameterLinks(linkInfo));
                }
                return contentBuilder;
            }
        }
        ((Content)contentBuilder).addContent(content);
        if (bl && !linkInfoImpl.excludeTypeParameterLinks) {
            ((Content)contentBuilder).addContent(this.getTypeParameterLinks(linkInfo));
        }
        return contentBuilder;
    }

    @Override
    protected Content getTypeParameterLink(LinkInfo linkInfo, Type type) {
        LinkInfoImpl linkInfoImpl = new LinkInfoImpl(this.m_writer.configuration, ((LinkInfoImpl)linkInfo).getContext(), type);
        linkInfoImpl.excludeTypeBounds = linkInfo.excludeTypeBounds;
        linkInfoImpl.excludeTypeParameterLinks = linkInfo.excludeTypeParameterLinks;
        linkInfoImpl.linkToSelf = linkInfo.linkToSelf;
        linkInfoImpl.isJava5DeclarationLocation = false;
        return this.getLink(linkInfoImpl);
    }

    @Override
    protected Content getTypeAnnotationLink(LinkInfo linkInfo, AnnotationDesc annotationDesc) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public Content getTypeAnnotationLinks(LinkInfo linkInfo) {
        AnnotationDesc[] annotationDescArray;
        ContentBuilder contentBuilder = new ContentBuilder();
        if (linkInfo.type instanceof AnnotatedType) {
            annotationDescArray = linkInfo.type.asAnnotatedType().annotations();
        } else if (linkInfo.type instanceof TypeVariable) {
            annotationDescArray = linkInfo.type.asTypeVariable().annotations();
        } else {
            return contentBuilder;
        }
        if (annotationDescArray.length == 0) {
            return contentBuilder;
        }
        List<Content> list = this.m_writer.getAnnotations(0, annotationDescArray, false, linkInfo.isJava5DeclarationLocation);
        boolean bl = true;
        for (Content content : list) {
            if (!bl) {
                contentBuilder.addContent(" ");
            }
            contentBuilder.addContent(content);
            bl = false;
        }
        if (!list.isEmpty()) {
            contentBuilder.addContent(" ");
        }
        return contentBuilder;
    }

    private String getClassToolTip(ClassDoc classDoc, boolean bl) {
        ConfigurationImpl configurationImpl = this.m_writer.configuration;
        if (bl) {
            return configurationImpl.getText("doclet.Href_Type_Param_Title", classDoc.name());
        }
        if (classDoc.isInterface()) {
            return configurationImpl.getText("doclet.Href_Interface_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isAnnotationType()) {
            return configurationImpl.getText("doclet.Href_Annotation_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        if (classDoc.isEnum()) {
            return configurationImpl.getText("doclet.Href_Enum_Title", Util.getPackageName(classDoc.containingPackage()));
        }
        return configurationImpl.getText("doclet.Href_Class_Title", Util.getPackageName(classDoc.containingPackage()));
    }

    private DocPath getPath(LinkInfoImpl linkInfoImpl) {
        if (linkInfoImpl.context == LinkInfoImpl.Kind.PACKAGE_FRAME) {
            return DocPath.forName(linkInfoImpl.classDoc);
        }
        return this.m_writer.pathToRoot.resolve(DocPath.forClass(linkInfoImpl.classDoc));
    }
}

