/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Annotation;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TypeAnnotation {
    public final ConstantPool constant_pool;
    public final Position position;
    public final Annotation annotation;

    TypeAnnotation(ClassReader classReader) throws IOException, Annotation.InvalidAnnotation {
        this.constant_pool = classReader.getConstantPool();
        this.position = TypeAnnotation.read_position(classReader);
        this.annotation = new Annotation(classReader);
    }

    public TypeAnnotation(ConstantPool constantPool, Annotation annotation, Position position) {
        this.constant_pool = constantPool;
        this.position = position;
        this.annotation = annotation;
    }

    public int length() {
        int n = this.annotation.length();
        return n += TypeAnnotation.position_length(this.position);
    }

    public String toString() {
        try {
            return "@" + this.constant_pool.getUTF8Value(this.annotation.type_index).toString().substring(1) + " pos: " + this.position.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return exception.toString();
        }
    }

    private static Position read_position(ClassReader classReader) throws IOException, Annotation.InvalidAnnotation {
        int n;
        int n2 = classReader.readUnsignedByte();
        if (!TargetType.isValidTargetTypeValue(n2)) {
            throw new Annotation.InvalidAnnotation("TypeAnnotation: Invalid type annotation target type value: " + String.format("0x%02X", n2));
        }
        TargetType targetType = TargetType.fromTargetTypeValue(n2);
        Position position = new Position();
        position.type = targetType;
        switch (targetType) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                position.offset = classReader.readUnsignedShort();
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                int n3;
                n = classReader.readUnsignedShort();
                position.lvarOffset = new int[n];
                position.lvarLength = new int[n];
                position.lvarIndex = new int[n];
                for (n3 = 0; n3 < n; ++n3) {
                    position.lvarOffset[n3] = classReader.readUnsignedShort();
                    position.lvarLength[n3] = classReader.readUnsignedShort();
                    position.lvarIndex[n3] = classReader.readUnsignedShort();
                }
                break;
            }
            case EXCEPTION_PARAMETER: {
                position.exception_index = classReader.readUnsignedShort();
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                position.parameter_index = classReader.readUnsignedByte();
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                position.parameter_index = classReader.readUnsignedByte();
                position.bound_index = classReader.readUnsignedByte();
                break;
            }
            case CLASS_EXTENDS: {
                int n3 = classReader.readUnsignedShort();
                if (n3 == 65535) {
                    n3 = -1;
                }
                position.type_index = n3;
                break;
            }
            case THROWS: {
                position.type_index = classReader.readUnsignedShort();
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                position.parameter_index = classReader.readUnsignedByte();
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                position.offset = classReader.readUnsignedShort();
                position.type_index = classReader.readUnsignedByte();
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"TypeAnnotation: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("TypeAnnotation: Unknown target type: " + (Object)((Object)targetType)));
            }
        }
        n = classReader.readUnsignedByte();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n * 2; ++i) {
            arrayList.add(classReader.readUnsignedByte());
        }
        position.location = Position.getTypePathFromBinary(arrayList);
        return position;
    }

    private static int position_length(Position position) {
        int n = 0;
        ++n;
        switch (position.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                n += 2;
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                n += 2;
                int n2 = position.lvarOffset.length;
                n += 2 * n2;
                n += 2 * n2;
                n += 2 * n2;
                break;
            }
            case EXCEPTION_PARAMETER: {
                n += 2;
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                ++n;
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                ++n;
                ++n;
                break;
            }
            case CLASS_EXTENDS: {
                n += 2;
                break;
            }
            case THROWS: {
                n += 2;
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                ++n;
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                n += 2;
                ++n;
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"TypeAnnotation: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("TypeAnnotation: Unknown target type: " + (Object)((Object)position.type)));
            }
        }
        ++n;
        return n += 2 * position.location.size();
    }

    public static final class TargetType
    extends Enum<TargetType> {
        public static final /* enum */ TargetType CLASS_TYPE_PARAMETER;
        public static final /* enum */ TargetType METHOD_TYPE_PARAMETER;
        public static final /* enum */ TargetType CLASS_EXTENDS;
        public static final /* enum */ TargetType CLASS_TYPE_PARAMETER_BOUND;
        public static final /* enum */ TargetType METHOD_TYPE_PARAMETER_BOUND;
        public static final /* enum */ TargetType FIELD;
        public static final /* enum */ TargetType METHOD_RETURN;
        public static final /* enum */ TargetType METHOD_RECEIVER;
        public static final /* enum */ TargetType METHOD_FORMAL_PARAMETER;
        public static final /* enum */ TargetType THROWS;
        public static final /* enum */ TargetType LOCAL_VARIABLE;
        public static final /* enum */ TargetType RESOURCE_VARIABLE;
        public static final /* enum */ TargetType EXCEPTION_PARAMETER;
        public static final /* enum */ TargetType INSTANCEOF;
        public static final /* enum */ TargetType NEW;
        public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE;
        public static final /* enum */ TargetType METHOD_REFERENCE;
        public static final /* enum */ TargetType CAST;
        public static final /* enum */ TargetType CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT;
        public static final /* enum */ TargetType METHOD_INVOCATION_TYPE_ARGUMENT;
        public static final /* enum */ TargetType CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT;
        public static final /* enum */ TargetType METHOD_REFERENCE_TYPE_ARGUMENT;
        public static final /* enum */ TargetType UNKNOWN;
        private static final int MAXIMUM_TARGET_TYPE_VALUE = 75;
        private final int targetTypeValue;
        private final boolean isLocal;
        private static final TargetType[] targets;
        private static final /* synthetic */ TargetType[] $VALUES;

        public static TargetType[] values() {
            return (TargetType[])$VALUES.clone();
        }

        public static TargetType valueOf(String string) {
            return Enum.valueOf(TargetType.class, string);
        }

        private TargetType(int n2) {
            this(n2, false);
        }

        private TargetType(int n2, boolean bl) {
            if (n2 < 0 || n2 > 255) {
                throw new AssertionError((Object)("Attribute type value needs to be an unsigned byte: " + String.format("0x%02X", n2)));
            }
            this.targetTypeValue = n2;
            this.isLocal = bl;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public int targetTypeValue() {
            return this.targetTypeValue;
        }

        public static boolean isValidTargetTypeValue(int n) {
            if (n == TargetType.UNKNOWN.targetTypeValue) {
                return true;
            }
            return n >= 0 && n < targets.length;
        }

        public static TargetType fromTargetTypeValue(int n) {
            if (n == TargetType.UNKNOWN.targetTypeValue) {
                return UNKNOWN;
            }
            if (n < 0 || n >= targets.length) {
                throw new AssertionError((Object)("Unknown TargetType: " + n));
            }
            return targets[n];
        }

        static {
            TargetType[] targetTypeArray;
            CLASS_TYPE_PARAMETER = new TargetType(0);
            METHOD_TYPE_PARAMETER = new TargetType(1);
            CLASS_EXTENDS = new TargetType(16);
            CLASS_TYPE_PARAMETER_BOUND = new TargetType(17);
            METHOD_TYPE_PARAMETER_BOUND = new TargetType(18);
            FIELD = new TargetType(19);
            METHOD_RETURN = new TargetType(20);
            METHOD_RECEIVER = new TargetType(21);
            METHOD_FORMAL_PARAMETER = new TargetType(22);
            THROWS = new TargetType(23);
            LOCAL_VARIABLE = new TargetType(64, true);
            RESOURCE_VARIABLE = new TargetType(65, true);
            EXCEPTION_PARAMETER = new TargetType(66, true);
            INSTANCEOF = new TargetType(67, true);
            NEW = new TargetType(68, true);
            CONSTRUCTOR_REFERENCE = new TargetType(69, true);
            METHOD_REFERENCE = new TargetType(70, true);
            CAST = new TargetType(71, true);
            CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT = new TargetType(72, true);
            METHOD_INVOCATION_TYPE_ARGUMENT = new TargetType(73, true);
            CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT = new TargetType(74, true);
            METHOD_REFERENCE_TYPE_ARGUMENT = new TargetType(75, true);
            UNKNOWN = new TargetType(255);
            $VALUES = new TargetType[]{CLASS_TYPE_PARAMETER, METHOD_TYPE_PARAMETER, CLASS_EXTENDS, CLASS_TYPE_PARAMETER_BOUND, METHOD_TYPE_PARAMETER_BOUND, FIELD, METHOD_RETURN, METHOD_RECEIVER, METHOD_FORMAL_PARAMETER, THROWS, LOCAL_VARIABLE, RESOURCE_VARIABLE, EXCEPTION_PARAMETER, INSTANCEOF, NEW, CONSTRUCTOR_REFERENCE, METHOD_REFERENCE, CAST, CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT, METHOD_INVOCATION_TYPE_ARGUMENT, CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT, METHOD_REFERENCE_TYPE_ARGUMENT, UNKNOWN};
            targets = new TargetType[76];
            for (TargetType targetType : targetTypeArray = TargetType.values()) {
                if (targetType.targetTypeValue == TargetType.UNKNOWN.targetTypeValue) continue;
                TargetType.targets[targetType.targetTypeValue] = targetType;
            }
            for (int i = 0; i <= 75; ++i) {
                if (targets[i] != null) continue;
                TargetType.targets[i] = UNKNOWN;
            }
        }
    }

    public static class Position {
        public TargetType type = TargetType.UNKNOWN;
        public List<TypePathEntry> location = new ArrayList<TypePathEntry>(0);
        public int pos = -1;
        public boolean isValidOffset = false;
        public int offset = -1;
        public int[] lvarOffset = null;
        public int[] lvarLength = null;
        public int[] lvarIndex = null;
        public int bound_index = Integer.MIN_VALUE;
        public int parameter_index = Integer.MIN_VALUE;
        public int type_index = Integer.MIN_VALUE;
        public int exception_index = Integer.MIN_VALUE;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append((Object)this.type);
            switch (this.type) {
                case INSTANCEOF: 
                case NEW: 
                case CONSTRUCTOR_REFERENCE: 
                case METHOD_REFERENCE: {
                    stringBuilder.append(", offset = ");
                    stringBuilder.append(this.offset);
                    break;
                }
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: {
                    if (this.lvarOffset == null) {
                        stringBuilder.append(", lvarOffset is null!");
                        break;
                    }
                    stringBuilder.append(", {");
                    for (int i = 0; i < this.lvarOffset.length; ++i) {
                        if (i != 0) {
                            stringBuilder.append("; ");
                        }
                        stringBuilder.append("start_pc = ");
                        stringBuilder.append(this.lvarOffset[i]);
                        stringBuilder.append(", length = ");
                        stringBuilder.append(this.lvarLength[i]);
                        stringBuilder.append(", index = ");
                        stringBuilder.append(this.lvarIndex[i]);
                    }
                    stringBuilder.append("}");
                    break;
                }
                case METHOD_RECEIVER: {
                    break;
                }
                case CLASS_TYPE_PARAMETER: 
                case METHOD_TYPE_PARAMETER: {
                    stringBuilder.append(", param_index = ");
                    stringBuilder.append(this.parameter_index);
                    break;
                }
                case CLASS_TYPE_PARAMETER_BOUND: 
                case METHOD_TYPE_PARAMETER_BOUND: {
                    stringBuilder.append(", param_index = ");
                    stringBuilder.append(this.parameter_index);
                    stringBuilder.append(", bound_index = ");
                    stringBuilder.append(this.bound_index);
                    break;
                }
                case CLASS_EXTENDS: {
                    stringBuilder.append(", type_index = ");
                    stringBuilder.append(this.type_index);
                    break;
                }
                case THROWS: {
                    stringBuilder.append(", type_index = ");
                    stringBuilder.append(this.type_index);
                    break;
                }
                case EXCEPTION_PARAMETER: {
                    stringBuilder.append(", exception_index = ");
                    stringBuilder.append(this.exception_index);
                    break;
                }
                case METHOD_FORMAL_PARAMETER: {
                    stringBuilder.append(", param_index = ");
                    stringBuilder.append(this.parameter_index);
                    break;
                }
                case CAST: 
                case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
                case METHOD_INVOCATION_TYPE_ARGUMENT: 
                case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
                case METHOD_REFERENCE_TYPE_ARGUMENT: {
                    stringBuilder.append(", offset = ");
                    stringBuilder.append(this.offset);
                    stringBuilder.append(", type_index = ");
                    stringBuilder.append(this.type_index);
                    break;
                }
                case METHOD_RETURN: 
                case FIELD: {
                    break;
                }
                case UNKNOWN: {
                    stringBuilder.append(", position UNKNOWN!");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown target type: " + (Object)((Object)this.type)));
                }
            }
            if (!this.location.isEmpty()) {
                stringBuilder.append(", location = (");
                stringBuilder.append(this.location);
                stringBuilder.append(")");
            }
            stringBuilder.append(", pos = ");
            stringBuilder.append(this.pos);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        public boolean emitToClassfile() {
            return !this.type.isLocal() || this.isValidOffset;
        }

        public static List<TypePathEntry> getTypePathFromBinary(List<Integer> list) {
            ArrayList<TypePathEntry> arrayList = new ArrayList<TypePathEntry>(list.size() / 2);
            for (int i = 0; i < list.size(); i += 2) {
                if (i + 1 == list.size()) {
                    throw new AssertionError((Object)("Could not decode type path: " + list));
                }
                arrayList.add(TypePathEntry.fromBinary(list.get(i), list.get(i + 1)));
            }
            return arrayList;
        }

        public static List<Integer> getBinaryFromTypePath(List<TypePathEntry> list) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size() * 2);
            for (TypePathEntry typePathEntry : list) {
                arrayList.add(typePathEntry.tag.tag);
                arrayList.add(typePathEntry.arg);
            }
            return arrayList;
        }

        public static class TypePathEntry {
            public static final int bytesPerEntry = 2;
            public final TypePathEntryKind tag;
            public final int arg;
            public static final TypePathEntry ARRAY = new TypePathEntry(TypePathEntryKind.ARRAY);
            public static final TypePathEntry INNER_TYPE = new TypePathEntry(TypePathEntryKind.INNER_TYPE);
            public static final TypePathEntry WILDCARD = new TypePathEntry(TypePathEntryKind.WILDCARD);

            private TypePathEntry(TypePathEntryKind typePathEntryKind) {
                if (typePathEntryKind != TypePathEntryKind.ARRAY && typePathEntryKind != TypePathEntryKind.INNER_TYPE && typePathEntryKind != TypePathEntryKind.WILDCARD) {
                    throw new AssertionError((Object)("Invalid TypePathEntryKind: " + (Object)((Object)typePathEntryKind)));
                }
                this.tag = typePathEntryKind;
                this.arg = 0;
            }

            public TypePathEntry(TypePathEntryKind typePathEntryKind, int n) {
                if (typePathEntryKind != TypePathEntryKind.TYPE_ARGUMENT) {
                    throw new AssertionError((Object)("Invalid TypePathEntryKind: " + (Object)((Object)typePathEntryKind)));
                }
                this.tag = typePathEntryKind;
                this.arg = n;
            }

            public static TypePathEntry fromBinary(int n, int n2) {
                if (n2 != 0 && n != TypePathEntryKind.TYPE_ARGUMENT.tag) {
                    throw new AssertionError((Object)("Invalid TypePathEntry tag/arg: " + n + "/" + n2));
                }
                switch (n) {
                    case 0: {
                        return ARRAY;
                    }
                    case 1: {
                        return INNER_TYPE;
                    }
                    case 2: {
                        return WILDCARD;
                    }
                    case 3: {
                        return new TypePathEntry(TypePathEntryKind.TYPE_ARGUMENT, n2);
                    }
                }
                throw new AssertionError((Object)("Invalid TypePathEntryKind tag: " + n));
            }

            public String toString() {
                return this.tag.toString() + (this.tag == TypePathEntryKind.TYPE_ARGUMENT ? "(" + this.arg + ")" : "");
            }

            public boolean equals(Object object) {
                if (!(object instanceof TypePathEntry)) {
                    return false;
                }
                TypePathEntry typePathEntry = (TypePathEntry)object;
                return this.tag == typePathEntry.tag && this.arg == typePathEntry.arg;
            }

            public int hashCode() {
                return this.tag.hashCode() * 17 + this.arg;
            }
        }

        public static enum TypePathEntryKind {
            ARRAY(0),
            INNER_TYPE(1),
            WILDCARD(2),
            TYPE_ARGUMENT(3);

            public final int tag;

            private TypePathEntryKind(int n2) {
                this.tag = n2;
            }
        }
    }
}

