/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ClassFile {
    public final int magic;
    public final int minor_version;
    public final int major_version;
    public final ConstantPool constant_pool;
    public final AccessFlags access_flags;
    public final int this_class;
    public final int super_class;
    public final int[] interfaces;
    public final Field[] fields;
    public final Method[] methods;
    public final Attributes attributes;

    public static ClassFile read(File file) throws IOException, ConstantPoolException {
        return ClassFile.read(file.toPath(), new Attribute.Factory());
    }

    public static ClassFile read(Path path) throws IOException, ConstantPoolException {
        return ClassFile.read(path, new Attribute.Factory());
    }

    public static ClassFile read(Path path, Attribute.Factory factory) throws IOException, ConstantPoolException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            ClassFile classFile = new ClassFile(inputStream, factory);
            return classFile;
        }
    }

    public static ClassFile read(File file, Attribute.Factory factory) throws IOException, ConstantPoolException {
        return ClassFile.read(file.toPath(), factory);
    }

    public static ClassFile read(InputStream inputStream) throws IOException, ConstantPoolException {
        return new ClassFile(inputStream, new Attribute.Factory());
    }

    public static ClassFile read(InputStream inputStream, Attribute.Factory factory) throws IOException, ConstantPoolException {
        return new ClassFile(inputStream, factory);
    }

    ClassFile(InputStream inputStream, Attribute.Factory factory) throws IOException, ConstantPoolException {
        int n;
        int n2;
        ClassReader classReader = new ClassReader(this, inputStream, factory);
        this.magic = classReader.readInt();
        this.minor_version = classReader.readUnsignedShort();
        this.major_version = classReader.readUnsignedShort();
        this.constant_pool = new ConstantPool(classReader);
        this.access_flags = new AccessFlags(classReader);
        this.this_class = classReader.readUnsignedShort();
        this.super_class = classReader.readUnsignedShort();
        int n3 = classReader.readUnsignedShort();
        this.interfaces = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.interfaces[n2] = classReader.readUnsignedShort();
        }
        n2 = classReader.readUnsignedShort();
        this.fields = new Field[n2];
        for (n = 0; n < n2; ++n) {
            this.fields[n] = new Field(classReader);
        }
        n = classReader.readUnsignedShort();
        this.methods = new Method[n];
        for (int i = 0; i < n; ++i) {
            this.methods[i] = new Method(classReader);
        }
        this.attributes = new Attributes(classReader);
    }

    public ClassFile(int n, int n2, int n3, ConstantPool constantPool, AccessFlags accessFlags, int n4, int n5, int[] nArray, Field[] fieldArray, Method[] methodArray, Attributes attributes) {
        this.magic = n;
        this.minor_version = n2;
        this.major_version = n3;
        this.constant_pool = constantPool;
        this.access_flags = accessFlags;
        this.this_class = n4;
        this.super_class = n5;
        this.interfaces = nArray;
        this.fields = fieldArray;
        this.methods = methodArray;
        this.attributes = attributes;
    }

    public String getName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.this_class).getName();
    }

    public String getSuperclassName() throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.super_class).getName();
    }

    public String getInterfaceName(int n) throws ConstantPoolException {
        return this.constant_pool.getClassInfo(this.interfaces[n]).getName();
    }

    public Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return this.access_flags.is(512);
    }

    public int byteLength() {
        return 8 + this.constant_pool.byteLength() + 2 + 2 + 2 + this.byteLength(this.interfaces) + this.byteLength(this.fields) + this.byteLength(this.methods) + this.attributes.byteLength();
    }

    private int byteLength(int[] nArray) {
        return 2 + 2 * nArray.length;
    }

    private int byteLength(Field[] fieldArray) {
        int n = 2;
        for (Field field : fieldArray) {
            n += field.byteLength();
        }
        return n;
    }

    private int byteLength(Method[] methodArray) {
        int n = 2;
        for (Method method : methodArray) {
            n += method.byteLength();
        }
        return n;
    }
}

