/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel.internal.writer;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.writer.FilterCodeWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class PrologCodeWriter
extends FilterCodeWriter {
    private final String prolog;

    public PrologCodeWriter(CodeWriter core, String prolog) {
        super(core);
        this.prolog = prolog;
    }

    @Override
    public Writer openSource(JPackage pkg, String fileName) throws IOException {
        Writer w = super.openSource(pkg, fileName);
        PrintWriter out = new PrintWriter(w);
        if (this.prolog != null) {
            int idx;
            out.println("//");
            String s = this.prolog;
            while ((idx = s.indexOf(10)) != -1) {
                out.println("// " + s.substring(0, idx));
                s = s.substring(idx + 1);
            }
            out.println("//");
            out.println();
        }
        out.flush();
        return w;
    }
}

