<?php

namespace app\home\controller;

use think\Lang;

class Connectqq extends BaseMall {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/connectqq.lang.php');
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/login-register.lang.php');
        /**
         * 判断qq互联功能是否开启
         */
        if (config('qq_isuse') != 1) {
            $this->error(lang('home_qqconnect_unavailable')); //'系统未开启QQ互联功能'
        }
        /**
         * 初始化测试数据
         */
        if (!session('openid')) {
            $this->error(lang('home_qqconnect_error')); //'系统错误'
        }
        $this->assign('hidden_nctoolbar', 1);
    }

    /**
     * 首页
     */
    public function index() {
        /**
         * 检查登录状态
         */
        if (session('is_login') == '1') {
            //qq绑定
            $this->bindqq();
        } else {
            $this->autologin();
            $this->register();
        }
    }

    private function checkWapQQlogin() {
        if ((session('m'))) {
            return true;
        }
        return false;
    }

    /**
     * qq绑定新用户
     */
    public function register() {
        //实例化模型
        $member_model = model('member');
        if (request()->isPost()) {
            if (model('member')->getMemberInfo(array('member_email' => input('param.email')))){
                $this->error(lang('login_register_email_exists'), 'Login/login');
            }
            $update_info = array();
            $update_info['member_password'] = md5(trim(input('post.password')));
            if (!empty(input('post.email'))) {
                $update_info['member_email'] = input('post.email');
                session('member_email', input('post.email'));
            }
            $member_model->editMember(array('member_id' => session('member_id')), $update_info);
            $this->error(lang('ds_common_save_succ'), HOME_SITE_URL);
        } else {
            //检查登录状态
            $member_model->checkloginMember();
            //获取qq账号信息
            require_once(PLUGINS_PATH . '/login/qq/user/get_user_info.php');
            $qquser_info = get_user_info();
            $this->assign('qquser_info', $qquser_info);
            $this->assign('user_passwd', '');

            $logic_connect_api = model('connectapi', 'logic');
            //注册会员信息 返回会员信息
            $reg_info = array(
                'member_qqopenid' => session('openid'),
                'nickname' => isset($qquser_info['nickname'])?$qquser_info['nickname']:'',
                'headimgurl' => isset($qquser_info['figureurl_qq_2'])?$qquser_info['figureurl_qq_2']:'',
            );




            $wx_member = $logic_connect_api->wx_register($reg_info, 'qq');
            if ($wx_member) {
                $member_model->createSession($wx_member, true);
                if ($this->checkWapQQlogin()) {
                    @header('location: ' . MOBILE_SITE_URL . '/index.php/login/qq');
                    exit;
                } else {
                    echo $this->fetch($this->template_dir . 'connect_register');
                }
            } else {
                $this->error(lang('login_usersave_regist_fail'), 'login/register'); //"会员注册失败"
            }
        }
    }

    /**
     * 已有用户绑定QQ
     */
    public function bindqq() {
        $member_model = model('member');
        //验证QQ账号用户是否已经存在
        $array = array();
        $array['member_qqopenid'] = session('openid');
        $member_info = $member_model->getMemberInfo($array);
        if (is_array($member_info) && count($member_info) > 0) {
            session('openid', null);
            $this->error(lang('home_qqconnect_binding_exist'), 'memberconnect/qqbind'); //'该QQ账号已经绑定其他商城账号,请使用其他QQ账号与本账号绑定'
        }
        //获取qq账号信息
        require_once(PLUGINS_PATH . '/login/qq/user/get_user_info.php');
        $qquser_info = get_user_info();
        $edit_state = $member_model->editMember(array('member_id' => session('member_id')), array(
            'member_qqopenid' => session('openid'), 'member_qqinfo' => serialize($qquser_info)
        ));
        if ($edit_state) {
            $this->success(lang('home_qqconnect_binding_success'), 'memberconnect/qqbind');
        } else {
            $this->error(lang('home_qqconnect_binding_fail'), 'memberconnect/qqbind'); //'绑定QQ失败'
        }
    }

    /**
     * 绑定qq后自动登录
     */
    public function autologin() {
        //查询是否已经绑定该qq,已经绑定则直接跳转
        $member_model = model('member');
        $array = array();
        $array['member_qqopenid'] = session('openid');
        $member_info = $member_model->getMemberInfo($array);
        if (is_array($member_info) && count($member_info) > 0) {
            if (!$member_info['member_state']) {//1为启用 0 为禁用
                $this->error(lang('ds_notallowed_login'));
            }
            $member_model->createSession($member_info);
            if ($this->checkWapQQlogin()) {
                @header('location: ' . MOBILE_SITE_URL . '/login/type/qq');
                exit;
            } else {
                $success_message = lang('login_index_login_success');
                $this->success($success_message, HOME_SITE_URL);
            }
        }
    }

    /**
     * 更换绑定QQ号码
     */
    public function changeqq() {
        //如果用户已经登录，进入此链接则显示错误
        if (session('is_login') == '1') {
            $this->error(lang('home_qqconnect_error'), 'index/index'); //'系统错误'
        }
        session('openid', null);
        @header('Location:' . HOME_SITE_URL . '/api/toqq');
        exit;
    }

}
