<?php

namespace app\admin\controller;

use think\Lang;

class Promotionmansong extends AdminControl {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/' . config('default_lang') . '/promotionmansong.lang.php');
    }

    /**
     * 活动列表
     * */
    public function index() {
        //自动开启满就送
        if (intval(input('param.promotion_allow')) === 1) {
            $config_model = model('config');
            $update_array = array();
            $update_array['promotion_allow'] = 1;
            $config_model->editConfig($update_array);
        }
        $mansong_model = model('pmansong');

        $param = array();
        if (!empty(input('param.mansong_name'))) {
            $param['mansong_name'] = array('like', '%' . input('param.mansong_name') . '%');
        }
        if (!empty(input('param.state'))) {
            $param['mansong_state'] = input('param.state');
        }
        $mansong_list = $mansong_model->getMansongList($param, 10);
        $this->assign('mansong_list', $mansong_list);
        $this->assign('show_page', $mansong_model->page_info->render());
        $this->assign('mansong_state_array', $mansong_model->getMansongStateArray());


        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 添加满就送活动
     * */
    public function mansong_add() {
        if (!request()->isPost()) {
            $pmansong_model = model('pmansong');
            $start_time = $pmansong_model->getMansongNewStartTime();
            $end_time = time();
            if (empty($start_time))
                $start_time = time();

            $this->assign('start_time', $start_time);
            $this->assign('end_time', $end_time);
            $this->setAdminCurItem('mansong_add');
            return $this->fetch();
        }else {
            $mansong_name = trim(input('post.mansong_name'));
            $start_time = strtotime(input('post.start_time'));
            $end_time = strtotime(input('post.end_time'));

            $pmansong_model = model('pmansong');
            $mansongrule_model = model('pmansongrule');

            if ($start_time >= $end_time) {
                ds_json_encode(10001,lang('greater_than_start_time'));
            }
            if (empty($mansong_name)) {
                ds_json_encode(10001,lang('mansong_name_error'));
            }

            $start_time_limit = $pmansong_model->getMansongNewStartTime();
            if (!empty($start_time_limit) && $start_time_limit > $start_time) {
                $start_time = $start_time_limit;
            }

            if (empty(input('post.mansong_rule/a'))) {
                ds_json_encode(10001,'满即送规则不能为空');
            }

            $param = array();
            $param['mansong_name'] = $mansong_name;
            $param['mansong_starttime'] = $start_time;
            $param['mansong_endtime'] = $end_time;
            $param['mansong_remark'] = trim(input('post.remark'));
            $mansong_id = $pmansong_model->addMansong($param);
            if ($mansong_id) {
                $mansong_rule_array = array();
                foreach (input('post.mansong_rule/a') as $value) {
                    list($price, $discount, $goods_id) = explode(',', $value);
                    $mansong_rule = array();
                    $mansong_rule['mansong_id'] = $mansong_id;
                    $mansong_rule['mansongrule_price'] = $price;
                    $mansong_rule['mansongrule_discount'] = $discount;
                    $mansong_rule['goods_id'] = $goods_id;
                    $mansong_rule_array[] = $mansong_rule;
                }
                //生成规则
                $result = $mansongrule_model->addMansongruleArray($mansong_rule_array);

                $this->log('添加满即送活动，活动名称：' . $mansong_name);


                ds_json_encode(10000,lang('mansong_add_success'));
            } else {
                ds_json_encode(10001,lang('mansong_add_fail'));
            }
        }
    }

    /**
     * 活动详细信息
     * temp
     * */
    public function mansong_detail() {
        $mansong_id = intval(input('param.mansong_id'));

        $mansong_model = model('pmansong');
        $mansongrule_model = model('pmansongrule');

        $mansong_info = $mansong_model->getMansongInfoByStoreID($mansong_id);
        if (empty($mansong_info)) {
            $this->error(lang('param_error'));
        }
        $this->assign('mansong_info', $mansong_info);

        $param = array();
        $param['mansong_id'] = $mansong_id;
        $mansongrule_list = $mansongrule_model->getMansongruleListByID($mansong_id);
        $this->assign('mansongrule_list', $mansongrule_list);

        return $this->fetch();
    }

    /**
     * 满即送活动取消
     * */
    public function mansong_cancel() {
        $mansong_id = intval(input('param.mansong_id'));

        if ($mansong_id <= 0) {
            ds_json_encode(10001, lang('param_error'));
        }

        $mansong_model = model('pmansong');
        $result = $mansong_model->cancelMansong(array('mansong_id' => $mansong_id));
        if ($result) {
            $this->log('取消满即送活动，活动编号' . $mansong_id);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }

    /**
     * 选择活动商品
     * */
    public function search_goods() {
        $goods_model = model('goods');
        $condition = array();
        $condition['goods_name'] = array('like', '%' . input('param.goods_name') . '%');
        $goods_list = $goods_model->getGeneralGoodsList($condition, '*', 8);

        $this->assign('goods_list', $goods_list);
        $this->assign('show_page', $goods_model->page_info->render());
        echo $this->fetch();
    }

    /**
     * 满即送活动删除
     * */
    public function mansong_del() {
        $mansong_model = model('pmansong');
        $mansong_id = input('param.mansong_id');
        $mansong_id_array = ds_delete_param($mansong_id);
        if ($mansong_id_array === FALSE) {
            ds_json_encode(10001, lang('param_error'));
        }
        $condition = array('mansong_id' => array('in', $mansong_id_array));
        $result = $mansong_model->delMansong($condition);
        if ($result) {
            $this->log('删除满即送活动，活动编号' . implode(',', $mansong_id_array));
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }

    /**
     * 页面内导航菜单
     *
     * @param string $menu_key 当前导航的menu_key
     * @param array $array 附加菜单
     * @return
     */
    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => lang('mansong_list'),
                'url' => url('Promotionmansong/index')
            ), array(
                'name' => 'mansong_add',
                'text' => lang('mansong_add'),
                'url' => url('Promotionmansong/mansong_add')
            ),
        );
        if (request()->action() == 'mansong_detail') {
            $menu_array[] = array(
                'name' => 'mansong_detail', 'text' => lang('mansong_detail'),
                'url' => url('Promotionmansong/mansong_detail')
            );
        }
        return $menu_array;
    }

}
