<?php

namespace app\admin\controller;


use think\Lang;

class Promotionbundling extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/'.config('default_lang').'/promotionbundling.lang.php');
    }



    /**
     * 活动管理
     */
    public function index()
    {
        $pbundling_model = model('pbundling');

        // 查询添加
        $where = '';
        if (input('param.bundling_name') != '') {
            $where['bl_name'] = array('like', '%' . trim(input('param.bundling_name')) . '%');
        }
        if (is_numeric(input('param.state'))) {
            $where['bl_state'] = input('param.state');
        }
        $pbundling_list = $pbundling_model->getBundlingList($where,'*','bl_id desc',10);
        $pbundling_list = array_under_reset($pbundling_list, 'bl_id');
        $this->assign('show_page', $pbundling_model->page_info->render());
        if (!empty($pbundling_list)) {
            $blid_array = array_keys($pbundling_list);
            $bgoods_array = $pbundling_model->getBundlingGoodsList(array( 'bl_id' => array('in', $blid_array)), 'bl_id,goods_id,count(*) as count', 'blgoods_appoint desc', 'bl_id');
            $bgoods_array = array_under_reset($bgoods_array, 'bl_id');
            foreach ($pbundling_list as $key => $val) {
                $pbundling_list[$key]['goods_id'] = isset($bgoods_array[$val['bl_id']]['goods_id'])?$bgoods_array[$val['bl_id']]['goods_id']:'';
                $pbundling_list[$key]['count'] = isset($bgoods_array[$val['bl_id']]['count'])?$bgoods_array[$val['bl_id']]['count']:'';
            }
        }
        $this->assign('pbundling_list', $pbundling_list);

        // 状态数组
        $state_array = array(0 => lang('ds_close'), 1 => lang('ds_open'));
        $this->assign('state_array', $state_array);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }
    
    
    /**
     * 套餐活动添加
     */
    public function bundling_add() {
        /**
         * 实例化模型
         */
        $pbundling_model = model('pbundling');

        if (request()->isPost()) {
            // 插入套餐
            $data = array();

            $bl_id = intval(input('post.bundling_id'));

            if ($bl_id <= 0) {
                $data['bl_name'] = input('post.bundling_name');
                $data['bl_discount_price'] = input('post.discount_price');
                $data['bl_freight_choose'] = input('post.bundling_freight_choose');
                $data['bl_freight'] = input('post.bundling_freight');
                $data['bl_state'] = intval(input('post.state'));
                $bl_id = $pbundling_model->addBundling($data);
                if (!$bl_id) {
                    ds_json_encode(10001,lang('ds_common_op_fail'));
                }
            } else {
                $condition['bl_id'] = $bl_id;
                $data['bl_name'] = input('post.bundling_name');
                $data['bl_discount_price'] = input('post.discount_price');
                $data['bl_freight_choose'] = input('post.bundling_freight_choose');
                $data['bl_freight'] = input('post.bundling_freight');
                $data['bl_state'] = intval(input('post.state'));
                $pbundling_model->editBundling($data, $condition);
            }


            // 插入套餐商品
            $goods_model = model('goods');
            $data_goods = array();
            $appoint_goodsid = false;
            if (input('post.bundling_id')) {
                $pbundling_model->delBundlingGoods(array('bl_id' => $bl_id));
            }
            $goods_array = input('post.goods/a');#获取数组
            if (!empty($goods_array) && is_array($goods_array)) {
                foreach ($goods_array as $key => $val) {
                    // 验证是否为本店铺商品
                    $goods_info = $goods_model->getGoodsInfoByID($val['gid']);
                    if (empty($goods_info)) {
                        continue;
                    }
                    $data = array();
                    $data['bl_id'] = $bl_id;
                    $data['goods_id'] = $goods_info['goods_id'];
                    $data['goods_name'] = $goods_info['goods_name'];
                    $data['goods_image'] = $goods_info['goods_image'];
                    $data['blgoods_price'] = ds_price_format($val['price']);
                    $data['blgoods_appoint'] = intval($val['appoint']);
                    if (!$appoint_goodsid && intval($val['appoint']) == 1) {
                        $appoint_goodsid = intval($val['gid']);
                    }
                    $data_goods[] = $data;
                }
            }
            // 插入数据
            $return = $pbundling_model->addBundlingGoodsAll($data_goods);
            $this->log('添加优惠套装，名称：' . input('post.bundling_name') . ' id：' . $return);
            ds_json_encode(10000,lang('ds_common_op_succ'));
        } else {
            // 是否能使用编辑器
                $editor_multimedia = true;
            $this->assign('editor_multimedia', $editor_multimedia);

            if (intval(input('param.bundling_id')) > 0) {
                $bundling_info = $pbundling_model->getBundlingInfo(array('bl_id' => intval(input('param.bundling_id'))));
                $this->assign('bundling_info', $bundling_info);

                $b_goods_list = $pbundling_model->getBundlingGoodsList(array('bl_id' => intval(input('param.bundling_id'))));
                if (!empty($b_goods_list)) {
                    $goodsid_array = array();
                    foreach ($b_goods_list as $val) {
                        $goodsid_array[] = $val['goods_id'];
                    }
                    $goods_list = model('goods')->getGoodsList(array('goods_id' => array('in', $goodsid_array)), 'goods_id,goods_price,goods_image,goods_name');
                    $this->assign('goods_list', array_under_reset($goods_list, 'goods_id'));
                }
                $this->assign('b_goods_list', $b_goods_list);
                // 输出导航
                $this->setAdminCurItem('bundling_edit');
            } else {
                $this->setAdminCurItem('bundling_add');
            }
            return $this->fetch('bundling_add');
        }
    }

    /**
     * 套餐活动添加商品
     */
    public function bundling_add_goods() {
        /**
         * 实例化模型
         */
        $goods_model = model('goods');

        // where条件
        $where = array();
        if (trim(input('param.keyword')) != '') {
            $where['goods_name'] = array('like', '%' . trim(input('param.keyword')) . '%');
        }

        $goods_list = $goods_model->getGoodsListForPromotion($where, '*', 8, 'bundling');
        $this->assign('show_page', $goods_model->page_info->render());
        $this->assign('goods_list', $goods_list);
        return $this->fetch( 'bundling_add_goods');
    }
    
    
    


    /**
     * 删除套餐活动
     */
    public function del_bundling()
    {
        $bl_id = intval(input('param.bl_id'));
        if ($bl_id <= 0) {
            $this->error(lang('param_error'));
        }
        $rs = model('pbundling')->delBundlingForAdmin(array('bl_id' => $bl_id));
        if ($rs) {
            $this->success(lang('ds_common_op_succ'));
        }
        else {
            $this->error(lang('ds_common_op_fail'));
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => lang('bundling_list'), 
                'url' => url('Promotionbundling/index')
            ),
            array(
                'name' => 'bundling_add',
                'text' => lang('bundling_add'), 
                'url' => url('Promotionbundling/bundling_add')
            ),
        );
        return $menu_array;
    }
}