<?php

namespace app\admin\controller;


use think\Lang;

class Mbcategorypic extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/'.config('default_lang').'/mobile.lang.php');
    }

    /**
     *
     */
    public function mb_category_list()
    {
        $mbcategory_model = model('mbcategory');
        $link_list = $mbcategory_model->getMbcategoryList(array());
        /**
         * 整理图片链接
         */
        if (is_array($link_list)) {
            foreach ($link_list as $k => $v) {
                if (!empty($v['gc_thumb'])) {
                    $link_list[$k]['gc_thumb'] = UPLOAD_SITE_URL . '/' . ATTACH_MOBILE . '/category' . '/' . $v['gc_thumb'];
                }
            }
        }
        /**
         * 商品分类
         */
        $goods_class = model('goodsclass')->getGoodsclassForCacheModel();
        $this->assign('goods_class', $goods_class);
        $this->setAdminCurItem('index');
        $this->assign('link_list', $link_list);
        return $this->fetch('category_list');
    }

    /**
     * 删除
     */
    public function mb_category_del()
    {
        $gc_id = input('param.gc_id');
        $gc_id_array = ds_delete_param($gc_id);
        if ($gc_id_array == FALSE) {
            ds_json_encode('10001', lang('link_index_choose_del'));
        }
        
        $mbcategory_model = model('mbcategory');
        foreach ($gc_id_array as $key => $value) {
            //删除图片
            $tmp = $mbcategory_model->getOneMbcategory($value);
            if (!empty($tmp['gc_thumb'])) {
                @unlink(BASE_UPLOAD_PATH . DS . ATTACH_MOBILE . '/category/' . $tmp['gc_thumb']);
            }
            $mbcategory_model->delMbcategory($value);
        }
        ds_json_encode(10000, lang('ds_common_del_succ'));
    }

    /**
     * 添加
     */
    public function mb_category_add()
    {

        $mbcategory_model = model('mbcategory');

        if (request()->isPost()) {
            $category = $mbcategory_model->getOneMbcategory(intval(input('post.link_category')));
            if (!empty($category)) {
                $this->error(lang('link_add_category_exist'));
            }
            /**
             * 上传图片
             */
            $link_pic = '';
            if ($_FILES['link_pic']['name'] != '') {
                $upload = request()->file('link_pic');
                $file_path= BASE_UPLOAD_PATH .DS.ATTACH_MOBILE . DS .'category';
                $result=$upload->rule('uniqid')->validate(['ext'=>ALLOW_IMG_EXT])->move($file_path);
                if ($result) {
                    $link_pic = $result->getFilename();
                }
                else {
                    $this->error($upload->getError());
                }
            }

            $insert_array = array();
            $insert_array['gc_id'] = trim(input('post.link_category'));
            $insert_array['gc_thumb'] = trim($link_pic);

            $result = $mbcategory_model->addMbcategory($insert_array);
            if ($result) {
                dsLayerOpenSuccess(lang('link_add_succ'));
            }
            else {
                $this->error(lang('link_add_fail'));
            }
        } else {
            /**
             * 商品分类
             */
            $goods_class = model('goodsclass')->getGoodsclassForCacheModel();
            $this->assign('goods_class', $goods_class);
            return $this->fetch('form');
        }
    }

    /**
     * 编辑
     */
    public function mb_category_edit()
    {
        $mbcategory_model = model('mbcategory');
        if (request()->isPost()) {
            $link_pic='';
            /**
             * 上传图片
             */
            if ($_FILES['link_pic']['name'] != '') {
                $upload = request()->file('link_pic');
                $file_path= BASE_UPLOAD_PATH .DS.ATTACH_MOBILE . DS .'category';
                $result=$upload->rule('uniqid')->validate(['ext'=>ALLOW_IMG_EXT])->move($file_path);
                if ($result) {
                    $link_pic = $result->getFilename();;
                }
                else {
                    $this->error($upload->getError());
                }
            }
            $link_array = $mbcategory_model->getOneMbcategory(intval(input('param.gc_id')));
            $update_array = array();
            $update_array['gc_id'] = intval(input('param.gc_id'));
            if ($link_pic) {
                $update_array['gc_thumb'] = $link_pic;
            }
            $result = $mbcategory_model->update($update_array);
            if ($result) {
                /**
                 * 删除图片
                 */
                if (!empty($link_pic) && !empty($link_array['gc_thumb'])) {
                    @unlink(BASE_UPLOAD_PATH . DS . ATTACH_MOBILE . '/category/' . $link_array['gc_thumb']);
                }
                dsLayerOpenSuccess(lang('ds_common_save_succ'));
            }
            else {
                $this->error(lang('ds_common_save_fail'));
            }
        }  else {
            $link_array = $mbcategory_model->getOneMbcategory(intval(input('param.gc_id')));
            if (empty($link_array)) {
                $this->error(lang('param_error'));
            }
            /**
             * 商品分类
             */
            $goods_class = model('goodsclass')->getGoodsclassForCacheModel();
            $this->assign('goods_class', $goods_class);

            $this->assign('link_array', $link_array);
            return $this->fetch('form');
        }
    }


    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name'=>'index','text'=>lang('ds_manage'),'url'=>url('Mbcategorypic/mb_category_list')
            ),array(
                'name'=>'add',
                'text'=>lang('ds_new'),
                'url'=>"javascript:dsLayerOpen('".url('Mbcategorypic/mb_category_add')."','".lang('ds_new')."')"
            )
        );
        return $menu_array;
    }
}