<?php

namespace app\admin\controller;


use think\Lang;

class Evaluate extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'admin/lang/'.config('default_lang').'/evaluate.lang.php');
    }

    /**
     * 商品来自买家的评价列表
     */
    public function evalgoods_list() {
        $evaluategoods_model = model('evaluategoods');

        $condition = array();
        //商品名称
        if (input('param.goods_name')) {
            $condition['geval_goodsname'] = array('like', '%'.input('param.goods_name').'%');
        }
        if(input('param.stime')&&input('param.etime')) {
            $stime = strtotime(input('param.stime'));
            $etime = strtotime(input('param.etime'));
            $condition['geval_addtime'] = array('between', array($stime, $etime));
        }
        $evalgoods_list	= $evaluategoods_model->getEvaluategoodsList($condition, 10);

        $this->assign('show_page',$evaluategoods_model->page_info->render());
        $this->assign('evalgoods_list',$evalgoods_list);
        
        $this->assign('filtered', $condition ? 1 : 0); //是否有查询条件
        
        $this->setAdminCurItem('evalgoods_list');
        return $this->fetch('index');
    }
    
    
    /**
     * 解释来自买家的评价
     */
    public function explain_save() {
        $geval_id = intval(input('param.geval_id'));
        $evaluategoods_model = model('evaluategoods');
        if (!request()->isPost()) {
            $evaluategoods = $evaluategoods_model->getEvaluategoodsInfoByID($geval_id);
            $this->assign('evaluategoods', $evaluategoods);
            return $this->fetch('explain_save');
        } else {
            $geval_explain = trim(input('post.geval_explain'));
            //验证表单
            if (!$geval_explain) {
                $this->error('解释内容不能为空');
            }
            $evaluate_info = $evaluategoods_model->getEvaluategoodsInfoByID($geval_id);
            if (empty($evaluate_info)) {
                $this->error(lang('param_error'));
            }

            $update = array('geval_explain' => $geval_explain);
            $condition = array('geval_id' => $geval_id);
            $result = $evaluategoods_model->editEvaluategoods($update, $condition);

            if ($result) {
                dsLayerOpenSuccess('解释成功');
            } else {
                $this->error('解释保存失败');
            }
        }
    }

    /**
     * 删除商品评价
     */
    public function evalgoods_del() {
        $geval_id = intval(input('param.geval_id'));
        if ($geval_id <= 0) {
            ds_json_encode(10001, lang('param_error'));
        }
        $evaluategoods_model = model('evaluategoods');
        $result = $evaluategoods_model->delEvaluategoods(array('geval_id'=>$geval_id));
        if ($result) {
            $this->log('删除商品评价，评价编号'.$geval_id);
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }


    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'evalgoods_list',
                'text' => lang('admin_evaluate_list'),
                'url' => url('Evaluate/evalgoods_list')
            )
        );
        return $menu_array;
    }
}