/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.platform;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaToKotlinClassMap {
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassId kotlinClassId = this.mapJavaToKotlin(fqName2);
        return kotlinClassId != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkParameterIsNotNull(kotlinFqName, "kotlinFqName");
        return kotlinToJava.get(kotlinFqName);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName readOnlyFqName = readOnlyClassId.asSingleFqName();
        FqName mutableFqName = mutableClassId.asSingleFqName();
        mutableToReadOnly.put(mutableClassId.asSingleFqName().toUnsafe(), readOnlyFqName);
        readOnlyToMutable.put(readOnlyFqName.toUnsafe(), mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        javaToKotlin.put(javaClassId.asSingleFqName().toUnsafe(), kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        kotlinToJava.put(kotlinFqNameUnsafe.toUnsafe(), javaClassId);
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassDescriptor classDescriptor = this.mapJavaToKotlin(fqName2, builtIns);
        if (classDescriptor == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor;
        FqName fqName3 = readOnlyToMutable.get(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf(kotlinAnalog);
        }
        FqName kotlinMutableAnalogFqName = fqName3;
        List<ClassDescriptor> list = Arrays.asList(kotlinAnalog, builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName));
        Intrinsics.checkExpressionValueIsNotNull(list, "Arrays.asList(kotlinAnal\u2026tlinMutableAnalogFqName))");
        return list;
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return mutableToReadOnly.containsKey(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return readOnlyToMutable.containsKey(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return this.convertToOppositeMutability(mutable, (Map<FqNameUnsafe, FqName>)mutableToReadOnly, "mutable");
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return this.convertToOppositeMutability(readOnly, (Map<FqNameUnsafe, FqName>)readOnlyToMutable, "read-only");
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl;
        boolean bl2 = bl = !clazz.isPrimitive() && !clazz.isArray();
        if (_Assertions.ENABLED && !bl) {
            String string = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkExpressionValueIsNotNull(classId3, "classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, Map<FqNameUnsafe, FqName> map2, String mutabilityKindName) {
        FqName fqName2 = map2.get(DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw (Throwable)new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return classDescriptor;
    }

    private JavaToKotlinClassMap() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        JavaToKotlinClassMap javaToKotlinClassMap;
        INSTANCE = javaToKotlinClassMap = new JavaToKotlinClassMap();
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        PlatformMutabilityMapping[] platformMutabilityMappingArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap2 = javaToKotlinClassMap;
        ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FQ_NAMES.iterable)");
        ClassId classId2 = classId;
        Intrinsics.checkExpressionValueIsNotNull(KotlinBuiltIns.FQ_NAMES.mutableIterable, "FQ_NAMES.mutableIterable");
        JvmPrimitiveType[] kotlinMutable$iv = KotlinBuiltIns.FQ_NAMES.mutableIterable;
        FqName fqName2 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName3 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName2, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName3), false);
        platformMutabilityMappingArray[0] = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId3 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterator);
        Intrinsics.checkExpressionValueIsNotNull(classId3, "ClassId.topLevel(FQ_NAMES.iterator)");
        kotlinReadOnly$iv = classId3;
        FqName fqName4 = KotlinBuiltIns.FQ_NAMES.mutableIterator;
        Intrinsics.checkExpressionValueIsNotNull(fqName4, "FQ_NAMES.mutableIterator");
        kotlinMutable$iv = fqName4;
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName6, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName6), false);
        platformMutabilityMappingArray[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId4 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
        Intrinsics.checkExpressionValueIsNotNull(classId4, "ClassId.topLevel(FQ_NAMES.collection)");
        kotlinReadOnly$iv = classId4;
        FqName fqName7 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull(fqName7, "FQ_NAMES.mutableCollection");
        kotlinMutable$iv = fqName7;
        FqName fqName8 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName9, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName8, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName9), false);
        platformMutabilityMappingArray[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId5 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.list);
        Intrinsics.checkExpressionValueIsNotNull(classId5, "ClassId.topLevel(FQ_NAMES.list)");
        kotlinReadOnly$iv = classId5;
        FqName fqName10 = KotlinBuiltIns.FQ_NAMES.mutableList;
        Intrinsics.checkExpressionValueIsNotNull(fqName10, "FQ_NAMES.mutableList");
        kotlinMutable$iv = fqName10;
        FqName fqName11 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName12, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName11, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName12), false);
        platformMutabilityMappingArray[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId6 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.set);
        Intrinsics.checkExpressionValueIsNotNull(classId6, "ClassId.topLevel(FQ_NAMES.set)");
        kotlinReadOnly$iv = classId6;
        FqName fqName13 = KotlinBuiltIns.FQ_NAMES.mutableSet;
        Intrinsics.checkExpressionValueIsNotNull(fqName13, "FQ_NAMES.mutableSet");
        kotlinMutable$iv = fqName13;
        FqName fqName14 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName15, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName14, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName15), false);
        platformMutabilityMappingArray[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId7 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.listIterator);
        Intrinsics.checkExpressionValueIsNotNull(classId7, "ClassId.topLevel(FQ_NAMES.listIterator)");
        kotlinReadOnly$iv = classId7;
        FqName fqName16 = KotlinBuiltIns.FQ_NAMES.mutableListIterator;
        Intrinsics.checkExpressionValueIsNotNull(fqName16, "FQ_NAMES.mutableListIterator");
        kotlinMutable$iv = fqName16;
        FqName fqName17 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName18, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName17, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName18), false);
        platformMutabilityMappingArray[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId8 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map);
        Intrinsics.checkExpressionValueIsNotNull(classId8, "ClassId.topLevel(FQ_NAMES.map)");
        kotlinReadOnly$iv = classId8;
        FqName fqName19 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkExpressionValueIsNotNull(fqName19, "FQ_NAMES.mutableMap");
        kotlinMutable$iv = fqName19;
        FqName fqName20 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName21 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName21, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName20, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName21), false);
        platformMutabilityMappingArray[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId9 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map).createNestedClassId(KotlinBuiltIns.FQ_NAMES.mapEntry.shortName());
        Intrinsics.checkExpressionValueIsNotNull(classId9, "ClassId.topLevel(FQ_NAME\u2026MES.mapEntry.shortName())");
        kotlinReadOnly$iv = classId9;
        FqName fqName22 = KotlinBuiltIns.FQ_NAMES.mutableMapEntry;
        Intrinsics.checkExpressionValueIsNotNull(fqName22, "FQ_NAMES.mutableMapEntry");
        kotlinMutable$iv = fqName22;
        FqName fqName23 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName24 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName24, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName23, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName24), false);
        platformMutabilityMappingArray[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf(platformMutabilityMappingArray);
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "FQ_NAMES.any");
        javaToKotlinClassMap.addTopLevel(Object.class, fqNameUnsafe);
        FqNameUnsafe fqNameUnsafe2 = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe2, "FQ_NAMES.string");
        javaToKotlinClassMap.addTopLevel(String.class, fqNameUnsafe2);
        FqNameUnsafe fqNameUnsafe3 = KotlinBuiltIns.FQ_NAMES.charSequence;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe3, "FQ_NAMES.charSequence");
        javaToKotlinClassMap.addTopLevel(CharSequence.class, fqNameUnsafe3);
        FqName fqName25 = KotlinBuiltIns.FQ_NAMES.throwable;
        Intrinsics.checkExpressionValueIsNotNull(fqName25, "FQ_NAMES.throwable");
        javaToKotlinClassMap.addTopLevel(Throwable.class, fqName25);
        FqNameUnsafe fqNameUnsafe4 = KotlinBuiltIns.FQ_NAMES.cloneable;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe4, "FQ_NAMES.cloneable");
        javaToKotlinClassMap.addTopLevel(Cloneable.class, fqNameUnsafe4);
        FqNameUnsafe fqNameUnsafe5 = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe5, "FQ_NAMES.number");
        javaToKotlinClassMap.addTopLevel(Number.class, fqNameUnsafe5);
        FqName fqName26 = KotlinBuiltIns.FQ_NAMES.comparable;
        Intrinsics.checkExpressionValueIsNotNull(fqName26, "FQ_NAMES.comparable");
        javaToKotlinClassMap.addTopLevel(Comparable.class, fqName26);
        FqNameUnsafe fqNameUnsafe6 = KotlinBuiltIns.FQ_NAMES._enum;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe6, "FQ_NAMES._enum");
        javaToKotlinClassMap.addTopLevel(Enum.class, fqNameUnsafe6);
        FqName fqName27 = KotlinBuiltIns.FQ_NAMES.annotation;
        Intrinsics.checkExpressionValueIsNotNull(fqName27, "FQ_NAMES.annotation");
        javaToKotlinClassMap.addTopLevel(Annotation.class, fqName27);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            javaToKotlinClassMap.addMapping(platformCollection);
        }
        kotlinMutable$iv = JvmPrimitiveType.values();
        for (int i = 0; i < kotlinMutable$iv.length; ++i) {
            JvmPrimitiveType jvmType = kotlinMutable$iv[i];
            ClassId classId10 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull(classId10, "ClassId.topLevel(jvmType.wrapperFqName)");
            ClassId classId11 = ClassId.topLevel(KotlinBuiltIns.getPrimitiveFqName(jvmType.getPrimitiveType()));
            Intrinsics.checkExpressionValueIsNotNull(classId11, "ClassId.topLevel(KotlinB\u2026e(jvmType.primitiveType))");
            javaToKotlinClassMap.add(classId10, classId11);
        }
        for (ClassId classId12 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId13 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId12.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkExpressionValueIsNotNull(classId13, "ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId14 = classId12.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkExpressionValueIsNotNull(classId14, "classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            javaToKotlinClassMap.add(classId13, classId14);
        }
        int classId12 = 0;
        int n = 23;
        while (classId12 < n) {
            void i;
            ClassId classId15 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + (int)i));
            Intrinsics.checkExpressionValueIsNotNull(classId15, "ClassId.topLevel(FqName(\u2026functions.Function\" + i))");
            ClassId classId16 = KotlinBuiltIns.getFunctionClassId((int)i);
            Intrinsics.checkExpressionValueIsNotNull(classId16, "KotlinBuiltIns.getFunctionClassId(i)");
            javaToKotlinClassMap.add(classId15, classId16);
            FunctionClassDescriptor.Kind kFunction = FunctionClassDescriptor.Kind.KFunction;
            String kFun = kFunction.getPackageFqName().toString() + "." + kFunction.getClassNamePrefix();
            FqName fqName28 = new FqName(kFun + (int)i);
            ClassId classId17 = ClassId.topLevel(new FqName(kFun));
            Intrinsics.checkExpressionValueIsNotNull(classId17, "ClassId.topLevel(FqName(kFun))");
            javaToKotlinClassMap.addKotlinToJava(fqName28, classId17);
            ++i;
        }
        FqName fqName29 = KotlinBuiltIns.FQ_NAMES.nothing.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName29, "FQ_NAMES.nothing.toSafe()");
        javaToKotlinClassMap.addKotlinToJava(fqName29, javaToKotlinClassMap.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            Intrinsics.checkParameterIsNotNull(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkParameterIsNotNull(kotlinMutable, "kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual(this.javaClass, platformMutabilityMapping.javaClass) || !Intrinsics.areEqual(this.kotlinReadOnly, platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual(this.kotlinMutable, platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

