/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationConfiguration;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmPackageTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Intrinsics.checkParameterIsNotNull(debugName, "debugName");
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_14 = i$iv;
                    void var24_17 = i$iv++;
                    int[] nArray = result$iv;
                    nArray[var24_17] = n3 = stream.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                Object packageParts;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result = new LinkedHashMap();
                Iterator<JvmPackageTable.PackageParts> iterator2 = table.getPackagePartsList().iterator();
                while (iterator2.hasNext()) {
                    String partShortName;
                    Object object;
                    IndexedValue $receiver$iv2;
                    JvmPackageTable.PackageParts proto;
                    JvmPackageTable.PackageParts packageParts2 = proto = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(packageParts2, "proto");
                    String packageFqName = packageParts2.getPackageFqName();
                    Map map2 = result;
                    String string = packageFqName;
                    Intrinsics.checkExpressionValueIsNotNull(string, "packageFqName");
                    Iterator key$iv = string;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    packageParts = (PackageParts)object;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex(protocolStringList)) {
                        String string2;
                        String facadeShortName;
                        String string3;
                        ProtocolStringList protocolStringList2;
                        Integer multifileFacadeId;
                        int index = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list, "proto.multifileFacadeShortNameIdList");
                        Integer n = CollectionsKt.getOrNull(list, index);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            protocolStringList2 = proto.getMultifileFacadeShortNameList();
                            int p1 = ((Number)n5).intValue();
                            string3 = (String)CollectionsKt.getOrNull(protocolStringList2, p1);
                        } else {
                            string3 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it = protocolStringList2;
                            string2 = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
                        } else {
                            string2 = null;
                        }
                        String facadeInternalName = string2;
                        String string4 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull(string4, "partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string4), facadeInternalName);
                    }
                    if (!configuration.isJvmPackageNameSupported()) continue;
                    ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList3, "proto.classWithJvmPackageNameShortNameList");
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex(protocolStringList3)) {
                        String jvmPackageName;
                        int index = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list, "proto.classWithJvmPackageNamePackageIdList");
                        Integer n = CollectionsKt.getOrNull(list, index);
                        if (n == null) {
                            List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list2, "proto.classWithJvmPackageNamePackageIdList");
                            n = CollectionsKt.lastOrNull(list2);
                        }
                        if (n == null) {
                            continue;
                        }
                        int packageId = n;
                        ProtocolStringList protocolStringList4 = table.getJvmPackageNameList();
                        Intrinsics.checkExpressionValueIsNotNull(protocolStringList4, "table.jvmPackageNameList");
                        if ((String)CollectionsKt.getOrNull(protocolStringList4, packageId) == null) {
                            continue;
                        }
                        String string5 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull(string5, "partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string5), null);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object;
                    String key$iv;
                    Iterable $receiver$iv;
                    packageParts = result;
                    JvmPackageTable.PackageParts packageParts3 = proto;
                    Intrinsics.checkExpressionValueIsNotNull(packageParts3, "proto");
                    Intrinsics.checkExpressionValueIsNotNull(packageParts3.getPackageFqName(), "proto.packageFqName");
                    Object value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull(string, "proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    PackageParts packageParts4 = (PackageParts)object;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    $receiver$iv = protocolStringList;
                    for (Object element$iv : $receiver$iv) {
                        String p1 = (String)element$iv;
                        packageParts4.addMetadataPart(p1);
                    }
                }
                return new ModuleMapping(result, debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

