=begin
Copyright 2014 TIG (c)  
All rights reserved.  
THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,  
INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  
FITNESS FOR A PARTICULAR PURPOSE.  

Usage:  
Plugins menu or Ruby Console:  
  TIG.save_all_components  
If the model has never been saved then nothing happens !  
Otherwise all components in the model are saved into a folder made with the  
model named, 'ModelName_Components'  
If a component is nested and not available as a stand-alone component then it is  
put into a subfolder named after its parent component's definition: if it is  
used in several components it is duplicated in appropriate subfolders.  
If a component's name contains unsuitable characters for a saved SKP name  
[e.g. / or :], then those characters are substituted [with "_"],  
if a component name is already used it is incremented, so #0 >>> #1 etc.  
Progress/success/failure is reported in the Ruby Console.  
On completion the 'ModelName_Component' folder is opened.  

Version:  
1.0	20140625 First issue.  
1.1 20140626 Illict character trapping improved.
=end

require('sketchup.rb')

module TIG
	###menu
	unless file_loaded?(__FILE__)
		UI.menu("Plugins").add_item("TIG.save_all_components"){ self.save_all_components() }
	end
	file_loaded(__FILE__)
	###
    def self.save_all_components()
	  m=Sketchup.active_model
	  p=m.path.tr("\\","/")
	  unless p.empty? # i.e. NOT Untitled/unsaved
		f=File.join(File.dirname(p), "#{m.title}_Components")
		begin
		  Dir.mkdir(f)
		rescue
		end
		ns={}
		m.definitions.each{|d|
		 next if d.group? || d.image?
		 n=d.name.gsub(/[\<\>\/\\\:\?\"\%\\*|]/, '_').gsub(/^\./, '-')
		 while ns[n]==true
		   n.next!
		 end
		 if d.hidden?
		   d.instances.each{|i|
			  s=File.join(f, i.parent.name.gsub(/[\<\>\/\\\:\?\"\%\*|]/, '_')).gsub(/^\./, '-')
			  begin
			    Dir.mkdir(s)
			  rescue
			  end
			  c=File.join(s, n)
			  begin
			  d.save_as(c)
			  if File.exist?(c+".skp")
			    ns[n]=true
			    puts "Saved #{c+".skp"}"
			  else
			    ns[n]=false
				puts "Failed to save #{c+".skp"}"
			  end
			rescue
			  ns[n]=false
			  puts "Failed to save #{c+".skp"}"
			end
		   }
		 else # in model
			c=File.join(f, n)
			begin
			  d.save_as(c)
			  if File.exist?(c+".skp")
			    ns[n]=true
			    puts "Saved #{c+".skp"}"
			  else
			    ns[n]=false
				puts "Failed to save #{c+".skp"}"
			  end
			rescue
			  ns[n]=false
			  puts "Failed to save #{c+".skp"}"
			end
		 end
		 
		}
		UI.openURL("file:///#{f}")
	  else
	    puts "TIG.save_all_components:\nSave this new model first !"
		UI.messagebox("TIG.save_all_components:\n\nSave this new model first !")
	  end#if
	  return
   end
end
	