Scriptname Display_Armor_Script extends ObjectReference  

Armor Property ClawToPlace Auto
{The claw we want to place}
Bool Property isPlaced = false Auto Hidden
Message Property FailMessage auto
{The message to show if the player dont have the claw in their inventory}

Event OnActivate(ObjectReference akActivator)
if(isPlaced == FALSE) ; is the claw placed?
if akActivator.getItemCount(ClawToPlace) >= 1 ; Does the player have the claw?
isPlaced = TRUE
self.getLinkedRef().enable() ; Enable the Static Claw
(akActivator as actor).removeItem(ClawToPlace, 1) ; Remove the claw from the players inventory
else
FailMessage.show() ; If the player doesnt have the claw, show the Fail message.
endif
else
isPlaced = FALSE
self.getLinkedRef().disable() ; If the claw was already placed, disable the static claw
(akActivator as actor).addItem(ClawToPlace, 1) ; add the claw back.
endif
endEvent
