// Generated by CoffeeScript 1.7.1
(function() {
  var BrowserWindow, FOLDERS, Menu, Tray, app, cleanBackup, dialog, fs, mainWindow, path, port, redirect, server, serverStarted, showOpenDialog, spawn, startServer, vipEmail;

  path = require('path');

  fs = require('fs');

  app = require('app');

  Menu = require('menu');

  Tray = require('tray');

  dialog = require('dialog');

  BrowserWindow = require('browser-window');

  spawn = require('child_process').spawn;

  mainWindow = null;

  vipEmail = '';

  server = null;

  port = 8000;

  serverStarted = false;

  FOLDERS = {
    HTML: path.join(__dirname, 'html'),
    BACKUP: path.join(__dirname, 'backup'),
    UTILS: path.join(__dirname, 'utils'),
    IMG: path.join(__dirname, 'img')
  };

  startServer = function(cb) {
    var doTimeout, serverPath;
    switch (process.platform) {
      case 'darwin':
        serverPath = path.join(FOLDERS.UTILS, 'server');
        break;
      case 'win32':
        serverPath = path.join(FOLDERS.UTILS, 'server.exe');
        break;
      case 'linux':
        serverPath = path.join(FOLDERS.UTILS, 'server-linux');
        break;
      default:
        return;
    }
    server = spawn(serverPath, [port]);
    doTimeout = null;
    server.stdout.on('data', function(data) {
      console.log('----stdout: ' + data);
    });
    server.stderr.on('data', function(data) {
      console.log('----stderr: ' + data);
      if (!serverStarted) {
        port++;
        if (doTimeout) {
          clearTimeout(doTimeout);
        }
        startServer(cb);
      }
    });
    if (doTimeout) {
      clearTimeout(doTimeout);
    }
    return doTimeout = setTimeout((function() {
      serverStarted = true;
      return cb();
    }), 1000);
  };

  redirect = function(url) {
    return mainWindow.loadUrl('file://' + path.join(FOLDERS.HTML, url));
  };

  cleanBackup = function() {
    var file, fullPath, _i, _len, _ref, _results;
    _ref = fs.readdirSync(FOLDERS.BACKUP);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      file = _ref[_i];
      fullPath = path.join(FOLDERS.BACKUP, file);
      fs.unlinkSync(fullPath);
      _results.push(console.log('[Main cleanBackup delete]', file));
    }
    return _results;
  };

  showOpenDialog = function(cb) {
    var options;
    options = {
      properties: ['openFile', 'openDirectory', 'multiSelections'],
      filters: [
        {
          name: 'Images',
          extensions: ['png', 'jpeg', 'jpg']
        }
      ]
    };
    return dialog.showOpenDialog(mainWindow, options, function(fullPathList) {
      console.log('[Main showOpenDialog] fullPathList', fullPathList);
      if (cb && fullPathList) {
        return cb(fullPathList);
      }
    });
  };

  global['redirect'] = redirect;

  global['FOLDERS'] = FOLDERS;

  global['showOpenDialog'] = showOpenDialog;

  global['getEmail'] = function() {
    return vipEmail;
  };

  global['setEmail'] = function(email) {
    return vipEmail = email;
  };

  global['openExternal'] = require('shell').openExternal;

  global['openDevTools'] = function() {
    return mainWindow.openDevTools();
  };

  global['port'] = function() {
    return port;
  };

  app.on('window-all-closed', function() {
    server.kill();
    return app.quit();
  });

  app.on('ready', function() {
    mainWindow = new BrowserWindow({
      width: 1280,
      height: 768,
      'min-width': 800,
      'min-height': 680,
      frame: true,
      show: false
    });
    if (!fs.existsSync(FOLDERS.BACKUP)) {
      fs.mkdir(FOLDERS.BACKUP);
    }
    cleanBackup();
    startServer(function() {
      redirect('layout.html');
      return setTimeout((function() {
        return mainWindow.show();
      }), 2000);
    });
    return mainWindow.on('closed', function() {
      mainWindow = null;
      return cleanBackup();
    });
  });

}).call(this);

//# sourceMappingURL=main.map
