// Generated by CoffeeScript 1.7.1
(function() {
  var app, fs, imgBackgroundCSS, path, zoomDiffBoxCSS, zoomListImgCSS;

  path = require('path');

  fs = require('fs');

  app = window.app;

  zoomListImgCSS = function(zoom) {
    var ret;
    ret = ".file-list-view .file-box { width: " + (102 * zoom) + "px; height: " + (150 * zoom) + "px; } .file-list-view .file-box .image-box { width: " + (100 * zoom) + "px; height: " + (100 * zoom) + "px; } .file-list-view .file-box .image-box .img { line-height: " + (100 * zoom) + "px; } .file-list-view .file-box .image-box .img img { max-width: " + (100 * zoom - 15) + "px; max-height: " + (100 * zoom - 15) + "px; }";
    return ret;
  };

  imgBackgroundCSS = function(color) {
    var bg, ret, transBgPath;
    transBgPath = path.join(window.FOLDERS.IMG, 'bg-transparent.png');
    if (!color || color === 'transparent') {
      bg = "background-image: url(" + transBgPath + ")";
    } else {
      bg = "background-color: " + color;
    }
    ret = ".file-list-view .file-box .image-box { " + bg + " }";
    return ret;
  };

  zoomDiffBoxCSS = function(zoom) {
    var ret;
    ret = ".canvas .diff-box { transform: scale(" + zoom + "); }";
    return ret;
  };

  app.controller('FileViewController', function($scope, $rootScope, FileStatusService, Redirector, $timeout) {
    var animateZoomPromise, init, listenWheelZoom;
    $scope.needShow = function() {
      return Redirector.isCurrentView(Redirector.views.file);
    };
    $scope.model = {
      filesInfo: null
    };
    $scope.MODE = {
      LIST: 'list',
      DIFF: 'diff'
    };
    $scope.drop = function(files) {
      var file, s, _i, _len, _results;
      console.log('[FileViewController drop] files', files);
      s = FileStatusService;
      _results = [];
      for (_i = 0, _len = files.length; _i < _len; _i++) {
        file = files[_i];
        _results.push(s.load(file.path));
      }
      return _results;
    };
    init = function() {
      $scope.listMode();
      $scope.isOriFront = false;
      $scope.currentModel = null;
      return $scope.refreshStamp = Date.now();
    };
    $scope.$watch((function() {
      var i, _i, _len, _ref, _results;
      _ref = FileStatusService.model();
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        i = _ref[_i];
        _results.push(i.progress);
      }
      return _results;
    }), (function() {
      var i, m;
      m = FileStatusService.model();
      $scope.model.filesInfo = m;
      if (m.length === 0) {
        return init();
      }
      if (((function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = m.length; _i < _len; _i++) {
          i = m[_i];
          if (i.selected) {
            _results.push(i);
          }
        }
        return _results;
      })()).length === 0) {
        $scope.selectedManager.singleSelect(0);
      }
      $timeout((function() {
        return $scope.refreshStamp = Date.now();
      }), 50);
      console.log('[FileViewController $watch] $scope.currentModel', $scope.currentModel);
      return console.log('[FileViewController $watch] $scope.model.filesInfo', $scope.model.filesInfo);
    }), true);
    $scope.selectedManager = {
      allSelected: [],
      _lastControlIndex: -1,
      _lastShiftIndex: -1,
      singleSelect: function(index) {
        var sm;
        sm = $scope.selectedManager;
        $scope.model.filesInfo[index].selected = true;
        sm._lastControlIndex = index;
        return sm.updateSelected();
      },
      compressible: function() {
        var i, _i, _len, _ref, _results;
        _ref = $scope.selectedManager.allSelected;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          i = _ref[_i];
          if (i.status.isCompressible()) {
            _results.push(i);
          }
        }
        return _results;
      },
      compressed: function() {
        var i, _i, _len, _ref, _results;
        _ref = $scope.selectedManager.allSelected;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          i = _ref[_i];
          if (i.status.isCompressed()) {
            _results.push(i);
          }
        }
        return _results;
      },
      setSelected: function(a, b, bool) {
        var d, i, m, _i, _len, _results;
        if (a < 0 || b < 0) {
          return;
        }
        m = $scope.model.filesInfo;
        d = a < b ? m.slice(a, +b + 1 || 9e9) : m.slice(b, +a + 1 || 9e9);
        _results = [];
        for (_i = 0, _len = d.length; _i < _len; _i++) {
          i = d[_i];
          _results.push(i.selected = bool);
        }
        return _results;
      },
      onSelectAll: function() {
        var sm;
        sm = $scope.selectedManager;
        sm.setSelected(0, $scope.model.filesInfo.length, true);
        return sm.updateSelected();
      },
      onDelete: function() {
        var info, sm, _i, _len, _ref, _results;
        sm = $scope.selectedManager;
        _ref = sm.allSelected;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          info = _ref[_i];
          _results.push(FileStatusService.remove(info));
        }
        return _results;
      },
      onRestore: function() {
        var info, reader, sm, _i, _len, _ref;
        sm = $scope.selectedManager;
        _ref = sm.compressed();
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          info = _ref[_i];
          reader = info.restoreToOrigin();
          reader.on('end', function() {
            return $timeout((function() {
              return $scope.refreshStamp = Date.now();
            }), 10);
          });
          console.log('[FileViewController selectedManager onRestore] 1', info.fullPath);
        }
        return sm.updateSelected();
      },
      onAutoCompress: function() {
        var info, sm, _i, _len, _ref;
        sm = $scope.selectedManager;
        _ref = sm.compressible();
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          info = _ref[_i];
          info.setAutoCompress(true);
        }
        return sm.updateSelected();
      },
      updateSelected: function() {
        var allSelected, i, sm;
        sm = $scope.selectedManager;
        allSelected = (function() {
          var _i, _len, _ref, _results;
          _ref = $scope.model.filesInfo;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            i = _ref[_i];
            if (i.selected) {
              _results.push(i);
            }
          }
          return _results;
        })();
        $scope.currentModel = allSelected.length === 1 ? allSelected[0] : null;
        sm.allSelected = allSelected;
        return console.log('[FileViewController updateSelected] sm', sm);
      },
      onModelSelect: function(info, e) {
        var curIndex, m, setSelected, sm;
        sm = $scope.selectedManager;
        m = $scope.model.filesInfo;
        curIndex = m.indexOf(info);
        setSelected = sm.setSelected;
        if (e.metaKey || e.ctrlKey) {
          info.selected = !info.selected;
          sm._lastControlIndex = curIndex;
          sm._lastShiftIndex = -1;
        } else if (e.shiftKey) {
          setSelected(curIndex, sm._lastShiftIndex, false);
          setSelected(curIndex, sm._lastControlIndex, true);
          sm._lastShiftIndex = curIndex;
        } else {
          setSelected(0, m.length - 1, false);
          info.selected = true;
          sm._lastControlIndex = curIndex;
          sm._lastShiftIndex = -1;
        }
        return sm.updateSelected();
      }
    };
    $scope.listMode = function() {
      return $scope.currentMode = $scope.MODE.LIST;
    };
    $scope.diffMode = function() {
      if (!$scope.currentModel) {
        return;
      }
      $scope.originModel = {
        fullPath: $scope.currentModel.backupFullPath
      };
      $scope.currentMode = $scope.MODE.DIFF;
      $scope.zoomDiffBox.autoFit();
      return $scope.animateZoomInfo();
    };
    $scope.maskHandler = function(progress) {
      var p, ret;
      p = FileStatusService.PROGRESS;
      ret = null;
      switch (progress) {
        case p.WAITING:
          ret = {
            "class": 'waiting',
            text: '等待中'
          };
          break;
        case p.COMPRESSING:
          ret = {
            "class": 'compressing',
            text: '压缩中'
          };
          break;
        case p.COMPRESS_ERROR:
          ret = {
            "class": 'error',
            text: '出错'
          };
          break;
        case p.LIMIT:
          ret = {
            "class": 'limit',
            text: '压缩受限'
          };
          break;
        case p.ERROR_FORMAT:
          ret = {
            "class": 'error',
            text: '格式错误'
          };
      }
      return ret;
    };
    $scope.COMPRESS_PROGRESS = FileStatusService.PROGRESS;
    $scope.zoom = function(cur, zoomObject) {
      var floor;
      floor = function(x, digit) {
        return Math.floor(x * Math.pow(10, digit)) / Math.pow(10, digit);
      };
      zoomObject.cur = floor(cur, 4);
      return zoomObject.curShow = floor(cur * 100, 0);
    };
    $scope.zoomListImg = {
      step: 0.5,
      min: 1,
      max: 4,
      cur: 1,
      zoomOut: function() {
        var zoomObject;
        zoomObject = $scope.zoomListImg;
        return $scope.zoom(Math.max(zoomObject.cur - zoomObject.step, zoomObject.min), zoomObject);
      },
      zoomIn: function() {
        var zoomObject;
        zoomObject = $scope.zoomListImg;
        return $scope.zoom(Math.min(zoomObject.cur + zoomObject.step, zoomObject.max), zoomObject);
      },
      CSS: function() {
        return zoomListImgCSS($scope.zoomListImg.cur);
      }
    };
    $scope.zoomDiffBox = {
      step: 0.5,
      min: 0.25,
      max: 4,
      cur: 1,
      curShow: 100,
      center: false,
      toNearestStep: function(n) {
        var obj, r;
        obj = $scope.zoomDiffBox;
        r = obj.step * Math.floor(n / obj.step + 0.49);
        return r = Math.min(Math.max(r, obj.min), obj.max);
      },
      zoomOut: function() {
        var zoomObject;
        zoomObject = $scope.zoomDiffBox;
        return $scope.zoom(zoomObject.toNearestStep(zoomObject.cur - zoomObject.step), zoomObject);
      },
      zoomIn: function() {
        var zoomObject;
        zoomObject = $scope.zoomDiffBox;
        return $scope.zoom(zoomObject.toNearestStep(zoomObject.cur + zoomObject.step), zoomObject);
      },
      CSS: function() {
        return zoomDiffBoxCSS($scope.zoomDiffBox.cur);
      },
      center: function() {
        var canvas, diffBox, img, left, top;
        canvas = $scope.canvasElement;
        diffBox = $scope.diffBoxElement;
        img = $scope.diffImageElement;
        left = canvas.clientWidth / 2 - img.width / 2;
        top = canvas.clientHeight / 2 - img.height / 2;
        diffBox.style.setProperty('left', left + 'px', null);
        return diffBox.style.setProperty('top', top + 'px', null);
      },
      _getRatio: function() {
        var canvas, fitPadding, img, ratio;
        canvas = $scope.canvasElement;
        img = $scope.diffImageElement;
        fitPadding = 10;
        ratio = Math.min((canvas.clientWidth - fitPadding) / img.width, (canvas.clientHeight - fitPadding) / img.height);
        return ratio;
      },
      fitOrigin: function() {
        var self;
        self = $scope.zoomDiffBox;
        $scope.zoom(1, self);
        self.center();
      },
      fitFullScreen: function() {
        var ratio, self;
        self = $scope.zoomDiffBox;
        ratio = self._getRatio();
        console.log('[FileViewController zoomDiffBox] fit ratio', ratio);
        $scope.zoom(ratio, self);
        return self.center();
      },
      autoFit: function() {
        var ratio, self;
        self = $scope.zoomDiffBox;
        ratio = self._getRatio();
        if (ratio < 1) {
          return self.fitFullScreen();
        } else {
          return self.fitOrigin();
        }
      },
      zoomInBox: function() {
        var cr, diffBox, img, ir, left, leftPix, limit, offsetLeft, offsetTop, top;
        img = $scope.diffImageElement;
        diffBox = $scope.diffBoxElement;
        if (!$scope.canvasElement) {
          return;
        }
        cr = $scope.canvasElement.getBoundingClientRect();
        ir = img.getBoundingClientRect();
        offsetLeft = (ir.width - img.width) / 2;
        offsetTop = (ir.height - img.height) / 2;
        leftPix = 20;
        limit = {
          left: {
            min: leftPix - ir.width,
            max: cr.width - leftPix
          },
          top: {
            min: leftPix - ir.height,
            max: cr.height - leftPix
          }
        };
        if (ir.left > limit.left.max) {
          left = limit.left.max;
        }
        if (ir.left < limit.left.min) {
          left = limit.left.min;
        }
        if (ir.top > limit.top.max) {
          top = limit.top.max;
        }
        if (ir.top < limit.top.min) {
          top = limit.top.min;
        }
        if (left || top) {
          if (!left) {
            left = ir.left;
          }
          if (!top) {
            top = ir.top;
          }
          left += offsetLeft;
          top += offsetTop;
          diffBox.style.setProperty('left', left + 'px', null);
          return diffBox.style.setProperty('top', top + 'px', null);
        }
      }
    };
    $scope.$watch((function() {
      return $scope.zoomDiffBox.CSS();
    }), function() {
      return $timeout($scope.zoomDiffBox.zoomInBox, 100);
    });
    $scope.$watch('zoomDiffBox.curShow', function() {
      var cur, obj;
      obj = $scope.zoomDiffBox;
      if (Math.floor(obj.cur * 100) === obj.curShow) {
        return;
      }
      cur = obj.curShow / 100;
      cur = Math.max(cur, obj.min);
      cur = Math.min(cur, obj.max);
      return $scope.zoom(cur, obj);
    });
    listenWheelZoom = function() {
      if (!$scope.canvasElement) {
        return $timeout(listenWheelZoom, 1000);
      }
      return $scope.canvasElement.addEventListener('mousewheel', function(e) {
        var anchorDistToCenter, d, dr, lastScale, left, s, top, xOnDiff, yOnDiff;
        if ($scope.currentMode !== $scope.MODE.DIFF) {
          return;
        }
        d = $scope.diffBoxElement;
        dr = d.getBoundingClientRect();
        xOnDiff = Math.min(dr.width, Math.max(e.x - dr.left, 0));
        yOnDiff = Math.min(dr.height, Math.max(0, e.y - dr.top));
        anchorDistToCenter = {
          x: dr.width / 2 - xOnDiff,
          y: dr.height / 2 - yOnDiff
        };
        lastScale = $scope.zoomDiffBox.cur;
        if (e.wheelDelta > 0) {
          $scope.zoomDiffBox.zoomIn();
        } else {
          $scope.zoomDiffBox.zoomOut();
        }
        s = $scope.zoomDiffBox.cur / lastScale - 1;
        left = d.offsetLeft + anchorDistToCenter.x * s;
        top = d.offsetTop + anchorDistToCenter.y * s;
        d.style.setProperty('left', left + 'px', null);
        d.style.setProperty('top', top + 'px', null);
        console.log("[FileView WheelZoom] scale:[" + lastScale + "->" + $scope.zoomDiffBox.cur + "], left:[" + d.offsetLeft + "->" + left + "]");
        return $scope.$apply();
      });
    };
    listenWheelZoom();
    $scope.showDiffZoomInfo = false;
    animateZoomPromise = null;
    $scope.animateZoomInfo = function() {
      $scope.showDiffZoomInfo = false;
      if (animateZoomPromise) {
        $timeout.cancel(animateZoomPromise);
      }
      $timeout((function() {
        return $scope.showDiffZoomInfo = true;
      }), 10);
      return animateZoomPromise = $timeout((function() {
        return $scope.showDiffZoomInfo = false;
      }), 2010);
    };
    $scope.$watch('zoomDiffBox.cur', $scope.animateZoomInfo);
    $scope.setBG = function(color) {
      return $scope.currentBG = color;
    };
    $scope.setBG('dark');
    $scope.imgBackgroundCSS = imgBackgroundCSS;
    document.addEventListener('keyup', function(e) {
      var DEL, ESC, _ref;
      _ref = [27, 46], ESC = _ref[0], DEL = _ref[1];
      switch (e.keyCode) {
        case ESC:
          if ($scope.currentMode = $scope.MODE.DIFF) {
            $scope.listMode();
            return $scope.$apply();
          }
          break;
        case DEL:
          $scope.selectedManager.onDelete();
          return $scope.$apply();
      }
    });
    Mousetrap.bind(['command+a', 'ctrl+a'], function() {
      $scope.selectedManager.onSelectAll();
      return $scope.$apply();
    });
    $scope.onMouseMove = function(e) {
      var cur, rectBox, x;
      if (!e) {
        return;
      }
      rectBox = $scope.diffBoxElement.getBoundingClientRect();
      cur = $scope.zoomDiffBox.cur;
      x = Math.max(0, (e.x - rectBox.left) / cur);
      x = Math.min(rectBox.width / cur, x);
      return document.querySelector('.ori-box').style.setProperty('width', x.toFixed(0) + 'px', null);
    };
    $scope.reveal = function(fullPath) {
      var p;
      if (!fullPath) {
        return;
      }
      p = path.parse(fullPath);
      return window.openExternal('file://' + p.dir);
    };
    init();
    console.log('[FileViewController] init ok');
  });

}).call(this);

//# sourceMappingURL=fileView.map
