// Generated by CoffeeScript 1.7.1
(function() {
  var FOLDERS, WebSocketManager, app, disableEvent, fs, getPort, imageSize, init, keyUpList, openDevTools, path, remote, showOpenDialog, _rd;

  fs = require('fs');

  path = require('path');

  remote = require('remote');

  imageSize = require('image-size');

  _rd = remote.getGlobal('FOLDERS');

  FOLDERS = {
    HTML: _rd.HTML,
    BACKUP: _rd.BACKUP,
    UTILS: _rd.UTILS,
    IMG: _rd.IMG
  };

  showOpenDialog = remote.getGlobal('showOpenDialog');

  openDevTools = remote.getGlobal('openDevTools');

  getPort = remote.getGlobal('port');

  app = angular.module('app', ['mgcrea.ngStrap']);

  init = function() {
    window.app = app;
    window.openExternal = remote.getGlobal('openExternal');
    window.wsManager = WebSocketManager();
    window.FOLDERS = FOLDERS;
    return window.checkVIP = function() {
      return wsManager.ws.send(wsManager.EVENT_REQ.CHECK_VIP().json);
    };
  };

  disableEvent = function(e) {
    if (e) {
      e.preventDefault();
      e.stopPropagation();
    }
  };

  document.addEventListener('drop', disableEvent);

  document.addEventListener('dragover', disableEvent);

  keyUpList = [];

  document.addEventListener('keyup', function(e) {
    var arraySame, down, hissatsu, key_a, key_b, left, right, up, _ref;
    arraySame = function(a, b) {
      var i, ret, _i, _ref;
      if (a.length !== b.length) {
        return false;
      }
      ret = true;
      for (i = _i = 0, _ref = a.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (a[i] !== b[i]) {
          ret = false;
        }
      }
      return ret;
    };
    _ref = [37, 38, 39, 40, 65, 66], left = _ref[0], up = _ref[1], right = _ref[2], down = _ref[3], key_a = _ref[4], key_b = _ref[5];
    hissatsu = [up, up, down, down, left, right, left, right, key_b, key_a];
    keyUpList.push(e.keyCode);
    if (hissatsu.length !== keyUpList.length) {
      return;
    }
    if (arraySame(keyUpList, hissatsu)) {
      openDevTools();
      return keyUpList = [];
    } else {
      return keyUpList.shift();
    }
  });

  WebSocketManager = function() {
    var EVENT_REQ, EVENT_RES, connectedHandlers, messageHandlers, ret, ws, wsUrl;
    wsUrl = 'ws://localhost:' + getPort() + '/echo';
    ws = new WebSocket(wsUrl);
    messageHandlers = [];
    connectedHandlers = [];
    ws.onmessage = function(event) {
      var handler, message, _i, _len, _results;
      console.log("[App WebSocketManager WebSocketManager] <--", event.data);
      if (event.data === 'ok') {
        return;
      }
      message = JSON.parse(event.data);
      _results = [];
      for (_i = 0, _len = messageHandlers.length; _i < _len; _i++) {
        handler = messageHandlers[_i];
        _results.push(handler(message));
      }
      return _results;
    };
    ws.onopen = function() {
      var handler, _i, _len, _results;
      console.log("[App WebSocketManager WebSocketManager] ===");
      _results = [];
      for (_i = 0, _len = connectedHandlers.length; _i < _len; _i++) {
        handler = connectedHandlers[_i];
        _results.push(handler());
      }
      return _results;
    };
    EVENT_REQ = {
      _format: function(cmd) {
        var ret;
        return ret = {
          cmd: cmd,
          json: JSON.stringify(cmd)
        };
      },
      COMPRESS_FILE: function(fullPath) {
        var cmd;
        cmd = {
          event: 'new_file',
          payload: {
            path: fullPath
          }
        };
        return EVENT_REQ._format(cmd);
      },
      CREATE_AUTH: function(email, password) {
        var cmd;
        cmd = {
          event: 'create_auth',
          payload: {
            email: email,
            password: password
          }
        };
        return EVENT_REQ._format(cmd);
      },
      CHECK_VIP: function() {
        var cmd;
        cmd = {
          event: 'check_vip',
          payload: ''
        };
        return EVENT_REQ._format(cmd);
      },
      COMPRESSED_COUNT: function() {
        var cmd;
        cmd = {
          event: 'compressed_count',
          payload: ''
        };
        return EVENT_REQ._format(cmd);
      }
    };
    EVENT_RES = {
      COMPRESS_PROGRESS: 'compress_progress',
      CREATE_AUTH: 'create_auth',
      CHECK_VIP: 'check_vip',
      COMPRESSED_COUNT: 'compressed_count'
    };
    ret = {
      EVENT_REQ: EVENT_REQ,
      EVENT_RES: EVENT_RES,
      ws: ws,
      addMessageHandler: function(handler) {
        if (messageHandlers.indexOf(handler) < 0) {
          return messageHandlers.push(handler);
        }
      },
      addConnectedHandler: function(handler) {
        return connectedHandlers.push(handler);
      }
    };
    return ret;
  };

  init();

  app.filter('fileName', function() {
    var ret;
    ret = function(fullName) {
      var index;
      index = fullName.lastIndexOf('.');
      if (index < 0) {
        return fullName;
      }
      return fullName.slice(0, index);
    };
    return ret;
  });

  app.filter('fileSize', function() {
    var ret;
    ret = function(bytes, number) {
      var unit, units, _i, _len;
      if (!bytes) {
        return null;
      }
      if (!number) {
        number = 2;
      }
      units = ['B', 'K', 'M', 'G'];
      for (_i = 0, _len = units.length; _i < _len; _i++) {
        unit = units[_i];
        if (Math.abs(bytes) < 1024) {
          return bytes.toFixed(number) + unit;
        }
        bytes /= 1024;
      }
    };
    return ret;
  });

  app.directive('moveCenter', function() {
    var ret;
    ret = {
      scope: {
        bind: "=moveCenter"
      },
      link: function(scope, element, attrs) {
        var el;
        el = element[0];
        return scope.$watch((function() {
          return scope.bind;
        }), function() {
          if (scope.bind) {
            el.style.setProperty('left', '50%', null);
            el.style.setProperty('top', '50%', null);
            return scope.bind = false;
          } else {
            el.style.setProperty('left', '', null);
            return el.style.setProperty('top', '', null);
          }
        });
      }
    };
    return ret;
  });

  app.directive('dragMove', function() {
    var ret;
    ret = {
      link: function(scope, element) {
        var el, fix_x, fix_y, onMouseMove, onMouseUp;
        el = element[0];
        fix_x = 0;
        fix_y = 0;
        el.addEventListener('mousedown', function(e) {
          fix_x = el.offsetLeft - e.clientX;
          fix_y = el.offsetTop - e.clientY;
          document.addEventListener('mouseup', onMouseUp);
          return document.addEventListener('mousemove', onMouseMove);
        });
        onMouseUp = function() {
          fix_x = 0;
          fix_y = 0;
          document.removeEventListener('mouseup', onMouseUp);
          return document.removeEventListener('mousemove', onMouseMove);
        };
        return onMouseMove = function(e) {
          var replaceCss;
          replaceCss = {
            left: (e.clientX + fix_x) + 'px',
            top: (e.clientY + fix_y) + 'px'
          };
          element.css(replaceCss);
        };
      }
    };
    return ret;
  });

  app.directive('getElement', function() {
    var ret;
    ret = {
      link: function(scope, element, attrs) {
        return scope[attrs.getElement] = element[0];
      }
    };
    return ret;
  });

  app.directive('disableChildDrag', function() {
    var ret;
    ret = {
      link: function(scope, element) {
        var allChildren, el, _i, _len, _ref;
        allChildren = function(ele) {
          var childElement, e, _i, _len, _ref, _ret;
          _ret = [];
          _ref = ele.children();
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            e = _ref[_i];
            childElement = angular.element(e);
            _ret.push(childElement);
            if (childElement.children().length > 0) {
              _ret = _ret.concat(allChildren(childElement));
            }
          }
          return _ret;
        };
        _ref = allChildren(element);
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          el = _ref[_i];
          el[0].setAttribute('draggable', 'false');
        }
      }
    };
    return ret;
  });

  app.directive('filesDrop', function() {
    var ret;
    ret = {
      scope: {
        drop: '=filesDrop'
      },
      link: function(scope, element) {
        var el;
        el = element[0];
        el.addEventListener('drop', function(e) {
          var files;
          e.preventDefault();
          console.log(e.dataTransfer.types);
          files = e.dataTransfer.files;
          return scope.drop(files);
        });
      }
    };
    return ret;
  });

  app.directive('piePath', function($timeout) {
    var ret;
    return ret = {
      scope: {
        rate: '@piePath'
      },
      link: function(scope, element) {
        var el;
        el = element[0];
        return scope.$watch((function() {
          return el.parentElement.offsetWidth + el.parentElement.offsetHeight + scope.rate;
        }), function() {
          var draw;
          if (scope.rate < 0.001) {
            return;
          }
          if (el.parentElement.offsetWidth === 0 || el.parentElement.offsetHeight === 0) {
            return;
          }
          draw = function() {
            var angle, endX, endY, height, longArcFlag, pi, piePath, r, width, x, y;
            width = el.parentElement.offsetWidth;
            height = el.parentElement.offsetHeight;
            r = Math.min(width, height) / 2;
            x = r;
            y = r;
            pi = 3.1415926;
            angle = pi / 2 - 2 * pi * scope.rate;
            endX = r + r * Math.cos(angle);
            endY = r - r * Math.sin(angle);
            longArcFlag = 0;
            if (endX < x) {
              longArcFlag = 1;
            }
            piePath = "M" + x + "," + y + " L" + x + ",0 A" + r + "," + r + " 0 " + longArcFlag + ",1 " + endX + "," + endY + " z";
            el.setAttribute('d', piePath);
          };
          $timeout((function() {
            return draw();
          }), 10);
        });
      }
    };
  });

  app.directive('bindLeftBtn', function($timeout) {
    var ret;
    ret = {
      scope: {
        isFront: "=bindLeftBtn"
      },
      link: function(scope, element) {
        var el;
        el = element[0];
        el.addEventListener('mousedown', function(e) {
          scope.isFront = true;
          return scope.$apply();
        });
        return el.addEventListener('mouseup', function(e) {
          scope.isFront = false;
          return scope.$apply();
        });
      }
    };
    return ret;
  });

  app.directive('bindKeySpace', function($timeout) {
    var ret;
    ret = {
      scope: {
        isFront: "=bindKeySpace"
      },
      link: function(scope, element) {
        var onKeyDown;
        onKeyDown = function(e) {
          if (e.keyCode !== 32) {
            return;
          }
          scope.isFront = true;
          scope.$apply();
          e.preventDefault();
          return document.removeEventListener('keydown', onKeyDown);
        };
        document.addEventListener('keyup', function(e) {
          if (e.keyCode !== 32) {
            return;
          }
          scope.isFront = false;
          scope.$apply();
          e.preventDefault();
          return document.addEventListener('keydown', onKeyDown);
        });
        return document.addEventListener('keydown', onKeyDown);
      }
    };
    return ret;
  });

  app.factory('Redirector', function($rootScope) {
    var location, ret, views;
    views = {
      drop: 'drop-view',
      file: 'file-view'
    };
    location = views.drop;
    ret = {
      views: views,
      go: function(view) {
        return location = view;
      },
      isCurrentView: function(view) {
        return location === view;
      }
    };
    return ret;
  });

  app.factory('FileStatusService', function($rootScope, $timeout) {
    var Compressor, FileLoader, PROGRESS, ThumbMaker, backup, backupFullPath, compressFile, messageHandler, model, pushModel, pushedCount, ret, searchModel, wsManager;
    model = [];
    PROGRESS = {
      NOT_START: 1,
      COMPRESSING: 2,
      COMPRESS_ERROR: 4,
      WAITING: 8,
      LIMIT: 16,
      ERROR_FORMAT: 32,
      COMPRESSED_LARGER: 64,
      COMPRESSED: 128
    };
    pushedCount = 0;
    searchModel = function(cmpValue) {
      var fileInfo, _i, _len;
      for (_i = 0, _len = model.length; _i < _len; _i++) {
        fileInfo = model[_i];
        if (cmpValue(fileInfo)) {
          return fileInfo;
        }
      }
      return null;
    };
    pushModel = function(data) {
      model.push(data);
      return $timeout((function() {
        return $rootScope.$apply();
      }), 0);
    };
    backupFullPath = function(fullPath) {
      return path.join(FOLDERS.BACKUP, path.parse(fullPath).base);
    };
    backup = function(fullPath) {
      fs.createReadStream(fullPath).pipe(fs.createWriteStream(backupFullPath(fullPath)));
      return console.log('[App FileStatusService backup] copy', fullPath);
    };
    messageHandler = function(message) {
      var m;
      m = searchModel(function(info) {
        return info['fullPath'] === message['full_path'];
      });
      switch (message.event) {
        case wsManager.EVENT_RES.COMPRESS_PROGRESS:
          m.progress = message['progress'];
          switch (message['progress']) {
            case PROGRESS.COMPRESSED:
              m.progress = PROGRESS.COMPRESSED;
              m.onCompressed();
              $timeout((function() {
                return $rootScope.$apply();
              }), 0);
              break;
            case PROGRESS.COMPRESSING:
              (function(m) {
                var updateCompressingRate;
                m.compressingRate = 0;
                updateCompressingRate = function() {
                  var r;
                  r = m.compressingRate;
                  m.compressingRate = r + (0.95 - r) * 0.02;
                  if (m.progress !== PROGRESS.COMPRESSING) {
                    return m.compressingRate = 1;
                  }
                  return $timeout(updateCompressingRate, 100);
                };
                return updateCompressingRate();
              })(m);
          }
          return $timeout((function() {
            return $rootScope.$apply();
          }), 0);
        case wsManager.EVENT_RES.COMPRESSED_COUNT:
          pushedCount = message.value;
          return $timeout((function() {
            return $rootScope.$apply();
          }), 0);
      }
    };
    wsManager = window.wsManager;
    wsManager.addMessageHandler(messageHandler);
    compressFile = function(fullPath) {
      return wsManager.ws.send(wsManager.EVENT_REQ.COMPRESS_FILE(fullPath).json);
    };
    FileLoader = {
      tasks: [],
      idle: true,
      push: function(fullPath, subFiles) {
        FileLoader.tasks.push([fullPath, subFiles]);
        return $timeout((function() {
          return $rootScope.$apply();
        }), 10);
      },
      nextTask: function() {
        var existInfo, fileName, files, fl, fullPath, i, status, subFiles, _i, _len, _ref;
        console.log('[App FileStatusService FileLoader] nextTask tasks', (function() {
          var _i, _len, _ref, _results;
          _ref = FileLoader.tasks;
          _results = [];
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            i = _ref[_i];
            _results.push(i[0]);
          }
          return _results;
        })());
        fl = FileLoader;
        if (fl.tasks.length === 0) {
          fl.idle = true;
          console.log('[App FileStatusService FileLoader] idle->true');
          FileLoader.taskFinished();
          return;
        }
        _ref = fl.tasks.shift(), fullPath = _ref[0], subFiles = _ref[1];
        if (subFiles) {
          for (_i = 0, _len = subFiles.length; _i < _len; _i++) {
            fileName = subFiles[_i];
            fl.push(path.join(fullPath, fileName));
          }
          return fl.nextTask();
        }
        status = fs.lstatSync(fullPath);
        if (status.isDirectory()) {
          files = fs.readdirSync(fullPath);
          if (files.length === 0) {
            return fl.nextTask();
          }
          fl.tasks.unshift([path.join(fullPath, files[0]), null]);
          if (files.length > 1) {
            fl.push(fullPath, files.slice(1));
          }
          return fl.nextTask();
        }
        if (status.isFile() && ret.rightExt(fullPath) && !ret.zeroSize(fullPath)) {
          if (ret.limited()) {
            fl.tasks = [];
            if (ret.limited()) {
              $rootScope.notifyBox.post('fa fa-ban', '非VIP限制10张', 'http://www.ppduck.com/pay', '开通VIP');
            }
            return fl.nextTask();
          }
          existInfo = searchModel(function(info) {
            return info['fullPath'] === fullPath;
          });
          if (existInfo) {
            ret.existsModel.push(existInfo);
            return fl.nextTask();
          }
          backup(fullPath);
          pushModel(ret.makeFileInfo(fullPath));
          pushedCount++;
          console.log('[App FileStatusService FileLoader] pushModel fullPath', fullPath);
        }
        return $timeout(fl.nextTask, 10);
      },
      update: function() {
        if (!FileLoader.idle) {
          return;
        }
        FileLoader.idle = false;
        return FileLoader.nextTask();
      },
      taskFinished: function() {
        var i, info, s, _i, _j, _len, _len1, _ref, _ref1;
        s = ret;
        if (s.existsModel.length > 0) {
          if (confirm('是否重载已存在图片\n' + ((function() {
            var _i, _len, _ref, _results;
            _ref = s.existsModel;
            _results = [];
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              i = _ref[_i];
              _results.push(i.pathInfo.base);
            }
            return _results;
          })()).join('\n'))) {
            _ref = s.existsModel;
            for (_i = 0, _len = _ref.length; _i < _len; _i++) {
              info = _ref[_i];
              s.remove(info);
            }
            _ref1 = s.existsModel;
            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
              info = _ref1[_j];
              s.load(info.fullPath);
            }
          } else {
            $rootScope.notifyBox.post('fa fa-exclamation', "" + s.existsModel.length + "张己存在", '', '');
          }
          return s.existsModel = [];
        }
      },
      start: function() {
        return $rootScope.$watch((function() {
          return FileLoader.tasks.length;
        }), function() {
          return FileLoader.update();
        });
      }
    };
    FileLoader.start();
    ThumbMaker = {
      tasks: [],
      idle: true,
      push: function(fullPah, cb) {
        return ThumbMaker.tasks.push([fullPah, cb]);
      },
      nextTask: function() {
        var c, canvas, cb, fullPath, img, tm, _ref;
        tm = ThumbMaker;
        if (tm.tasks.length === 0) {
          return tm.idle = true;
        }
        _ref = tm.tasks.shift(), fullPath = _ref[0], cb = _ref[1];
        canvas = document.querySelector("canvas");
        c = canvas.getContext("2d");
        c.clearRect(0, 0, canvas.width, canvas.height);
        img = new Image();
        img.onload = function(e) {
          var h, thumbSize, w;
          thumbSize = 400;
          if (img.width > img.height) {
            w = Math.min(img.width, thumbSize);
            h = w * img.height / img.width;
          } else {
            h = Math.min(img.height, thumbSize);
            w = h * img.width / img.height;
          }
          canvas.width = w;
          canvas.height = h;
          c.drawImage(this, 0, 0, w, h);
          cb(canvas.toDataURL("image/png"));
          return $timeout(tm.nextTask, 10);
        };
        return img.src = fullPath;
      },
      update: function() {
        if (!ThumbMaker.idle) {
          return;
        }
        ThumbMaker.idle = false;
        return ThumbMaker.nextTask();
      },
      start: function() {
        return $rootScope.$watch((function() {
          return ThumbMaker.tasks.length;
        }), ThumbMaker.update);
      }
    };
    ThumbMaker.start();
    Compressor = {
      compressing: false,
      update: function() {
        if (Compressor.compressing) {
          return;
        }
        Compressor.compressing = true;
        return Compressor.compressNext();
      },
      compressNext: function() {
        var m;
        m = searchModel(function(info) {
          return info['autoCompress'];
        });
        if (m === null) {
          Compressor.compressing = false;
        } else {
          console.log('[App FileStatusService compressNext] fullPath', m.fullPath);
          m.progress = PROGRESS.WAITING;
          m.autoCompress = false;
          compressFile(m.fullPath);
          $timeout((function() {
            return Compressor.compressNext();
          }), 10);
        }
      }
    };
    init = function() {
      wsManager.addConnectedHandler(function() {
        return wsManager.ws.send(wsManager.EVENT_REQ.COMPRESSED_COUNT().json);
      });
      return $rootScope.$watch((function() {
        var i;
        return [
          model.length, (function() {
            var _i, _len, _results;
            _results = [];
            for (_i = 0, _len = model.length; _i < _len; _i++) {
              i = model[_i];
              _results.push(i.autoCompress);
            }
            return _results;
          })()
        ];
      }), (function(newValue, oldValue) {
        console.log('[App FileStatusService $watch] model.length', model.length);
        return Compressor.update();
      }), true);
    };
    ret = {
      PROGRESS: PROGRESS,
      load: function(fullPath) {
        return FileLoader.push(fullPath);
      },
      limited: function() {
        return !$rootScope.isVIP() && pushedCount >= 10;
      },
      pushedCount: function() {
        return pushedCount;
      },
      zeroSize: function(fullPath) {
        return fs.lstatSync(fullPath).size === 0;
      },
      rightExt: function(fullPath) {
        var _ref;
        return (_ref = path.parse(fullPath.toLowerCase()).ext) === '.png' || _ref === '.jpg' || _ref === '.jpeg';
      },
      makeFileInfo: function(fullPath) {
        var pathStatus, retInfo;
        pathStatus = fs.lstatSync(fullPath);
        retInfo = {
          fullPath: fullPath,
          originSize: pathStatus.size,
          progress: ret.PROGRESS.NOT_START,
          size: null,
          pathInfo: path.parse(fullPath),
          birthTime: pathStatus.birthtime,
          autoCompress: true,
          isOrigin: true,
          reduceRate: null,
          compressingRate: 0,
          backupFullPath: backupFullPath(fullPath),
          thumbSrc: null,
          status: {
            isCompressible: function() {
              return retInfo.progress & (PROGRESS.NOT_START | PROGRESS.COMPRESS_ERROR | PROGRESS.ERROR_FORMAT | PROGRESS.COMPRESSED_LARGER);
            },
            isCompressed: function() {
              return retInfo.progress & PROGRESS.COMPRESSED;
            },
            isFinished: function() {
              return retInfo.progress & (PROGRESS.COMPRESSED | PROGRESS.COMPRESSED_LARGER);
            },
            isCompressing: function() {
              return retInfo.progress & PROGRESS.COMPRESSING;
            },
            isHandled: function() {
              return retInfo.progress & (PROGRESS.COMPRESSED | PROGRESS.COMPRESS_ERROR | PROGRESS.ERROR_FORMAT | PROGRESS.COMPRESSED_LARGER);
            }
          },
          setAutoCompress: function(bool) {
            retInfo.autoCompress = bool;
            return $timeout((function() {
              return $rootScope.$apply();
            }), 0);
          },
          restoreFile: function() {
            var reader;
            reader = fs.createReadStream(retInfo.backupFullPath);
            reader.pipe(fs.createWriteStream(fullPath));
            retInfo.restoreFileInfo();
            return reader;
          },
          restoreFileInfo: function() {
            retInfo.size = null;
            retInfo.reduceRate = null;
            return $timeout((function() {
              return $rootScope.$apply();
            }), 0);
          },
          restoreToOrigin: function() {
            var reader;
            reader = retInfo.restoreFile();
            retInfo.isOrigin = true;
            retInfo.progress = PROGRESS.NOT_START;
            return reader;
          },
          onCompressed: function() {
            var m;
            m = retInfo;
            m.getSize();
            m.getReduceRate();
            m.isOrigin = false;
            if (m.getReduceRate() === 0) {
              m.restoreFile();
              return m.progress = PROGRESS.COMPRESSED_LARGER;
            }
          },
          getSize: function() {
            return retInfo.size = fs.lstatSync(retInfo.fullPath).size;
          },
          getReduceRate: function() {
            return retInfo.reduceRate = Math.max(0, 1 - retInfo.size / retInfo.originSize);
          }
        };
        imageSize(fullPath, function(err, bound) {
          retInfo.bound = bound;
          return $timeout((function() {
            return $rootScope.$apply();
          }), 0);
        });
        ThumbMaker.push(fullPath, function(src) {
          return retInfo.thumbSrc = src;
        });
        return retInfo;
      },
      model: function() {
        return model;
      },
      remove: function(info) {
        return model.splice(model.indexOf(info), 1);
      },
      emptyModel: function() {
        return model = [];
      },
      existsModel: [],
      testPush: function(d) {
        return pushModel(d);
      }
    };
    init();
    return ret;
  });

  app.controller("TopController", function($rootScope, $scope, FileStatusService, Redirector, $timeout, $modal) {
    $scope.onShowOpenDialog = function() {
      return showOpenDialog(function(fullPathList) {
        var fullPath, _i, _len;
        for (_i = 0, _len = fullPathList.length; _i < _len; _i++) {
          fullPath = fullPathList[_i];
          FileStatusService.load(fullPath);
        }
        return Redirector.go(Redirector.views.file);
      });
    };
    $scope.onCleanView = function() {
      if (FileStatusService.model().length === 0) {
        return;
      }
      if (confirm('是否清空列表')) {
        return FileStatusService.emptyModel();
      }
    };
    $scope.$watch((function() {
      return FileStatusService.pushedCount();
    }), function() {
      return $scope.pushedCount = Math.max(0, 10 - FileStatusService.pushedCount());
    });
    $scope.$watch((function() {
      var i, _i, _len, _ref, _results;
      _ref = FileStatusService.model();
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        i = _ref[_i];
        _results.push(i.size);
      }
      return _results;
    }), (function() {
      var compressed, handled, info, s, sumModel;
      s = FileStatusService;
      if (s.model().length === 0) {
        $scope.modelEmpty = true;
        Redirector.go(Redirector.views.drop);
        return;
      }
      Redirector.go(Redirector.views.file);
      $scope.modelEmpty = false;
      compressed = (function() {
        var _i, _len, _ref, _results;
        _ref = s.model();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          info = _ref[_i];
          if (info.progress === s.PROGRESS.COMPRESSED) {
            _results.push(info);
          }
        }
        return _results;
      })();
      handled = (function() {
        var _i, _len, _ref, _results;
        _ref = s.model();
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          info = _ref[_i];
          if (info.status.isHandled()) {
            _results.push(info);
          }
        }
        return _results;
      })();
      $scope.compressedLength = compressed.length;
      if (compressed.length === 0) {
        return;
      }
      sumModel = function(func) {
        var r, _i, _len;
        r = 0;
        for (_i = 0, _len = compressed.length; _i < _len; _i++) {
          info = compressed[_i];
          r += func(info);
        }
        return r;
      };
      $scope.statistic = {
        origin: sumModel((function(info) {
          return info.originSize;
        })),
        size: sumModel((function(info) {
          return info.size;
        })),
        fileCount: handled.length,
        compressedCount: compressed.length,
        totalCount: s.model().length
      };
      return $scope.statistic.compress = Math.round((1 - $scope.statistic.size / $scope.statistic.origin) * 100);
    }), true);
    $scope.modelEmpty = true;
    $rootScope.openExternal = function(url) {
      return window.openExternal(url);
    };
    $rootScope.notifyBox = {
      allMsg: [],
      post: function(logo, message, linkSrc, linkText) {
        var obj;
        obj = {
          logo: logo,
          message: message,
          linkSrc: linkSrc,
          linkText: linkText
        };
        $rootScope.notifyBox.allMsg.push(obj);
        return $timeout((function() {
          return $rootScope.$apply();
        }), 0);
      },
      start: function() {
        return $rootScope.$watch((function() {
          return $rootScope.notifyBox.allMsg.length;
        }), function() {
          var nb, showNext, t;
          nb = $rootScope.notifyBox;
          if (nb._working) {
            return;
          }
          nb._working = true;
          t = 2 * 1000;
          showNext = function() {
            var msg;
            if (nb.allMsg.length === 0) {
              return nb._working = false;
            }
            msg = nb.allMsg.shift();
            nb._show(msg);
            return $timeout(showNext, t);
          };
          return showNext();
        });
      },
      _working: false,
      _show: function(obj) {
        $rootScope.notify.showBox = false;
        $rootScope.notify.logo = obj.logo;
        $rootScope.notify.message = obj.message;
        $rootScope.notify.linkSrc = obj.linkSrc;
        $rootScope.notify.linkText = obj.linkText;
        return $timeout((function() {
          return $rootScope.notify.showBox = true;
        }), 10);
      }
    };
    $rootScope.notify = {
      showBox: false
    };
    $rootScope.notifyBox.start();
    $scope.aboutModal = {
      redirectToLogin: false,
      modal: $modal({
        scope: $scope,
        template: 'about.html',
        show: false
      }),
      onShow: function() {},
      onHide: function() {},
      setOnShow: function(func) {
        return this.onShow = func;
      },
      setOnHide: function(func) {
        return this.onHide = func;
      },
      loginView: function() {
        this.redirectToLogin = true;
        return $scope.aboutModal.modal.show();
      },
      aboutView: function() {
        return $scope.aboutModal.modal.show();
      }
    };
    $scope.$on('modal.show', function() {
      return $scope.aboutModal.onShow();
    });
    $scope.$on('modal.hide', function() {
      return $scope.aboutModal.onHide();
    });
    $rootScope._vipEmail = "";
    $rootScope.getEmail = function() {
      return $rootScope._vipEmail;
    };
    $rootScope.setEmail = function(email) {
      return $rootScope._vipEmail = email;
    };
    $rootScope.isVIP = function() {
      return $rootScope._vipEmail !== "";
    };
    window.wsManager.addMessageHandler(function(message) {
      var email;
      switch (message.event) {
        case wsManager.EVENT_RES.CHECK_VIP:
          if (message.success) {
            email = message.message;
            $rootScope.setEmail(email);
          } else {
            $rootScope.setEmail('');
          }
          return $timeout((function() {
            return $rootScope.$apply();
          }), 0);
      }
    });
    window.wsManager.addConnectedHandler(function() {
      return window.checkVIP();
    });
    console.log('[TopController] init ok');
    $rootScope.version = '1.0.2';
  });

}).call(this);

//# sourceMappingURL=app.map
