// Generated by CoffeeScript 1.7.1
(function() {
  var app, remote, wsManager;

  remote = require('remote');

  app = window.app;

  wsManager = window.wsManager;

  app.controller('AboutViewController', function($scope, $rootScope, $timeout) {
    var VIEWS, aboutModal, createAuth, init;
    VIEWS = {
      ABOUT: 1,
      LOGIN: 2
    };
    init = function() {
      $scope.VIEWS = VIEWS;
      $scope.setView(VIEWS.ABOUT);
      $scope.setFootMessage('');
      $scope.formLogin = null;
      $scope.model = {
        email: $rootScope.getEmail(),
        password: ''
      };
      if ($rootScope.isVIP()) {
        $scope.model.email = $rootScope.getEmail();
        return $scope.setView(VIEWS.ABOUT);
      }
    };
    wsManager.addMessageHandler(function(message) {
      switch (message.event) {
        case wsManager.EVENT_RES.CREATE_AUTH:
          console.log('CREATE_AUTH', JSON.stringify(message));
          if (message.success) {
            $rootScope.setEmail($scope.model.email);
            $scope.setView(VIEWS.ABOUT);
            $scope.setFootMessage('');
          } else {
            $scope.setFootMessage('验证失败');
            $rootScope.setEmail('');
          }
          return $timeout((function() {
            return $rootScope.$apply();
          }), 0);
      }
    });
    $scope.setView = function(view) {
      $scope.currentView = view;
      return $scope.setFootMessage('');
    };
    $scope.IsView = function(view) {
      return $scope.currentView === view;
    };
    createAuth = function(email, password) {
      return wsManager.ws.send(wsManager.EVENT_REQ.CREATE_AUTH(email, password).json);
    };
    $scope.submitLogin = function() {
      console.log($scope.model);
      $scope.setFootMessage("");
      if ($scope.formLogin.$invalid) {
        return $scope.setFootMessage('用户名或密码无效');
      }
      return createAuth($scope.model.email, $scope.model.password);
    };
    $scope.logout = function() {
      $scope.model.email = '';
      $scope.model.password = '';
      return createAuth('', '');
    };
    $scope.setFootMessage = function(message) {
      return $scope.footMessage = message;
    };
    aboutModal = $scope.$parent.aboutModal;
    aboutModal.setOnShow(function() {
      $scope.duckWinkVideo.play();
      if (aboutModal.redirectToLogin) {
        $scope.setView(VIEWS.LOGIN);
        return aboutModal.redirectToLogin = false;
      }
    });
    aboutModal.setOnHide(function() {
      return $scope.duckWinkVideo.pause();
    });
    $scope.aboutModal = aboutModal;
    init();
    return console.log("[AboutViewController] init ok");
  });

}).call(this);

//# sourceMappingURL=about.map
