(function($){
if(!$.registerNameSpace("ydapp.pages")){return false;}
/**
* @desc 云端APP列表类分页方法
*/
$.registerNameSpace("ydapp.pages");
$.extend($.ydapp.pages, {
	init:function(total,limit,pNo,att,dislen){/*分页初始化*/
		if(typeof(total)=="undefined"){return "<a class='active'>1</a>";};
		if(typeof(dislen)=="undefined"){dislen=9;}
		returnhtml="";
		total=Number(total);
		limit=Number(limit);
		pNo=Number(pNo);
		if(limit >= total){
			returnhtml="<a class='active'>1</a>";
			return returnhtml;
		}
		lastpag=Math.ceil(total/limit);
		if(pNo>lastpag){
			pNo=lastpag;
		}
		curpage=pNo;
		laststart=(lastpag-1)*limit;
		if(curpage>1){
			prestr="<a class='page_up' "+att[0].replace(att[1],""+(curpage-1))+" title='上一页'>上一页</a>";
		}else{
			prestr="";
		}
		if(curpage<lastpag){
			nextstr="<a class='page_down' "+att[0].replace(att[1],""+(curpage+1)) + " title='下一页'>下一页</a>";
		}else{
			nextstr="";
		}
		dispageoff=parseInt(dislen/2,10);
		dismid=dispageoff+1;
		if(curpage==1){
			fstyle=" class='active'";
		}else{
			fstyle="";
		}
		if(curpage==lastpag){
			lstyle=" class='active'";
		}else{
			lstyle="";
		}
		pagedot={"left":0,"rigth":0};
		if(lastpag > dislen){
			if(curpage > dismid){
				pagedot.left=1;
				if(curpage>(lastpag-dispageoff)){
					pagedot.rigth=0;
				}else{
					pagedot.rigth=1;
				}
			}else{
				pagedot.left=0;
				if(curpage>(lastpag-dispageoff)){
					pagedot.rigth=0;
				}else{
					pagedot.rigth=1;
				}
			}
		}else{
			pagedot.left=0;
			pagedot.rigth=0;
		}
		var pages=new Array();
		var pstart=new Array();
		var pstyle=new Array();
		if(pagedot.left==0){
			if(pagedot.rigth==0){
				dislen=lastpag;
			}
			for(pj=0;pj<(dislen-1);pj++){
				pages[pj]=1+pj;
				pstart[pj]=(pages[pj]-1)*limit;
				if(pages[pj]==curpage){
					pstyle[pj]="  class='active'";
				}else{
					pstyle[pj]="";
				}
			}
			for(pj=0;pj<(dislen-2);pj++){
				returnhtml += "<a "+att[0].replace(att[1],""+pages[pj]) + pstyle[pj]+">"+pages[pj]+"</a>";
			}
			if(pagedot.rigth==0){
				returnhtml += "<a "+att[0].replace(att[1],""+pages[pj]) + pstyle[pj]+">"+pages[pj]+"</a><a "+att[0].replace(att[1],""+lastpag)+ lstyle+">"+lastpag+"</a>";
			}else{
				returnhtml += "<a class='pagePoint'>...</a><a " +att[0].replace(att[1],""+lastpag) + lstyle+">"+lastpag+"</a>";
			}
		}else{
			if(pagedot.rigth==0){
				begpage=lastpag-dislen+2;
			}else{
				begpage=curpage-dispageoff+1;
			}
			for(pj=0;pj<(dislen-2);pj++){
				pages[pj]=begpage+pj;
				pstart[pj]=(pages[pj]-1)*limit;
				if(pages[pj]==curpage){
					pstyle[pj]="  class='active'";
				}else{
					pstyle[pj]="";
				}
			}
			if(pagedot.rigth==0){
				pj=0;
				returnhtml += "<a " +att[0].replace(att[1],"1") + fstyle+">1</a><a class='pagePoint'>...</a>";
				for(pj=1;pj<(dislen-2);pj++){
					returnhtml += "<a " +att[0].replace(att[1],"" +pages[pj]) + pstyle[pj]+">"+pages[pj]+"</a>";
				}
				returnhtml += "<a " +att[0].replace(att[1],"" +lastpag) + lstyle+">"+lastpag+"</a>";
			}else{
				pj=0;
				returnhtml += "<a " +att[0].replace(att[1],"1") + fstyle+">1</a><a class='pagePoint'>...</a>";
				for(pj=1;pj<(dislen-3);pj++){
					returnhtml += "<a " +att[0].replace(att[1],"" +pages[pj]) + pstyle[pj]+">"+pages[pj]+"</a>";
				}
				returnhtml += "<a class='pagePoint'>...</a><a " +att[0].replace(att[1],"" +lastpag) + lstyle+">"+lastpag+"</a>";
			}
		}
		returnhtml=prestr + returnhtml + nextstr;
		return returnhtml;
	},
	backCall:function(fn){/*分页事件绑定*/
		var activePage = Number($(".pages a[class='active']").text());
		$(".pages a[class='page_up']").attr("href",activePage-1);
		$(".pages a[class='page_down']").attr("href",activePage+1);
		var allPages = $(".pages a[class!='pagePoint'][class!='active']");
		$.each(allPages, function(){
			$(this).click(function(){
				var _pno=($(this).text()=="上一页" || $(this).text()=="下一页")?$(this).attr("href"):$(this).text();
				fn(_pno);
				return false;
			});
		});
		$(".pages a[class='active']").removeAttr("href");
	}
});

//qq微博分页
$.ydapp.pages.qq_weibo={
	init:function(){
		$(".moreComment .pages a").hide().parent().find("a[class='page_down'],a[class='page_up']").show();
		$(".moreComment .pages a[class='page_down']").show().attr("href",1);
		$(".moreComment .pages a[class='page_up']").show().attr("href",2);
	}
}
})(jQuery);