/**
 * 与客户端通信 封装
 */
/**
 * 开始游戏
 *  chaos         101
 *  dota          10201
 *  imba(英霸)    10208
 *  忍村          10210
 */
//调用方式$.cga.client.client.xxx();
$.registerNameSpace("cga.client.client");
$.cga.client.client = {

    /**
     * 通知客户端登录
     * uid 用户id
     * token 加密串
     * salt 随机字符串
     * userJsonData 用户json数据
     */

    login : function(code,msg,uid,userJsonData){
        try{
            window.top.hfweb.login(code,msg,uid,userJsonData);
        }catch(e){
            alert(e);
        }
        //$.cga.client.client.closeWindow();
        return;
    },


    /**
     * 通知客户端退出
     * user_id 用户ID
     */
    logout : function(user_id) {
       /* if(!user_id)  {
            alert('用户ID为空,退出失败');
            return;
        }*/
        try {
            
            window.top.hfweb.logout(user_id);
        } catch(e) {
            alert('退出失败');
            return;
        }
    },

    /**
     * 获取客户端用户ID
     */
    getUserId : function() {
        var user_id = 0;
        try {
            user_id = window.top.hfweb.getStringUserID();
        } catch(e) {

        }
        return user_id;
    },

    
    checkClientLogin : function() {
        var is_login = false;
        try {
            is_login = window.top.hfweb.isUserLogon();
        } catch(e) {

        }
        return is_login;
    },

    setUserInfo : function(avatar_index,user_nick) {
            try{
                window.top.hfweb.setUserInfo(avatar_index,user_nick)
            }catch(e){
                alert('更新客户端头像失败!');
                return;
            }
    },
    /**
     * 获取客户端用户登入的信息
     * 返回json 值 uid,account,token,token_time
     * 
     */
    getReloginInfo : function(){
    	try {
           return window.top.hfweb.getReloginInfo();
        } catch(e) {
            alert('获取客户端登入信息失败');
            return;
        }
    },
    /**
     * 打开登录窗口
     */
    openLoginWindow : function() {
        try {
            window.top.hfweb.openLoginWindow();
        } catch(e) {
            alert('打开登录界面失败');
            return;
        }
    },
    
    /**
     * 关闭当前窗口
     * callback 回调函数
     */
    closeWindow : function(callback){
        callback = $.isFunction(callback) ? callback : '';
        try{
            window.top.hfwin.close(callback);
        }catch(e){
            alert(e);
        }
    },
    /**
     * 开始游戏
     *  chaos         101
     *  dota          10201
     *  imba(英霸)    10208
     *  忍村          10210
     */
    startGame : function(game_id) {
        if(!game_id) {
            alert('打开游戏失败,游戏ID为空');
            return false;
        }
        try {
        	//alert('打开游戏');
            return window.top.hfweb.startGame(game_id);
        } catch(e) {
            alert('打开游戏失败,游戏ID'+game_id);
            return false;
        }
    },

    /**
     * 刷新当前窗口
     */
    refreshWindow : function() {
        try {
            window.top.hfwin.refresh();
        } catch(e) {
            alert('刷新窗口失败');
            return;
        }
    },
    /**
     * 弹出消息提示框
     * text 提示框内容
     * title 提示框标题
     * type 提示框类型 1->确定 2->取消 3->中止 4->重试 5->忽略 6->是 7->否 10->再试 11->继续
     */
    showMsgDialog : function(text,title,type) {
        type = type || 1;
        text = text || '';
        title = title || '';
        try {
            window.top.hfwin.showMessageDialog(text,title,type);
        } catch(e) {
            alert(e);
            return;
        }
    },

    /**
     * 打开新窗口
     * width 宽度
     * height 高度
     * title 标题
     * url 打开连接
     * window_type login->登录 reguser->注册 modifypwd->修改密码 
     *             profile->个人中心 share->分享 具体跟金总沟通
     * flag
     * 0--子类窗体，即当前窗体为其父窗体的子类窗体。当父窗体关闭时会自动关闭该子类窗体。
     * 1--子类联动窗体，即当前窗体为其父窗体的子类联动窗体，
     *    这时父窗体关闭时只是隐藏；当该子类联动窗体关闭时，自动会关闭父窗体。
     * 2--弹出窗体，即当前窗体为主程序里的主窗体的子类窗体。
     */
    openNewWindow : function(width,height,title,url,window_type,flag) {
        if(!url || !url.length) {
            return false;
        }
        width = width || 100;
        height = height || 100;
        title = title || '';
        window_type = window_type || 'login';
        flag = flag || 2;
        try {
            window.top.hfwin.newPopWindow(width,height,title,url,window_type,flag);
        } catch(e) {
            alert(e);
            return;
        }
    },

    getWindowLeft : function() {
        try {
            return window.top.hfwin.left;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowLeft : function(value) {
        try {
            window.top.hfwin.left = value || 0;
        } catch(e) {
            alert(e);
            return;
        }
    },

    getWindowTop : function() {
        try {
            return window.top.hfwin.top;
        } catch(e) {
            alert(e);
            return;
        }
    },
    
    setWindowTop : function(value) {
        try {
            window.top.hfwin.top = value || 0;
        } catch(e) {
            alert(e);
            return;
        }
    },

    getWindowWidth : function() {
        try {
            return window.top.hfwin.width;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowWidth : function(value) {
        try {
            window.top.hfwin.width = value || 0;
        } catch(e) {
            alert(e);
            return;
        }
    },


    getWindowHeight : function() {
        try {
            return window.top.hfwin.height;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowHeight : function(value) {
        try {
            window.top.hfwin.height = value || 0;
        } catch(e) {
            alert(e);
            return;
        }
    },

    getWindowOwner : function() {
        try {
            return window.top.hfwin.owner;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setMinimizeCallback : function(callback) {
        callback = callback || function() {};
        try {
            window.top.hfwin.onMinimize = callback;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setMaximizeCallback : function(callback) {
        callback = callback || function() {};
        try {
            window.top.hfwin.onMaximize = callback;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setCloseCallback : function(callback) {
        callback = callback || function() {};
        try {
            window.top.hfwin.onClose = callback;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowLeftTop : function(left , top) {
        left = left || 0;
        top = top || 0;
        try {
            window.top.hfwin.setTopLeft(left,top);
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowSize : function(width,height) {
        width = width || 100;
        height = height || 100;
        try {
            window.top.hfwin.setSize(width,height);
        } catch(e) {
            alert(e);
            return;
        }
    },


    setWindowPos : function(left,top,width,height) {
        left = left || 0;
        top = top || 0;
        width = width || 100;
        height = height || 100;
        try {
            window.top.hfwin.setPos(left,top,width,height);
        } catch(e) {
            alert(e);
            return;
        }
    },

    setMinSize : function(width,height) {
        width = width || 0;
        height = height || 0;
        try {
            window.top.hfwin.setMinSize(width,height);
        } catch(e) {
            alert(e);
            return;
        }
    },

    hideWindow : function() {
        try {
            window.top.hfwin.hide();
            return true;
        } catch(e) {
            alert(e);
            return;
        }
    },


    setMaxWindow : function() {
        try {
            window.top.hfwin.maximize();
            return true;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setMinWindow : function() {
        try {
            window.top.hfwin.minimize();
            return true;
        } catch(e) {
            alert(e);
            return;
        }
    },

    setWindowInfo : function(width,height,type,title) {
        width = width || 100;
        height = height || 100;
        type = type || 'login';
        title = title || '';
        try {
            return window.top.hfwin.setWindowInfo(width,height,type,title);
        } catch(e) {
            alert(e);
            return;
        }
    },

    openKeySetting : function(game_id) {
        try {
            window.top.hfweb.openKeySetting(game_id);
        } catch(e) {
            alert(e);
            return;
        }
    },

    openGameSetting : function(game_id) {
        try {
            window.top.hfweb.openGameSetting(game_id);
        } catch(e) {
            alert(e);
            return;
        }
    },


    /**
     * 打开新窗口
     * width 宽度
     * height 高度
     * title 标题
     * url 打开连接
     * window_type login->登录 reguser->注册 modifypwd->修改密码 
     *             profile->个人中心 share->分享 具体跟金总沟通
     * flag
     * 0-> 有标题栏的弹出窗体 
     * 1-> 无标题栏的弹出窗体
     */
    openWindowUrl : function(width,height,title,url,window_type,flag) {
        if(!url || !url.length) {
            return false;
        }
        width = width || 100;
        height = height || 100;
        title = title || '';
        window_type = window_type || 'login';
        flag = flag || 0;
        if(flag == 1) flag = 65536; //金总说的
        if (flag == 2) flag = 131072;
        try {
            window.top.hfweb.openWindowUrl(width,height,title,url,window_type,flag);
        } catch(e) {
            alert(e);
            return;
        }

    },


    /**
     * 上报第一次登录数据
     */
    reportFirstLogonData : function(user_id) {
        if(!user_id) return;
        try {
            window.top.hfweb.reportFirstLogonData(user_id);
        } catch(e) {
            return;
        } 
    },

    /**
     *  设置主界面大按钮为选中状态
     */
    setMainPageIndex : function(index) {
        try {
            window.top.hfweb.setMainPagePushed(index);
        } catch(e) {
            return;
        }
    },


    /**
     *  设置主界面url
     */
    setMainUrl : function(url) {
        try {
            window.top.hfweb.navigateUrl(url,1);
        } catch(e) {
            return;
        }
    },

    //设置游戏主界面url
    setMainGameUrl : function(index,url) {
        if(!url || !url.length) return;
        this.setMainPageIndex(0);
       // url = encodeURIComponent(url);
        //var game_url = $.cga.config.SITE_URL+'/major?index='+index+'&url='+url;
        //alert(url);
        var game_url = url;
        this.setMainUrl(game_url);
    },
    
    //加入当前连接
    setCurrPage:function(url){
    	 if(!url || !url.length) return;
    	 try {
             window.top.hfweb.setCurrPage(url);
         } catch(e) {
        	 //alert('加入url失败!');
             return;
         }
    },
    
    //客户端主导航跳转
    switchToolbarToMain : function(url) {
    	 if(!url || !url.length) return;
    	 try {
             window.top.hfweb.switchToolbarToMain(url);
         } catch(e) {
             return;
         }
    },
    
    //前进
    getBackward:function(){
    	 try {
            return  window.top.hfweb.getBackwardPage();
         } catch(e) {
             return;
         }
    },
    getForward:function(){
   	 try {
           return  window.top.hfweb.getForwardPage();
        } catch(e) {
            return;
        }
   },
   hasBackwardPage:function(){
	   	 try {
	           return  window.top.hfweb.hasBackwardPage();
	        } catch(e) {
	            return;
	        }
	},
	hasForwardPage:function(){
	   	 try {
	           return  window.top.hfweb.hasForwardPage();
	        } catch(e) {
	            return;
	        }
	},
	updateUserInfoFromWeb:function(UserJsonData){
	   	 try {
	          return  window.top.hfweb.updateUserInfoFromWeb(UserJsonData);
	     } catch(e) {
	            return;
	     }
	},
	initJscript:function(val){
	   	 try {
	          return  window.top.hfweb.initJscript(val);
	     } catch(e) {
	            return;
	     }
	},
	getCurrentSkin:function(){
	   	 try {
	   		 return  window.top.hfweb.getCurrentSkin();
	     } catch(e) {
	    	 return;
	     }
	}
};
