/**
 * 游戏管理左边的菜单栏
 */
$.registerNameSpace("cga.apps.index.gameBar");
$.cga.apps.index.gameBar = {
		//单个元素上下移动
	
	//排序
	sortIndex:function(index){
		index.sort(function(a,b){
			return parseInt(a)>parseInt(b)?1:-1;
		});
		return index;
	},
	sequenceGameHtml:function(){
		var arr = new  Array();
		$(".bar_menu ul li.game").each(function(){
			arr.push($(this).attr('index'));
		})
		arr = this.sortIndex(arr);
		var html = "";
		var max_len = 8;
		if(arr.length<=max_len){
			max_len = arr.length;
		}
		for(var i=0;i<max_len;i++){
			html += this.getGameHtml(arr[i]);
		}
		$("li.game").remove();
		$(".bar_menu ul").append(html);
	},
	getGameHtml:function(index){
		var obj =$(".bar_menu ul li.game[index="+index+"]");
		obj.find(".idel").hide();
		var html='<li class="game" index="'+index+'" gid="'+obj.attr('gid')+'" state="'+obj.attr('state')+'" gtype="'+(obj.attr("gtype") ? obj.attr("gtype") : '')+'">'
		html+=obj.html();
		html+='</li>';
		return html;
	},
	//置顶
	setTop:function(index){
		index=parseInt(index);
		$(".bar_menu ul li.game[index="+index+"]").attr('index',0);
		if(index>1){
			$(".bar_menu ul li.game").each(function(){
				var i = $(this).attr("index");
				if(parseInt(i)<index){
					var n = parseInt(i)+1;
					$(this).attr("index",n);
				}
			});
		}
		$(".bar_menu ul li.game[index=0]").attr('index',1);
		//$(".bar_menu ul li.game[index="+index+"]").attr('index',1);
		this.sequenceGameHtml();
	},
	
	//打开游戏加入左边的菜单
	openGameAddMenu:function(obj){
		
		var gtype = typeof obj.type == 'undefined' ? '' : obj.type;
		var index = $(".bar_menu ul li.game[gid="+obj.game_id+"][gtype="+gtype+"]").attr('index');

		if(parseInt(index)>0){
			this.setTop(index);
			this.submitUserGame(gtype);
		}else{
			var new_index =this.getNewGameListIndex();
			obj.index = 1;
			var html = this.createGameListHtml(obj);

			if($(".bar_menu ul li.game").length == 0){
				$(".bar_menu ul").append(html);
			}else{
				//$(".bar_menu ul li.game").eq(new_index-2).after(html);
				$(".bar_menu ul").prepend(html);
			}
			//保存数据
			this.sequenceGameHtml();
			this.submitUserGame(gtype);
		}
	},
	initGameHtml:function(){
		if($('#bar_button a').attr('abr')!='2'){
			$(".bar_menu ul li.game").each(function(){
				
				var gid = $(this).attr('gid');
				$('i[gid="'+gid+'"]').hide();
			});
		}
	},
	getGameListData:function(){
		var jsonStr='[';
		var type = '';
		$(".bar_menu ul li.game").each(function(){
			type = $(this).attr('gtype');
			jsonStr +="{\"game_id\":\""+$(this).attr('gid')+"\",";
			jsonStr +="\"state\":\""+$(this).attr('state')+"\",";
			if(type) jsonStr +="\"type\":\""+type+"\",";
			jsonStr +="\"index\":\""+$(this).attr('index')+"\"},";
		});
		jsonStr = jsonStr.substr(0,jsonStr.length-1);
		jsonStr +=']';
		this.initGameHtml();
		return  jsonStr;
	},
	submitUserGame:function(gtype){
		gtype = gtype ? gtype : 'war';
		var url = gtype == 'war' ? "/user/gameMenu" : '/app/appMenu';
		$.ajax({
			url:url,
			data:{'data':this.getGameListData(),'client':$("#client").val()},
			type:"post",
			//async:false,
			dataType:'json',
			success:function(ref){
				if(ref.code==-2){
					$.cga.client.client.openLoginWindow();
				}
			},
			error:function(e){
				//alert(e);
			}
		});
	},
	createGameListHtml:function(obj){
		var style = "";
		var type = obj.type ? obj.type : '';
		var url = {"war":"#game?game_id=", "pc":"#app?app_id="};
		url = type ? eval('url.'+type) : url.war;
		if(type) obj.game_name = $.cga.common.func.cutFontLength(obj.game_name,7,'');
		if($('#bar_button a').attr('abr')!='2'){
			style = 'style="display:none"';
		}
		var  html ="";
		html +='<li class="game" gid='+obj.game_id+' index="'+obj.index+'" state="edit" gtype="'+type+'">';
        html +='<a href="'+url+obj.game_id+'" class="g_menu"  onfocus="this.blur()">';
        html += '<span class="avatar_40x40">';
        html += '<img src="'+obj.game_icon+'" width="48" height="48" alt="">';
        html += '</span>';
        html += '<strong> '+obj.game_name+'</strong>';
        html += '</a></li>';
        return  html;		
	},
	getNewGameListIndex:function(){
		var list_index = $(".bar_menu ul li.game").length;
		var new_index=0;
		if(list_index>0){
			var i=2;
			$(".bar_menu ul li.game").each(function(){
				$(this).attr('index',i);
				i++;
			});
		}
		return  new_index;	
	}
}