(function($){
if(!$.registerNameSpace("ydapp.game.pc_game")){return false;}
/**
* @desc 游戏频道 - 单机游戏
*/
$.registerNameSpace("ydapp.game.pc_game");
$.extend($.ydapp.game.pc_game, {
	index:{
		init:function(){
		}	
	},
	list:{
		init:function(){
			$.mouseHover(".game_v_list li");
			var app_id = app_status = 0;
			//游戏状态
			$(".addRes_m").each(function(){
				app_id = $(this).attr("resid");
				app_status = $.cga.client.appclient.initApp(app_id);
				$(this).removeClass().addClass("addRes_m "+$.ydapp.game.pc_game.statusClass(app_status)+"_m");
			});
		}
	},
	content:{
		init:function(){
			//游戏状态
			var app_id = $("a.addRes_g").attr("resid");
			var app_status = $.cga.client.appclient.initApp(app_id);
			$("a.addRes_g").removeClass().addClass("addRes_g "+$.ydapp.game.pc_game.statusClass(app_status)+"_g");

			$.ydapp.autoSlideClass.content_imgSlide("#slideContentCase", "#slideLeftBar", "#slideRihtBar","#slideNumBar");
			$.ydapp.autoSlideClass.type0("#slideContentCase1", "#leftBar1", "#rightBar1", 3 ,false);
			$("#tab_link_pc_game li").click(function(){
				$(this).parent().find("li[class='active']").removeClass("active");
				$(this).addClass("active");
				var _div=$(this).parent().parent().parent().find(".info_list");
				_div.hide();
				_div.eq($(this).find("a").attr("index")).show();
			});
		}	
	},
	/**
	*  评分计算
	*  @param	n1	int	比较分数
	*  @param	n2	int	总分数
	* 	return ["9.9",99,[9,9],[n1,n2]]
	*/
	starNumCount:function(n1, n2){
		var ret="00";
		n1=Number(n1);
		n2=Number(n2);
		if(n1>0&&n2>0){
			ret=""+Math.round(n1/n2*10);
			if(ret.length==1){ret="0"+ret;}
		}
		var s_num0 = ret.toString().substr(0,1);
		var s_num1 = ret.toString().substr(1);
		if(ret=="100"){
			var s_num0 = 10;
			var s_num1 = 0;
			return [s_num0,Number(ret),[s_num0,s_num1],[n1,n2]];
		}
		return [s_num0+"."+s_num1,Number(ret),[s_num0,s_num1],[n1,n2]];
	},
	statusClass:function(app_status) {
		var rclass = '';
		if(app_status == 1 || app_status == 4 || app_status == 5) {
			rclass = 'loading';
		} else if(app_status == 2) {
			rclass = 'restart';
		} else if(app_status == 7) {
			rclass = 'downloadOpen';
		} else {
			rclass = 'download';
		}
		return rclass;
	}
});

$("a.addRes_m,a.addRes_g[addApp='true']").die().live("click",function(){
	try{
		eval('var _app='+$(this).attr("apps"))
		var jsonArr = new Array();
		var n = 0;
		var jsonStr ='';
		var operate = $(this).attr("class").slice(9,-2);
		for(var key in _app) {
			if(typeof _app[key] == 'string')
				_app[key] = $.cga.common.func.chrToUnicode(_app[key]);
			jsonArr[n++] = "\""+key+"\":"+_app[key];
		}
		jsonStr = "{"+jsonArr.join(",")+"}";
		var isopen = $.cga.client.appclient.openApp(jsonStr, operate);
		if(isopen && operate == 'download'){
			$.post('/app/updatedown',{"app_id":_app.id},function(ref) {
				if(ref.errno) {
					alert(ref.msg);
				} else {
					var _obj = $("#app_user_download");
					_obj.html(parseInt(_obj.html())+1);
				}
			});
		}
	}catch(e){}
});
/*$("a.downloadOpen_g,a.downloadOpen_m[addApp='true']").die().live("click",function(){
	try{
		var app_id = $(this).attr("resid");
		eval('var _app='+$(this).attr("apps"));
		var obj = {
			"game_id":app_id,
			"game_name":_app.name,
			"game_icon":_app.imgUrl,
			"type":"pc"
		};
		parent.$("#barIframe")[0].contentWindow.$.cga.apps.index.gameBar.openGameAddMenu(obj); 
		$.cga.client.appclient.appStart(app_id);
	}catch(e){}
});
$("a.restart_g,a.restart_m[addApp='true']").die().live("click",function(){
	try{
		var app_id = $(this).attr("resid");
		$.cga.client.appclient.appContinue(app_id);
	}catch(e){}
});*/
})(jQuery);