/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class FileUtils {
    private FileUtils() {
    }

    public static List<File> pathsToFilesList(Set<String> paths) {
        return paths.stream().filter(path -> !path.isEmpty()).map(File::new).collect(Collectors.toList());
    }

    public static int calculateHash(File file) throws IOException {
        byte[] data = Files.readAllBytes(file.toPath());
        return Arrays.hashCode(data);
    }

    public static String appendSlashIfRequired(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            return path;
        }
        return path + (path.contains("/") ? "/" : "\\");
    }

    public static File createFolderInJarDir(String folder) {
        File workingDir = new File(".");
        File dirToCreate = new File(workingDir, folder);
        dirToCreate.mkdirs();
        return dirToCreate;
    }
}

