/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.model.Bitness;
import com.ray.wing.resorep.service.DllSettingsService;
import com.ray.wing.resorep.service.HookedApplicationsService;
import com.ray.wing.resorep.service.ProxyDllService;
import com.ray.wing.resorep.service.UiSettingsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ProxyDllServiceImpl
implements ProxyDllService {
    private static final Logger log = LoggerFactory.getLogger(ProxyDllServiceImpl.class);
    private static final String D3D11_DLL_FILE_NAME = "d3d11.dll";
    private static final String DX_11_DLL_32_LOCATION = System.getenv("SystemRoot") + "\\SysWOW64\\" + "d3d11.dll";
    private static final String DX_11_DLL_64_LOCATION = System.getenv("SystemRoot") + "\\system32\\" + "d3d11.dll";
    private static final String STORE_CUSTOM_GAME_D3D11_DLL_AS = "game_d3d11.dll";
    private static final String OLD_PROXIED_D3D11_DLL_EXT = ".bak";
    @Value(value="${dx11.proxied.dll.name}")
    private String dx11ProxiedDllName;
    @Value(value="${dx11.proxy.32.dll.sizes}")
    private List<Long> dx11Proxy32DllSizes;
    @Value(value="${dx11.proxy.64.dll.sizes}")
    private List<Long> dx11Proxy64DllSizes;
    @Value(value="${dll.proxy.32.file}")
    private String proxy32DllFileName;
    @Value(value="${dll.proxy.64.file}")
    private String proxy64DllFileName;
    @Autowired
    private UiSettingsService uiSettingsService;
    @Autowired
    private HookedApplicationsService hookedApplicationsService;
    @Autowired
    private DllSettingsService dllSettingsService;
    @Autowired
    private MessageSource messageSource;

    @Override
    public void installProxy(String executableFilePath, Bitness bitness) throws IOException {
        File gameExe = new File(executableFilePath);
        File gameDir = gameExe.getParentFile();
        if (gameDir.exists() && gameDir.isDirectory()) {
            this.cleanUpGameDir(gameDir);
            File dx11SystemDll = new File(ProxyDllServiceImpl.getSystemDllPath(bitness));
            File dx11InGameFolderDll = new File(gameDir, dx11SystemDll.getName());
            File dx11ProxiedDll = new File(gameDir, this.dx11ProxiedDllName);
            if (dx11InGameFolderDll.exists() && !this.isProxy(dx11InGameFolderDll)) {
                Files.copy(dx11InGameFolderDll.toPath(), dx11InGameFolderDll.toPath().resolveSibling(STORE_CUSTOM_GAME_D3D11_DLL_AS), new CopyOption[0]);
                if (dx11ProxiedDll.exists()) {
                    Files.move(dx11ProxiedDll.toPath(), dx11ProxiedDll.toPath().resolveSibling(dx11ProxiedDll.getName() + OLD_PROXIED_D3D11_DLL_EXT), StandardCopyOption.REPLACE_EXISTING);
                }
                Files.move(dx11InGameFolderDll.toPath(), dx11InGameFolderDll.toPath().resolveSibling(this.dx11ProxiedDllName), new CopyOption[0]);
            }
            if (!dx11InGameFolderDll.exists()) {
                File proxyDllInResorepFolder = new File(this.getProxyDllFileName(bitness));
                Files.copy(proxyDllInResorepFolder.toPath(), dx11InGameFolderDll.toPath(), new CopyOption[0]);
            }
            if (!dx11ProxiedDll.exists()) {
                Files.copy(dx11SystemDll.toPath(), dx11ProxiedDll.toPath(), new CopyOption[0]);
            }
        } else {
            String message = this.messageSource.getMessage("error.directory.invalid", new Object[]{gameDir.getCanonicalPath()}, LocaleContextHolder.getLocale());
            throw new IOException(message);
        }
        this.dllSettingsService.copyDllSettingsToGameFolder(gameDir);
    }

    private static String getSystemDllPath(Bitness bitness) {
        switch (bitness) {
            case BIT32: {
                return DX_11_DLL_32_LOCATION;
            }
            case BIT64: {
                return DX_11_DLL_64_LOCATION;
            }
        }
        throw new IllegalArgumentException("Unknown bitness: " + (Object)((Object)bitness));
    }

    private String getProxyDllFileName(Bitness bitness) {
        switch (bitness) {
            case BIT32: {
                return this.proxy32DllFileName;
            }
            case BIT64: {
                return this.proxy64DllFileName;
            }
        }
        throw new IllegalArgumentException("Unknown bitness: " + (Object)((Object)bitness));
    }

    private void cleanUpGameDir(File gameDir) throws IOException {
        String[] dllsToDelete;
        for (String dllToDelete : dllsToDelete = new String[]{D3D11_DLL_FILE_NAME, STORE_CUSTOM_GAME_D3D11_DLL_AS, "ori_d3d11.dll", "ori_d3d11.dll.bak"}) {
            File file = new File(gameDir, dllToDelete);
            if (!file.exists() || file.isDirectory() || !this.isProxy(file)) continue;
            Files.delete(file.toPath());
        }
        File settingsFile = new File(gameDir, "dllsettings.ini");
        if (settingsFile.exists() && !settingsFile.isDirectory()) {
            Files.delete(settingsFile.toPath());
        }
    }

    private boolean isProxy(File d3D11dllInGameFolder) throws IOException {
        if (d3D11dllInGameFolder.exists() && d3D11dllInGameFolder.isFile()) {
            Long fileSize = d3D11dllInGameFolder.length();
            return this.dx11Proxy64DllSizes.contains(fileSize) || this.dx11Proxy32DllSizes.contains(fileSize);
        }
        String message = this.messageSource.getMessage("error.file.not_exists_or_is_directory", new Object[]{d3D11dllInGameFolder.getCanonicalPath()}, LocaleContextHolder.getLocale());
        throw new IllegalArgumentException(message);
    }

    @Override
    public void removeProxy(String executableFilePath) throws IOException {
        File gameExe = new File(executableFilePath);
        File gameDir = gameExe.getParentFile();
        if (gameDir.exists() && gameDir.isDirectory()) {
            File dx11InGameFolderDll;
            File dx11ProxiedDll = new File(gameDir, this.dx11ProxiedDllName);
            if (dx11ProxiedDll.exists()) {
                Files.delete(dx11ProxiedDll.toPath());
            }
            if ((dx11InGameFolderDll = new File(gameDir, D3D11_DLL_FILE_NAME)).exists()) {
                Files.delete(dx11InGameFolderDll.toPath());
            }
            if (new File(gameDir, STORE_CUSTOM_GAME_D3D11_DLL_AS).exists()) {
                Files.move(dx11InGameFolderDll.toPath().resolveSibling(STORE_CUSTOM_GAME_D3D11_DLL_AS), dx11InGameFolderDll.toPath(), new CopyOption[0]);
            }
            this.dllSettingsService.removeDllSettingsFileFromGameFolder(gameDir);
        } else {
            String message = this.messageSource.getMessage("error.directory.invalid", new Object[]{gameDir.getCanonicalPath()}, LocaleContextHolder.getLocale());
            log.warn(message);
        }
    }
}

