/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.exception.UnsupportedOsVersionException;
import com.ray.wing.resorep.model.Bitness;
import com.ray.wing.resorep.model.OsVersion;
import com.ray.wing.resorep.service.GlobalHookService;
import com.ray.wing.resorep.service.WinService;
import com.ray.wing.resorep.util.FileUtils;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class GlobalHookServiceImpl
implements GlobalHookService {
    public static final String LOAD_APP_INIT_DLLS_KEY = "LoadAppInit_DLLs";
    public static final String APP_INIT_DLLS_KEY = "AppInit_DLLs";
    public static final String APP_INIT_DLLS_SEPARATOR = ",";
    public static final String APP_INIT_DLLS_DELIMETERS_REGEX = " |,";
    @Value(value="${dll.32.file}")
    private String dll32File;
    @Value(value="${dll.64.file}")
    private String dll64File;
    @Autowired
    private WinService winService;
    @Autowired
    private MessageSource messageSource;

    @Override
    public boolean isGlobalHookEnabled() throws InvocationTargetException, IllegalAccessException, UnsupportedOsVersionException, IOException {
        OsVersion osVersion = this.winService.getOsVersion();
        switch (osVersion) {
            case WIN_7: {
                boolean is32BitHookEnabled = this.isAppInitHookEnabled(Bitness.BIT32, this.dll32File);
                boolean is64BitHookEnabled = this.isAppInitHookEnabled(Bitness.BIT64, this.dll64File);
                return is32BitHookEnabled && is64BitHookEnabled;
            }
        }
        throw new UnsupportedOsVersionException(osVersion, this.messageSource);
    }

    private boolean isAppInitHookEnabled(Bitness bitness, String pathToDll) throws IOException {
        int loadAppInitDllsInt = Advapi32Util.registryGetIntValue(WinReg.HKEY_LOCAL_MACHINE, this.getKey(bitness), LOAD_APP_INIT_DLLS_KEY);
        boolean loadAppInitDlls = loadAppInitDllsInt == 1;
        boolean isDllFoundInAppInitDlls = false;
        long ourDllHash = FileUtils.calculateHash(new File(pathToDll));
        for (File dll : FileUtils.pathsToFilesList(this.getSeparateAppInitDllPathsAsSet(bitness))) {
            if (ourDllHash != (long)FileUtils.calculateHash(dll)) continue;
            isDllFoundInAppInitDlls = true;
            break;
        }
        return loadAppInitDlls && isDllFoundInAppInitDlls;
    }

    private String getKey(Bitness bitness) {
        String keyRoot = bitness == Bitness.BIT32 ? "SOFTWARE\\Wow6432Node" : "SOFTWARE";
        String commonKeyPath = "\\Microsoft\\Windows NT\\CurrentVersion\\Windows";
        return keyRoot + commonKeyPath;
    }

    @Override
    public void enableHook() throws IOException {
        this.disableHook();
        this.setLoadAppInitDlls(Bitness.BIT32, 1);
        this.setLoadAppInitDlls(Bitness.BIT64, 1);
        this.addDllToAppInitDllsPath(Bitness.BIT32, this.dll32File);
        this.addDllToAppInitDllsPath(Bitness.BIT64, this.dll64File);
    }

    private void setLoadAppInitDlls(Bitness bitness, int value) {
        Advapi32Util.registrySetIntValue(WinReg.HKEY_LOCAL_MACHINE, this.getKey(bitness), LOAD_APP_INIT_DLLS_KEY, value);
    }

    private void addDllToAppInitDllsPath(Bitness bitness, String dllFileName) throws IOException {
        File dllFile = new File(dllFileName);
        this.appendDllToAppInitDllsPath(bitness, dllFile.getCanonicalPath());
    }

    private void appendDllToAppInitDllsPath(Bitness bitness, String dllToAppend) {
        String appInitDllsPath = this.getAppInitDllsPath(bitness);
        String separator = appInitDllsPath.isEmpty() ? "" : APP_INIT_DLLS_SEPARATOR;
        this.setAppInitDllsPath(bitness, appInitDllsPath + separator + dllToAppend);
    }

    private void setAppInitDllsPath(Bitness bitness, String value) {
        Advapi32Util.registrySetStringValue(WinReg.HKEY_LOCAL_MACHINE, this.getKey(bitness), APP_INIT_DLLS_KEY, value);
    }

    private String getAppInitDllsPath(Bitness bitness) {
        return Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, this.getKey(bitness), APP_INIT_DLLS_KEY);
    }

    private Set<String> getSeparateAppInitDllPathsAsSet(Bitness bitness) {
        String[] appInitDllPathsArray = this.getAppInitDllsPath(bitness).split(APP_INIT_DLLS_DELIMETERS_REGEX);
        return new HashSet<String>(Arrays.asList(appInitDllPathsArray));
    }

    @Override
    public void disableHook() throws IOException {
        this.disableOldVersionHooks();
        this.removeDllFomAppInitDlls(Bitness.BIT32, this.dll32File);
        this.removeDllFomAppInitDlls(Bitness.BIT64, this.dll64File);
        this.clearLoadAppInitDlls(Bitness.BIT32);
        this.clearLoadAppInitDlls(Bitness.BIT64);
    }

    private void clearLoadAppInitDlls(Bitness bitness) {
        if (this.getAppInitDllsPath(bitness).isEmpty()) {
            this.setLoadAppInitDlls(bitness, 0);
        }
    }

    private void removeDllFomAppInitDlls(Bitness bitness, String dllFileName) throws IOException {
        Set<String> appInitDllPaths = this.getSeparateAppInitDllPathsAsSet(bitness);
        long ourDllHash = FileUtils.calculateHash(new File(dllFileName));
        Iterator<String> iterator = appInitDllPaths.iterator();
        while (iterator.hasNext()) {
            String path = iterator.next();
            if (!path.isEmpty() && ourDllHash != (long)FileUtils.calculateHash(new File(path))) continue;
            iterator.remove();
        }
        String newAppInitDllsPath = String.join((CharSequence)APP_INIT_DLLS_SEPARATOR, appInitDllPaths);
        this.setAppInitDllsPath(bitness, newAppInitDllsPath);
    }

    public void disableOldVersionHooks() {
    }
}

