/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.forms;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.ray.wing.resorep.forms.BitnessDialog;
import com.ray.wing.resorep.forms.UpdateDialog;
import com.ray.wing.resorep.model.Bitness;
import com.ray.wing.resorep.service.DllLogFileService;
import com.ray.wing.resorep.service.GlobalHookService;
import com.ray.wing.resorep.service.HookedApplicationsService;
import com.ray.wing.resorep.service.ProxyDllService;
import com.ray.wing.resorep.service.TextureFoldersService;
import com.ray.wing.resorep.service.TextureSavingService;
import com.ray.wing.resorep.service.UpdateService;
import com.ray.wing.resorep.util.UiUtils;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MainWindow
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MainWindow.class);
    private static final int MIN_WIDTH = 250;
    private static final int MIN_HEIGHT = 200;
    private List<String> selectedApplications = new ArrayList<String>();
    @Value(value="${version}")
    private String version;
    @Autowired
    private GlobalHookService globalHookService;
    @Autowired
    private HookedApplicationsService hookedApplicationsService;
    @Autowired
    private TextureSavingService textureSavingService;
    @Autowired
    private DllLogFileService dllLogFileService;
    @Autowired
    private ProxyDllService proxyDllService;
    @Autowired
    private TextureFoldersService textureFoldersService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UiUtils uiUtils;
    final JFileChooser applicationFileChooser = new JFileChooser(".");
    final JFileChooser dllLogFileChooser = new JFileChooser(".");
    final JFileChooser moddedTexturesFolderFileChooser = new JFileChooser(".");
    final JFileChooser originalTexturesFolderFileChooser = new JFileChooser(".");
    private JCheckBox globalHookCheckBox;
    private JPanel mainPanel;
    private JButton addHookedApplicationButton;
    private JButton removeHookedApplicationButton;
    private JTable applicationsToHookTable;
    private JTextField dllLogFileTextField;
    private JButton browseDllLogFileButton;
    private JCheckBox saveTexturesCheckBox;
    private JTextField moddedTexturesFolderTextField;
    private JButton browseModdedTexturesFolderButton;
    private JTextField originalTexturesFolderTextField;
    private JButton browseOriginalTexturesFolderButton;
    private JButton helpButton;
    private JLabel enableGlobalHookLabel;
    private JLabel applicationsToHookLabel;
    private JLabel dllLogLocationLabel;
    private JLabel moddedTexturesPathLabel;
    private JLabel originalTexturesPathLabel;
    private AbstractTableModel applicationsToHookTableModel;

    public MainWindow() {
        this.$$$setupUI$$$();
    }

    @Override
    public void run() {
        try {
            LocaleContextHolder.setLocale(new Locale("en", "US"));
            try {
                if (this.updateService.isNewVersionAvailable(this.version)) {
                    this.showUpdateDialog(this.updateService.getNewVersionUrl(), this.updateService.getNewVersionString());
                }
            }
            catch (Exception e) {
                log.error("Update check failed", e);
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                log.warn("Look and feel setup failed", e);
            }
            String applicationNameAndVersion = this.messageSource.getMessage("main_window.title", new Object[]{this.version}, LocaleContextHolder.getLocale());
            log.info(applicationNameAndVersion);
            JFrame frame = new JFrame(applicationNameAndVersion);
            frame.setContentPane(this.mainPanel);
            this.helpButton.addActionListener(new HelpButtonActionListener());
            this.saveTexturesCheckBox.setSelected(this.textureSavingService.isTextureSavingEnabled());
            this.saveTexturesCheckBox.addActionListener(new SaveTexturesCheckboxListener());
            this.initHookedApplicationsTable();
            this.applicationFileChooser.setFileSelectionMode(0);
            this.addHookedApplicationButton.addActionListener(new AddHookedApplicationsButtonListener());
            this.removeHookedApplicationButton.addActionListener(new RemoveHookedApplicationsButtonListener());
            this.dllLogFileTextField.setText(this.dllLogFileService.getDllLogFilePath());
            this.dllLogFileChooser.setFileSelectionMode(0);
            this.browseDllLogFileButton.addActionListener(new DllLogFileButtonListener());
            this.moddedTexturesFolderFileChooser.setFileSelectionMode(1);
            this.moddedTexturesFolderTextField.setText(this.textureFoldersService.getModdedTexturesFolderPath());
            this.browseModdedTexturesFolderButton.addActionListener(new ModdedTexturesFolderButtonListener());
            this.originalTexturesFolderFileChooser.setFileSelectionMode(1);
            this.originalTexturesFolderTextField.setText(this.textureFoldersService.getOriginalTexturesFolderPath());
            this.browseOriginalTexturesFolderButton.addActionListener(new OriginalTexturesFolderButtonListener());
            this.localizeUi(frame);
            frame.setDefaultCloseOperation(3);
            frame.setMinimumSize(new Dimension(250, 200));
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
        catch (IOException e) {
            this.uiUtils.processExceptionAndExit(e, log);
        }
    }

    private void showUpdateDialog(String newVersionUrl, String newVersionString) {
        new UpdateDialog(newVersionUrl, newVersionString, this.messageSource, this.uiUtils);
    }

    private void localizeUi(JFrame frame) {
        Locale locale = LocaleContextHolder.getLocale();
        this.enableGlobalHookLabel.setText(this.messageSource.getMessage("main_window.label.enable_global_hook", null, locale));
        this.applicationsToHookLabel.setText(this.messageSource.getMessage("main_window.label.applications_to_hook", null, locale));
        this.dllLogLocationLabel.setText(this.messageSource.getMessage("main_window.label.dll_log_location", null, locale));
        this.moddedTexturesPathLabel.setText(this.messageSource.getMessage("main_window.label.modded_textures_path", null, locale));
        this.originalTexturesPathLabel.setText(this.messageSource.getMessage("main_window.label.original_textures_path", null, locale));
    }

    private void initHookedApplicationsTable() {
        this.applicationsToHookTableModel = new ApplicationsToHookTableModel();
        this.applicationsToHookTable.setModel(this.applicationsToHookTableModel);
        this.applicationsToHookTable.getSelectionModel().addListSelectionListener(new ApplicationsToHookTableSelectionListener());
        TableRowSorter<AbstractTableModel> rowSorter = new TableRowSorter<AbstractTableModel>(this.applicationsToHookTableModel);
        rowSorter.setSortable(0, false);
        rowSorter.setSortable(1, false);
        this.applicationsToHookTable.setRowSorter(rowSorter);
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayoutManager(12, 7, new Insets(0, 0, 0, 0), -1, -1));
        JSeparator separator1 = new JSeparator();
        this.mainPanel.add((java.awt.Component)separator1, new GridConstraints(2, 1, 1, 5, 0, 1, 4, 0, new Dimension(-1, 5), new Dimension(-1, 5), new Dimension(-1, 5), 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.mainPanel.add((java.awt.Component)panel1, new GridConstraints(4, 5, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.addHookedApplicationButton = new JButton();
        this.addHookedApplicationButton.setText("+");
        panel1.add((java.awt.Component)this.addHookedApplicationButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.removeHookedApplicationButton = new JButton();
        this.removeHookedApplicationButton.setEnabled(false);
        this.removeHookedApplicationButton.setText("-");
        panel1.add((java.awt.Component)this.removeHookedApplicationButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((java.awt.Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        this.mainPanel.add((java.awt.Component)scrollPane1, new GridConstraints(4, 1, 1, 4, 0, 3, 5, 3, null, null, null, 0, false));
        this.applicationsToHookTable = new JTable();
        this.applicationsToHookTable.setCellSelectionEnabled(false);
        this.applicationsToHookTable.setColumnSelectionAllowed(false);
        this.applicationsToHookTable.setRowSelectionAllowed(true);
        this.applicationsToHookTable.setShowVerticalLines(true);
        this.applicationsToHookTable.putClientProperty("Table.isFileList", Boolean.FALSE);
        scrollPane1.setViewportView(this.applicationsToHookTable);
        this.applicationsToHookLabel = new JLabel();
        this.applicationsToHookLabel.setText("Applications to hook:");
        this.mainPanel.add((java.awt.Component)this.applicationsToHookLabel, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 1, new Dimension(10, -1), new Dimension(10, -1), new Dimension(10, -1), 0, false));
        Spacer spacer3 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(20, -1), new Dimension(20, -1), 0, false));
        Spacer spacer4 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer4, new GridConstraints(3, 6, 1, 1, 0, 1, 0, 1, new Dimension(10, -1), new Dimension(10, -1), new Dimension(10, -1), 0, false));
        Spacer spacer5 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer5, new GridConstraints(0, 0, 1, 7, 0, 2, 1, 0, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        Spacer spacer6 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer6, new GridConstraints(3, 3, 1, 2, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.mainPanel.add((java.awt.Component)spacer7, new GridConstraints(11, 0, 1, 7, 0, 2, 1, 2, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        this.dllLogFileTextField = new JTextField();
        this.dllLogFileTextField.setEditable(false);
        this.mainPanel.add((java.awt.Component)this.dllLogFileTextField, new GridConstraints(6, 1, 1, 4, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.browseDllLogFileButton = new JButton();
        this.browseDllLogFileButton.setText("...");
        this.mainPanel.add((java.awt.Component)this.browseDllLogFileButton, new GridConstraints(6, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.dllLogLocationLabel = new JLabel();
        this.dllLogLocationLabel.setText("Dll log location:");
        this.mainPanel.add((java.awt.Component)this.dllLogLocationLabel, new GridConstraints(5, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.moddedTexturesPathLabel = new JLabel();
        this.moddedTexturesPathLabel.setText("Load modded textures from:");
        this.mainPanel.add((java.awt.Component)this.moddedTexturesPathLabel, new GridConstraints(7, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.moddedTexturesFolderTextField = new JTextField();
        this.moddedTexturesFolderTextField.setEditable(false);
        this.mainPanel.add((java.awt.Component)this.moddedTexturesFolderTextField, new GridConstraints(8, 1, 1, 4, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.browseModdedTexturesFolderButton = new JButton();
        this.browseModdedTexturesFolderButton.setText("...");
        this.mainPanel.add((java.awt.Component)this.browseModdedTexturesFolderButton, new GridConstraints(8, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.originalTexturesPathLabel = new JLabel();
        this.originalTexturesPathLabel.setText("Save original textures to:");
        this.mainPanel.add((java.awt.Component)this.originalTexturesPathLabel, new GridConstraints(9, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.saveTexturesCheckBox = new JCheckBox();
        this.saveTexturesCheckBox.setText("");
        this.mainPanel.add((java.awt.Component)this.saveTexturesCheckBox, new GridConstraints(9, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.originalTexturesFolderTextField = new JTextField();
        this.originalTexturesFolderTextField.setEditable(false);
        this.mainPanel.add((java.awt.Component)this.originalTexturesFolderTextField, new GridConstraints(10, 1, 1, 4, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.browseOriginalTexturesFolderButton = new JButton();
        this.browseOriginalTexturesFolderButton.setText("...");
        this.mainPanel.add((java.awt.Component)this.browseOriginalTexturesFolderButton, new GridConstraints(10, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.globalHookCheckBox = new JCheckBox();
        this.globalHookCheckBox.setEnabled(false);
        this.globalHookCheckBox.setText("");
        this.mainPanel.add((java.awt.Component)this.globalHookCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.enableGlobalHookLabel = new JLabel();
        this.enableGlobalHookLabel.setEnabled(false);
        this.enableGlobalHookLabel.setText("Enable global hook");
        this.mainPanel.add((java.awt.Component)this.enableGlobalHookLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.helpButton = new JButton();
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/question20.png")));
        this.helpButton.setIconTextGap(4);
        this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        this.helpButton.setText("");
        this.helpButton.setToolTipText("Help");
        this.mainPanel.add((java.awt.Component)this.helpButton, new GridConstraints(1, 5, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class OriginalTexturesFolderButtonListener
    implements ActionListener {
        private OriginalTexturesFolderButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int returnVal = MainWindow.this.originalTexturesFolderFileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                File originalTexturesFolder = MainWindow.this.originalTexturesFolderFileChooser.getSelectedFile();
                try {
                    String path = originalTexturesFolder.getCanonicalPath();
                    MainWindow.this.textureFoldersService.setOriginalTexturesFolderPath(path);
                    MainWindow.this.originalTexturesFolderTextField.setText(path);
                }
                catch (IOException e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
        }
    }

    private class ModdedTexturesFolderButtonListener
    implements ActionListener {
        private ModdedTexturesFolderButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int returnVal = MainWindow.this.moddedTexturesFolderFileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                File moddedTexturesFolder = MainWindow.this.moddedTexturesFolderFileChooser.getSelectedFile();
                try {
                    String path = moddedTexturesFolder.getCanonicalPath();
                    MainWindow.this.textureFoldersService.setModdedTexturesFolderPath(path);
                    MainWindow.this.moddedTexturesFolderTextField.setText(path);
                }
                catch (IOException e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
        }
    }

    private class DllLogFileButtonListener
    implements ActionListener {
        private DllLogFileButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int returnVal = MainWindow.this.dllLogFileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                File dllLogFile = MainWindow.this.dllLogFileChooser.getSelectedFile();
                try {
                    String path = dllLogFile.getCanonicalPath();
                    MainWindow.this.dllLogFileService.setDllLogFilePath(path);
                    MainWindow.this.dllLogFileTextField.setText(path);
                }
                catch (IOException e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
        }
    }

    private class ApplicationsToHookTableSelectionListener
    implements ListSelectionListener {
        private ApplicationsToHookTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MainWindow.this.selectedApplications.clear();
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                MainWindow.this.removeHookedApplicationButton.setEnabled(true);
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!lsm.isSelectedIndex(i)) continue;
                    MainWindow.this.selectedApplications.add(MainWindow.this.hookedApplicationsService.getHookedApplications().get(i).getExecutablePath());
                }
            } else {
                MainWindow.this.removeHookedApplicationButton.setEnabled(false);
            }
        }
    }

    private class ApplicationsToHookTableModel
    extends AbstractTableModel {
        private ApplicationsToHookTableModel() {
        }

        @Override
        public int getRowCount() {
            return MainWindow.this.hookedApplicationsService.getHookedApplications().size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return MainWindow.this.hookedApplicationsService.getHookedApplications().get(rowIndex).getExecutablePath();
                }
                case 1: {
                    return MainWindow.this.hookedApplicationsService.getHookedApplications().get(rowIndex).getBitness().getValue();
                }
            }
            return "error";
        }

        @Override
        public String getColumnName(int column) {
            return (new String[]{"Path", "Type"})[column];
        }
    }

    private class RemoveHookedApplicationsButtonListener
    implements ActionListener {
        private RemoveHookedApplicationsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (String application : MainWindow.this.selectedApplications) {
                try {
                    MainWindow.this.hookedApplicationsService.removeHookedApplication(application);
                }
                catch (IOException e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
            if (MainWindow.this.hookedApplicationsService.getHookedApplications().isEmpty()) {
                MainWindow.this.removeHookedApplicationButton.setEnabled(false);
            }
            MainWindow.this.applicationsToHookTableModel.fireTableDataChanged();
        }
    }

    private class AddHookedApplicationsButtonListener
    implements ActionListener {
        private AddHookedApplicationsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int returnVal = MainWindow.this.applicationFileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                File file = MainWindow.this.applicationFileChooser.getSelectedFile();
                BitnessDialog bitnessDialog = new BitnessDialog();
                bitnessDialog.setLocationRelativeTo(null);
                bitnessDialog.setVisible(true);
                Optional<Bitness> bitness = bitnessDialog.getChoosenBitness();
                if (bitness.isPresent()) {
                    try {
                        MainWindow.this.hookedApplicationsService.addHookedApplication(file, bitness.get());
                        MainWindow.this.applicationsToHookTableModel.fireTableDataChanged();
                    }
                    catch (IOException | IllegalArgumentException e) {
                        MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                    }
                }
            }
        }
    }

    private class SaveTexturesCheckboxListener
    implements ActionListener {
        private SaveTexturesCheckboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (MainWindow.this.saveTexturesCheckBox.isSelected()) {
                try {
                    MainWindow.this.textureSavingService.enableSaving();
                }
                catch (Exception e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            } else {
                try {
                    MainWindow.this.textureSavingService.disableSaving();
                }
                catch (Exception e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
        }
    }

    private class HelpButtonActionListener
    implements ActionListener {
        private HelpButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (!Desktop.isDesktopSupported()) {
                    String message = MainWindow.this.messageSource.getMessage("error.url.unable_to_open", null, LocaleContextHolder.getLocale());
                    throw new UnsupportedOperationException(message);
                }
                String helpUrl = MainWindow.this.messageSource.getMessage("main_window.help.url", null, LocaleContextHolder.getLocale());
                Desktop.getDesktop().browse(new URI(helpUrl));
            }
            catch (Exception e) {
                MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
            }
        }
    }

    private class GlobalHookCheckboxListener
    implements ActionListener {
        private GlobalHookCheckboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainWindow.this.globalHookCheckBox.isSelected()) {
                try {
                    MainWindow.this.globalHookService.enableHook();
                }
                catch (Exception e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            } else {
                try {
                    MainWindow.this.globalHookService.disableHook();
                }
                catch (Exception e) {
                    MainWindow.this.uiUtils.processExceptionAndContinue(e, log);
                }
            }
        }
    }
}

