/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.util;

import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class UiUtils {
    @Autowired
    private MessageSource messageSource;

    public void processExceptionAndExit(Exception e, Logger logger) {
        this.processException(e, logger, true);
    }

    public void processExceptionAndContinue(Exception e, Logger logger) {
        this.processException(e, logger, false);
    }

    private void processException(Exception e, Logger logger, boolean shouldExit) {
        String message = e.getClass().getSimpleName() + ": " + e.getMessage();
        logger.error(message, e);
        JOptionPane.showMessageDialog(null, message, this.messageSource.getMessage("error.window.title", null, LocaleContextHolder.getLocale()), 0);
        if (shouldExit) {
            System.exit(-1);
        }
    }
}

