/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.service.DllSettingsService;
import com.ray.wing.resorep.service.TextureFoldersService;
import com.ray.wing.resorep.util.FileUtils;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TextureFoldersServiceImpl
implements TextureFoldersService {
    private static final String MODDED_TEXTURES_FOLDER_PROPERTY_NAME = "modded_textures_folder";
    private static final String ORIGINAL_TEXTURES_FOLDER_PROPERTY_NAME = "original_textures_folder";
    @Value(value="${default.modded.textures.folder}")
    private String defaultModdedTexturesFolder;
    @Value(value="${default.original.textures.folder}")
    private String defaultOriginalTexturesFolder;
    @Autowired
    private DllSettingsService dllSettingsService;

    @Override
    public String getModdedTexturesFolderPath() throws IOException {
        String path = this.dllSettingsService.getPropertyString(MODDED_TEXTURES_FOLDER_PROPERTY_NAME);
        if (path == null || path.isEmpty()) {
            String folderPath = FileUtils.createFolderInJarDir(this.defaultModdedTexturesFolder).getCanonicalPath();
            this.setModdedTexturesFolderPath(folderPath);
            return folderPath;
        }
        return path;
    }

    @Override
    public void setModdedTexturesFolderPath(String path) throws IOException {
        this.dllSettingsService.setPropertyString(MODDED_TEXTURES_FOLDER_PROPERTY_NAME, path);
        FileUtils.createFolderInJarDir(path);
    }

    @Override
    public String getOriginalTexturesFolderPath() throws IOException {
        String path = this.dllSettingsService.getPropertyString(ORIGINAL_TEXTURES_FOLDER_PROPERTY_NAME);
        if (path == null || path.isEmpty()) {
            String folderPath = FileUtils.createFolderInJarDir(this.defaultOriginalTexturesFolder).getCanonicalPath();
            this.setOriginalTexturesFolderPath(folderPath);
            return folderPath;
        }
        return path;
    }

    @Override
    public void setOriginalTexturesFolderPath(String path) throws IOException {
        this.dllSettingsService.setPropertyString(ORIGINAL_TEXTURES_FOLDER_PROPERTY_NAME, path);
    }
}

