/*
 * Decompiled with CFR 0.152.
 */
package com.ray.wing.resorep.service.impl;

import com.ray.wing.resorep.model.Bitness;
import com.ray.wing.resorep.model.HookedApplication;
import com.ray.wing.resorep.service.DllSettingsService;
import com.ray.wing.resorep.service.HookedApplicationsService;
import com.ray.wing.resorep.service.ProxyDllService;
import com.ray.wing.resorep.util.UiUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class HookedApplicationsServiceImpl
implements HookedApplicationsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HookedApplicationsService.class);
    private static final String HOOKED_APPLICATION_PROPERTY = "application_to_hook";
    private static final char PROPERTY_DELIMITER_CHAR = '|';
    private static final String PROPERTY_DELIMITER_REGEX = "\\|";
    @Autowired
    private DllSettingsService dllSettingsService;
    @Autowired
    private ProxyDllService proxyDllService;
    @Autowired
    private UiUtils uiUtils;
    @Autowired
    private MessageSource messageSource;

    @Override
    public List<HookedApplication> getHookedApplications() {
        try {
            List<String> hookedAppsProperties = this.dllSettingsService.getPropertyValues(HOOKED_APPLICATION_PROPERTY);
            return hookedAppsProperties.stream().map(HookedApplicationsServiceImpl::toHookedApplication).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.uiUtils.processExceptionAndExit(e, LOGGER);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addHookedApplication(File executableFile, Bitness bitness) throws IOException {
        String executableFilePath = executableFile.getCanonicalPath();
        HookedApplication hookedApplication = new HookedApplication(executableFilePath, bitness);
        if (this.getHookedApplications().contains(hookedApplication)) {
            String message = this.messageSource.getMessage("error.application.already_added", null, LocaleContextHolder.getLocale());
            throw new IllegalArgumentException(message);
        }
        this.proxyDllService.installProxy(executableFilePath, bitness);
        this.dllSettingsService.addNonUniqueProperty(HOOKED_APPLICATION_PROPERTY, HookedApplicationsServiceImpl.toPropertyValue(hookedApplication));
    }

    @Override
    public void removeHookedApplication(String executableFilePath) throws IOException {
        this.proxyDllService.removeProxy(executableFilePath);
        this.dllSettingsService.removeNonUniqueProperty(HOOKED_APPLICATION_PROPERTY, executableFilePath + '|' + Bitness.BIT32.name());
        this.dllSettingsService.removeNonUniqueProperty(HOOKED_APPLICATION_PROPERTY, executableFilePath + '|' + Bitness.BIT64.name());
    }

    private static HookedApplication toHookedApplication(String propertyValue) {
        String[] valueParts = propertyValue.split(PROPERTY_DELIMITER_REGEX);
        assert (valueParts.length == 2);
        return new HookedApplication(valueParts[0], Bitness.valueOf(valueParts[1]));
    }

    private static String toPropertyValue(HookedApplication hookedApplication) {
        return hookedApplication.getExecutablePath() + '|' + hookedApplication.getBitness().name();
    }
}

