light = LibStub("AceAddon-3.0"):NewAddon("PVPReporter", "AceConsole-3.0")

local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

local options = {
	name = "PVPReporter",
	handler = lightOptions,
	type = 'group',
	args = {
		general = {
			type = 'group',
			name = "PVPReporter",
			args = {
				Reset	=	{
							name		=	L["Reset"],
							desc		=	L["Resets the sounds values back to zero"],
							type		=	"execute",
							func		=	function() reset() end,							
								},
				enable			=	{
							name		=	L["Enable Sounds(TESTING)"],
							desc		=	L["Enables the soundFiles"],
							type		=	"toggle",
							width		=	"full",
							order		=	1,
							set			=	function(info,val) light.db.profile.enable = val end,
							get			=	function(info) return light.db.profile.enable end,						
							},
				SoundTab= {
					name		=	L["SoundTab"],
					type		=	"group",
					guiInline	=	true,
					order		=	7,
					args		=	{
								Enable		=	{
									name		=	L["Enable"],
									desc		=	L["This button wil enable the sounds files for killing blows and deaths"],
									type		=	"execute",
									func		=	function() enable()  end,							
								},
								Disable		=	{
									name		=	L["Disable"],
									desc		=	L["This button wil disable the sounds files for killing blows and deaths"],
									type		=	"execute",									
									func		=	function() disable()  end,				
								},
					},
				},
			
				InfoTab= {
					name		=	L["InfoTab"],
					type		=	"group",
					guiInline	=	true,
					order		=	7,
					args		=	{
								loglevel1		=	{
									name		=	L["Print Info"],
									desc		=	L["This button wil print basic information about the addon"],
									type		=	"execute",
									func		=	function()print("|cffFE2E2ECurrent version of addon: 1.14"); print("|cffFE2E2EThis addon was made by: Eucalyptisch from Outland EU"); end,									
								},
								loglevel2		=	{
									name		=	L["Print HKInfo"],
									desc		=	L["This button wil print basic information about your current hk levels etc"],
									type		=	"execute",									
									func		=	function() local name1, currentAmount1, texture1, earnedThisWeek1, weeklyMax1, totalMax1, isDiscovered1 = GetCurrencyInfo(392) local name, currentAmount, texture, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(390)print("Total amount of lifetime hks:"..GetPVPLifetimeStats(hk)..""); print("Current amount of honor:"..currentAmount1..""); print("Amount earned this week:"..earnedThisWeek1.."");print("Current amount of conquest:"..currentAmount.."");print("Amount earned this week:"..earnedThisWeek.."");	print("Max amount of conquest earnable:"..weeklyMax.."");  end,					
								},
					},
				},
				killingblowTab= {
					name		=	L["killingblowTab"],
					type		=	"group",
					guiInline	=	true,
					order		=	7,
					args		=	{
								KBenable		=	{
									name		=	L["Enable"],
									desc		=	L["This button wil enable the sound files and message printed when getting killing blows"],
									type		=	"execute",
									func		=	function() KBenable()  end,									
								},
								KBdisable		=	{
									name		=	L["Disable"],
									desc		=	L["This button wil disable the sound files and message printed when getting killing blows"],
									type		=	"execute",									
									func		=	function() KBdisable() end,					
								},
					},
				},
			},			
		},
	},
}

local lightProfile = {
	profile = {
		enable = true,
		
	}
}

local index = 0
enabling = true
KBtrue = true

function KBdisable()
	if(KBtrue == true) then
		KBtrue = false
		print(L["Killing blows and soundfiles are now disabled"])
	end

end

function KBenable()
	if(KBtrue == false) then
		KBtrue = true
		print(L["Killing blows and soundfiles are now enabled"])
	end

end

function disable()
	if(enabling == true) then
		enabling = false
		print(L["Sound effects are now disabled"])
	end
end

function enable()
	if(enabling == false) then
		enabling = true
		print(L["Sound effect are now enabled"])
	end
end

function reset()	
	index = 0
	enabling = true
	KBtrue = true
	print(L["PVPReporter has now been resetted"])
end


local event_frame = CreateFrame("Frame")    
local arenaTrue1 = true
local arenaTrue2 = true 
local arenaTrue3 = true
local arenaTrue4 = true
local arenaTrue5 = true
local BGTrue1 = true
local BGTrue2 = true
event_frame:RegisterEvent("UPDATE_WORLD_STATES") 

local reset_arena = CreateFrame("Frame")   
reset_arena:RegisterEvent("PLAYER_ENTERING_WORLD") 

reset_arena:SetScript("OnEvent",
    function(self, event, addon)
			 arenaTrue1 = true
			 arenaTrue2 = true 
			 arenaTrue3 = true
			 arenaTrue4 = true 
			 arenaTrue5 = true
			 BGTrue1 = true
	         BGTrue2 = true
			 index = 0
end) 

event_frame:SetScript("OnEvent",
    function(self, event, addon)
		local arena1 , arena2 , arena3 , arena4 ,arena5 = unitID
		local aa =format("%.2f",(UnitHealth("player") / UnitHealthMax("player")) * 100)
		local ac =format("%.2f",(UnitHealth("arena2") / UnitHealthMax("arena2")) * 100)
		 --local b = "Arena target 2 health: " .. UnitHealth("arena2") .. " HP"
		local pvpType, isFFA, faction = GetZonePVPInfo();	
		if pvpType == "arena" then
			if(arenaTrue1 == true) and (UnitHealth("arena1") > 0) and (UnitHealth("arena1") ~= nil ) then
				local a = "" ..UnitName("arena1").. "/" ..UnitClass("arena1").. L[" has "].. UnitHealth("arena1") .. " HP"
				local index = GetChannelName("Party")
				SendChatMessage(a, "Party", nil, index); 
				arenaTrue1 = false
			end	
		
		    if(arenaTrue2 == true) and (UnitHealth("arena2") > 0) and (UnitHealth("arena2") ~= nil ) then			
				local b = "" ..UnitName("arena2").. "/" ..UnitClass("arena2").. L[" has "].. UnitHealth("arena2") .. " HP"
				local index = GetChannelName("Party")
				SendChatMessage(b, "Party", nil, index); 	
				arenaTrue2 = false
			end		
			
			if(arenaTrue3 == true) and (UnitHealth("arena3") > 0) and (UnitHealth("arena3") ~= nil ) then			
				local c = "" ..UnitName("arena3").. "/" ..UnitClass("arena3").. L[" has "].. UnitHealth("arena3") .. " HP"
				local index = GetChannelName("Party")
				SendChatMessage(c, "Party", nil, index); 	
				arenaTrue3 = false
			end	
			
		    if(arenaTrue4 == true) and (UnitHealth("arena4") > 0) and (UnitHealth("arena4") ~= nil ) then			
				local d = "" ..UnitName("arena4").. "/" ..UnitClass("arena4").. L[" has "].. UnitHealth("arena4") .. " HP"
				local index = GetChannelName("Party")
				SendChatMessage(d, "Party", nil, index); 	
				arenaTrue4 = false
			end	
				
			 if(arenaTrue5 == true) and (UnitHealth("arena5") > 0) and (UnitHealth("arena5") ~= nil ) then			
				local e = "" ..UnitName("arena5").. "/" ..UnitClass("arena5").. L[" has "].. UnitHealth("arena5") .. " HP"
				local index = GetChannelName("Party")
				SendChatMessage(e, "Party", nil, index); 	
				arenaTrue5 = false
			end		
		end			
			
		if pvpType == nil then
			if(BGTrue1 == true) and (UnitHealth("arena1") > 0) and (UnitHealth("arena1") ~= nil ) then
				local a = "" ..UnitName("arena1").. "/" ..UnitClass("arena1").. L[" has "].. UnitHealth("arena1") .. " HP"
				local index = GetChannelName("Raid")
				SendChatMessage(a, "Raid", nil, index); 
				BGTrue1 = false
			end	
		
		    if(BGTrue2 == true) and (UnitHealth("arena2") > 0) and (UnitHealth("arena2") ~= nil ) then			
				local b = "" ..UnitName("arena2").. "/" ..UnitClass("arena2").. L[" has "].. UnitHealth("arena2") .. " HP"
				local index = GetChannelName("Raid")
				SendChatMessage(b, "Raid", nil, index); 	
				BGTrue2 = false
			end		
		end
end)


local event_trinket = CreateFrame("Frame")
event_trinket:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")

event_trinket:SetScript("OnEvent",
    function(arg1,arg2, arg3,arg4,arg5,arg6,arg7)
	local pvpType, isFFA, faction = GetZonePVPInfo();	
	if pvpType == "arena" then
	if  arg7 == 42292 and arg3 == "arena1"   then
			SendChatMessage(L["Trinket used by "] ..UnitName("arena1").. "/" ..UnitClass("arena1").."", "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Trinket.ogg", "Master");
	end	
	
	if  arg7 == 42292 and arg3 == "arena2" then
			SendChatMessage(L["Trinket used by "] ..UnitName("arena2").. "/" ..UnitClass("arena2").."", "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Trinket.ogg", "Master");
	end	
	
	if  arg7 == 42292 and arg3 == "arena3" then
			SendChatMessage(L["Trinket used by "] ..UnitName("arena3").. "/" ..UnitClass("arena3").."", "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Trinket.ogg", "Master");
		end
	end
	
	if pvpType == nil then
	if  arg7 == 42292 and arg3 == "arena1"   then
			SendChatMessage(L["Trinket used by "] ..UnitName("arena1").. "/" ..UnitClass("arena1").."", "Raid")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Trinket.ogg", "Master");
	end	
	
	if  arg7 == 42292 and arg3 == "arena2" then
			SendChatMessage(L["Trinket used by "] ..UnitName("arena2").. "/" ..UnitClass("arena2").."", "Raid")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Trinket.ogg", "Master");
	end	
	
	end

end)

local event_drinking = CreateFrame("Frame")
event_drinking:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")

event_drinking:SetScript("OnEvent",
    function(arg1,arg2, arg3,arg4,arg5,arg6,arg7)
	local pvpType, isFFA, faction = GetZonePVPInfo();	
	if pvpType == "arena" then
	if  arg7 == 105232 or arg7 == 118358 or arg7 == 65499 or arg7 == 80610 or arg7 == 80618 or arg7 == 74636 and arg3 == "arena1"  then
			SendChatMessage(""..UnitName("arena1").. "/" ..UnitClass("arena1")..L[" is drinking"], "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\drinking.ogg", "Master");
	end	
	
	if  arg7 == 105232 or arg7 == 118358 or arg7 == 65499 or arg7 == 80610 or arg7 == 80618 or arg7 == 74636 and arg3 == "arena2"  then
			SendChatMessage(""..UnitName("arena2").. "/" ..UnitClass("arena2")..L[" is drinking"], "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\drinking.ogg", "Master");
	end	
	
	if  arg7 == 105232 or arg7 == 118358 or arg7 == 65499 or arg7 == 80610 or arg7 == 80618 or arg7 == 74636 and arg3 == "arena3"  then
			SendChatMessage(""..UnitName("arena3").. "/" ..UnitClass("arena3")..L[" is drinking"], "Party")
			--Soundfile is from the addon called GladiatorlosSA.
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\drinking.ogg", "Master");
		end
	end
end)

local EventFrame = CreateFrame("Frame")
EventFrame:RegisterEvent("PLAYER_PVP_KILLS_CHANGED")
EventFrame:RegisterEvent("PLAYER_DEAD")

EventFrame:SetScript("OnEvent", function(self, event, ...)
		if event == "PLAYER_DEAD" and (enabling == true) then
			PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\You_Slain_1.mp3", "Master");
			index = 0
		
	end
end)

local event_lowhealth = CreateFrame("Frame")
event_lowhealth:RegisterEvent("UPDATE_WORLD_STATES")

event_lowhealth:SetScript("OnEvent",
    function(self, event, addon)
		local pvpType, isFFA, faction = GetZonePVPInfo();
		if pvpType == "arena" then
			if(UnitHealth("arena1") < 100000) and (UnitHealth("arena1") > 000000) then
				local ab = "" ..UnitName("arena1").. "/" ..UnitClass("arena1").. " has ".. UnitHealth("arena1") .. " health"
				local index = GetChannelName("Party")
				SendChatMessage(ab, "Party", nil, index); 				
				end
			
				
			if(UnitHealth("arena2") < 100000) and (UnitHealth("arena2") > 000000) then				
				local ad = "" ..UnitName("arena2").. "/" ..UnitClass("arena2").. " has ".. UnitHealth("arena2") .. " health"
				local index = GetChannelName("Party")
				SendChatMessage(ad, "Party", nil, index); 				
				end
			
				
			if(UnitHealth("arena3") < 100000) and (UnitHealth("arena3") > 000000) then				
				local af = "" ..UnitName("arena3").. "/" ..UnitClass("arena3").. " has ".. UnitHealth("arena3") .. " health"
				local index = GetChannelName("Party")
				SendChatMessage(af, "Party", nil, index); 			
				end
		end			
end)


function light:OnInitialize()
	light:RegisterChatCommand("lightconfig", "lightSlash1")
	light:RegisterChatCommand("lightstats", "lightSlash2")
	light:RegisterChatCommand("lightdaily", "lightSlash3")
	light:RegisterChatCommand("lighthelp", "lightSlash4")
	printStartMessage(self)
	
	self.db = LibStub("AceDB-3.0"):New("lightDB", lightProfile, "Default")
	options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("lightOptions", options.args.general)
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("lightProfiles", options.args.profile)
	
	self.lightOptions = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("lightOptions", "PVPReporter")
	self.lightProfiles = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("lightProfiles", "Profiles", "PVPReporter")
end

-- Add a function to the /light slash command.
function light:lightSlash1(input)
	InterfaceOptionsFrame_OpenToCategory("PVPReporter")
end

function light:lightSlash2(input)
	local name1, currentAmount1, texture1, earnedThisWeek1, weeklyMax1, totalMax1, isDiscovered1 = GetCurrencyInfo(392)
	local name, currentAmount, texture, earnedThisWeek, weeklyMax, totalMax, isDiscovered = GetCurrencyInfo(390)
	 -- print(L["Total amount of lifetime hks:"]..GetPVPLifetimeStats(hk)..""); 
	 -- print(L["Current amount of honor:"]..currentAmount1..""); 
	 -- print(L["Amount earned this week:(CURRENTLY BROKEN)"]..earnedThisWeek1.."");
	 -- print(L["Current amount of conquest:"]..currentAmount.."");
	 -- print(L["Amount earned this week:"]..earnedThisWeek.."");	
	 -- print(L["Max amount of conquest earnable:"]..weeklyMax.."");
	 print("总荣誉击杀数："..GetPVPLifetimeStats(hk)..""); 
	 print("当前荣誉："..currentAmount1..""); 
	 print("本周获得：（暂时失效）"..earnedThisWeek1.."");
	 print("当前征服点数："..currentAmount.."");
	 print("本周征服点数："..earnedThisWeek.."");	
	 print("总获得征服点数："..weeklyMax.."");
end

function light:lightSlash3(input)
	local hk, hp = GetPVPSessionStats();
	DEFAULT_CHAT_FRAME:AddMessage( "你现在拥有" .. hk .. " 次荣誉击杀（本日），预估 " .. hp .. " 点荣誉点数 " );
end

function light:lightSlash4(input)
	print("/lightconfig");
	print("/lightstats");
	print("/lightdaily");
end

--Openings Message.
function printStartMessage(self)
	local timeleft = 5 --set the countdown to w/e you want
	local f = CreateFrame("Frame", nil, UIParent)
	f:SetScript("OnUpdate", function(_,arg)
	timeleft = timeleft - arg
	if timeleft >= 0 then
		timeleft = nil
		f:SetScript("OnUpdate", nil)
		print(L["|cffFE2E2ECurrent version of PVPReporter: 1.14"]);
		print(L["|cffFE2E2EType /lighthelp to get a list of commands"]);
	end
	end)
end

--The following code has been retrieved from http://forums.wowace.com/showthread.php?t=19784 with some minor changes.
local playerName, petName = UnitName("player")
local damageEvent = {
	["SWING_DAMAGE"] = true,
	["RANGE_DAMAGE"] = true,
	["SPELL_DAMAGE"] = true,
	["SPELL_PERIODIC_DAMAGE"] = true,
}
local function OnEvent(self, event, timestamp, subevent, hideCaster, sourceGUID, sourceName, sourceFlags, sourceRaidFlags, destGUID, destName, destFlags, destRaidFlags, ...)
	local spellID, spellName, spellSchool, amount, overkill
	if (KBtrue == true) then
		if damageEvent[subevent] then
			if subevent == "SWING_DAMAGE" then
				amount, overkill = ...
			else
				spellID, spellName, spellSchool, amount, overkill = ...
			end
			if overkill > 1 and (sourceName == playerName) then		
				print(format("%s 被击杀 %s 技能 %s %s 点伤害!", sourceName, destName, amount, subevent == "SWING_DAMAGE" and "Melee" or GetSpellLink(spellID)))
				index = index + 1			
				killMSG()
			
			end
		end
	end
end

function killMSG()
		if(enabling == true) then
			if(index == 1) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\First_Blood.mp3", "Master");
				index = index + 1;
			end
			if(index == 3) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Doublekill1.mp3", "Master");
				index = index + 1;
			end
			if(index == 5) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Triplekill.mp3", "Master");
				index = index + 1;
			end
			if(index == 7) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Quadrakill.mp3", "Master");
				index = index + 1;
			end
			if(index == 9) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Pentakill1.mp3", "Master");
				index = index + 1;
			end
			if(index == 11) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Dominating.mp3", "Master");
				index = index + 1;
			end
			if(index == 13) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Rampage.mp3", "Master");
				index = index + 1;
			end
			if(index >= 15) then
				PlaySoundFile("Interface\\AddOns\\PVPReporter\\Sounds\\Legendary2_1.mp3", "Master");
				index = index + 1;
			end
		end	
end

local f = CreateFrame("Frame")
f:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
f:SetScript("onEvent", OnEvent)




