-- holder for some lib functions
if hedlib then return end

hedlib = CreateFrame("Frame")

hedlib.dummy = function() end

hedlib.round = function (n)
	return floor(n+0.5)
end

hedlib.round = function(num, idp)
	local mult = 10^(idp or 0)
	return math.floor(num * mult + 0.5) / mult
end

hedlib.isPlayer = function(unit)
	if(unit == 'player' or unit == 'vehicle' or unit == 'pet') then
		return true
	else
		return nil
	end
end

hedlib.isEnemy = function(unit)
	if (UnitIsEnemy("player", unit) or UnitCanAttack("player", unit)) then
		return true
	else
		return nil
	end
end

hedlib.siValue = function(val)
	if val==0 then
		return
	elseif val >= 10000000 or val <= -10000000 then 
        return string.format("%.1fm", val / 1000000) 
    elseif val >= 1000000 or val <= -1000000 then
        return string.format("%.2fm", val / 1000000) 
    elseif val >= 100000 or val <= -100000 then
        return string.format("%.0fk", val / 1000) 
    elseif val >= 1000 or val <= -1000 then
        return string.format("%.1fk", val / 1000) 
    else
        return ceil(val)
    end
end

hedlib.hex = function(r, g, b)
	if(type(r) == 'table') then
		if(r.r) then r, g, b = r.r, r.g, r.b else r, g, b = unpack(r) end
	end
	return ('|cff%02x%02x%02x'):format(r * 255, g * 255, b * 255)
end

hedlib.fontsize = function(height)
	local FRAME_SIZE,FONT_SIZE = 1,0.9
	local size = FONT_SIZE * (height / FRAME_SIZE)
	size = (size>9) and size or 9
	return(hedlib.round(size))
end

hedlib.CreateBD = function(f,border,color, bgcolor)
	color = color or {1,0,0,1}
	border = border or 5
	local backdrop_tab = { 
    bgFile = hedlib.backdrop_texture, 
    edgeFile = hedlib.backdrop_edge_texture,
    tile = false,
    tileSize = 0, 
    edgeSize = border, 
    insets = { 
      left = border, 
      right = border, 
      top = border, 
      bottom = border,
    },
  	}
	f.bd = f.bd or CreateFrame("Frame", nil, f)
    f.bd:SetFrameLevel(0)
    f.bd:SetPoint("TOPLEFT",-border,border)
    f.bd:SetPoint("BOTTOMRIGHT",border,-border)
    f.bd:SetBackdrop(backdrop_tab)
	bgcolor = bgcolor or {0,0,0,0}
    f.bd:SetBackdropColor(unpack(bgcolor))
   	f.bd:SetBackdropBorderColor(unpack(color))
	return f.bd
end

hedlib.CreateBG=function(f,border,coltex,color)
	f.bg = f.bg or f:CreateTexture(nil, "BACKGROUND")
	border=border or 0
	if (border==0) then
		f.bg:SetAllPoints(f)
	else
		f.bg:SetPoint("TOPLEFT", -border, border)
		f.bg:SetPoint("BOTTOMRIGHT", border, -border)
	end
	coltex = coltex or {0,0,0}
	if type(coltex) == "string" then
		f.bg:SetTexture(coltex)
		if color then
			f.bg:SetVertexColor(unpack(color))
		end
	else	
		f.bg:SetTexture(unpack(coltex))
	end
	return f.bg
end

hedlib.CreateOverlay=function(f,border,coltex,color)
	f.overlay = f.overlay or f:CreateTexture(nil, "BACKGROUND")
	border=border or 0
	if (border==0) then
		f.overlay:SetAllPoints(f)
	else
		f.overlay:SetPoint("TOPLEFT", -border, border)
		f.overlay:SetPoint("BOTTOMRIGHT", border, -border)
	end
	coltex = coltex or {0,0,0}
	if type(coltex) == "string" then
		f.overlay:SetTexture(coltex)
		if color then
			f.overlay:SetVertexColor(unpack(color))
		end
	else	
		f.overlay:SetTexture(unpack(coltex))
	end
	return f.overlay
end

hedlib.CreateFont = function(f, font, size, outline)
	if size then 
		if size<1 then 
			size = hedlib.fontsize(f:GetHeight())+size
		end
	else
		size = hedlib.fontsize(f:GetHeight())
	end
	
	local fs = f:CreateFontString(nil, "OVERLAY")
	fs:SetFont(font, size, outline)
	fs:SetShadowColor(0,0,0,1)
	return fs
end  

hedlib.UpdateFS=function(f, size, justify)
    f:SetFont(hedlib.font, size, "OUTLINE")
    f:SetShadowColor(0, 0, 0, 0)
    if(justify) then f:SetJustifyH(justify) end
    return f
end

hedlib.ColorGradient = function(perc, ...)
	if perc >= 1 then
		local r, g, b = select(select('#', ...) - 2, ...)
		return r, g, b
	elseif perc <= 0 then
		local r, g, b = ...
		return r, g, b
	end
	
	local num = select('#', ...) / 3

	local segment, relperc = math.modf(perc*(num-1))
	local r1, g1, b1, r2, g2, b2 = select((segment*3)+1, ...)

	return r1 + (r2-r1)*relperc, g1 + (g2-g1)*relperc, b1 + (b2-b1)*relperc
end

hedlib.executes = function()
	local playerClass, englishClass = UnitClass("player")
	if (englishClass=="DEATHKNIGHT" and cfg.release==3) then
		nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(2,17)
		if (currRank>0) then
			return 35
		end
	elseif (englishClass=="WARRIOR" or englishClass=="HUNTER" or englishClass=="PALADIN") then
		return 20
	end
	return 0
end

local flashframe = nil
local flashsec = 0
hedlib.flash = function(sec,color)
	color = color or {1, 0, 0, 0.55}
	flashsec=sec
	flashframe = _G["HedFlash"] or CreateFrame("Frame", "HedFlash", UIParent)
	flashframe:SetFrameStrata("BACKGROUND")
	flashframe:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",})
	flashframe:SetAllPoints(UIParent)
	flashframe.elapsed = 0
	flashframe:SetScript("OnShow", function(self)
--		self.elapsed = 0
		self:SetAlpha(0)
	end)
	
	flashframe:SetScript("OnUpdate", function(self, elapsed)
		elapsed = self.elapsed + elapsed
		if elapsed >= flashsec then
			self:Hide()
			self:SetAlpha(0)
			return
		end
		local alpha = elapsed % 0.4
		if elapsed > 0.2 then
			alpha = 0.4 - alpha
		end
		self:SetAlpha(alpha * 5)
		self.elapsed = elapsed
	end)
--	flashframe:Hide()

	flashframe:SetBackdropColor(unpack(color))
	flashframe:Show()
end

--[[ Creating info text ]]
local textframe = CreateFrame("Frame", nil, UIParent)
textframe:SetScript("OnUpdate", FadingFrame_OnUpdate)
textframe.fadeInTime = 0 -- 0.5
textframe.fadeOutTime = 0.5 -- 2
textframe.holdTime = 1 -- 3
textframe:Hide()
hedlib.textframe=textframe

local text = textframe:CreateFontString("HInfoText", "OVERLAY")
text:SetFont("Fonts\\FRIZQT__.TTF", 32, "THICKOUTLINE")
text:SetPoint("CENTER", UIParent, "CENTER",0,350)
text:SetTextColor(0.41, 0.8, 0.94)
hedlib.textframe.text=text

local icon=textframe:CreateTexture(nil, 'OVERLAY')
icon:SetHeight(30)
icon:SetWidth(30)
icon:SetPoint("RIGHT",text,"LEFT")
hedlib.textframe.icon=icon

hedlib.Warning = function(t,i,color)
	if i then
		color = color or {1,0,0}
	else
		color = color or {0.41, 0.8, 0.94}
	end
	hedlib.textframe.text:SetTextColor(unpack(color))
    hedlib.textframe.text:SetText(t)

	if (i) then
		hedlib.textframe.icon:SetTexture(i)
		hedlib.textframe.icon:Show()
	else
		hedlib.textframe.icon:Hide()
	end
	if hedlib.textframe:IsShown() then 
		hedlib.textframe.startTime=GetTime()
	else
	    FadingFrame_Show(hedlib.textframe)
	end
end

hedlib.TargetingYou = function(u)
	local uguid=UnitGUID(u.."target")
	local myguid=UnitGUID("vehicle") or UnitGUID("player")
	if (uguid and uguid==myguid) then
		return true
	else
		return nil
	end
end

hedlib.ClearTable = function(table)
	for k in pairs( table ) do
		table[k] = nil
	end
end