-- get the addon namespace
local addon, ns = ...

-- get the config values
local cfg = ns.cfg

-- get the library
local lib = _G["HEDD_lib"] or CreateFrame("Frame","HEDD_lib")
ns.lib = lib

cfg.showchannel = false
cfg.debugspells = nil

cfg.h=cfg.isize -- 10
cfg.l=300
cfg.freq=1/4
cfg.UpdateTime=1/4
cfg.max=1
cfg.react=0.1

cfg.class = select(2,UnitClass("player"))

cfg.backdrop_texture = "Interface\\AddOns\\Hedd\\textures\\backdrop"
cfg.backdrop_edge_texture = "Interface\\AddOns\\Hedd\\textures\\backdrop_edge"
cfg.statusbar_texture = "Interface\\AddOns\\Hedd\\textures\\Minimalist"-- "Interface\\BUTTONS\\UI-Listbox-Highlight2"

cfg.target='o'

-- cfg.unknownclass=true

function lib.defaults()
	cfg.gcd=nil
	cfg.classfound=nil
	cfg.now=GetTime()
	cfg.castEnd=cfg.now
	cfg.mintime=0
	cfg.maxmintime = 21
	cfg.cmintime = cfg.maxmintime

	cfg.power=UnitPower("player")
	cfg.powermax=UnitPowerMax("player")
	_,cfg.pactiveRegen = GetPowerRegen()
	
	cfg.healthmax=UnitHealthMax("target")
	cfg.health=(cfg.healthmax==0) and 100 or hedlib.round(UnitHealth("target")*100/cfg.healthmax,0)

	cfg.onupdate=nil
	cfg.onpower=nil
	cfg.onhealth=nil
--	cfg.overlap=0

	cfg.case = {}
	cfg.spells = {}
	cfg.sp_conv={}
	cfg.auras = {}
	cfg.plist = {}
	cfg.casting=nil
	cfg.spellcast = {}
	cfg.lastspell_time=nil
	cfg.watchunits={}
	Heddevents = {}
	cfg.combo = GetComboPoints('player', 'target')
	cfg.holy = UnitPower("player" , SPELL_POWER_HOLY_POWER)
	cfg.mode=""
	cfg.set={}
	cfg.setitems={}
	cfg.equip={}
	cfg.res_spells ={}
	
	cfg.res_spells ={
		[GetSpellInfo(75)]=true
		}
		
	cfg.Weapons={}
	cfg.Weapons.Main, _, _, cfg.Weapons.Off = GetWeaponEnchantInfo()
	cfg.onGround = true
	cfg.spells_aoe={}
	cfg.spells_single={}
	cfg.spells_range={}
end

cfg.shapes={}
cfg.shapes={
[1]="Cat",
[2]="Tree",
[3]="Travel",
[4]="Aquatic",
[5]="Bear",
[17]="Battle",
[18]="Defensive",
[19]="Berserker",
[22]="Metamorphosis",
[27]="Flight",
[31]="Moonkin"
}

lib.defaults()

Heddframe = _G["HEDD_MAIN"] or CreateFrame("Button","HEDD_MAIN",UIParent)
Heddframe:SetWidth(cfg.isize)
Heddframe:SetHeight(cfg.isize)
Heddframe:SetPoint(unpack(cfg.point))
Heddframe:SetMovable(true)
--[[Heddframe.texture = Heddframe:CreateTexture(nil,"BACKGROUND")
Heddframe.texture:SetAllPoints(Heddframe)
Heddframe.texture:SetTexture(135/255,206/255,235/255,0.5 )]]
hedlib.backdrop_texture=cfg.backdrop_texture
hedlib.backdrop_edge_texture=cfg.backdrop_edge_texture
hedlib.CreateBD(Heddframe,cfg.border,{1,0,0,1})
Heddframe.bd:Hide()
Heddframe:Show()

Heddframe:EnableMouse(true)

Heddframe.bar=_G["HEDD_BAR"] or CreateFrame("StatusBar", "HEDD_BAR", Heddframe)
Heddframe.bar:SetWidth(-1)
Heddframe.bar:SetHeight(cfg.h)
Heddframe.bar:SetStatusBarTexture(cfg.statusbar_texture)
Heddframe.bar:SetStatusBarColor(124/255, 252/255, 0)
Heddframe.bar:Show()
Heddframe.bar.cd = 0
Heddframe.bar.start = cfg.now
Heddframe.bar:SetPoint("RIGHT",Heddframe,"LEFT")
Heddframe.bar.force=nil
Heddframe.bar.lu=cfg.now
Heddframe.text = hedlib.CreateFont(Heddframe, cfg.textfont, 12, "OUTLINE")
Heddframe.text:SetPoint("TOP",Heddframe,"BOTTOM")
Heddframe.text:SetText("")

Heddtalents = _G["HEDD_tal"] or CreateFrame("Frame","HEDD_tal",UIParent)
Heddtalents:Show()

--[[Heddtest = _G["HEDD_TEST"] or CreateFrame("Button","HEDD_TEST",UIParent)
Heddtest:Show()
Heddtest:RegisterEvent("RUNE_POWER_UPDATE")
Heddtest:SetScript("OnEvent", function(...)
print(...)
end)
Heddtest:Hide()]]

local configmode = false

local move = function()
	if ( configmode ) then
		print("Drag HEDD icon!")
--		Heddframe:EnableMouse(true)
		Heddframe:RegisterForDrag("LeftButton")
		Heddframe:SetScript("OnDragStart", function(Heddframe) Heddframe:StartMoving() end)
		Heddframe:SetScript("OnDragStop", function(Heddframe) 
			Heddframe:StopMovingOrSizing()
			Heddframe:SetUserPlaced(true)
			local x, y = Heddframe:GetLeft(), Heddframe:GetBottom()
			end)
	else
		print("HEDD icon is pined!")
--		Heddframe:EnableMouse(false)
		Heddframe:RegisterForDrag(nil)
		Heddframe:SetScript("OnDragStart", nil)
		Heddframe:SetScript("OnDragStop", nil)
	end
end

HEDDTOGGLELOCKED = function()
	configmode = not configmode
	move()
end

SlashCmdList.HEDD = function() HEDDTOGGLELOCKED() end
SLASH_HEDD1 = "/Hedd"
SLASH_HEDD2 = "/hedd"