--[[--------------------------------------------------
--Juked by Robrman, Inspired by Kollektiv's InterruptBar
--Version 1.4.2
CHANGELOG:
--Added Carrion Swarm, corrected CD on Spear Hand Strike (Thanks Shivtey)(v1.4.2)
--Added optical blast, changed ring of frost and intimidating shout for 5.1(v1.4.1)
--Added some/most new spells, may need tweaking - open to suggestions(v1.4)
--Updated for MoP, removed obsolete spells, haven't added the new spells yet
--Cleaned up the code
--Updated for 4.3, added some new spells
--Fixed Hidden off smart on (spell icons were stacking)
--Some of the cooldowns may have changed, if they have and I didnt fix them please let me know.
--Fixed for 4.2, added shadowfury, fixed cloak of shadows and combat readiness CD
--Cleaned up some of the code
--Fixed moving the frames
--Fixed spell reflect cd
--Updated for 4.1
--Fixed some issues with profiles, still could be more
--Added profiles, i've tested it works perfectly fine from what i've tried - 
--FINALLY added a GUI for the options.  Use "/juked gui" or "/juked opts" or "/juked config" 
--Added Silencing shot to be reset with Readiness
--Added Readiness resetting Scatter Shot and Deterrence, I probably missed some..its 5 am nobody on to help me test fully, sorry if its incomplete post and i'll fix it
--Cleaned up some of the code, fixed some errors with repositioning
--Added individual locking, hiding and smart modes, still possibly buggy
--Fixed moving, probably still some work to be done there
--Cleaned up the help menu a bit, feedback is appreciated
--Added scaling for main bar and prio bar individually
--Fixed possible problem with Gnaw if used by a transformed ghoul (Thanks Damnationx)
--Fixed Death Coil cooldown to account for Warlock 4 piece bonus -30 seconds (Thanks Damnationx)
--Fixed cooldown timer restarting (if same CD is popped, restart timer. Thanks Damnationx)
--Added Inner Focus   {spellID=89485, time=45, prio=false},--Inner Focus     (Thanks Sazalolz, cant believe i missed it)
--Added /juked prioonly   this will ONLY display cooldowns for spells marked with prio=true
--Added noCD option to disable the numeric cooldown from Juked 
--Fixed some cooldown durations(Thanks Sazalolz for pointing it out)
--Externalized the spell table(Thanks Sazalolz for the suggestion)
--Added test for all modes
--Added a fix for some versions of omniCC
--Fixed Rebuke spellID
--Addon can now be accessed from /juked   /jd   and   /ib(kept this cause i kept typing it by accident)
--Added the option to grow the bars upward from the anchor /juked
----------------------------------------------------]]
JukedRealm = GetCVar("realmName");
JukedChar = UnitName("player");
CharIndex=JukedChar.." - "..JukedRealm
JukedDB=JukedDB or {}
JukedDB["CharsUse"]=JukedDB["CharsUse"] or {}
JukedDB["Default"]= JukedDB["Default"] or { scale = 1,scale2=1 , hidden = false,hidden2=false, smart=false, smartPrio=false,prio = false, cols=6, colsPrio=6, arenaOnly=false, bgOnly=false, lock = false,growUp=1,growLeft=1, noCD=false,prioOnly=false,}
JukedDB[CharIndex] = JukedDB[CharIndex] or JukedDB["Default"]--{ scale = 1,scale2=1 , hidden = false,hidden2=false, smart=false, smartPrio=false,prio = false, cols=6, colsPrio=6, arenaOnly=false, bgOnly=false, lock = false,growUp=1,growLeft=1, noCD=false,prioOnly=false,}
for k,v in pairs(JukedDB) do
	if not (type(JukedDB[k]) == "table" ) then 
		JukedDB[k]=nil
	elseif (k=="Position" and (JukedDB["Position"]["scale2"]==nil)) then 
		JukedDB[k]=nil
	end
end
if (JukedDB["CharsUse"][CharIndex]) then
	CharIndex=JukedDB["CharsUse"][CharIndex]
else
	JukedDB["CharsUse"][CharIndex]=CharIndex
end

local abilities = {}
local order
local arena=false
local bg=false
local band = bit.band
local spell_table=spell_table

if spell_table==nil then ChatFrame1:AddMessage("NOT LOADED",0,1,0) end
for k,spell in ipairs(spell_table) do
	local name,_,spellicon = GetSpellInfo(spell.spellID)	
	abilities[spell.spellID] = { icon = spellicon, duration = spell.time }
end

local frame
local bar
local bar2
local x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
local x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
local y2 = 0
local count2 = 0
local count=0
local y=0
local totalIcons=0
local GetTime = GetTime
local ipairs = ipairs
local pairs = pairs
local select = select
local floor = floor
local band = bit.band
local GetSpellInfo = GetSpellInfo
local GROUP_UNITS = bit.bor(0x00000010, 0x00000400)
local activetimers = {}
local size = 0

local function getsize()
	size = 0
	for k in pairs(activetimers) do
		size = size + 1
	end
end

local function isInBG()
	local a,type = IsInInstance()
	if (type == "pvp") then
		return true
	end
	return false
end

local function isInArena()
	local _,type = IsInInstance()
	if (type == "arena") then
		return true
	end
	return false
	
end
local function isPrio(ability)
	for _,v in ipairs(spell_table) do
		if v.spellID==ability then--find ability in table
			return v.prio--return prio status for ability
		end
	end
	return false
end

local function getTotalPrio(from)
	local ret=0
	if JukedDB[CharIndex].prio or from then
		for _,v in ipairs(spell_table) do
			if v.prio then
				ret=ret+1
			end
		end
	end
	return ret
end

local function getTotalMain()
	local ret=0
	if JukedDB[CharIndex].prio then
		for _,v in ipairs(spell_table) do
			if not v.prio then
				ret=ret+1
			end
		end
		return ret
	end
	return #(spell_table)
end

local function Juked_AddIcons()

	for _,ability in ipairs(spell_table) do--for all spells in spell table
		local btn = CreateFrame("Frame",nil,bar)
		btn:SetWidth(30)--create the frame and set the dimensions
		btn:SetHeight(30)
		
		if JukedDB[CharIndex].prio and isPrio(ability.spellID) then
			btn:SetPoint("CENTER",bar,"CENTER",x2,y2)
		else
			btn:SetPoint("CENTER",bar,"CENTER",x,y)
		end
			
		btn:SetFrameStrata("LOW")
		local cd = CreateFrame("Cooldown",nil,btn)
		cd.noomnicc = not JukedDB[CharIndex].noCD
		cd.noOCC = not JukedDB[CharIndex].noCD
		cd.noCooldownCount = not JukedDB[CharIndex].noCD
		
		cd:SetAllPoints(true)
		cd:SetFrameStrata("LOW")
		cd:Hide()
		
		local texture = btn:CreateTexture(nil,"BACKGROUND")
		texture:SetAllPoints(true)
		texture:SetTexture(abilities[ability.spellID].icon)
		texture:SetTexCoord(0.07,0.9,0.07,0.90)
	
		local text = cd:CreateFontString(nil,"ARTWORK")
		text:SetFont(STANDARD_TEXT_FONT,18,"OUTLINE")
		text:SetTextColor(1,1,0,1)
		text:SetPoint("LEFT",btn,"LEFT",1,0)
		
		btn.texture = texture
		btn.text = text
		btn.duration = abilities[ability.spellID].duration
		btn.cd = cd
		
		if JukedDB[CharIndex].prio and isPrio(ability.spellID) then
			bar2[ability.spellID] = btn
			if (JukedDB[CharIndex].prioOnly and not isPrio(ability.spellID)) then bar2[ability.spellID]:Hide() end
			x2 = x2 + 30 * JukedDB[CharIndex].growLeft
			count2 = count2 + 1
			totalIcons = totalIcons + 1
			if count2 >= JukedDB[CharIndex].colsPrio and JukedDB[CharIndex].colsPrio > 0 then
				y2 = y2 - 30 * JukedDB[CharIndex].growUp
				x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
				count2=0
			end
		else
			bar[ability.spellID] = btn
			if (JukedDB[CharIndex].prioOnly and not isPrio(ability.spellID)) then bar[ability.spellID]:Hide() end
			x = x + 30 * JukedDB[CharIndex].growLeft
			count = count + 1
			totalIcons = totalIcons + 1
			if count >= JukedDB[CharIndex].cols and JukedDB[CharIndex].cols > 0 then
				y = y - 30 * JukedDB[CharIndex].growUp
				x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
				count=0
			end
		end
	end
	x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
	count=0
	y=0
	active=0
	x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
	count2=0
	y2=0
end

local function Juked_AddIcon(ability)
	if (JukedDB[CharIndex].prioOnly and not isPrio(ability)) then return end
	if JukedDB[CharIndex].prio and isPrio(ability) then
		if not bar2[ability]:IsVisible() then
			bar2[ability]:SetPoint("CENTER",bar2,x2,y2)
			bar2[ability]:Show()
			x2 = x2 + 30 * JukedDB[CharIndex].growLeft
			count2 = count2 + 1
			if count2 >= JukedDB[CharIndex].colsPrio and JukedDB[CharIndex].colsPrio > 0 then
				y2 = y2 - 30 * JukedDB[CharIndex].growUp
				x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
				count2=0
			end
		end
	else
		if not bar[ability]:IsVisible() then
			bar[ability]:SetPoint("CENTER",bar,x,y)
			bar[ability]:Show()
			x = x + 30 * JukedDB[CharIndex].growLeft
			count = count + 1
			if count >= JukedDB[CharIndex].cols and JukedDB[CharIndex].cols > 0 then
				y = y - 30 * JukedDB[CharIndex].growUp
				x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
				count=0
			end
		end
	end
		local main=getTotalMain()
	if JukedDB[CharIndex].cols == 0 then
		bar:SetWidth(30*main)
	else
		bar:SetWidth(30*JukedDB[CharIndex].cols)
	end
	local numprio=getTotalPrio()
	if JukedDB[CharIndex].prio then
		if JukedDB[CharIndex].colsPrio == 0 then
			bar2:SetWidth(30*numprio)
		else
			bar2:SetWidth(30*JukedDB[CharIndex].colsPrio)
		end
	end
end


local function Juked_SavePosition()
	local point, _, relativePoint, xOfs, yOfs = bar:GetPoint()
	if not JukedDB[CharIndex].Position then 
		JukedDB[CharIndex].Position = {}
	end
	--first bar
	JukedDB[CharIndex].Position.point = point
	JukedDB[CharIndex].Position.relativePoint = relativePoint
	JukedDB[CharIndex].Position.xOfs = xOfs
	JukedDB[CharIndex].Position.yOfs = yOfs
	--second bar
	local point, _, relativePoint, xOfs, yOfs = bar2:GetPoint()
	JukedDB[CharIndex].Position.point2 = point
	JukedDB[CharIndex].Position.relativePoint2 = relativePoint
	JukedDB[CharIndex].Position.xOfs2 = xOfs
	JukedDB[CharIndex].Position.yOfs2 = yOfs
end

local function Juked_LoadPosition()
	if JukedDB[CharIndex].Position then
		bar:SetPoint(JukedDB[CharIndex].Position.point,UIParent,JukedDB[CharIndex].Position.relativePoint,JukedDB[CharIndex].Position.xOfs,JukedDB[CharIndex].Position.yOfs)
			if  JukedDB[CharIndex].Position.point2 then
				bar2:SetPoint(JukedDB[CharIndex].Position.point2,UIParent,JukedDB[CharIndex].Position.relativePoint2,JukedDB[CharIndex].Position.xOfs2,JukedDB[CharIndex].Position.yOfs2)
			else
				bar2:SetPoint("CENTER", UIParent, "CENTER")
			end
	else
		bar:SetPoint("CENTER", UIParent, "CENTER")
		bar2:SetPoint("CENTER", UIParent, "CENTER")
	end
end

local function Juked_Repos()
	if (JukedDB[CharIndex].bgOnly and not bg and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].bgOnly and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].arenaOnly and JukedDB[CharIndex].bgOnly and not bg) then return end
	if not JukedDB[CharIndex].smart then
		x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
		count=0
		y=0
		for _,v in ipairs(spell_table) do
			if not (JukedDB[CharIndex].prio and isPrio(v.spellID)) then
				bar[v.spellID]:Hide()
				Juked_AddIcon(v.spellID)
				if JukedDB[CharIndex].hidden and not activetimers[v.spellID] then
					bar[v.spellID]:Hide()
				end
			end
		end
	else 
		if JukedDB[CharIndex].hidden then
			x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
			count=0
			y=0
		end
		for _,v in ipairs(spell_table) do
			if not(isPrio(v.spellID) and JukedDB[CharIndex].prio) then
				bar[v.spellID]:Hide()
				if activetimers[v.spellID] then
					Juked_AddIcon(v.spellID)
				else 
					if JukedDB[CharIndex].hidden then
						bar[v.spellID]:Hide()
					end
				end
			end
		end
	end
	if JukedDB[CharIndex].prio then
		if not JukedDB[CharIndex].smartPrio then
			x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
			count2 = 0
			y2 = 0
			for _,v in ipairs(spell_table) do
				if JukedDB[CharIndex].prio and isPrio(v.spellID) then
					bar2[v.spellID]:Hide()
					Juked_AddIcon(v.spellID)
					if JukedDB[CharIndex].hidden2 and not activetimers[v.spellID] then
						bar2[v.spellID]:Hide()
					end
				end
			end
		else
			if JukedDB[CharIndex].hidden2 then
				x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
				count2 = 0
				y2 = 0
			end
			for _,v in ipairs(spell_table) do
				if JukedDB[CharIndex].prio and isPrio(v.spellID) and JukedDB[CharIndex].hidden2 then
					bar2[v.spellID]:Hide()
					if activetimers[v.spellID] then
						Juked_AddIcon(v.spellID)
					else
						if JukedDB[CharIndex].hidden2 then
							bar2[v.spellID]:Hide()
						end
					end
				end
			end
		end
	end
end

local function Juked_UpdateBar()
	bar:SetScale(JukedDB[CharIndex].scale)
	bar2:SetScale(JukedDB[CharIndex].scale2)
	
	local main=getTotalMain()
	local numprio=getTotalPrio()
	if JukedDB[CharIndex].cols == 0 then
		bar:SetWidth(30*main)
	else
		bar:SetWidth(30*JukedDB[CharIndex].cols)
	end
	if JukedDB[CharIndex].prio then
		if JukedDB[CharIndex].colsPrio == 0 then
			bar2:SetWidth(30*numprio)
		else
			bar2:SetWidth(30*JukedDB[CharIndex].colsPrio)
		end
		bar2:Show()
	end
	if not JukedDB[CharIndex].prio then--if prio was disabled
		for _,v in ipairs(spell_table) do 
			if isPrio(v.spellID) and bar2[v.spellID] then--if spell is prio and on currently on bar2
				bar[v.spellID]=bar2[v.spellID] --move the spell back to bar1
			end
		end
		bar2:Hide()--hide bar2
	elseif JukedDB[CharIndex].prio and table.getn(bar2) == 0 then--if prio is on and bar2 is empty
		for _,v in ipairs(spell_table) do
			if JukedDB[CharIndex].prio and isPrio(v.spellID) then--if spell is prio and prio is on
				if bar[v.spellID] and not bar2[v.spellID] then
					bar2[v.spellID]=bar[v.spellID]--put spell on bar2
				end
			end
		end
	end
	--if bgonly mode is on, and not in a bg, or arenaonly and not in arena, or bgonly and arenaonly modes and not in bg or arena
	if (JukedDB[CharIndex].bgOnly and not bg and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].bgOnly and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].arenaOnly and JukedDB[CharIndex].bgOnly and not bg) then 
		for _,v in ipairs(spell_table) do
			if JukedDB[CharIndex].prio and isPrio(v.spellID) then
				bar2[v.spellID]:Hide()--hide spells on prio and main bar
			else
				bar[v.spellID]:Hide()
			end
		end
		return
	end
	if JukedDB[CharIndex].hidden or JukedDB[CharIndex].hidden2 or JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio then
		if JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio then
			x = 15+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].cols/2)*-30*((JukedDB[CharIndex].growLeft-1)/2))
			count=0
			y=0
			x2 = 15+((JukedDB[CharIndex].colsPrio/2)*-30*((JukedDB[CharIndex].growLeft+1)/2))+((JukedDB[CharIndex].colsPrio/2-1)*-30*((JukedDB[CharIndex].growLeft-1)/2))
			y2 = 0
			count2 = 0
		end
		for _,v in ipairs(spell_table) do
			if JukedDB[CharIndex].prio and isPrio(v.spellID) then
				if JukedDB[CharIndex].hidden2 or JukedDB[CharIndex].smartPrio then
					bar2[v.spellID]:Hide()--hide spells on bar2
				else
					bar2[v.spellID]:Show()
				end
				bar2[v.spellID].cd.noomnicc = not JukedDB[CharIndex].noCD
				bar2[v.spellID].cd.noOCC = not JukedDB[CharIndex].noCD--set correct flags to enable/disable omniCC 
				bar2[v.spellID].cd.noCooldownCount = not JukedDB[CharIndex].noCD
				bar2[v.spellID]:SetParent(bar2)
			else	
				if JukedDB[CharIndex].hidden or JukedDB[CharIndex].smart then
					bar[v.spellID]:Hide()--hide spells on main bar
				else
					bar[v.spellID]:Show()
				end
				bar[v.spellID].cd.noomnicc = not JukedDB[CharIndex].noCD
				bar[v.spellID].cd.noOCC = not JukedDB[CharIndex].noCD--set correct flags to enable/disable omniCC 
				bar[v.spellID].cd.noCooldownCount = not JukedDB[CharIndex].noCD
				bar[v.spellID]:SetParent(bar)
			end
		end
	else--if not hidden or smart
		for _,v in ipairs(spell_table) do
			if JukedDB[CharIndex].prio and isPrio(v.spellID) then
				bar2[v.spellID]:Show() --show spell
				bar2[v.spellID].cd.noomnicc = not JukedDB[CharIndex].noCD
				bar2[v.spellID].cd.noOCC = not JukedDB[CharIndex].noCD--set correct flags to enable/disable omniCC 
				bar2[v.spellID].cd.noCooldownCount = not JukedDB[CharIndex].noCD
				bar2[v.spellID]:SetParent(bar2)
			else
				bar[v.spellID]:Show() 
				bar[v.spellID].cd.noomnicc = not JukedDB[CharIndex].noCD
				bar[v.spellID].cd.noOCC = not JukedDB[CharIndex].noCD
				bar[v.spellID].cd.noCooldownCount = not JukedDB[CharIndex].noCD
				bar[v.spellID]:SetParent(bar)
			end
		end
	end
	if JukedDB[CharIndex].prioOnly then--if prio only
		for _,v in ipairs(spell_table) do
			if not isPrio(v.spellID) then--hide non-prio spells
				bar[v.spellID]:Hide()
			end
		end
	end
	if JukedDB[CharIndex].lock then--if bar is locked, disable mouse
		bar:EnableMouse(false)
	else--else, enable mouse
		bar:EnableMouse(true)
	end
	if JukedDB[CharIndex].lockPrio then
		bar2:EnableMouse(false)
	else
		bar2:EnableMouse(true)
	end
end

local function Juked_CreateBar()
	bar = CreateFrame("Frame", "jukedMainBar", UIParent)
	bar:SetMovable(true)
	bar:SetWidth(120)
	bar:SetHeight(30)
	bar:SetClampedToScreen(true) 
	bar:SetScript("OnMouseDown",function(self,button) if button == "LeftButton" then self:StartMoving() end end)
	bar:SetScript("OnMouseUp",function(self,button) if button == "LeftButton" then self:StopMovingOrSizing() Juked_SavePosition() end end)
	bar:Show()

	bar2 = CreateFrame("Frame", "jukedPrioBar", UIParent)
	bar2:SetMovable(true)
	bar2:SetWidth(120)
	bar2:SetHeight(30)
	bar2:SetClampedToScreen(true) 
	bar2:SetScript("OnMouseDown",function(self,button) if button == "LeftButton" then self:StartMoving() end end)
	bar2:SetScript("OnMouseUp",function(self,button) if button == "LeftButton" then self:StopMovingOrSizing() Juked_SavePosition() end end)
	bar2:Show()
	
	Juked_AddIcons()
	Juked_UpdateBar()
	Juked_LoadPosition()
end

local function Juked_UpdateText(text,cooldown)
if  JukedDB[CharIndex].noCD then return end
	if cooldown < 100 then 
		if cooldown <= 0.5 then
			text:SetText("")
		elseif cooldown < 10 then
			text:SetFormattedText(" %d",cooldown)
		else
			text:SetFormattedText("%d",cooldown)
		end
	else
		local m=floor((cooldown+30)/60)
		text:SetFormattedText("%dm",m)
	end
	if cooldown < 6 then 
		text:SetTextColor(1,0,0,1)
	else 
		text:SetTextColor(1,1,0,1) 
	end
end

local function Juked_StopAbility(ref,ability)
	if (JukedDB[CharIndex].hidden2 and isPrio(ability)) or (JukedDB[CharIndex].hidden and not isPrio(ability)) then
		if ref then
			ref:Hide()
		else
			if isPrio(ability) and JukedDB[CharIndex].prio then
				ref=bar2[ability]
			else
				ref=bar[ability]	
			end
		end
	end
	if activetimers[ability] then activetimers[ability] = nil end
	if ref then
		ref.text:SetText("")
		ref.cd:Hide()
	end
	if (JukedDB[CharIndex].hidden or JukedDB[CharIndex].hidden2) and (JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio) then Juked_Repos() end
end

local time = 0
local function Juked_OnUpdate(self, elapsed)
	time = time + elapsed
	if time > 0.25 then
		getsize()
		for ability,ref in pairs(activetimers) do
			ref.cooldown = ref.start + ref.duration - GetTime()
			if ref.cooldown <= 0 then
				Juked_StopAbility(ref,ability)
			else 
				Juked_UpdateText(ref.text,floor(ref.cooldown+0.5))
			end
		end
		if size == 0 then frame:SetScript("OnUpdate",nil) end
		time = time - 0.25
	end
end

local function Juked_StartTimer(ref,ability)
	if (JukedDB[CharIndex].bgOnly and not bg and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].bgOnly and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].arenaOnly and JukedDB[CharIndex].bgOnly and not bg) then return end
	if JukedDB[CharIndex].hidden or JukedDB[CharIndex].hidden2 or JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio then
		ref:Show()
	end
	local duration
	activetimers[ability] = ref
	ref.cd:Show()
	ref.cd:SetCooldown(GetTime()-0.40,ref.duration)
	ref.start = GetTime()
	Juked_UpdateText(ref.text,ref.duration)
	frame:SetScript("OnUpdate",Juked_OnUpdate)
end

local function Juked_COMBAT_LOG_EVENT_UNFILTERED(...)
	local spellID, ability, useSecondDuration
	return function(_, eventtype, _,_, srcName, srcFlags, _,_, dstName, dstFlags,_, id)
		if (band(srcFlags, 0x00000040) == 0x00000040 and (eventtype == "SPELL_CAST_SUCCESS" or eventtype == "SPELL_AURA_APPLIED")) then 
			spellID = id
		else
			return
		end
		if spellID == 49376 then spellID = 16979; useSecondDuration = true end -- Feral Charge - Cat -> Feral Charge - Bear
		if spellID == 91797 then spellID = 91800; end
		if (JukedDB[CharIndex].prioOnly and not isPrio(spellID)) then return end
		if (JukedDB[CharIndex].bgOnly and not bg and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].bgOnly and JukedDB[CharIndex].arenaOnly and not arena) or (not JukedDB[CharIndex].arenaOnly and JukedDB[CharIndex].bgOnly and not bg) then return end
		local cold_snap={82676,44572,45438}
		local prep={1766,1856,36554,51722}
		local readiness={19263,19503,34490}
		
		if spellID == 11958 then --cold snap 82676 Ring of Frost -- 44572 Deep Freeze -- 45438 Ice Block
			if JukedDB[CharIndex].prio and isPrio(ability) then
				for _,abil in ipairs(cold_snap) do
					if activetimers[abil] then
						Juked_StopAbility(bar2[abil],abil)
					end
				end
			else
				for _,abil in ipairs(cold_snap) do
					if activetimers[abil] then
						Juked_StopAbility(bar[abil],abil)
					end
				end
			end
		elseif spellID == 14185 then --prep
			if JukedDB[CharIndex].prio and isPrio(ability) then
				for _,abil in ipairs(prep) do
					if activetimers[abil] then
						Juked_StopAbility(bar2[abil],abil)
					end
				end
			else
				for _,abil in ipairs(prep) do
					if activetimers[abil] then
						Juked_StopAbility(bar[abil],abil)
					end
				end
			end
			--[[ 1766  Kick 1856  Vanish 36554 Shadowstep 76577 Smoke Bomb 51722 Dismantle
				Non tracked: Sprint, Smoke Bomb]]
		elseif spellID == 23989 then --readiness
			if JukedDB[CharIndex].prio and isPrio(ability) then
				for _,abil in ipairs(readiness) do
					if activetimers[abil] then
						Juked_StopAbility(bar2[abil],abil)
					end
				end
			else
				for _,abil in ipairs(readiness) do
					if activetimers[abil] then
						Juked_StopAbility(bar[abil],abil)
					end
				end
			end
		end
		useSecondDuration = false

		if abilities[spellID] then	
			if useSecondDuration and spellID == 16979 then
				if JukedDB[CharIndex].prio and isPrio(spellID) then
					bar2[spellID].duration=30
				else
					bar[spellID].duration=30
				end
			elseif spellID == 16979 then
				if JukedDB[CharIndex].prio and isPrio(spellID) then
					bar2[spellID].duration=15
				else
					bar[spellID].duration=15
				end
			end
			if JukedDB[CharIndex].prio and isPrio(spellID) then
				if JukedDB[CharIndex].smartPrio then Juked_AddIcon(spellID) end
				Juked_StartTimer(bar2[spellID],spellID)
			else
				if JukedDB[CharIndex].smart then Juked_AddIcon(spellID) end
				Juked_StartTimer(bar[spellID],spellID)
			end
		end
	end
end

Juked_COMBAT_LOG_EVENT_UNFILTERED = Juked_COMBAT_LOG_EVENT_UNFILTERED()


local function Juked_ResetAllTimers()
	for _,ability in ipairs(spell_table) do
		if JukedDB[CharIndex].prio and isPrio(ability.spellID) then
			Juked_StopAbility(bar2[ability.spellID],ability.spellID)
		else
			Juked_StopAbility(bar[ability.spellID],ability.spellID)
		end
	end
	if not (JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio) and not ((JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio) and (JukedDB[CharIndex].hidden or JukedDB[CharIndex].hidden2)) then
		Juked_Repos()
	end

end

local function Juked_Reset()
	JukedDB[CharIndex] = JukedDB[CharIndex] or { scale = 1,scale2=1, hidden = false,hidden2=false, smart=false,smartPrio=false,prio = false, cols=6, colsPrio=6, arenaOnly=false, bgOnly=false, lock = false,lockPrio=false,growUp=1,growLeft=-1 ,noCD=false,prioOnly=false}
	Juked_ResetAllTimers()
	Juked_UpdateBar()
	Juked_LoadPosition()
end

local function Juked_PLAYER_ENTERING_WORLD(self)
	arena=isInArena()
	bg=isInBG()
	Juked_Reset()
end

local function Juked_Test()
	if (JukedDB[CharIndex].smart or JukedDB[CharIndex].smartPrio) and (JukedDB[CharIndex].hidden or JukedDB[CharIndex].hidden2) then 
		Juked_Repos()
	end
	if JukedDB[CharIndex].prioOnly then 
		for _,ability in ipairs(spell_table) do
			if isPrio(ability.spellID) then
				if JukedDB[CharIndex].smartPrio then Juked_AddIcon(ability.spellID) end
				if JukedDB[CharIndex].prio then
					Juked_StartTimer(bar2[ability.spellID],ability.spellID)
				else
					Juked_StartTimer(bar[ability.spellID],ability.spellID)
				end
			end
		end
	else
		for _,ability in ipairs(spell_table) do
			if JukedDB[CharIndex].prio and isPrio(ability.spellID) then
				if JukedDB[CharIndex].smartPrio then Juked_AddIcon(ability.spellID) end
				Juked_StartTimer(bar2[ability.spellID],ability.spellID)
			else
			if JukedDB[CharIndex].smart then Juked_AddIcon(ability.spellID) end
				Juked_StartTimer(bar[ability.spellID],ability.spellID)
			end
		end
	end
end


local cmdfuncs = {
	status = function() 
		ChatFrame1:AddMessage("Scale - Main Bar(1) = "..JukedDB[CharIndex].scale.."  Prio Bar(2) = "..JukedDB[CharIndex].scale2,0,1,1)
		local cd="Disabled"
		if (JukedDB[CharIndex].hidden) then cd="Enabled"; end
		ChatFrame1:AddMessage("Hidden(1) - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].hidden2) then cd="Enabled"; end
		ChatFrame1:AddMessage("Hidden(2) - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].smart) then cd="Enabled"; end
		ChatFrame1:AddMessage("Smart(1) - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].smartPrio) then cd="Enabled"; end
		ChatFrame1:AddMessage("Smart(2) - "..cd,0,1,1)
		cd="unlocked"
		if (JukedDB[CharIndex].lock) then cd="locked"; end
		ChatFrame1:AddMessage("Locked(1) - "..cd,0,1,1)
		cd="unlocked"
		if (JukedDB[CharIndex].lockPrio) then cd="locked"; end
		ChatFrame1:AddMessage("Locked(2) - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].prio) then cd="Enabled"; end
		ChatFrame1:AddMessage("Prio - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].arenaOnly) then cd="Enabled"; end
		ChatFrame1:AddMessage("ArenaOnly - "..cd,0,1,1)
		cd="Disabled"
		if (JukedDB[CharIndex].bgOnly) then cd="Enabled"; end
		ChatFrame1:AddMessage("BGOnly - "..cd,0,1,1)
		cd="growing down"
		if (JukedDB[CharIndex].growUp==-1) then cd="growing up"; end
		ChatFrame1:AddMessage("Cooldowns are "..cd.." from the anchor",0,1,1)
		cd="Disabled"
		cd="growing right"
		if (JukedDB[CharIndex].growLeft==-1) then cd="growing left"; end
		ChatFrame1:AddMessage("Cooldowns are "..cd.." from the anchor",0,1,1)
		cd="Disabled"
		if (not JukedDB[CharIndex].noCD) then cd="Enabled"; end
		ChatFrame1:AddMessage("Juked cooldown display is "..cd,0,1,1)
		cd="all spell cooldowns"
		if (JukedDB[CharIndex].prioOnly) then cd="ONLY priority cooldowns"; end
		ChatFrame1:AddMessage("Displaying "..cd.."(PrioOnly mode="..tostring(JukedDB[CharIndex].prioOnly)..")",0,1,1)
		ChatFrame1:AddMessage("Columns per row:  Main Bar(1) = "..JukedDB[CharIndex].cols.."  Prio Bar(2) = "..JukedDB[CharIndex].colsPrio,0,1,1)
	end,
	scale = function(id,v,from) 
		if not id or not v then 
			ChatFrame1:AddMessage("USAGE: scale <bar ID> <number>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			ChatFrame1:AddMessage("Current settings: Main Bar(1) = "..JukedDB[CharIndex].scale.."  Prio Bar(2) = "..JukedDB[CharIndex].scale2,0,1,0)
			return
		end
		if ((id == 1 or id == 2) and v >= 0) then 
			if id==1 then
				JukedDB[CharIndex].scale = v
			elseif id == 2 then
				JukedDB[CharIndex].scale2=v
			end
			if not from then
				ChatFrame1:AddMessage("Scale for bar"..id.." set to"..v,0,1,0)
			end
			Juked_UpdateBar()
			return
		end
		if not from then
			ChatFrame1:AddMessage("USAGE: scale <bar ID> <number>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			ChatFrame1:AddMessage("Current settings: Main Bar(1) = "..JukedDB[CharIndex].scale.."  Prio Bar(2) = "..JukedDB[CharIndex].scale2,0,1,0)
		end
	end,
	hidden = function(id,from) 
		if not id then 
			ChatFrame1:AddMessage("USAGE: hidden <bar ID>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			return
		end
		if ((id == 1 or id == 2)) then 
			local cd="Disabled"
			if id == 1 then
				JukedDB[CharIndex].hidden = not JukedDB[CharIndex].hidden
				if (JukedDB[CharIndex].hidden) then cd="Enabled"; end
			elseif id == 2 then
				JukedDB[CharIndex].hidden2 = not JukedDB[CharIndex].hidden2
				if (JukedDB[CharIndex].hidden2) then cd="Enabled"; end
			end
			if not from then
				ChatFrame1:AddMessage("Juked hidden("..id..") mode is now "..cd,0,1,1)
				ChatFrame1:AddMessage("Enabled = Spells are hidden when not on cooldown",0,1,0)
				ChatFrame1:AddMessage("Disabled = Spells are always visible",0,1,0)
				ChatFrame1:AddMessage("Note: If Smart & Hidden mode are enabled, the cooldowns realign to the anchor when off cooldown",0,1,0)
			end
			Juked_UpdateBar() 
			Juked_Repos() 
		end
	end,
	smart = function(id,from) 
		if not id then 
			ChatFrame1:AddMessage("USAGE: smart <bar ID>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			return
		end
		local cd="Disabled"
		if ((id == 1 or id == 2)) then 
			if id == 1 then
				JukedDB[CharIndex].smart = not JukedDB[CharIndex].smart
				if (JukedDB[CharIndex].smart) then cd="Enabled"; end
			elseif id == 2 then
				JukedDB[CharIndex].smartPrio = not JukedDB[CharIndex].smartPrio
				if (JukedDB[CharIndex].smartPrio) then cd="Enabled"; end
			end
		end
		if not from then
			ChatFrame1:AddMessage("Juked smart mode is now "..cd,0,1,1)
			ChatFrame1:AddMessage("Enabled = Spells are only displayed once used and in the order they're used",0,1,0)
			ChatFrame1:AddMessage("Disabled = Spells are always displayed in the same order",0,1,0)
			ChatFrame1:AddMessage("Note: If Smart & Hidden mode are enabled, the cooldowns realign to the anchor when off cooldown",0,1,0)
		end
		Juked_Reset() 
	end,
	lock = function(id,from) 
		if not id then 
			ChatFrame1:AddMessage("USAGE: lock <bar ID>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			return
		end
		if ((id == 1 or id == 2)) then 
			local cd="unlocked"
			if id == 1 then
				JukedDB[CharIndex].lock = not JukedDB[CharIndex].lock
				if (JukedDB[CharIndex].hidden) then cd="locked"; end
			elseif id == 2 then
				JukedDB[CharIndex].lockPrio = not JukedDB[CharIndex].lockPrio
				if (JukedDB[CharIndex].lockPrio) then cd="locked"; end
			end
			if not from then ChatFrame1:AddMessage("Juked bar"..id.." is now "..cd,0,1,1) end
		end
		if not from then
			ChatFrame1:AddMessage("Locked = Bars can't be moved",0,1,0)
			ChatFrame1:AddMessage("Unlocked = Bars can be moved",0,1,0)
		end
		Juked_UpdateBar()
	end,
	prio = function(from) 
		JukedDB[CharIndex].prio = not JukedDB[CharIndex].prio
		if not from then
			local cd="Disabled"
			if (JukedDB[CharIndex].prio) then cd="Enabled"; end
			ChatFrame1:AddMessage("Juked Prio bar is now "..cd,0,1,1)
			ChatFrame1:AddMessage("Enabled = A second bar is created, displaying priority spells",0,1,0)
			ChatFrame1:AddMessage("Disabled = Juked displays all spells on the main bar",0,1,0)
		end
		local temp1=JukedDB[CharIndex].smart
		local temp2=JukedDB[CharIndex].smartPrio

		Juked_UpdateBar()
		JukedDB[CharIndex].smartPrio=false
		JukedDB[CharIndex].smart=false
		Juked_Repos() 
		JukedDB[CharIndex].smart=temp1
		JukedDB[CharIndex].smartPrio=temp2
		Juked_UpdateBar()
	end,
	arenaonly = function(from) 
		JukedDB[CharIndex].arenaOnly = not JukedDB[CharIndex].arenaOnly
		if not from then 
			local cd="Disabled"
			if (JukedDB[CharIndex].arenaOnly) then cd="Enabled"; end
			ChatFrame1:AddMessage("Juked Arena Only mode is now "..cd,0,1,1)
			ChatFrame1:AddMessage("Enabled = Juked is displayed ONLY in Arenas",0,1,0)
			ChatFrame1:AddMessage("Disabled = Juked is displayed outside of Arenas",0,1,0)
			ChatFrame1:AddMessage("Note: If BGOnly & ArenaOnly are enabled, it will work in Arenas and BGs",0,1,0)
		end
		Juked_Reset() 
	end,
	bgonly = function(from) 
		JukedDB[CharIndex].bgOnly = not JukedDB[CharIndex].bgOnly
		if not from then 
			local cd="Disabled"
			if (JukedDB[CharIndex].bgOnly) then cd="Enabled"; end
			ChatFrame1:AddMessage("Juked BG Only mode is now "..cd,0,1,1)
			ChatFrame1:AddMessage("Enabled = Juked is displayed ONLY in Battlegrounds",0,1,0)
			ChatFrame1:AddMessage("Disabled = Juked is displayed outside of Battlegrounds",0,1,0)
			ChatFrame1:AddMessage("Note: If BGOnly & ArenaOnly are enabled, it will work in Arenas and BGs",0,1,0)
		end
		Juked_Reset() 
	end,
	growup=function(from) 		
		JukedDB[CharIndex].growUp=JukedDB[CharIndex].growUp*-1
		if not from then 
			local text="growing down"
			if (JukedDB[CharIndex].growUp==-1) then text="growing up"; end
			ChatFrame1:AddMessage("Juked cooldowns are "..text.." from the anchor",0,1,1)
		end
		Juked_Repos()
		end,
	growleft=function(from) 		
		JukedDB[CharIndex].growLeft=JukedDB[CharIndex].growLeft*-1
		if not from then 
			local text="growing right"
			if (JukedDB[CharIndex].growLeft==-1) then text="growing left"; end
			ChatFrame1:AddMessage("Juked cooldows are "..text.." from the anchor",0,1,1)
		end
		Juked_Repos()
		end,
	nocd=function(from) 
		JukedDB[CharIndex].noCD = not JukedDB[CharIndex].noCD
		if not from then 
			local cd="Disabled"
			if (not JukedDB[CharIndex].noCD) then cd="Enabled"; end
			ChatFrame1:AddMessage("Juked cooldown display is now "..cd,0,1,1)
			ChatFrame1:AddMessage("Enabled = Juked displays text",0,1,0)
			ChatFrame1:AddMessage("Disabled = Juked displays no text, OmniCC can be used",0,1,0)
		end
		Juked_Reset()
	end,
	prioonly=function(from)
		JukedDB[CharIndex].prioOnly=not JukedDB[CharIndex].prioOnly
		if not from then
			local cd="all spell cooldowns"
			if (JukedDB[CharIndex].prioOnly) then cd="ONLY priority cooldowns"; end
			ChatFrame1:AddMessage("Juked is now displaying "..cd,0,1,1)
		end
		Juked_Reset()  
	end,
	opts=function()
		InterfaceOptionsFrame_OpenToCategory(Juked.mainpanel);
	end,
	gui=function()
		InterfaceOptionsFrame_OpenToCategory(Juked.mainpanel);
	end,
	config=function()
		InterfaceOptionsFrame_OpenToCategory(Juked.mainpanel);
	end,
	cols = function(id,v,from) 
		if not id or not v then 
			ChatFrame1:AddMessage("USAGE: cols <bar ID> <number>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			ChatFrame1:AddMessage("Current settings: Main Bar(1) = "..JukedDB[CharIndex].cols.."  Prio Bar(2) = "..JukedDB[CharIndex].colsPrio,0,1,0)
			return
		end
		if ((id == 1 or id == 2) and v >= 0) then 
			if id==1 then
				if (v==0) then
					JukedDB[CharIndex].cols = getTotalMain()
				else
					JukedDB[CharIndex].cols = v
				end
			elseif id==2 then
				if (v==0) then
					JukedDB[CharIndex].colsPrio = getTotalPrio()
				else
					JukedDB[CharIndex].colsPrio = v
				end
			end
			if not from then
				ChatFrame1:AddMessage("Cols for bar"..id.." set to "..v,0,1,0)
			end
			Juked_Repos()
			return	
		end
		if not from then
			ChatFrame1:AddMessage("USAGE: /juked cols <bar ID> <number>",0,1,0)
			ChatFrame1:AddMessage("Bar IDs: Main bar = 1   Prio Bar = 2",0,1,0)
			ChatFrame1:AddMessage("Current settings: Main Bar(1) = "..JukedDB[CharIndex].cols.."  Prio Bar(2) = "..JukedDB[CharIndex].colsPrio,0,1,0)
			ChatFrame1:AddMessage("Example: set main bar cols to 6: /juked cols 1 6",0,1,0)
		end
	end,
	reset = function() Juked_Reset() end,
	test = function() Juked_Test() end,
}

local cmdtbl = {}
function Juked_Command(cmd)
	for k in ipairs(cmdtbl) do
		cmdtbl[k] = nil
	end
	for v in gmatch(cmd, "[%d|%a|.]+") do
		tinsert(cmdtbl, v)
	end
  local cb = cmdfuncs[cmdtbl[1]] 
  if cb then
  	local s = tonumber(cmdtbl[2])
  	local ss = tonumber(cmdtbl[3])
  	cb(s,ss)
  else
	ChatFrame1:AddMessage("Juked 帮助",0,1,0)
	ChatFrame1:AddMessage("config - 显示当前设置",0,1,0)
	ChatFrame1:AddMessage("scale <bar ID> <number> - 设置该监视条",0,1,0)
  	ChatFrame1:AddMessage("hidden <bar ID> (toggle) - 非冷却状态隐藏图标",0,1,0)
	ChatFrame1:AddMessage("smart <bar ID>(toggle) - 仅显示",0,1,0)
  	ChatFrame1:AddMessage("lock <bar ID>(toggle) - 锁定监视条",0,1,0)
	ChatFrame1:AddMessage("growup (toggle) - 从锚点向上延伸",0,1,0)
	ChatFrame1:AddMessage("growleft (toggle) - 从锚点向左延伸",0,1,0)
	ChatFrame1:AddMessage("prio (toggle) - 显示第2锚点主要技能",0,1,0)
	ChatFrame1:AddMessage("arenaonly (toggle) - 仅在竞技场显示",0,1,0)
	ChatFrame1:AddMessage("bgonly (toggle) - 仅在战场显示",0,1,0)
	ChatFrame1:AddMessage("prioonly (toggle) - 仅显示重要监视",0,1,0)
	ChatFrame1:AddMessage("nocd (toggle) - 隐藏插件计时器，使用omniCC",0,1,0)
	ChatFrame1:AddMessage("cols <bar ID> <num> (0 = 1 row) - 设定当前监视条行数",0,1,0)
  	ChatFrame1:AddMessage("test - 激活所有CD，打开DEBUG模式",0,1,0)
  	ChatFrame1:AddMessage("reset - 重置所有CD",0,1,0)
	ChatFrame1:AddMessage("settingsun是傻X",0,1,0)
  end
end

local function Juked_OnLoad(self)
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	if not JukedDB then
		JukedDB={}
	end
	JukedDB["Default"]= JukedDB["Default"] or { scale = 1,scale2=1 , hidden = false,hidden2=false, smart=false, smartPrio=false,prio = false, cols=6, colsPrio=6, arenaOnly=false, bgOnly=false, lock = false,growUp=1,growLeft=1, noCD=false,prioOnly=false,}
	JukedDB["CharsUse"]=JukedDB["CharsUse"] or {}
	
	if (JukedDB["CharsUse"][CharIndex]) then
		if (JukedDB[JukedDB["CharsUse"][CharIndex]]) then
			CharIndex=JukedDB["CharsUse"][CharIndex]
		else
			JukedDB["CharsUse"][CharIndex]=CharIndex
			if not JukedDB[CharIndex] then
				JukedDB[CharIndex]=JukedDB["Default"]
			end
		end	
	else
		JukedDB["CharsUse"][CharIndex]=CharIndex
		if not JukedDB[CharIndex] then
			JukedDB[CharIndex]=JukedDB["Default"]
		end
	end
	for k,v in pairs(JukedDB) do
		if not (type(JukedDB[k]) == "table" ) then 
			JukedDB[k]=nil
		elseif (k=="Position" and (JukedDB["Position"]["scale2"]==nil)) then 
			JukedDB[k]=nil
		end
	end
	
	Juked_CreateBar()
	
	SlashCmdList["Juked"] = Juked_Command
	SLASH_Juked1 = "/juked"
	SLASH_Juked2 = "/jd"
	SLASH_Juked3 = "/ib"
	ChatFrame1:AddMessage("Juked插件作者:Robrman, 汉化：esoyu . 输入 /juked 或 /jd 打开设置面板.",0,1,0)
end

local eventhandler = {
	["VARIABLES_LOADED"] = function(self) Juked_OnLoad(self) end,
	["PLAYER_ENTERING_WORLD"] = function(self) Juked_PLAYER_ENTERING_WORLD(self) end,
	["COMBAT_LOG_EVENT_UNFILTERED"] = function(self,...) Juked_COMBAT_LOG_EVENT_UNFILTERED(...) end,
}

local function Juked_OnEvent(self,event,...)
	eventhandler[event](self,...)
end

frame = CreateFrame("Frame","jukedMainFrame",UIParent)
frame:SetScript("OnEvent",Juked_OnEvent)
frame:RegisterEvent("VARIABLES_LOADED")

Juked = {};
Juked.mainpanel = CreateFrame( "Frame", "JukedMainPanel", UIParent );
Juked.mainpanel.name = "Juked";
local title = Juked.mainpanel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 20, -10)
title:SetText("Juked")
local subtitle = Juked.mainpanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -8)
subtitle:SetPoint("RIGHT", Juked.mainpanel, -32, 0)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("Juked冷却监视-全局设置")

local buttonPositionY = -60;
local buttonPositionX = 20;

local t = {"prio","prioOnly","arenaOnly","bgOnly","nocd","growLeft","growUp"};
local general_cmd_table={cmdfuncs["prio"],cmdfuncs["prioonly"],cmdfuncs["arenaonly"],cmdfuncs["bgonly"],cmdfuncs["nocd"],cmdfuncs["growleft"],cmdfuncs["growup"]};
local t2 = {"显示主要监视条","仅显示主要监视条", "仅在竞技场显示","仅在战场显示","隐藏Juked冷却提示","从锚点向左延伸","从锚点向上延伸"};
for i,v in ipairs (t) do
	local Juked_IconOptions_CheckButton = CreateFrame("CheckButton", "JUKED_Button_"..v, Juked.mainpanel, "OptionsCheckButtonTemplate");
	Juked_IconOptions_CheckButton:SetPoint("TOPLEFT",buttonPositionX,buttonPositionY);
	getglobal(Juked_IconOptions_CheckButton:GetName().."Text"):SetText(t2[i]);

	local function Juked_IconOptions_CheckButton_OnClick()
			general_cmd_table[i](1,"gui")
	end

	local function Juked_IconOptions_CheckButton_OnShow()
		if (v == "growLeft" or v == "growUp") then
			Juked_IconOptions_CheckButton:SetChecked(JukedDB[CharIndex][v]==-1);
		else
			Juked_IconOptions_CheckButton:SetChecked(JukedDB[CharIndex][v]);
		end
	end

	Juked_IconOptions_CheckButton:RegisterForClicks("AnyUp");
	Juked_IconOptions_CheckButton:SetScript("OnClick", Juked_IconOptions_CheckButton_OnClick);
	Juked_IconOptions_CheckButton:SetScript("OnShow", Juked_IconOptions_CheckButton_OnShow);
	buttonPositionY = buttonPositionY - 30;
end

-- Add the panel to the Interface Options
InterfaceOptions_AddCategory(Juked.mainpanel);
-- Make a child panel
Juked.mainbarpanel = CreateFrame( "Frame", "MainBarPanel", Juked.mainpanel);
Juked.mainbarpanel.name = "总体监视条";
-- Specify childness of this panel (this puts it under the little red [+], instead of giving it a normal AddOn category)
Juked.mainbarpanel.parent = Juked.mainpanel.name;
			
local title = Juked.mainbarpanel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 20, -10)
title:SetText("总体监视条设置")

local subtitle = Juked.mainbarpanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -8)
subtitle:SetPoint("RIGHT", Juked.mainbarpanel, -32, 0)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("Juked总体监视条设置")	

buttonPositionY = -60;
buttonPositionX = 20;

-- Main bar options
local t = {"hidden","smart","lock"};
local bar_cmd_table={cmdfuncs["hidden"],cmdfuncs["smart"],cmdfuncs["lock"]};
local t2 = {"隐藏图标","智能模式", "锁定框架"};
for i,v in ipairs (t) do
	local Juked_IconOptions_CheckButton = CreateFrame("CheckButton", "JUKED_Button_"..v, Juked.mainbarpanel, "OptionsCheckButtonTemplate");
	Juked_IconOptions_CheckButton:SetPoint("TOPLEFT",buttonPositionX,buttonPositionY);
	getglobal(Juked_IconOptions_CheckButton:GetName().."Text"):SetText(t2[i]);

	local function Juked_IconOptions_CheckButton_OnClick()
			bar_cmd_table[i](1,"gui")
	end

	local function Juked_IconOptions_CheckButton_OnShow()
		Juked_IconOptions_CheckButton:SetChecked(JukedDB[CharIndex][v]);
	end

	Juked_IconOptions_CheckButton:RegisterForClicks("AnyUp");
	Juked_IconOptions_CheckButton:SetScript("OnClick", Juked_IconOptions_CheckButton_OnClick);
	Juked_IconOptions_CheckButton:SetScript("OnShow", Juked_IconOptions_CheckButton_OnShow);
	buttonPositionY = buttonPositionY - 30;
end
local tsliders = {"cols","scale"};
local slider_table={cmdfuncs["cols"],cmdfuncs["scale"]};
local slidert2 = {"技能格数","缩放（默认为1.0）" };
buttonPositionY = buttonPositionY - 30;
for i,v in ipairs (tsliders) do
	local Juked_IconOptions_Slider = CreateFrame("Slider", "Juked_Slider_"..v, Juked.mainbarpanel, "OptionsSliderTemplate");
	Juked_IconOptions_Slider:SetPoint("TOPLEFT",buttonPositionX,buttonPositionY);
	getglobal(Juked_IconOptions_Slider:GetName() .. 'Low'):SetText('-');
	getglobal(Juked_IconOptions_Slider:GetName() .. 'High'):SetText('+');
	getglobal(Juked_IconOptions_Slider:GetName() .. 'Text'):SetText(slidert2[i].."\n数值: "..JukedDB[CharIndex][v]);

	if (v == "cols") then
		Juked_IconOptions_Slider:SetMinMaxValues(0,#(spell_table));
		Juked_IconOptions_Slider:SetValueStep(1.0);
	elseif (v == "scale") then
		Juked_IconOptions_Slider:SetMinMaxValues(0.1,2.0);
		Juked_IconOptions_Slider:SetValueStep(0.1);
	end
	
	local function Juked_IconOptions_Slider_OnShow()
		Juked_IconOptions_Slider:SetValue(JukedDB[CharIndex][v]);
	end

	local function Juked_IconOptions_Slider_OnValueChanged()
		slider_table[i](1,Juked_IconOptions_Slider:GetValue(),"gui");
		getglobal(Juked_IconOptions_Slider:GetName() .. 'Text'):SetText(slidert2[i].."\n数值: "..JukedDB[CharIndex][v]);
	end

	Juked_IconOptions_Slider:SetScript("OnValueChanged", Juked_IconOptions_Slider_OnValueChanged);
	Juked_IconOptions_Slider:SetScript("OnShow", Juked_IconOptions_Slider_OnShow);
	buttonPositionY = buttonPositionY - 60;
end

InterfaceOptions_AddCategory(Juked.mainbarpanel);
-- Make a child panel
Juked.priobarpanel = CreateFrame( "Frame", "PrioBarPanel", Juked.mainpanel);
Juked.priobarpanel.name = "主要监视条";
-- Specify childness of this panel (this puts it under the little red [+], instead of giving it a normal AddOn category)
Juked.priobarpanel.parent = Juked.mainpanel.name;

local title = Juked.priobarpanel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 20, -10)
title:SetText("主要监视条设置")

local subtitle = Juked.priobarpanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -8)
subtitle:SetPoint("RIGHT", Juked.priobarpanel, -32, 0)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("Juked主要监视条设置")	

buttonPositionY = -60;
buttonPositionX = 20;
local priot = {"hidden2","smartPrio","lockPrio"};
for i,v in ipairs (priot) do
	local Juked_IconOptions_CheckButton = CreateFrame("CheckButton", "JUKED_Button_"..v, Juked.priobarpanel, "OptionsCheckButtonTemplate");
	Juked_IconOptions_CheckButton:SetPoint("TOPLEFT",buttonPositionX,buttonPositionY);
	getglobal(Juked_IconOptions_CheckButton:GetName().."Text"):SetText(t2[i]);

	local function Juked_IconOptions_CheckButton_OnClick()
			bar_cmd_table[i](2,"gui")
	end

	local function Juked_IconOptions_CheckButton_OnShow()
		Juked_IconOptions_CheckButton:SetChecked(JukedDB[CharIndex][v]);
	end

	Juked_IconOptions_CheckButton:RegisterForClicks("AnyUp");
	Juked_IconOptions_CheckButton:SetScript("OnClick", Juked_IconOptions_CheckButton_OnClick);
	Juked_IconOptions_CheckButton:SetScript("OnShow", Juked_IconOptions_CheckButton_OnShow);

	buttonPositionY = buttonPositionY - 30;
end
tsliders = {"colsPrio","scale2"};
buttonPositionY = buttonPositionY - 30;
for i,v in ipairs (tsliders) do
	local Juked_IconOptions_Slider = CreateFrame("Slider", "Juked_Slider_"..v, Juked.priobarpanel, "OptionsSliderTemplate");
	Juked_IconOptions_Slider:SetPoint("TOPLEFT",buttonPositionX,buttonPositionY);

	getglobal(Juked_IconOptions_Slider:GetName() .. 'Low'):SetText('-');
	getglobal(Juked_IconOptions_Slider:GetName() .. 'High'):SetText('+');
	getglobal(Juked_IconOptions_Slider:GetName() .. 'Text'):SetText(slidert2[i].."\n数值: "..JukedDB[CharIndex][v]);
	
	if (v == "colsPrio") then
		local val = getTotalPrio("gui");
		Juked_IconOptions_Slider:SetMinMaxValues(0,val+1);
		Juked_IconOptions_Slider:SetValueStep(1.0);
	elseif (v == "scale2") then
		
		Juked_IconOptions_Slider:SetMinMaxValues(0.1,2.0);
		Juked_IconOptions_Slider:SetValueStep(0.1);
	end
	
	local function Juked_IconOptions_Slider_OnShow()
		Juked_IconOptions_Slider:SetValue(JukedDB[CharIndex][v]);
	end

	local function Juked_IconOptions_Slider_OnValueChanged()
		slider_table[i](2,Juked_IconOptions_Slider:GetValue(),"gui");
		getglobal(Juked_IconOptions_Slider:GetName() .. 'Text'):SetText(slidert2[i].."\n数值: "..JukedDB[CharIndex][v]);
	end

	Juked_IconOptions_Slider:SetScript("OnValueChanged", Juked_IconOptions_Slider_OnValueChanged);
	Juked_IconOptions_Slider:SetScript("OnShow", Juked_IconOptions_Slider_OnShow);

	buttonPositionY = buttonPositionY - 60;
end
InterfaceOptions_AddCategory(Juked.priobarpanel);


-- Make a child panel
Juked.profilepanel = CreateFrame( "Frame", "ProfilePanel", Juked.mainpanel);
Juked.profilepanel.name = "配置";
-- Specify childness of this panel (this puts it under the little red [+], instead of giving it a normal AddOn category)
Juked.profilepanel.parent = Juked.mainpanel.name;

local title = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetPoint("TOPLEFT", 20, -10)
title:SetText("主要监视条设置")

local subtitle = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", title, "BOTTOMLEFT", 0, -8)
subtitle:SetPoint("RIGHT", Juked.profilepanel, -32, 0)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("Juked 配置设置")	

buttonPositionY = -60;
buttonPositionX = 20;
local UsingProfileLabel = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontHighlight")
UsingProfileLabel:SetHeight(32)
UsingProfileLabel:SetPoint("TOPLEFT", buttonPositionX,buttonPositionY)
UsingProfileLabel:SetNonSpaceWrap(true)
UsingProfileLabel:SetJustifyH("LEFT")
UsingProfileLabel:SetJustifyV("TOP")
UsingProfileLabel:SetText("当前使用："..CharIndex)	


buttonPositionY=-100
local Juked_Options_EditBox = CreateFrame("EditBox", "Juked_NewProfile_NewID", Juked.profilepanel, "InputBoxTemplate");
Juked_Options_EditBox:SetPoint("TOPLEFT", buttonPositionX+5,buttonPositionY);
Juked_Options_EditBox:SetWidth(125);
Juked_Options_EditBox:SetHeight(32);
Juked_Options_EditBox:EnableMouse(true);
Juked_Options_EditBox:SetAutoFocus(false);
Juked_Options_EditBox_Text = Juked_Options_EditBox:CreateFontString(nil, 'ARTWORK', 'GameFontHighlightSmall');
Juked_Options_EditBox_Text:SetPoint("TOPLEFT", -3, 10);
Juked_Options_EditBox_Text:SetText("新配置名称");


-- New Profile Save Button
local Juked_CreateProfile_SaveButton = CreateFrame("Button", "Juked_ProfileSaveButton",Juked.profilepanel, "OptionsButtonTemplate");
Juked_CreateProfile_SaveButton:SetPoint("TOPLEFT",buttonPositionX+130,buttonPositionY-5);
Juked_CreateProfile_SaveButton:SetWidth(50);
Juked_CreateProfile_SaveButton:SetHeight(21);
Juked_CreateProfile_SaveButton:SetText("保存");

local function CreateNewProfile()
	JukedDB[Juked_Options_EditBox:GetText()]=JukedDB[Juked_Options_EditBox:GetText()] or { scale = 1,scale2=1 , hidden = false,hidden2=false, smart=false, smartPrio=false,prio = false, cols=6, colsPrio=6, arenaOnly=false, bgOnly=false, lock = false,growUp=1,growLeft=1, noCD=false,prioOnly=false,}
	Juked_Options_EditBox:SetText("")
end
Juked_CreateProfile_SaveButton:SetScript("OnClick", CreateNewProfile)


buttonPositionX = buttonPositionX+195
buttonPositionY = -100
local subtitle = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", buttonPositionX+10,buttonPositionY+15)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("使用配置...")
if not DropDownMenuUse then
   CreateFrame("Button", "DropDownMenuUse", Juked.profilepanel, "UIDropDownMenuTemplate")
end
 
DropDownMenuUse:ClearAllPoints()
DropDownMenuUse:SetPoint("TOPLEFT", buttonPositionX-10, buttonPositionY)
DropDownMenuUse:Show()
 
local items = {}

local function OnClick(self)
   UIDropDownMenu_SetSelectedID(DropDownMenuUse, self:GetID())
   JukedDB["CharsUse"][JukedChar.." - "..JukedRealm]=self:GetText()
   CharIndex=self:GetText()
   UsingProfileLabel:SetText("当前使用："..CharIndex)
   Juked_Reset()
end
 
local function initialize(self, level)
items = {};
 	for k,v in pairs(JukedDB) do
		if (type(JukedDB[k]) == "table" and not(k =="CharsUse")) then table.insert(items,k) end
	end
   local info = UIDropDownMenu_CreateInfo()
   for k,v in pairs(items) do
      info = UIDropDownMenu_CreateInfo()
      info.text = v
      info.value = v
      info.func = OnClick
      UIDropDownMenu_AddButton(info, level)
   end
end

UIDropDownMenu_Initialize(DropDownMenuUse, initialize)
UIDropDownMenu_SetWidth(DropDownMenuUse, 160);
UIDropDownMenu_SetButtonWidth(DropDownMenuUse, 180)
UIDropDownMenu_SetSelectedID(DropDownMenuUse, 1)
UIDropDownMenu_JustifyText(DropDownMenuUse, "LEFT")

buttonPositionX = 5
buttonPositionY = buttonPositionY -60

local subtitle = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", buttonPositionX+20,buttonPositionY+15)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("复制于...")

if not DropDownMenuCopy then
   CreateFrame("Button", "DropDownMenuCopy", Juked.profilepanel, "UIDropDownMenuTemplate")
end

DropDownMenuCopy:ClearAllPoints()
DropDownMenuCopy:SetPoint("TOPLEFT", buttonPositionX, buttonPositionY)
DropDownMenuCopy:Show()
 
local function OnClick(self)
   UIDropDownMenu_SetSelectedID(DropDownMenuCopy, self:GetID())
   JukedDB[JukedChar.." - "..JukedRealm]=JukedDB[self:GetText()]
   CharIndex=JukedChar.." - "..JukedRealm
   UsingProfileLabel:SetText("当前使用："..CharIndex)
   Juked_Reset()
end
 
local function initialize(self, level)
items = {};
 	for k,v in pairs(JukedDB) do
		if (type(JukedDB[k]) == "table" and not(k =="CharsUse")) then table.insert(items,k) end
	end
   local info = UIDropDownMenu_CreateInfo()
   for k,v in pairs(items) do
      info = UIDropDownMenu_CreateInfo()
      info.text = v
      info.value = v
      info.func = OnClick
      UIDropDownMenu_AddButton(info, level)
   end
end
 
UIDropDownMenu_Initialize(DropDownMenuCopy, initialize)
UIDropDownMenu_SetWidth(DropDownMenuCopy, 160);
UIDropDownMenu_SetButtonWidth(DropDownMenuCopy, 180)
UIDropDownMenu_SetSelectedID(DropDownMenuCopy, 1)
UIDropDownMenu_JustifyText(DropDownMenuCopy, "LEFT")

buttonPositionX = buttonPositionX+220

local subtitle = Juked.profilepanel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
subtitle:SetHeight(32)
subtitle:SetPoint("TOPLEFT", buttonPositionX,buttonPositionY+15)
subtitle:SetNonSpaceWrap(true)
subtitle:SetJustifyH("LEFT")
subtitle:SetJustifyV("TOP")
subtitle:SetText("删除配置")

if not DropDownMenuDel then
   CreateFrame("Button", "DropDownMenuDel", Juked.profilepanel, "UIDropDownMenuTemplate")
end

DropDownMenuDel:ClearAllPoints()
DropDownMenuDel:SetPoint("TOPLEFT", buttonPositionX-20, buttonPositionY)
DropDownMenuDel:Show()
 
local function OnClick(self)
	JukedDB[self:GetText()]=nil
	if (CharIndex == self:GetText()) then
		if ((JukedChar.." - "..JukedRealm)==self:GetText()) then
			JukedDB["CharsUse"][JukedChar.." - "..JukedRealm]="Default"
			CharIndex="Default"
		else
			CharIndex=JukedChar.." - "..JukedRealm
			if not JukedDB[CharIndex] then
				JukedDB[CharIndex] = JukedDB["Default"]
			end
			JukedDB["CharsUse"][CharIndex]=CharIndex
		end
		UsingProfileLabel:SetText("当前使用："..CharIndex)	
	end
	items = {};
 	for k,v in pairs(JukedDB) do
		if (type(JukedDB[k]) == "table" and not(k =="CharsUse")and not (k == "Default")) then table.insert(items,k) end
	end
	Juked_Reset()
end
 
local function initialize(self, level)
items = {};
 	for k,v in pairs(JukedDB) do
		if (type(JukedDB[k]) == "table" and not(k =="CharsUse")and not (k == "Default")) then table.insert(items,k) end
	end
	local info = UIDropDownMenu_CreateInfo()
	for k,v in pairs(items) do
		info = UIDropDownMenu_CreateInfo()
		info.text = v
		info.value = v
		info.func = OnClick
		UIDropDownMenu_AddButton(info, level)
	end
end
	
UIDropDownMenu_Initialize(DropDownMenuDel, initialize)
UIDropDownMenu_SetWidth(DropDownMenuDel, 160);
UIDropDownMenu_SetButtonWidth(DropDownMenuDel, 180)
UIDropDownMenu_SetSelectedID(DropDownMenuDel, 1)
UIDropDownMenu_JustifyText(DropDownMenuDel, "LEFT")
-- Add the child to the Interface Options
InterfaceOptions_AddCategory(Juked.profilepanel);