﻿----------------------------------------------------------------------------------------------------
-- DroodFocus 4.1.3 - target bar
-- Meranannon - Discordia - Vol'jin (EU)
-- rev 1
----------------------------------------------------------------------------------------------------

local DF = DF_namespace
local _

local frame=nil
local frameTexture=nil

local background=nil
local foreground=nil
local text=nil

local cursor=0
local offset = 1

local timetodieHP =0
local timetodieDps ={0,0,0,0,0,0,0,0,0,0,0}
local timetodie,timetodieDiff =0
local tempo=0
local seconde=1
local dps=0
local countDps=0

local frequency =1/60
local tempo=(frequency/15)*10
local tempo2=0

-- initialisation frames
function DF:init_targetbar_frame()
	
	if not frame then
		
		-- cadre principal
		frame = CreateFrame("FRAME","DF_targetbar_FRAME",DF.anchor[1].frame)
		frame:SetScript("OnMouseDown",function(self,button)
			if button=="LeftButton" then
  			frame:StartMoving()
  		elseif button=="RightButton" then
  			DF:options_show("DFtargetbar",frame)
  		end
		end)
		frame:SetScript("OnMouseUp",function(self,button)
			if button=="LeftButton" then
	  		frame:StopMovingOrSizing()
	  		local anchorx=DF.anchor[1].frame:GetLeft()
	  		local anchory=DF.anchor[1].frame:GetTop()		  			  		
	  		DF_config.targetbar.positionx=DF:alignToGridX(self:GetLeft()-anchorx)
	  		DF_config.targetbar.positiony=DF:alignToGridY(self:GetTop()-anchory)
	  		frame:ClearAllPoints()
	  		frame:SetPoint("TOPLEFT", DF.anchor[1].frame, "TOPLEFT", DF_config.targetbar.positionx, DF_config.targetbar.positiony)
				DF:updateWidgetValue("DFtargetbarleft")
				DF:updateWidgetValue("DFtargetbartop")
		  end
		end)	
		frame:SetScript("OnEnter",function(self,button)
			if DF.configmode then
				DF.DroodFGameTooltip:SetOwner(UIParent, "ANCHOR_TOPLEFT ",16,-16)
				DF.DroodFGameTooltip:ClearLines()
				DF.DroodFGameTooltip:AddLine("DROODFOCUS TARGETBAR",1,1,0,nil)
				DF.DroodFGameTooltip:AddLine(DF.locale["leftMB"],1,1,1,nil)
				DF.DroodFGameTooltip:AddLine(DF.locale["rightMB"],1,1,1,nil)
				DF.DroodFGameTooltip:Show()		
			end		
		end)		
		frame:SetScript("OnLeave",function(self,button)
			if DF.configmode then DF.DroodFGameTooltip:Hide() end
		end)		

		-- cadre pour la texture
		background = CreateFrame("StatusBar","DF_TARGETBAR_BACKGROUND",frame)
		foreground = CreateFrame("StatusBar","DF_TARGETBAR_FOREGROUND",frame)
		text = foreground:CreateFontString("DF_TARGETBAR_TEXT","ARTWORK")
		frameTexture=frame:CreateTexture("DF_TARGETBAR_FRAME_TEXTURE")
		frame:EnableMouse(false)	
	end

	if not DF_config.targetbar.newLevel then
		DF_config.targetbar.newLevel=DF_config.targetbar.level*10
	end
	local level = DF_config.targetbar.newLevel

	-- paramétres cadre principal
	frame:SetMovable(true)
		
	frame:SetWidth(DF_config.targetbar.width)
	frame:SetHeight(DF_config.targetbar.height)
	frame:ClearAllPoints()
	frame:SetPoint("TOPLEFT", DF.anchor[1].frame, "TOPLEFT", DF_config.targetbar.positionx, DF_config.targetbar.positiony)
	--frame:SetFrameLevel(level)

	if DF_config.targetbar.border then
		frameTexture:ClearAllPoints()
		frameTexture:SetAllPoints(frame)
		frameTexture:SetTexture(DF_config.targetbar.borderColor.r, DF_config.targetbar.borderColor.v, DF_config.targetbar.borderColor.b,1)
		frame.texture=frameTexture
	else
		frameTexture:ClearAllPoints()
		frameTexture:SetAllPoints(frame)
		frameTexture:SetTexture(DF_config.targetbar.borderColor.r, DF_config.targetbar.borderColor.v, DF_config.targetbar.borderColor.b,0)
		frame.texture=frameTexture
		
	end

	-- paramétres background
	background:SetWidth(DF_config.targetbar.width-DF_config.targetbar.borderSize*2)
	background:SetHeight(DF_config.targetbar.height-DF_config.targetbar.borderSize*2)
	background:SetPoint("TOPLEFT", frame, "TOPLEFT", DF_config.targetbar.borderSize, -DF_config.targetbar.borderSize)
	background:SetStatusBarTexture(DF_config.targetbar.texturePath)
	background:SetStatusBarColor(0.5, 0, 0, 1)
	background:SetOrientation("HORIZONTAL")
	--background:SetFrameLevel(level+1)

	-- paramétres foreground
	foreground:SetWidth(DF_config.targetbar.width-DF_config.targetbar.borderSize*2)
	foreground:SetHeight(DF_config.targetbar.height-DF_config.targetbar.borderSize*2)
	foreground:SetPoint("TOPLEFT", frame, "TOPLEFT", DF_config.targetbar.borderSize, -DF_config.targetbar.borderSize)
	foreground:SetStatusBarTexture(DF_config.targetbar.texturePath)
	foreground:SetStatusBarColor(1, 0, 0, 1)
	foreground:SetOrientation("HORIZONTAL")
	foreground:SetMinMaxValues(0, 100)
	--foreground:SetFrameLevel(level+2)

	background:SetStatusBarColor(DF_config.targetbar.color.r/3, DF_config.targetbar.color.v/3, DF_config.targetbar.color.b/3, DF_config.targetbar.color.a)
	foreground:SetStatusBarColor(DF_config.targetbar.color.r, DF_config.targetbar.color.v, DF_config.targetbar.color.b, DF_config.targetbar.color.a)
	background:SetOrientation(DF_config.targetbar.orientation)
	foreground:SetOrientation(DF_config.targetbar.orientation)

	--background:GetStatusBarTexture():SetHorizTile(false)
	--foreground:GetStatusBarTexture():SetHorizTile(false)
	
	-- paramétres text
	DF:MySetFont(text,DF_config.targetbar.fontPath,DF_config.targetbar.fontSize)
	text:SetShadowColor(0, 0, 0, 0.75)
	text:SetShadowOffset(0.5, -0.5)
	text:SetTextColor(DF_config.targetbar.textColor.r, DF_config.targetbar.textColor.v, DF_config.targetbar.textColor.b, 1)
	text:SetText("TEST")
	text:ClearAllPoints()
	text:SetPoint(DF_config.targetbar.textAlign, foreground, DF_config.targetbar.textAlign, DF_config.targetbar.textx, DF_config.targetbar.texty)
	
	if not DF_config.targetbar.showText then
		text:Hide()
	else
		text:Show()
	end
	
	if not DF_config.targetbar.enable then 
		frame:Hide()
	else
		frame:Show()
	end
	
	DF:targetbar_clearT2D()
	
end

-- gestion de l'animation
function DF:targetbar_update(elapsed)
	
	if not DF_config.targetbar.enable or not DF:toggle_isEnable() then return end

	local currentForm = DF:currentForm()
	if not DF:form_goofForm(DF_config.targetbar.form,currentForm) then
		frame:Hide()
		return
	else
		frame:Show()
	end

	tempo2=tempo2+elapsed	

	tempo=tempo+elapsed
	if tempo<frequency then return end
	tempo=0	
			
	local current=0
	local value=0
	local maxi=100

	if DF.configmode then
		
		current=50
		maxi=100
		timetodie=0
		
	else
		
		current = UnitHealth("target");		
		maxi = UnitHealthMax("target");

		if tempo2>=1 then
			
			tempo2=0
			
			if (timetodieHP>0) then
				
				timetodieDps[seconde]=timetodieHP-current
				
				dps=0
				countDps=0
				for i = 1,10 do
					if timetodieDps[i]~=nil then
						dps=dps+timetodieDps[i]
						countDps=countDps+1
					end
				end

				if countDps>0 then
					dps=dps/countDps
				else
					dps=0
				end
								
				if dps>0 and countDps>=4 then
					timetodie=(current/dps) -- temps restant a ce dps moyen
				else
					timetodie=0
				end
				
				seconde=seconde+1
				if seconde>10 then seconde=1 end
				
			else
			
				timetodie=0
			
			end
			
			timetodieHP=current;
			
		end
		
	end

	local maxi2=maxi
	if maxi2==0 then
		maxi2=100
	end

	value = 100 * (current/maxi2)
	
	if cursor>value then
		
		cursor = cursor - DF_config.cursorspeed
		if cursor<value then cursor=value end
		
	elseif cursor<value then
		
		cursor = cursor + DF_config.cursorspeed
		if cursor>value then cursor=value end
		
	end
	
	foreground:SetValue(cursor)
	text:SetText(DF:formatText(maxi,current,DF_config.targetbar.sformat,timetodie))
	
end

-- enable/disable déplacement du cadre avec la souris
function DF:targetbar_toogle_lock(flag)
	
	frame:EnableMouse(flag)
	
end

function DF:targetbar_reinit()
	
	DF:init_targetbar_frame()
	DF:targetbar_toogle_lock(DF.configmode)
	DF:options_setLevel()
end

function DF:targetbar_clearT2D()

	timetodieHP =0
	for i = 1,10 do
		timetodieDps[i] =nil
	end
	timetodie=0
	timetodieDiff =0
	seconde=1
	dps=0
	countDps=0	
	
end

function DF:targetbar_setLevel()
	local level = DF_config.targetbar.newLevel			
	DF:setMyFrameLevel(frame,level,"targetbar")
	DF:setMyFrameLevel(background,level+1)
	DF:setMyFrameLevel(foreground,level+2)
end