﻿----------------------------------------------------------------------------------------------------
-- DroodFocus 4.1.3 - spellsList
-- Author : Meranannon - Discordia - Vol'jin (EU)
-- rev 1
----------------------------------------------------------------------------------------------------
-- Liste de sorts prédéfinies
-- Predefined list of spells
----------------------------------------------------------------------------------------------------
local DF = DF_namespace
DF.spellsList ={}
DF.spellsListCheck={}
local _

DF.spellsListspecial ={
	{["texte"]=52610,["valeur"]="52610;62071;155836;127540;174544",["alttexte"]="Savage Roar for Cat",["ltype"]=1},
	{["texte"]=1079,["valeur"]="1079",["alttexte"]="Rip for Cat",["ltype"]=1},
	{["texte"]=155722,["valeur"]="155722;1822",["alttexte"]="Rake for Cat",["ltype"]=1},
	{["texte"]=106830,["valeur"]="106830",["alttexte"]="Trash for Cat",["ltype"]=1},
	{["texte"]=102355,["valeur"]="102355",["alttexte"]="Faerie Swarm",["ltype"]=1},
	{["texte"]=106951,["valeur"]="106952;106951;50334;157269",["alttexte"]="Berzerk",["ltype"]=1},
}

DroodFocusScanToolTip = CreateFrame("GameTooltip","DroodFocusCostToolTip",nil,"GameTooltipTemplate")
DroodFocusScanToolTip:SetOwner(UIParent, "ANCHOR_NONE")

local function EnumerateTooltipLines_helper(spellid,...)
	local Name, _, _, _, _, _ = GetSpellInfo(spellid) 
	--DF:debugLine("Name:",Name)
	if (Name) then
	  for i = 1, select("#", ...) do
	      local region = select(i, ...)
	      if region and region:GetObjectType() == "FontString" then
	          local text = region:GetText() -- string or nil
	          -- analyse le texte pour trouver energie et/ou durée
								
						if (text~=nil) then
	          	
	          	strpos=string.find(text,".nerg")
	          	if (strpos~=nil) then
	          		local costText=string.sub(text,strpos,strpos+15)
	          		local cost=string.match(costText, '%d+')
	          		if (cost~=nil) then
	          			local costNumber=tonumber(cost)
	          			if (costNumber~=nil and costNumber>0) then
	          				DF:setDefautCost(Name,costNumber)
	          			end
	          		end
	          	end
	          	
	          	strIndex=1
	          	while (true) do
		          	strpos=string.find(text,"%ss%.",strIndex)
								if (strpos~=nil) then
									local durationText=string.sub(text,strpos-5,strpos+1)
		          		local duration=string.match(durationText, '%d+')
		          		if (duration~=nil) then
		          			local durationNumber=tonumber(duration)
		          			if (durationNumber~=nil and durationNumber>5) then
		          				DF:setDefautDuration(Name,duration)
		          			end
		          		end
		          		strIndex=strpos+1
		          	else
		          		break
		          	end          	
							end
							
	          	strIndex=1
	          	while (true) do
		          	strpos=string.find(text,"%ssec",strIndex)

								if (strpos~=nil) then

									local durationText=string.sub(text,strpos-5,strpos+1)
		          		local duration=string.match(durationText, '%d+')
		          		if (duration~=nil) then
		          			local durationNumber=tonumber(duration)
		          			if (durationNumber~=nil and durationNumber>5) then
		          				DF:setDefautDuration(Name,duration)
		          			end
		          		end
		          		strIndex=strpos+1
		          	else
		          		break
		          	end          	
							end
	          	
	          end
	      end
	  end
  end
end

function EnumerateTooltipLines(spellid,tooltip) -- good for script handlers that pass the tooltip as the first argument.
    EnumerateTooltipLines_helper(spellid,tooltip:GetRegions())
end

function DF:setToolTipSpellInfo(spellBookId, spellID, bookType)
	DroodFocusScanToolTip:ClearLines()
	DroodFocusScanToolTip:SetSpellBookItem(spellBookId, bookType);
	EnumerateTooltipLines(spellID,DroodFocusScanToolTip)
end

function DF:spellslist_searchTable(spellid)
	local nb=getn(DF.spellsList)
	for i = 1,nb do
		if DF.spellsList[i].valeur==spellid then
			return true
		end
	end
	return false
end

function DF:setDefautDuration(spellid,duration)
	if (DF.defautDuration[spellid]==nil) then
		DF.defautDuration[spellid]={}
	end
	DF.defautDuration[spellid].duration=duration*1
	--DF:debugLine(spellid.." -> duration : ",duration)
end

function DF:setDefautCost(spellid,cost)
	if (DF.defautDuration[spellid]==nil) then
		DF.defautDuration[spellid]={}
	end
	DF.defautDuration[spellid].cost=cost*1
	--DF:debugLine(spellid.." -> cost : ",cost)
end

function DF:getDefautDuration(spellid)
	if (DF.defautDuration[spellid]~=nil) then
		if (DF.defautDuration[spellid].duration~=nil) then
			return DF.defautDuration[spellid].duration*1
		end
	end
	return 0
end

function DF:getDefautCost(spellid)
	if (DF.defautDuration[spellid]~=nil) then
		if (DF.defautDuration[spellid].cost~=nil) then
			return DF.defautDuration[spellid].cost*1
		end
	end
	return 0
end

-- construction de la liste des sorts a partir du grimoire et fusion des 2 listes
-- construction of the list of spells from the spellbook and merging two lists
function DF:spellslist_initTable()

	local lenom,lerang
	local finalname
	local latooltip
	local lid
	local nbIds	
	local temp
	local tnom
	
	if DF.spellsList then
		DF.spellsList=table.wipe(DF.spellsList)
	end

	if DF.spellsListCheck then
		DF.spellsListCheck=table.wipe(DF.spellsListCheck)
	end
	
	local num=1
	
	--for i = 1, GetNumSpellTabs() do
	for i = 1, 2 do
		
	   local name, empty, offset, numSpells = GetSpellTabInfo(i)
	   
	   if not name then
	      break;
	   end
   
	   for s = offset + 1, offset + numSpells do
	   	
	   	local	spell, rank = GetSpellBookItemName(s, BOOKTYPE_SPELL)
	   	local empty, spellId = GetSpellBookItemInfo(s, BOOKTYPE_SPELL)

			if spellId==33917 then
				spellId=33878
			end

			if not IsPassiveSpell(s, BOOKTYPE_SPELL) and not DF:spellslist_searchTable(spellId) then
				
				DF:setToolTipSpellInfo(s, spellId, BOOKTYPE_SPELL)
				
				if rank~="" then
					finalname="(L) "..spell.." ("..tostring(rank)..")"
				else
					finalname="(L) "..spell
				end

				if string.len(finalname)>32 then
					finalname=string.sub(finalname, 1 ,32).."..."
				end

				DF.spellsList[num]={}
				DF.spellsListCheck[num]={}

				latooltip="|cFFFFFF00Sort du livre|cFFFFFFFF\n"
				lenom=GetSpellInfo(spellId)
				if lenom==nil then
					lenom=DF.locale["unknow"]
				end
				latooltip=latooltip.."    "..name..": "..lenom.." ["..tostring(spellId).."]\n"
				
				DF.spellsList[num].lenom=lenom
				DF.spellsList[num].texte=finalname
				DF.spellsList[num].valeur=spellId
				DF.spellsList[num].ltype=1
				DF.spellsList[num].popup=true
				DF.spellsList[num].check=nil
				DF.spellsList[num].tooltip=latooltip

				DF.spellsListCheck[num].lenom=lenom
				DF.spellsListCheck[num].texte=finalname
				DF.spellsListCheck[num].valeur=spellId
				DF.spellsListCheck[num].ltype=1
				DF.spellsListCheck[num].popup=true
				DF.spellsListCheck[num].check=true
				
				if DF_cdsList[spellId]~=nil then
					DF.spellsListCheck[num].check=false
				end
				
				DF.spellsListCheck[num].tooltip=latooltip				
				
				num=num+1
			else
				--DF:debugLine(spell,spellId)
			end

	   end
	   
	end
	
	-- fusion liste special / special fusion list
	local nb=getn(DF.spellsListspecial)
	
	for i = 1,nb do
	
		if DF.spellsListspecial[i].ltype==1 then
			
			lenom,lerang = GetSpellInfo(DF.spellsListspecial[i].texte)
			finalname="(C) "
			latooltip="|cFFFFFF00Sorts prédéfinies|cFFFFFFFF\n"
			if DF.spellsListspecial[i].alttexte then
				latooltip=latooltip..DF.spellsListspecial[i].alttexte.."\n"
			end
			temp=DF:explode ( ";", DF.spellsListspecial[i].valeur )
			nbIds = getn(temp)
			for li = 1,nbIds do
				lid=tonumber(temp[li])
				tnom=GetSpellInfo(lid)
				if tnom==nil then
					tnom=DF.locale["unknow"]
				end
				latooltip=latooltip.."   "..tnom.." ["..tostring(lid).."]\n"
			end
			
		else

			lenom,lerang = GetItemInfo(DF.spellsListspecial[i].texte)
			finalname="(P) "
			latooltip="|cFFFFFF00Proc d'objets|cFFFFFFFF\n"
			if DF.spellsListspecial[i].alttexte then
				latooltip=latooltip..DF.spellsListspecial[i].alttexte.."\n"
			end
			temp=DF:explode ( ";", DF.spellsListspecial[i].valeur )
			nbIds = getn(temp)
			for li = 1,nbIds do
				lid=tonumber(temp[li])
				tnom=GetSpellInfo(lid)
				if tnom==nil then
					tnom=DF.locale["unknow"]
				end
				latooltip=latooltip.."   "..tnom.." ["..tostring(lid).."]\n"
			end			
		end

		if (not lenom or lenom==nil) then
			lenom="Unknow ID["..DF.spellsListspecial[i].texte.."]"
			lerang=""
		end

		DF.spellsList[num]={}
		DF.spellsList[num].lenom=lenom
		
		if string.len(lenom)>32 then
			lenom=string.sub(lenom, 1 ,32).."..."
		end
		
		finalname=finalname..lenom

		DF.spellsList[num].texte=finalname
		DF.spellsList[num].valeur=DF.spellsListspecial[i].valeur
		DF.spellsList[num].ltype=2
		DF.spellsList[num].popup=false
		DF.spellsList[num].check=nil
		DF.spellsList[num].tooltip=latooltip
		
		num=num+1		
		
	end	

	-- trier la liste / sort the list
	local mini=0
	local valeur=""
	local save ={}
	local nb=getn(DF.spellsList)
	
	for i = 1,nb do
		mini=i
		valeur=DF.spellsList[mini].texte
		for j = i,nb do
			if i~=j and DF.spellsList[j].texte<valeur then
				mini=j
				valeur=DF.spellsList[mini].texte
			end
		end
		
		save = DF.spellsList[i]
		DF.spellsList[i]=DF.spellsList[mini]
		DF.spellsList[mini]=save
		
	end

	-- trier la liste / sort the list
	local mini=0
	local valeur=""
	local save ={}
	local nb=getn(DF.spellsListCheck)
	
	for i = 1,nb do
		mini=i
		valeur=DF.spellsListCheck[mini].texte
		for j = i,nb do
			if i~=j and DF.spellsListCheck[j].texte<valeur then
				mini=j
				valeur=DF.spellsListCheck[mini].texte
			end
		end
		
		save = DF.spellsListCheck[i]
		DF.spellsListCheck[i]=DF.spellsListCheck[mini]
		DF.spellsListCheck[mini]=save
		
	end
	
	local SavageRoarName, _, _, _, _, _ = GetSpellInfo(52610) 
	local RipName, _, _, _, _, _ = GetSpellInfo(1079) 
	local RakeName, _, _, _, _, _ = GetSpellInfo(155722) 
	local ThrashName, _, _, _, _, _ = GetSpellInfo(106830) 
	local MoonfireName, _, _, _, _, _ = GetSpellInfo(164812) 
	local SunfireName, _, _, _, _, _ = GetSpellInfo(164815) 
	local MoonfireCatName, _, _, _, _, _ = GetSpellInfo(155625) 
	local LacerateName, _, _, _, _, _ = GetSpellInfo(33745) 
	
	DF:setDefautDuration(SavageRoarName,42)
	DF:setDefautDuration(RipName,24)
	DF:setDefautDuration(RakeName,15)
	DF:setDefautDuration(ThrashName,15)
	DF:setDefautDuration(MoonfireName,20)
	DF:setDefautDuration(SunfireName,20)
	DF:setDefautDuration(MoonfireCatName,14)
	DF:setDefautDuration(LacerateName,15)
		
end

function DF:spellsList_activeCDs()
	local newPt=DF.myArgs
	local lid=tonumber(DF.spellsListCheck[newPt].valeur)
	if DF.spellsListCheck[newPt].check then
		DF_cdsList[lid]=nil
	else
		DF_cdsList[lid]=true
	end
end