﻿----------------------------------------------------------------------------------------------------
-- DroodFocus 5.2.0a - Localization
-- Meranannon - Discordia - Vol'jin (EU)
-- rev 2
----------------------------------------------------------------------------------------------------

local DF = DF_namespace
local coolName = "|cFFFFFF00DroodFocus "..DROODFOCUS_VERSION.."|cFFFFFFFF"
local _

local replaceString=""
.."#meleeAP|"
.."#rangedAP|"
.."#meleeCrit|"
.."#rangedCrit|"
.."#spellCrit|"
.."#meleeHaste|"
.."#rangedHaste|"
.."#spellHaste|"
.."#armor|"
.."#dodge|"
.."#parry|"
.."#block|"
.."#mastery|"
.."#multistrike|"
.."#versatility|"
.."*->New line"

local _

DF.coolName=coolName

-- changelog and reminder text
DF.automaticReminder=false

-- Englais/English (Defaut)
DF.locale = {
	["DF413_REMINDERTEXT"]="\n"
	..coolName.." :\n"
	.."* 6.2 update.\n",
	["versionName"]=coolName,
	["saved"]=coolName.." - Configuration saved: ",
	["loaded"]=coolName.." - Configuration loaded: ",
	["reset"]=coolName.." - Configuration reset to default.",
	["welcome"]=coolName.." - Type '/droodfocus' to show commands.",
	["commands"]= coolName.." Commands :\n/droodfocus options: open main configuration panel\n/droodfocus configmode: swap to configuration mode.\n/droodfocus reset: reset actual configuration.\n/droodfocus buff|debuff: show in the chat a list of actifs buff or debuff with spells ID.\n/droodfocus center: Replace DF at middle of screen.\n/droodfocus practice: Start/stop training mode.\n/droodfocus news: Open changelog.\n/droodfocus report: change kick report chan.\n/droodfocus showspellid: Enables or disables the display of spell id in chat.",
	["locked"]=coolName.." - Configuration mode disabled.",
	["unlocked"]=coolName.." - Configuration mode enabled.",
	["reinit"]=coolName.." - Configuration reset.",
	["badconfig"]=coolName.." - Configuration invalid.",
	["blood"]="blood splatters",
	["iconzoomed"]="Zoomed textures",
	["abiPandemic"]="Flash",
	["abishowGlow"]="Proc",	
	["abiPandemicValue"]="Flash timer",
	["persistence"]="Persistence",
	["scale"]="Scale",
	["active"]="enabled",
	["mode"]="Blending mode",
	["level"]="Frame level",
	["ooc"]="Special FX",
	["positionx"]="Coordinate X",
	["positiony"]="Coordinate Y",
	["width"]="Width",
	["height"]="Height",
	["spacex"]="Offset X",
	["spacey"]="Offset Y",
	["scalemin"]="Scale",
	["speed"]="Speed",
	["scalemax"]="Amplitude",
	["textureOn"]="Active texture",
	["textureOff"]="Inactive texture",
	["alert"]="Warning icon",
	["texture1"]="Texture 'Not behind'",
	["texture2"]="Texture 'Out of range'",
	["texture3"]="Texture 'Aggro'",
	["powerbar"]="Power bar",
	["texturePath"]="Texture",
	["fontPath"]="Font",
	["fontSize"]="Font size",
	["border"]="Borders",
	["color"]="Color",
	["colors"]="Colors",
	["size"]="Size",
	["showText"]="Text enabled",
	["default"]="Default",
	["nrj"]="Energy",
	["rage"]="Rage",
	["mana"]="Mana",
	["texts"]="Texts",
	["numbers"]="Numbers",
	["arrows"]="Arrows",
	["effects"]="Specials effects",
	["parts"]="ADDON'S PARTS",
	["configmode"]="Configuration mode",
	["incombat"]="Visible in combat only",
	["haveTarget"]="Visible if active target",
	["config"]="Config.",
	["healthbar"]="Health bar",
	["colorGood"]="High health",
	["colorAverage"]="Average health",
	["colorBad"]="Low health",
	["text"]="Text",
	["manabar"]="Mana bar",
	["targetbar"]="Target health bar",
	["petbar"]="Pet health bar",
	["defensebar"]="Savage defense",
	["threatbar"]="Threat bar",
	["combo"]="Combo",
	["offsetx"]="Offset X",
	["offsety"]="Offset Y",
	["icons"]="Icons",
	["activeAlpha"]="Active alpha",
	["inactiveAlpha"]="Inactive alpha",
	["timerbar"]="TimerBars",
	["iconbar"]="IconBars",
	["timerange"]="Time range (s)",
	["timeline"]="Time lines",
	["order"]="Sort by timeleft",
	["debuffs"]="(De)Buffs list",
	["automatic"]="Automatic placement",
	["auto"]="Auto. mode",
	["enter"]="Enter",
	["leave"]="Leave",
	["infosmode"]="In configuration mode, you can move UI elements with the mouse and open element's config with rigth click mouse button.",
	["spells"]="Spells list",
	["unknow"]="Unknow",
	["ampspeed"]="Amplitude Speed",
	["grid"]="Grid",
	["aligngrid"]="Align to grid",
	["gridsizex"]="Grid offset X",
	["gridsizey"]="Grid offset Y",
	["none"]="None",
	["TOPLEFT"]="TopLeft",
	["TOP"]="Top",
	["TOPRIGHT"]="TopRight",
	["LEFT"]="Left",
	["CENTER"]="Center",
	["RIGHT"]="Right",
	["BOTTOMLEFT"]="BottomLeft",
	["BOTTOM"]="Bottom",
	["BOTTOMRIGHT"]="BottomRight",
	["align"]="Align",
	["crit"]="Crit",
	["pa"]="PA",
	["infostext"]="Infos format",
	["infos"]="Infos",	
	["hasIcon"]="Create icon",
	["hastimerbar"]="Create bar",
	["ids"]="ID's list",
	["sType"]="Spell type",
	["isPerso"]="Show yours (de)buffs only",
	["toCombo"]="Reflect stack > combo",
	["up"]="Move up",
	["copy"]="Copy",
	["down"]="Move down",
	["new"]="New",
	["kill"]="Delete",
	["infostance"]="Visibility & triggers:",
	["infospell1"]="ID & objects:",
	["infospell2"]="Options:",
	["form0"]="Humanoïd",	
	["form1"]="Stance 1",	
	["form2"]="Stance 2",	
	["form3"]="Stance 3",	
	["form4"]="Stance 4",	
	["form5"]="Stance 5",	
	["form6"]="Stance 6",	
	["form7"]="Stance 7",	
	["orientation"]="Orientation",
	["brokerInfo1"]="Left mouse button to open main configuration panel",
	["brokerInfo2"]="Right mouse button to toggle config mode",
	["background"]="Background",
	["configname"]="Current configuration name",
	["save"]="Save",
	["loadlist"]="Load saved config.",
	["loadspelllist"]="Add predefined spell",
	["DFmainpanel"]="Independent configuration",
	["introduction"]= "DroodFocus All-in-One addon for feral druids.\n* Statut bars : Energy, Rage, Mana, Health.\n* Combo's bar.\n* Buff/Debuff bar.\n\nFor every buff/debuff handle by DroodFocus, a small icon give you time left and number of stack.\n\nDebuffs are filtered to show all debuff or only yours.\nAll talents and glyphes are supported.\n\nThank you to use DroodFocus.\n\n\nMeranannon, Insane (Vol'jin - EU)",		
	["spellid"]="Spell ID",
	["mainmain"]="Configuration panel",
	["anchor"]="Anchor",
	["portrait"]="Portrait",
	["texture"]="Texture",
	["None"]="None",
	["getUptime"]="Watch uptime",
	["cursorspeed"]="Filling speed",
	["showSpark"]="Show spark",
	["first"]=coolName.." - First launch, default configuration loaded.",
	["visible"]="Visible",
	["colonne"]="Nb of columns",
	["colonne2"]="Nb of columns",
	["spellslist"]="Spells book",
	["strongcheck"]="ID scan",
	["cooldown"]="Cooldown pulse",
	["sharemedia"]="ShareMedia",
	["mpath"]="File path",
	["sharemediainfos"]="Adding medias to ShareMedia (reconnection needed).",
	["mtype"]="Media type",
	["add"]="Add",
	["mname"]="Media name",
	["test"]="Test",
	["ptype"]="Fitting",
	["linear"]="Linear",
	["radial"]="Radial",
	["sangle"]="Start angle",
	["eangle"]="End angle",
	["rayon"]="Radius",	
	["gps"]="G.P.S.",
	["toffsetx"]="Text offset X",
	["toffsety"]="Text offset Y",
	["number"]="Time",
	["stack"]="Stack",
	["DFOPTIONSelement"]="Main",
	["leftMB"]="Left mouse button to move",
	["rightMB"]="Right mouse button to open configuration",
	["rightMBanchor"]="Right mouse button to open configuration of this anchor",
	["showcd"]="Cooldown enabled",
	["activeAlphaCD"]="Alpha on CD",
	["cdoffsety"]="CD bar offset Y",
	["cdbar"]="CD Bar",
	["sound"]="Sound",
	["internalcd"]="CoolDown",
	["growup"]="Active spell at top",
	["visibility"]="Visibility & Various",
	["infovisibility"]="All objects visible only under the following conditions:",
	["infovarious"]="Interruptions",
	["inforange"]="Range",
	["infospe"]="Specializations",
	["roundMethod"]="Smallest integral value.",
	["reportkick"]="Show interupts in chan:",
	["reportkickplyonly"]="From player only.",
	["reportkickString"]="Interupt message",
	["prop"]="Proportional bar",
	["prop2"]="Proportional bar",
	["usertext"]="Custom text",
	["spiral"]="Countdown animation",
	["spiral1"]="None",
	["spiral2"]="WoW Standard",
	["spiral3"]="WoW Standard (reverse)",
	["spiral4"]="Rotating before end",
	["pointpa"]="PowerAttack dot",
	["talent"]="Talent tree",
	["talentinfos"]="Assign configuration to a talent tree.",
	["talentinfos2"]="This configuration will be loaded automatically when you change talent tree.",
	["talentinfos3"]="Be careful if you assign a configuration, be sure to save the changes made to this configuration or if they will be lost when you change talent spec.",
	["set"]="Actual",
	["clear"]="None",
	["currenttalent"]="Current configuration set:",
	["pulse"]="Pulse",
	["decimal"]="Show decimal",
	["minimap"]="Show minimap icon",
	["colorchg"]="Dynamic color",
	["target"]="Target",
	["always"]="Always visible",
	["castbar"]="CastBar",
	["sformat"]="String format",
	["normal"]="interruptible spell",
	["interrupt"]="not interruptible spell",
	["interval"]="Minimum interval",
	["AlertShowDebuff"]="Show debuff icons",
	["AlertShowBuff"]="Show buff icons",
	["pulse2"]="Impulsion on activation",	
	["loadconfigansw"]="What do you want to do with current spell list ?",
	["loadconfigkeep"]="Keep",	
	["loadconfigdisc"]="Replace",		
	["bearform"]="Bear form",
	["aquaticform"]="Aquatic form",
	["catform"]="Cat form",
	["travelform"]="Travel form",
	["moonkinform"]="Moonkin",
	["flightform"]="Flight form",
	["Tree"]="Tree of life form",
	["plbuff"]="Player buff",
	["pldebuff"]="Player debuff",
	["tabuff"]="Target buff",
	["tadebuff"]="Target debuff",
	["fobuff"]="Focus buff",
	["fodebuff"]="Focus debuff",
	["pebuff"]="Pet buff",
	["pedebuff"]="Pet debuff",
	["plcombo"]="Combo point",
	["plcustom"]="Custom",
	["arrowpos1"]="Arrow 1 position",
	["arrowpos2"]="Arrow 2 position",
	["arrowpos3"]="Arrow 3 position",
	["arrowpos4"]="Arrow 4 position",
	["arrowpos5"]="Arrow 5 position",
	["arrowpos6"]="Arrow 6 position",
	["practiceupd"]="Practice over. Do you want to add news spells list to current list ?",
	["practicemode"]="Practice mode.",
	["practicewindow"]="Practice",
	["practiceCheckBuff"]="Check buff.",
	["practiceCheckDebuff"]="Check debuff.",
	["practiceCheckAura"]="Check aura too.",
	["repyes"]="YES",
	["repno"]="NO",
	["stackup1"]="Stack bars above anchor.",
	["stackup2"]="Stack bars above anchor.",
	["anim"]="special FX",
	["power"]="Power",
	["alpha"]="Opacity",
	["begin"]="opening",
	["middle"]="active",
	["end"]="closing",
	["rotate"]="Rotation",
	["infospos"]="Position",
	["infoscale"]="Scale",
	["infoalpha"]="Opacity",
	["infospeed"]="FX speed",
	["infopulse"]="FX Pulse",
	["infossize"]="FX Size and texture",
	["chaker"]="Chaker",
	["animatic"]="Load animation preset",
	["fake"]="Test",
	["fxname"]="FX name",
	["customtexture"]="Custom texture",
	["timer"]="Timer",
	["small"]="small model",
	["above"]="above FX",
	["eclipsebar"]="Eclipse bar",
	["lunaire"]="Lunar",
	["solaire"]="Solar",
	["copy"]="Copy",
	["paste"]="Paste",
	["infosize"]="Sizes",
	["NotInRaid"]="Disabled in raid.",
	["bar1"]="Bars 1",
	["bar2"]="Bars 2",
	["fxstack"]="Nb of stack",
	["comboreq"]="Nb of combo points",
	["showdottimer"]="Dot timer enabled",
	["wheel"]="Wheel",
	["optionsscale"]="Options windows scale.",
	["ctrlrightMB"]="Ctrl+Right mouse button to open spell configuration",
	["luacode"]="LUA code",
	["combotextures"]="Combo points textures",
	["combo_cat_off"]="Cat/rogue/default inactive",
	["combo_cat_on"]="Cat/rogue/default active",
	["combo_bear_off"]="Bear inactive",
	["combo_bear_on"]="Bear active",
	["combo_rune_blood_off"]="Blood rune inactive",
	["combo_rune_blood_on"]="Blood rune active",
	["combo_rune_frost_off"]="Frost rune inactive",
	["combo_rune_frost_on"]="Frost rune active",
	["combo_rune_unholy_off"]="Unholy rune inactive",
	["combo_rune_unholy_on"]="Unholy rune active",
	["combo_holy_off"]="Holy power inactive",
	["combo_holy_on"]="Holy power active",
	["timerformat"]="Format m:ss",
	["LuaSnippets"]="Lua code",
	["TimerLimit"]="Timer thresold",
	["RdyMode"]="'Ready' mode",
	["abiWarn"]="CD timer alert",	
	["rdyIn"]="Ready in ",	
	["rdy"]="Ready!",		
	["kicked"]="kicked",
	["deleteconfigansw"]="Delete saved configuration :",	
	["offmode"]="Trigger when",
	["fxmodeactive"]="(de)buff active",
	["activedefault"]="Active by default",
	["fxmodeinactive"]="(de)buff inactive",
	["fxmodeactivet"]="(de)buff active on target",
	["fxmodeinactivet"]="(de)buff inactive on target",	
	["fxmodenocd"]="Abilities not under CD",	
	["fxmodecd"]="Abilities under CD",		
	["talents"]="Specialization",
	["stackbars"]="Stacking method",
	["defenseCharge"]="Savage defense charge",
	["defense_off"]="Charge available",
	["defense_on"]="Charge not available",
	["defense_norage"]="No rage",
	["defensecount"]="Max number of charges",
	["notMounted"]="Don't show when mounted",
	["Allspecs"]="All specs",
	["Primaryspec"]="Primary spec",
	["Secondaryspec"]="Secondary spec",
	["loadspellconfigansw"]="Replace actual spell list ?",
	["practiceinfos"]="Training mode allows DroodFocus to learn spells during a session on a dummy.",
	["RDY"]="OK",
	["iconsRdyText"]="'Ready' text",
	["FadeIn"]="Fade in ",
	["BuffGain"]="Active",
	["SoundWarning"]="Timer warning",
	["warningtext"]="Alert: Icon and text",
	["SoundWarningFile"]="Alert: Sound",
	["useInternalCombo"]="Internal counter (GFX)",
	["useInternalComboText"]="Internal counter (TXT)",
	["BuffWarning"]="Icon buff",
	["sensInf"]="Inferior or equal",
	["sensEgale"]="Equal",
	["sensSup"]="Superior",
	["TimerLimitSens"]="-> Check if value is",
	["abiVieLimite"]="Health limit",
	["IconActive"]="Icon active",
	["IconInactive"]="Icon inactive",
	["IconInactiveCD"]="Icon on CD",
	["configPrimarySpe"]="Primary spe config",
	["configSecondarySpe"]="Secondary spe config",
	["notarget"]="No target",
	["DFdotTracker"]="Dots tracker",
	["dotsList"]="Dots list",
	["DFdotPower"]="Dots power",
	["redColor"]="Lower power",
	["yellowColor"]="Same power",
	["greenColor"]="Greater power",
	["cap"]="threshold",
	["dotcolor"]="colored dot",
	["textDynamicColor"]="Automatic color",
	["no"]="No",
	["yes"]="Yes",
	["fBtoT"]="From bottom",
	["fTtoB"]="From top",
	["fLtoR"]="From left",
	["fRtoL"]="From right",
	["progressTexture"]="Progressive texture",
	["progressTextureFill"]="Filling mode",
	["fill"]="Fill",
	["empty"]="Empty",
	["gfx"]="Graphic",
	["txt"]="Text",
	["export"]="Export this spell",
	["import"]="Import a spell",
	["objscale"]="Gfx scale",
	["txtscale"]="Text scale",
	["floatmode"]="(Floating mode)",
	["dots"]="Little dots",
	["bigdots"]="Main dot",
	["PBautocolor"]="Automatic color",
	["PBpart"]="Limit",
	["inRange"]="Target range",
	["noRange"]="Not used",
	["mustInRange"]="Must be in range",
	["mustOutRange"]="Must be out of range",
	["aboveIcon"]="Texture above icon",
	["bigdotsValue"]="Value to shown",
	["BigdotsValue1"]="Ratio in %",
	["BigdotsValue2"]="Debuff power",
	["BigdotsValue3"]="Current power",
	["BigdotsValue4"]="Difference",
	["range1"]="Friendly target",
	["range2"]="Enemy target",
	["flashWhenOff"]="Animation when inactive",
	["flashWhenOffChoice1"]="Flashing",
	["flashWhenOffChoice2"]="Flashing but only in combat",
}

DF.help ={
	["ID's list"]="List of Spells ID|Multiple IDs possible, separated by a semicolon.|All ID are used to retrieve timeleft,stack,etc...|But ONLY the first ID will be used to load the texture of the icon and to retrieve CoolDown.| |For 'Custom' spell type, the ID is only used for the texture of the icon.",
	["abiPandemic"]="Flash|Icon flashing below timer",
	["abishowGlow"]="Proc|Hilighting effect after a proc is visible",
	["abiPandemicValue"]="Flash timer|timer in seconds",
	["Level"]="Level|Set the level of this frame (determines which of overlapping frames shows on top).|Higher numbers always show up on top of lower numbers.",
	["LevelObj"]="Level|Set the level of floating icon, floating bar and FX (determines which of overlapping frames shows on top).|Higher numbers always show up on top of lower numbers.",
	["Blend mode"]="Blend mode|Blend mode of the texture.|Adds texture color values to the underlying color values, using the alpha channel;|Light areas in the texture lighten the background while dark areas are more transparent.",
	["Spell ID"]="Spell ID|ID of the spell will trigger the effect.|You can find SpellID on http://www.wowhead.com.",
	["Text offset"]="Offset|Offset of text to anchor.",
	["iconzoomed"]="Zoomed textures|Icons textures are zoomed",
	["Point offset"]="Offset|Space between each point.",
	["Scale"]="Scale|Zoom level.",
	["Persistence"]="Persistence|The time that the texture will remain visible.",
	["Infos format"]="String format|Following strings will by replaced by theirs values:|"..replaceString,
	["Slide speed"]="Slide speed|In automatic mode, the icons slide to their positions at the selected speed.",
	["Automatic placement"]="Automatic placement|In this mode the icons are stored automatically.",
	["Sort by timeleft"]="Sort by timeleft|In automatic mode, the spells can be sorted by time remaining.",
	["Alpha"]="Alpha|Sets the alpha (transparency).",
	["Time range"]="Time range|Specifies the time range in seconds for bars.",
	["Time lines"]="Time lines|Indicates whether the lines represent the running time are displayed.",
	["Arrows"]="Arrows|Indicates whether the arrows on the power bar are visible.",
	["Spell type"]="Spell type|Indicates if this is a player/target buff or debuff or custom spell.",
	["Uptime"]="Uptime|Indicates whether the uptime of spells is tracked.|Uptime indicates how long the buff/debuff has been active during the fight.|type '/droodfocus uptime' after a fight to see summary.| |Warning! only accurate on dummy, swapping or lost target will corrupt uptime.",
	["Scan spell"]="Spell filtering|To check your debuff only.",
	["Stack > Combo"]="Stack > Combo|If checked, numbers of combo points following numbers of stack of the spell.",
	["Cursor speed"]="Spark speed|Statusbars are progressive. This is the moving speed of spark.",
	["Stance"]="Stance|Changes depending on the player class.|All stances aren't available for all classes.",
	["Humanoïd"]="Default stance|Available for all classes.",
	["spark"]="Spark|Indicates whether the spark at the end of the bar is visible.",
	["speed"]="Amplitude speed.",
	["position"]="Coordinate|Relative to anchor.",
	["iposition"]="Coordinate|Relative to anchor. Not used if icons placement is automatic.",
	["isize"]="Sizes|size  of icons.",
	["colonne"]="columns|For automatic mode, number of icons per line.",	
	["spellslist"]="Spells book|Click to add spellID to the editBox.",
	["strongcheck"]="ID scan|The spells scanned must exactly match the Id.|Most often not checked. By default, just the name of (de)buff is used.|But for certain spells the names are the same|The strict verification allows to distinguish this spells.",
	["mpath"]="File path|The path to the file. of the form:|  \\\\Interface\\\\AddOns\\\\DroodFocus\\\\datas\\\\statusbar.tga| |Warning! the file must be present in the directory before launching WoW.|Otherwise it will not be valid.",
	["mname"]="Media name|The name who appear in the list.",
	["mtype"]="Media type|The filetype handle by ShareMedia.",
	["ptype"]="Fitting|Method of fitting points.",
	["gps"]="G.P.S.|Shows the direction where is located the raid member targeted.|Only works for players of your raid.",
	["sound"]="Sounds|Play sound when player leaving combat.",
	["internalcd"]="CoolDown|CoolDown in seconde (0 = no CD)|For spell with no base CD (like trinket)|Override base CD.",
	["growup"]="Active spells at top|Active spells appear above inactive spells.",
	["abiSound"]="Spell sound|Play sound when buff/debuff is gain or apply.",
	["prop"]="Proportional Bars|By default, the bars covering a range of fixed time. | In this mode, the bar are proportionals to the remaining time from 0 to 100%.",	
	["blood"]="Blood splatters|Appears after a critical hit.",
	["infos"]="Infos|Displays real-time stats.",
	["ooc"]="Special FX|special effect when the buff proc.",
	["alert"]="Warning icon|Appears if you're too far or the wrong side of the target. Also shows buffs/debuffs earned.",
	["portrait"]="Portrait|Displays texture depending on the stance/form.",
	["cooldown"]="Cooldown pulse|flashes the icon of the ability whenever it becomes usable again.",
	["combo"]="Combo|Shows combo points for Druids / Rogues and runes for DeathKnights.",
	["usertext"]="Custom text|Replace default text in lists and bars.",
	["spiral"]="Countdown animation|Visual representation of the countdown.",	
	["showcd"]="Cooldown enabled|Indicates whether the cooldown is enabled.",	
	["align"]="Align|Reference point for the position of the object.",	
	["pointpa"]="Dots power|Point at top right indicates by a color if you can put a more powerfull debuff than actual one.|A red dot indicates that your power is less than current debuff.|A gray dot indicates that your power is the same.|A green dot indicates that your power is greater than actual debuff.| |In addition, in the bottom, 3 dots show if debuff has been put with savage roar (red), tiger fury (yellow) and Bloodtalons (blue).| |Option must be activated in icons/bars to be visible.",
	["pointpatext"]="Dots power|Show value in text too.",
	["pointpabars"]="Puissance des dots|Bar color change if you can put a more powerfull debuff than actual one.|Red indicates that your power is less than current debuff.|Gray indicates that your power is the same.|Green indicates that your power is greater than actual debuff.",
	["pulse"]="Pulse|The icons are zoomed at the application of spell. This indicates the power of zoom.",	
	["pulse2"]="Pulse|Power of impulsion.",	
	["decimal"]="Show decimal|Show decimal when timer < 3 sec.",
	["colorchg"]="Dynamic color|Color change with health points.",
	["target"]="Target|The unit used for localisation.",
	["always"]="Always visible|Visible in all form/aura.",
	["castbar"]="Cast bar|Show spell casting/channeling by your actual target.",
	["sformat"]="Text format|Following string will be replace by respective values|#m: Maximum value.|#c: Current value.|#p: Percentage.|#M: Maximum value in k.|#C: Current value in k.|#P: Percentage with decimal.|#t: Time to die in m:ss.",	
	["interval"]="Minimum interval|Minimum interval to update bar.",
	["arrowposition"]="Arrow position|Energy value indicated by the arrow.|-1 to desactivate arrow.",
	["anim"]="Animation type|Define type of animation.",
	["customtexture"]="Custom texture|Without pathfile, texture from 'custom' directory.",
	["fxstack"]="Number of stack|Minimum number of stack require to activate object.",
	["comboreq"]="Number of combo points|Minimum number of combo point require to activate object.",
	["showdottimer"]="Dot timer|Enable/disable timer between each tic.",
	["editableTexture"] = "Texture|Select texture in predefinited list|or enter filename (filename without path will take file into DroodFocus 'custom' directory) or SpellID to use texture of spell.",
	["LuaSnippetsHelp"]="Lua code|Somes lua code exemples.|NB: Actual code will be replaced by new one.",
	["iTimerLimit"]="Timer thresold|Inactive if time left don't check condition0 (0 = no limit).",
	["roundMethod"]="Smallest integral value|If selected (by default), floating-point numbers are rounded to the Smallest integral value (0.75 give 0)|else they are rounded to the greatest integral value (0.75 give 1).",	
	["RdyMode"]="'Ready' mode|Icon/bar shown as active if the spell isn't under CD",
	["abiWarn"]="CD timer alert|Alert when CD reach the limit (in sec. 0 = No alert)",
	["talents"]="Specialization|Active only in specified spec.",
	["defenseCharge"]="Savage defense count|For bear, Show number of charges instead combo points.",
	["defensespellid"]="Savage defense|Spell ID to use to retrive charges.",
	["normalCast"]="Cast bar|Play sound if spell is interruptible.",
	["interruptCast"]="Cast bar|Play sound if spell is not interruptible.",
	["SoundWarning"]="Timer warning|Alert when time left reach the limit (0=no warning).",	
	["useInternalCombo"]="Internal counter (GFX)|(only for cat)|Use internal combo points counter for graphical mode.",
	["useInternalComboText"]="Internal counter (TXT)|(only for cat)|Use internal combo points counter for text mode.",
	["BuffWarning"]="Icon buff|Show icon when you gain the buff.",
	["abiVieLimite"]="Health limit|Inactive if target health (in %) don't check condition (0 = no limit).",
	["configPrimarySpe"]="Primary/secondary spe config|Configuration to load when specialization activated.",
	["reportkickString"]="Interupt message|Message to show|#SPELL will be replaced by spell name.|#FROM will be replaced by source name.|#WHO will be replaced by who interupt spell.",
	["dotTracker"]="Dots tracker|List of active dots on multiple target.",
	["dotsList"]="Dots list|List of tracked dots : spell id separated by a semi-colon.",
	["cap"]="threshold|threshold for a more powerfull debuff (in %).",
	["textDynamicColor"]="Automatic color|Color depending on the threshold.",
	["progressTexture"]="Progressive texture|Texture progressively drawing according to the timer.",
	["objscale"]="Gfx scale|Scale of the texture. Only for float object.",
	["txtscale"]="Text scale|Scale of texts. Only for float object.",
	["inRange"]="Target range|By default, melee range for enemy target and spell range for friendly target.|Configurable in 'visibility' module.",
	["rangeid"]="Range|SpellID used to check if player is in range.",
}

if (GetLocale() == "frFR") then
	-- Français/French
	DF.locale = {
		["DF413_REMINDERTEXT"]="\n"
		..coolName.." :\n"
		.."* Mise à jour 6.2.\n",
		["versionName"]=coolName,
		["saved"]=coolName.." - Configuration sauvée: ",
		["loaded"]=coolName.." - Configuration chargée: ",
		["reset"]=coolName.." - Configuration reset.",
		["welcome"]=coolName.." - Taper '/droodfocus' pour voir les commandes.",
		["commands"]= coolName.." Commandes :\n/droodfocus options: ouvre le panneau de config principal.\n/droodfocus configmode: bascule en mode de configuration.\n/droodfocus reset: reset la configuration actuelle.\n/droodfocus buff|debuff: affiche dans le chat la liste des buff ou debuff actifs avec l'ID des sorts.\n/droodfocus center: Replacer DF au milieu de l'écran.\n/droodfocus practice: Démarre/arrête le mode d'entrainement.\n/droodfocus news: Voir le changelog.\n/droodfocus report: modifier le channel pour le report des interruptions.\n/droodfocus showspellid: Active ou desactive l'affichage de l'id dans le chat.",
		["locked"]=coolName.." - Mode de configuration désactivé.",
		["reinit"]=coolName.." - Nettoyage de la configuration complet.",
		["badconfig"]=coolName.." - Configuration invalide. Version trop ancienne.",
		["unlocked"]=coolName.." - Mode de configuration activé.",
		["blood"]="Tâches de sang",
		["iconzoomed"]="Textures zoomées",		
		["persistence"]="Persistence",
		["abiPandemic"]="Flash",
		["abishowGlow"]="Proc",	
		["abiPandemicValue"]="Flash timer",		
		["scale"]="Echelle",
		["active"]="Activé",
		["spacex"]="Espacement X",
		["spacey"]="Espacement Y",
		["mode"]="Mode affichage",
		["level"]="Niveau du cadre",
		["ooc"]="Effet spécial",
		["positionx"]="Position X",
		["positiony"]="Position Y",
		["width"]="Largeur",
		["height"]="Hauteur",
		["scalemin"]="Echelle",
		["texts"]="Textes",
		["numbers"]="Nombres",
		["scalemax"]="Amplitude",
		["speed"]="Vitesse",
		["textureOn"]="Texture quand active",
		["textureOff"]="Texture quand inactive",
		["alert"]="Icone d'alerte",
		["texture1"]="Texture 'Derriére la cible'",
		["texture2"]="Texture 'Hors de portée'",
		["texture3"]="Texture 'Aggro'",
		["powerbar"]="Barre de puissance",
		["texturePath"]="Texture",
		["fontPath"]="Police",
		["fontSize"]="Taille police",
		["border"]="Bordures",
		["color"]="Couleur",
		["colors"]="Couleurs",
		["size"]="Taille",
		["showText"]="Texte activé",
		["default"]="Défaut",
		["nrj"]="Energie",
		["rage"]="Rage",
		["mana"]="Mana",
		["arrows"]="Fléches",
		["effects"]="Effects spéciaux",
		["parts"]="ELEMENTS DE L'ADDON",
		["configmode"]="Mode de configuration.",
		["incombat"]="Visible en combat uniquement",
		["haveTarget"]="Visible si cible active",
		["config"]="Config.",
		["healthbar"]="Barre de vie",
		["colorGood"]="Vie haute",
		["colorAverage"]="Vie moyenne",
		["colorBad"]="Vie basse",
		["text"]="Texte",
		["manabar"]="Barre de mana",
		["targetbar"]="Barre vie cible",
		["petbar"]="Barre vie familier",
		["defensebar"]="Défense sauvage",
		["threatbar"]="Barre de menace",
		["combo"]="Combo",
		["offsetx"]="Décalage X",
		["offsety"]="Décalage Y",
		["icons"]="Icones",
		["activeAlpha"]="Transparence active",
		["inactiveAlpha"]="Transparence inactive",
		["timerbar"]="Barres de temps",
		["iconbar"]="Barres d'icône",
		["timerange"]="Plage de temps (s)",
		["timeline"]="Lignes de temps",
		["order"]="Trier par temps restant",
		["debuffs"]="Liste (De)Buffs",
		["automatic"]="Placement automatique",
		["auto"]="Mode auto.",
		["enter"]="Entrer",
		["leave"]="Quitter",
		["infosmode"]="Dans le mode de configuration, vous pouvez déplacer les éléments à la souris et ouvrir la config de celui-çi avec le bouton droit de la souris.",
		["spells"]="Liste des sorts",
		["unknow"]="Inconnu",
		["grid"]="Grille",
		["aligngrid"]="Aligner sur la grille",
		["gridsizex"]="Grille pas X",
		["gridsizey"]="Grille pas Y",
		["none"]="Aucun",
		["TOPLEFT"]="Haut Gauche",
		["TOP"]="Haut",
		["TOPRIGHT"]="Haut Droite",
		["LEFT"]="Gauche",
		["CENTER"]="Centre",
		["RIGHT"]="Droite",
		["BOTTOMLEFT"]="Bas Gauche",
		["BOTTOM"]="Bas",
		["BOTTOMRIGHT"]="Bas Droite",
		["align"]="Alignement",
		["crit"]="Crit",
		["pa"]="PA",
		["infostext"]="Format infos",
		["infos"]="Infos",	
		["hasIcon"]="Créer une icone",
		["ids"]="Liste IDs",
		["hastimerbar"]="Créer une barre de temps",
		["sType"]="Type de sort",
		["isPerso"]="Uniquement vos (de)buffs",
		["toCombo"]="Refléte nb stack > combo",
		["up"]="Monter",
		["copy"]="Copier",
		["down"]="Desc.",
		["new"]="Nouveau",
		["kill"]="Effacer",	
		["infostance"]="Visibilité & activation: ",
		["infospell1"]="ID & objets:",
		["infospell2"]="Options:",
		["form0"]="Humanoïde",	
		["form1"]="Posture 1",	
		["form2"]="Posture 2",	
		["form3"]="Posture 3",	
		["form4"]="Posture 4",	
		["form5"]="Posture 5",	
		["form6"]="Posture 6",
		["form7"]="Posture 7",
		["orientation"]="Orientation",
		["brokerInfo1"]="Clic gauche pour ouvrir le panneau de configuration principal",
		["brokerInfo2"]="Clic droit pour basculer le mode de configuration",
		["background"]="Fond",
		["configname"]="Nom de la configuration actuelle",
		["save"]="Sauver",
		["loadlist"]="Charger config. sauvée",
		["loadspelllist"]="Ajouter un sort prédéfinie",
		["DFmainpanel"]="configuration indépendante",
		["introduction"]= "DroodFocus rassemble toutes les infos utiles pour le druide féral.\n* Barres d'état : Energie, Rage, Mana, Vie.\n* Barre de Combo.\n* Barre de Buff/Debuff\n\nPour chaque buff/debuff gérés par DroodFocus, une petite icone\n(ou une barre d'état) indique le temps restant sur le debuff et le nombre de stack.\n\nLes debuffs sont filtrés pour gérer toutes les sources ou que les votres. Tous les talents et glyphes sont supportés.\n\nMerci d'utiliser DroodFocus.\n\n\nMeranannon, Insane (Vol'jin - EU)",
		["spellid"]="ID du sort",
		["mainmain"]="Panneau de configuration",
		["anchor"]="Ancre",
		["portrait"]="Portrait",
		["texture"]="Texture",
		["None"]="Vide",
		["getUptime"]="Surveiller uptime",
		["cursorspeed"]="Vitesse de l'étincelle",
		["showSpark"]="Voir étincelle",
		["first"]=coolName.." - Premier lancement, configuration par défaut chargée.",
		["visible"]="Contenu visible",
		["ampspeed"]="Vitesse amplitude",
		["colonne"]="Nb colonnes",
		["colonne2"]="Nb colonnes",
		["spellslist"]="Grimoire",
		["strongcheck"]="Scan par ID",
		["cooldown"]="Fin de cooldown",
		["sharemedia"]="ShareMedia",
		["mpath"]="Chemin d'accès",
		["sharemediainfos"]="Ajouter des médias à ShareMedia (reconnexion nécessaire).",
		["mtype"]="Type de média",
		["add"]="Ajouter",
		["mname"]="Nom du media",
		["test"]="Test",
		["ptype"]="Agencement",
		["linear"]="Lineaire",
		["radial"]="Radial",
		["sangle"]="Angle départ",
		["eangle"]="Angle fin",		
		["rayon"]="Rayon",	
		["gps"]="G.P.S.",
		["toffsetx"]="Offset X du texte",
		["toffsety"]="Offset Y du texte",
		["number"]="Temps",
		["stack"]="Stack",
		["DFOPTIONSelement"]="Principale",
		["leftMB"]="Bouton gauche pour déplacer",
		["rightMB"]="Bouton droit pour ouvrir la configuration",
		["rightMBanchor"]="Bouton droit pour ouvrir la configuration de cette ancre",
		["showcd"]="Cooldown activé",
		["activeAlphaCD"]="Transparence sous CD",
		["cdoffsety"]="Offset Y de la barre de CD",
		["cdbar"]="Barre de CD",
		["sound"]="Son",
		["internalcd"]="CoolDown",
		["growup"]="Sorts actifs en tête",
		["visibility"]="Visibilité et autres",
		["infovisibility"]="Ensemble des objets visible uniquement dans les conditions suivantes:",
		["infovarious"]="Interruptions",
		["inforange"]="Portée",
		["infospe"]="Spécialisations",
		["roundMethod"]="Arrondi inférieur.",
		["reportkick"]="Afficher interruptions dans chan:",
		["reportkickplyonly"]="Du joueur seulement.",
		["reportkickString"]="Message d'interruption",
		["prop"]="Barre proportionnelle",	
		["prop2"]="Barre proportionnelle",	
		["usertext"]="Texte personnalisé",
		["spiral"]="Animation du compte à rebours",
		["spiral1"]="Aucune",
		["spiral2"]="WoW standard",		
		["spiral3"]="WoW standard (inversé)",		
		["spiral4"]="Rotation avant expiration",
		["pointpa"]="Point puissance d'attaque",
		["talent"]="Arbre de talent",
		["talentinfos"]="Attribuer une configuration à un arbre de talent.",
		["talentinfos2"]="Cette configuration sera chargée automatiquement au changement de spé.",
		["talentinfos3"]="Attention si vous attribuez une configuration, veillez a bien sauver les changements fait a cette configuration ou sinon ils seront perdus quand vous changerez de spé.",
		["set"]="Actuelle",
		["clear"]="Aucune",	
		["currenttalent"]="Configuration actuelle:",
		["pulse"]="Impulsion",
		["decimal"]="Voir décimal",
		["minimap"]="Voir l'icône de la minimap",
		["colorchg"]="Couleur dynamique",
		["target"]="Cible",
		["always"]="Toujours visible",
		["castbar"]="Barre d'incantation",
		["sformat"]="Formatage du texte",
		["normal"]="sort interruptible",
		["interrupt"]="sort non interruptible",
		["interval"]="Interval minimum",
		["AlertShowDebuff"]="Voir icône des debuffs",
		["AlertShowBuff"]="Voir icône des buffs",
		["pulse2"]="Impulsion à l'activation",
		["loadconfigansw"]="Que voulez-vous faire de la liste des sorts actuelle ?",
		["loadconfigkeep"]="Garder",	
		["loadconfigdisc"]="Remplacer",	
		["bearform"]="Forme d'ours",
		["aquaticform"]="Forme aquatique",
		["catform"]="Forme de félin",
		["travelform"]="Forme de voyage",
		["moonkinform"]="Forme de sélénien",
		["Tree"]="Forme d'arbre de vie",
		["flightform"]="Forme de vol",
		["plbuff"]="Buff joueur",
		["pldebuff"]="Debuff joueur",
		["tabuff"]="Buff cible",
		["tadebuff"]="Debuff cible",
		["fobuff"]="Buff focus",
		["fodebuff"]="Debuff focus",
		["pebuff"]="Buff pet",
		["pedebuff"]="Debuff pet",	
		["plcombo"]="Point de combo",
		["plcustom"]="Personnalisé",		
		["arrowpos1"]="Position fléche 1",
		["arrowpos2"]="Position fléche 2",
		["arrowpos3"]="Position fléche 3",
		["arrowpos4"]="Position fléche 4",								
		["arrowpos5"]="Position fléche 5",
		["arrowpos6"]="Position fléche 6",
		["practiceupd"]="Entrainement terminé. Voulez vous ajouter les nouveaux sorts à la liste actuelle ?",
		["practicemode"]="Mode entrainement.",
		["practicewindow"]="Entrainement",
		["practiceCheckBuff"]="Surveiller les buffs.",
		["practiceCheckDebuff"]="Surveiller les debuffs.",
		["practiceCheckAura"]="Surveiller aussi les auras.",	
		["repyes"]="OUI",
		["repno"]="NON",	
		["stackup1"]="Barres au dessus de l'ancre.",
		["stackup2"]="Barres au dessus de l'ancre.",
		["anim"]="Effet special",
		["power"]="Puissance",
		["alpha"]="Transparence",
		["begin"]="Ouverture",
		["middle"]="active",
		["end"]="fermeture",	
		["rotate"]="Rotation",
		["infospos"]="Position",
		["infoscale"]="Echelle",
		["infoalpha"]="Transparence",
		["infospeed"]="FX Vitesse",
		["infopulse"]="FX Impulsion",
		["infossize"]="FX Dimensions et texture",	
		["chaker"]="'Chaker'",
		["animatic"]="Charger une animation",
		["fake"]="Tester",
		["fxname"]="FX Nom",
		["customtexture"]="Texture personnalisée",
		["timer"]="Timer",
		["small"]="petit modéle",
		["above"]="au dessus de l'effet",
		["eclipsebar"]="barre d'Eclipse",
		["lunaire"]="Lunaire",
		["solaire"]="Solaire",
		["copy"]="Copier",
		["paste"]="Coller",	
		["infosize"]="Dimensions",
		["NotInRaid"]="Desactivé en raid.",
		["bar1"]="Barres 1",
		["bar2"]="Barres 2",
		["fxstack"]="Nb de stack",
		["comboreq"]="Nb de pts de combo",		
		["showdottimer"]="Timer pour les dots activé",
		["wheel"]="Chrono",
		["optionsscale"]="Echelle fenêtres d'options.",
		["ctrlrightMB"]="Ctrl+Bouton droit pour ouvrir la configuration du sort",
		["luacode"]="Code Lua",	
		["combotextures"]="Combo points textures",
		["combo_cat_off"]="Chat/voleur/défaut inactif",
		["combo_cat_on"]="Chat/voleur/défaut actif",
		["combo_bear_off"]="Ours inactif",
		["combo_bear_on"]="Ours actif",
		["combo_rune_blood_off"]="Rune de sang inactif",
		["combo_rune_blood_on"]="Rune de sang actif",
		["combo_rune_frost_off"]="Rune de givre inactif",
		["combo_rune_frost_on"]="Rune de givre actif",
		["combo_rune_unholy_off"]="Rune impie inactif",
		["combo_rune_unholy_on"]="Rune impie actif",
		["combo_holy_off"]="Rune sacré inactif",
		["combo_holy_on"]="Rune sacré actif",
		["timerformat"]="Format m:ss",	
		["LuaSnippets"]="Code lua",
		["TimerLimit"]="Temps minimum",	
		["RdyMode"]="'Ready' mode",
		["abiWarn"]="CD Alerte timer",	
		["rdyIn"]="Prêt dans ",
		["rdy"]="Prêt!",
		["kicked"]="interrompu",	
		["deleteconfigansw"]="Effacer la configuration sauvée :",	
		["offmode"]="Activé quand",
		["fxmodeactive"]="(de)buff actif",
		["activedefault"]="Actif par défaut",
		["fxmodeinactive"]="(de)buff inactif",		
		["fxmodeactivet"]="(de)buff actif sur la cible",
		["fxmodeinactivet"]="(de)buff inactif sur la cible",
		["fxmodenocd"]="Technique hors CD",
		["fxmodecd"]="Technique sous CD",
		["talents"]="Spécialisation",
		["stackbars"]="Méthode d'empilement",
		["defenseCharge"]="Charges défense sauvage",
		["defense_off"]="Charge disponible",
		["defense_on"]="Charge indisponible",
		["defense_norage"]="Pas de rage",
		["defensecount"]="Nombre de charges maxi",
		["notMounted"]="Non visible en monture",
		["Allspecs"]="Toute spécialisation",
		["Primaryspec"]="Spécialisation primaire",
		["Secondaryspec"]="Spécialisation secondaire",
		["loadspellconfigansw"]="Remplacer l'actuelle liste des sorts ?",
		["practiceinfos"]="Le mode entrainement permet a DroodFocus d'apprendre les sorts pendant une séance sur un mannequin.",
		["RDY"]="OK",
		["iconsRdyText"]="'Ready' texte",
		["FadeIn"]="Fin dans ",
		["BuffGain"]="Actif",
		["SoundWarning"]="Alerte temps",
		["warningtext"]="alerte: Icone et texte",
		["SoundWarningFile"]="Alerte: Son",
		["useInternalCombo"]="Compteur interne (GFX)",
		["useInternalComboText"]="Compteur interne (TXT)",
		["BuffWarning"]="Icone du buff",
		["sensInf"]="Inférieure ou égale",
		["sensSup"]="Supérieure",
		["TimerLimitSens"]="-> Vérifier si la valeur est",
		["abiVieLimite"]="Vie limite",
		["IconActive"]="Icone active",
		["IconInactive"]="Icone inactive",
		["IconInactiveCD"]="Icone sous CD",		
		["configPrimarySpe"]="Config. spé primaire",
		["configSecondarySpe"]="Config. spé secondaire",
		["notarget"]="Pas de cible",
		["DFdotTracker"]="Dots traqueur",
		["dotsList"]="Liste des debuffs",
		["DFdotPower"]="Puissance des dots",
		["redColor"]="Puissance inférieure",
		["yellowColor"]="Puissance égale",
		["greenColor"]="Puissance supérieure",
		["cap"]="Seuil",
		["dotcolor"]="Point coloré",
		["textDynamicColor"]="Couleur automatique",
		["no"]="Non",
		["yes"]="Oui",
		["fBtoT"]="A partir du bas",
		["fTtoB"]="A partir du haut",
		["fLtoR"]="A partir de gauche",
		["fRtoL"]="A partir de droite",
		["progressTexture"]="Texture progressive",
		["progressTextureFill"]="Mode de remplissage",
		["fill"]="Remplir",
		["empty"]="Vider",
		["gfx"]="Graphique",
		["txt"]="Texte",
		["export"]="Exporter ce sort",
		["import"]="Importer un sort",
		["objscale"]="Echelle graphique",
		["txtscale"]="Echelle texte",
		["floatmode"]="(Mode flottant)",
		["dots"]="Petits points",
		["bigdots"]="Point principal",		
		["PBautocolor"]="Couleur automatique",
		["PBpart"]="Limite",
		["inRange"]="Portée de la cible",
		["noRange"]="Non utilisée",
		["mustInRange"]="Doit être à portée",
		["mustOutRange"]="Doit être hors de portée",	
		["aboveIcon"]="Texture au dessus de l'icône",
		["bigdotsValue"]="Valeur a afficher",	
		["BigdotsValue1"]="Ratio en %",
		["BigdotsValue2"]="Puissance debuff",
		["BigdotsValue3"]="Puissance actuelle",
		["BigdotsValue4"]="Différence",
		["range1"]="Cible amie",
		["range2"]="Cible enemie",
		["flashWhenOff"]="Animation quand inactive",
		["flashWhenOffChoice1"]="Flash",
		["flashWhenOffChoice2"]="Flash mais en combat seulement",
	}

	DF.help ={
		["ID's list"]="Liste des IDs|Plusieurs ID possibles, séparées par un point-virgule.|Toutes les IDs sont utilisées pour récupérer le temps restant, les stacks, ect...|Mais SEULEMENT La première ID est utilisée pour charger la texture de l'icône et pour récupérer le CoolDown.| |Pour le type de sort 'Personnalisé', l'ID n'est utilisée que pour la texture de l'icône.",
		["Level"]="Level|Niveau d'affichage du cadre.|Un cadre de niveau supérieur sera affiché au dessus d'un cadre de niveau inférieur.",
		["LevelObj"]="Level|Niveau d'affichage de l'icône flottant, la barre flottante et l'effet spécial.|Un objet de niveau supérieur sera affiché au dessus d'un objet de niveau inférieur.",
		["Blend mode"]="Mode de fusion|mode de fusion de la texture.|Ajoute des valeurs de transparence pour les couleurs sous-jacentes|En utilisant le canal alpha. Les zones claires sont plus visibles que les zones sombres, plus transparentes.",
		["abiPandemic"]="Flash|L'icone flash en dessous de la limite de temps",
		["abishowGlow"]="Proc|L'effet de brillance des sorts aprés un proc est visible.",
		["abiPandemicValue"]="Flash timer|limite en secondes",
		["iconzoomed"]="Textures zoomées|Les textures des icones sont zoomées",
		["Spell ID"]="ID du sort|L'ID du sort qui déclenche l'effet.|Vous pouvez trouver les ID sur Wowhead.com.",
		["Text offset"]="Décalage|Décalage du texte par rapport a l'origine.",
		["Point offset"]="Offset|Espace entre chaque point.",
		["Scale"]="Echelle|Niveau de grossissement.",
		["Persistence"]="Persistence|Le temps que la texture sera visible.",
		["Infos format"]="Format du texte|Les occurences suivantes seront remplacées par leurs valeurs:|"..replaceString,
		["Slide speed"]="Vitesse de déplacement|Dans le mode automatique, les icones glissent a leurs places a la vitesse séléctionée.",
		["Automatic placement"]="Placement automatique|Dans ce mode, les icones sont rangés automatiquement.",
		["Sort by timeleft"]="Trié par temps restant|Dans ce mode, les objets sont triés par temps restant.",
		["Alpha"]="Transparence|Ajuste la transparence.",
		["Time range"]="Interval de temps|Indique le temps que couvre une barre (en seconde).",
		["Time lines"]="Lignes de temps|Indique si les lignes qui courrent le long des barres sont visibles.",
		["Arrows"]="Fléches|Indique si les fléches sur la barre de puissance sont visibles.",
		["Spell type"]="Type de sort|indique si c'est un Buff ou un Debuff et sur quelle unité ou si c'est un sort personnalisé.",
		["Uptime"]="Uptime|Indique si l'uptime doit être surveillé.|L'uptime désigne le temps de présence d'un (de)buff pendant un combat.|Tapez '/droodfocus uptime' aprés un combat pour obtenir un résumé.| |Attention! valable uniquement sur un mannequin, le changement ou la perte de la cible fausse l'uptime.",
		["Scan spell"]="Filtre|Pour ne tenir compte que de vos debuffs.",
		["Stack > Combo"]="Stack > Combo|Pour refléter le nombre d'application du sort sur la barre de combo.",
		["Cursor speed"]="Vitesse de l'étincelle|Les barres de status sont progressives. C'est la vitesse de déplacement de l'étincelle.",
		["Stance"]="Posture|Change en fonction de la classe.|Toutes les postures ne sont pas disponibles pour toutes les classes.",
		["Humanoïd"]="Posture par défaut|Disponible pour toute les classes.",
		["spark"]="Etincelle|indique si l'étincelle en bout de barre est visible.",
		["speed"]="Vitesse amplitude.",
		["position"]="Coordonnée|Par rapport a l'ancre.",
		["iposition"]="Coordonnée|Par rapport a l'ancre. Non utilisé si le placement des icônes est automatique.",
		["isize"]="Tailles|Taille des icônes.",
		["colonne"]="Colonnes|Dans le mode automatique, indique le nombre d'icônes par ligne.",	
		["spellslist"]="Grimoire|Cliquer pour ajouter l'ID du/des sorts a la boite de texte.",
		["strongcheck"]="Scan par ID|Le sort scanné doit avoir l'Id exacte.|Le plus souvent non activé. Par défaut, juste le nom du (de)buff est vérifié.|Mais pour certains sorts le nom est identique.|La vérification stricte permet de distinguer ces sorts.",
		["mpath"]="Chemin d'accès|Le chemin d'accès au fichier, de la forme:|  \\\\Interface\\\\AddOns\\\\DroodFocus\\\\datas\\\\statusbar.tga| |Attention! le fichier doit être présent dans son répertoire avant le lancement de WoW.|Sinon il ne sera pas valide.",
		["mname"]="Nom du media|Le nom qui apparaît dans la liste.",
		["mtype"]="Type du media|Les différents type de média gérés par ShareMedia.",	
		["ptype"]="Agencement|Méthode d'agencement des points.",
		["gps"]="G.P.S|Montre la direction ou se trouve le membre du raid ciblé.|Fonctionne uniquement pour les joueurs de votre raid.",
		["sound"]="Sons|Joue un son quand le joueur sort de combat.",
		["internalcd"]="CoolDown|Temps de recharge en seconde (0 = pas de CD)|Pour les sorts sans CD d'origine (comme les bijoux)|Remplace le CD normal.",
		["growup"]="Sorts actifs en tête|Les sorts actifs apparaissent devant les sorts inactifs.",
		["abiSound"]="Son|joue le son quand le buff/debuff est appliqué.",
		["prop"]="Barres proportionnelles|Par défaut, les barres couvrent une plage de temps fixe.|Dans ce mode, les barres sont proportionnelles au temps restant de 0 à 100%.",	
		["blood"]="Tâches de sang|Apparaît après un coup critique.",
		["infos"]="Infos|Affiche les stats en temps réel.",
		["ooc"]="Effet spécial|Effet spécial quand le buff proc.",
		["alert"]="Icône d'alerte|Apparaît si un sort échoue parceque vous êtes trop loin ou du mauvais coté de la cible. Montre également les buffs/debuffs gagnés.",
		["portrait"]="Portrait|Affiche une texture en fonction de la posture/forme.",
		["cooldown"]="Fin de Cooldown|Un icône apparaît quand un cooldown se termine.",
		["combo"]="Combo|Affiche les points de combo du Druide/Voleur et les runes du Chevalier de la Mort.",	
		["usertext"]="Texte personnalisé|Remplace le texte par défaut dans les listes et barres.",
		["spiral"]="Animation du compte à rebours|Représentation visuelle du compte à rebours.",	
		["showcd"]="Cooldown activé|Indique si le cooldown doit être affiché.",	
		["align"]="Alignement|Point de référence pour la position de l'objet.",				
		["pointpa"]="Puissance des dots|Un point en haut a droite indique par une couleur si vous pouvez poser un debuff plus puissant que l'actuel.|Un point rouge indique que votre puissance est inférieure à celle du debuff actuel.|Un point gris indique que votre puissance est équivalente.|Un point vert indique que votre puissance est supérieur à la puissance du debuff actuel.| |De plus, trois indicateurs en bas indiquent si le debuff a été posé avec Rugissement sauvage (rouge), Fureur du tigre (jaune) et Griffes de sang (bleu).| |L'affichage doit être activé sur les icones/barres pour être visible.",
		["pointpatext"]="Puissance des dots|Afficher le texte également.",
		["pointpabars"]="Puissance des dots|La couleur de la barre change si vous pouvez poser un debuff plus puissant que l'actuel.|Rouge indique que votre puissance est inférieure à celle du debuff actuel.|Grise indique que votre puissance est équivalente.|Verte indique que votre puissance est supérieur à la puissance du debuff actuel.",
		["pulse"]="Impulsion|Les icônes pulsent a l'application du sort. Cette valeur indique la puissance de l'impulsion.",
		["pulse2"]="Impulsion|Puissance de l'impulsion.",	
		["decimal"]="Voir décimal|Voir décimal quand le temps < 3 sec.",
		["colorchg"]="Couleur dynamique|La couleur change en fonction des points de vie.",
		["target"]="Cible|L'unité utilisée pour la localisation.",
		["always"]="Toujours visible|Toujours visible quelque soit la forme/aura.",
		["castbar"]="Barre d'incantation|Montre le sort incanté/canalisé par votre cible actuelle.",
		["sformat"]="Formatage du texte|Les chaines suivantes seront remplacées par les valeurs respectives|#m: Valeur maxi.|#c: Valeur actuelle.|#p: Pourcentage.|#M: Valeur maxi en k.|#C: Valeur actuelle en k.|#P: Pourcentage flottant.|#t: Temps avant la mort en m:ss.",	
		["interval"]="Interval minimum|Interval minimum de mise à jour de la barre.",
		["arrowposition"]="Position fléche|Niveau d'énergie indiquée par la fléche|-1 pour desactiver la fléche.",
		["anim"]="Type d'animation|Definie le type d'animation.",
		["customtexture"]="Texture personnalisée|Sans chemin d'accès, texture provenant du répertoire 'custom'.",
		["fxstack"]="Nombre de stack|Nombre de stack minimum nécéssaire pour activer l'objet.",
		["comboreq"]="Nombre de point de combo|Nombre de point de combo minimum nécéssaire pour activer l'objet.",
		["showdottimer"]="Dot timer|Active ou désactive le timer pour chaque tic.",		
		["editableTexture"] = "Texture|Selectionnez la texture dans la liste prédéfinie|ou entrez le nom du fichier (sans le chemin, fichier provenant du répertoire 'custom') ou le SpellID pour utiliser la texture du sort.",
		["LuaSnippetsHelp"]="Code Lua|Quelques exemples de code lua.|NB: Le code actuel sera remplacé par le nouveau.",
		["iTimerLimit"]="Temps minimum|Inactif si le temps restant ne remplie pas la condition (0 = Pas de limite).",	
		["roundMethod"]="Arrondi inférieur|Si coché (par défaut), les nombres à virgule sont arrondis a l'entier inférieur (0.75 affichera 0)|sinon ils sont arrondis à l'entier supérieur (0.75 affichera 1).",
		["RdyMode"]="'Ready' mode|L'icone ou la barre est montrée comme active si le sort n'est pas sous CD.",
		["abiWarn"]="CD Alerte timer|Alerte quand le CD atteint la limite (en sec. 0=pas d'alerte)",
		["talents"]="Spécialisation|Actif dans la spec. sélectionnée.",		
		["defenseCharge"]="Charges défense sauvage|Pour l'ours, montre le nombre de charges plutot que les points de combo.",
		["defensespellid"]="Defense sauvage|ID du sort a utiliser pour récupérer les charges.",
		["normalCast"]="Barre d'incantation|Joue le son si le sort est interruptible.",
		["interruptCast"]="Barre d'incantation|Joue le son si le sort n'est pas interruptible.",
		["SoundWarning"]="Alerte temps|Alerte quand le temps restant atteint la limite (0=pas d'alerte).",	
		["useInternalCombo"]="Compteur interne (GFX)|(uniquement pour le chat)|Utiliser le compteur de combo interne pour le mode graphique.",
		["useInternalComboText"]="Compteur interne (TXT)|(uniquement pour le chat)|Utiliser le compteur de combo interne pour le mode texte.",
		["BuffWarning"]="Icone du buff|Voir l'icone quand le joueur obtient le buff.",
		["abiVieLimite"]="Vie limite|Inactif si la vie de la cible (en %) ne remplie pas la condition (0=pas de limite).",
		["configPrimarySpe"]="Config. spé primaire/secondaire|Configuration a charger quand la spécialisation est activée.",
		["reportkickString"]="Message d'interruption|Message a afficher|#SPELL sera remplacé par le nom du sort.|#FROM sera remplacé par la source du sort.|#WHO sera remplacé par qui a interrompu le sort.",
		["dotTracker"]="Dots traqueur|Liste des debuffs actifs sur plusieurs cibles.",
		["dotsList"]="Liste des debuffs|Liste des debuffs traqués : spell id séparés par un point virgule.",
		["cap"]="Seuil|Seuil pour un debuff plus puissant (en %).",
		["textDynamicColor"]="Couleur automatique|Couleur en fonction du seuil.",
		["progressTexture"]="Texture progressive|La texture apparaît progressivement selon le timer.",
		["objscale"]="Echelle graphique|Echelle de la texture. Uniquement pour les objets flottants.",
		["txtscale"]="Echelle texte|Echelle des textes. Uniquement pour les objets flottants.",
		["inRange"]="Portée de la cible|Par défaut, portée en mélée pour les cibles enemies et portée des sorts pour les cibles amies.|Configurable dans le module 'visibilité'.",
		["rangeid"]="Portée|SpellID utilisée pour vérifier si le joueur est à portée."
	}

end



